<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Model\Pro;

use Saltus\WP\Plugin\Saltus\InteractiveGlobes\Features\Meta\MetaCore;

/**
 * common meta
 */
class MetaRegions {
	public static function merge( $meta, $settings ) {

		$actions_default       = $settings['actions_default'];
		$options               = $settings['options'];
		$default_colour        = isset( $options['defaultActiveColor'] ) && ! empty( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#99d8c9';
		$default_hover_colour  = isset( $options['defaultHoverColor'] ) && ! empty( $options['defaultHoverColor'] ) ? $options['defaultHoverColor'] : '#2ca25f';
		$template_editor       = isset( $options['template_editor'] ) ? $options['template_editor'] : 'text';

		// PRO regions meta
		$meta['globe_info']['sections']['region'] = array(
			'title'  => __( 'Regions Layer', 'interactive-globes' ),
			'icon'   => 'fa fa-globe fa-lg fa-rotate-90',
			'class'  => 'geojson_tab',
			'fields' => array(
				'regionInfo'   => array(
					'type'    => 'content',
					'content' => '<div class="ig_admin_example"><div>' . __( 'Load a layer with region/country shapes and add interactivity to them.', 'interactive-globes' ).'</div></div>',
				),
				'regionSource'  => array(
					'type'     => 'select',
					'title'    => __( 'Type', 'interactive-globes' ),
					'options'  => [
						'disabled' => __( 'Disabled', 'interactive-globes' ),
						'continents' => __( 'Continents', 'interactive-globes' ),
						'countries' => __( 'Countries', 'interactive-globes' ),
						'countriesMorocco' => __( 'Countries (Morocco)', 'interactive-globes' ),
						'countriesIndia' => __( 'Countries (India)', 'interactive-globes' ),
						'countriesChina' => __( 'Countries (China)', 'interactive-globes' ),
						'countriesRussia' => __( 'Countries (Russia)', 'interactive-globes' ),
						'outline' => __( 'Outline', 'interactive-globes' ),
						'custom' => __( 'Custom Source', 'interactive-globes' ),
					],
				),
				'regionCustomSourceURL'  => array(
					'type'     => 'text',
					'title'    => __( 'Custom GEOJSON Url', 'interactive-globes' ),
					'dependency' => array( array( 'regionSource', '==', 'custom' ) ),
				),
				'regionInfo2'   => array(
					'type'    => 'content',
					'content' => '<div>' . __( 'Click the "Add New Region Interactivity" button below to start adding interactivity to the regions. Use the correct region code.', 'interactive-globes' ).'</div>',
					'dependency' => array( array( 'regionSource', '!=', 'disabled' ) ),
				),
				'regionCpt' => array(
					'type'     => 'callback',
					'function' => [ MetaCore::class, 'cpt_manager' ],
					'dependency' => array( array( 'regionSource', '!=', 'disabled' ) ),
					'args'     => [
						'cpt'          => 'itt_globe_region',
						'data'         => [ 'geojson' ],
						'button_label' => __( 'Add New Region Interactivity', 'interactive-globes' )
					],
				),
				'regionDefaults' => array(
					'type'   => 'fieldset',
					'title'  => __( 'Default values', 'interactive-globes' ),
					'desc'   => '',
					'dependency' => array( array( 'regionSource', '!=', 'disabled' ) ),
					'fields' => array(
						'action'   => array(
							'type'    => 'select',
							'title'   => __( 'Click Action', 'interactive-globes' ),
							'desc'    => '',
							'options' => $actions_default,
							'default' => 'none',
						),
						'color'    => array(
							'type'    => 'color',
							'title'   => __( 'Fill Color', 'interactive-globes' ),
							'default' => $default_colour,
						),
						'hover'    => array(
							'type'    => 'color',
							'title'   => __( 'Hover Color', 'interactive-globes' ),
							'default' => $default_hover_colour,
						),
						'inactive'     => array(
							'type'       => 'color',
							'title'      => __( 'Inactive Regions Color', 'interactive-globes' ),
							'default'    => '#c9c9c9',
						),
					),
				),
				'regionsTooltipTemplate' => [
					'type'    => $template_editor,
					'title'   => __( 'Tooltip Template', 'interactive-globes' ),
					'default' => '',
					'desc'    => __( 'Override default tooltip template. You can use placeholders with curly brackets like {name} that exist in your data source.<br>Default value is {tooltipContent}.', 'interactive-globes' ),
					'dependency' => [ [ 'regionSource', '!=', 'disabled' ] ],
				],
			),
		);

		return $meta;
	}
}
