<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Model\Pro;

/**
 * Dot label meta
 */
class MetaDotLabel {
	public static function merge( $meta, $settings ) {

		$options         = $settings['options'];
		$template_editor = isset( $options['template_editor'] ) ? $options['template_editor'] : 'text';

		// Default Point meta
		$new_fonts = array(
			'PTSerif_Regular' => __( 'PTSerif Regular (~130kb)', 'interactive-globes' ),
		);

		$meta['globe_info']['sections']['dotlabel']['fields']['labelFont']['options'] = array_merge(
			$meta['globe_info']['sections']['dotlabel']['fields']['labelFont']['options'],
			$new_fonts
		);

		$meta['globe_info']['sections']['dotlabel']['fields']['dotLabelsTooltipTemplate'] = [
			'type'    => $template_editor,
			'title'   => __( 'Tooltip Template', 'interactive-globes' ),
			'default' => '',
			'desc'    => __( 'Override default tooltip template. You can use placeholders with curly brackets like {title} that exist in your data source.<br>Default value is {tooltipContent}.', 'interactive-globes' ),
		];
		return $meta;
	}
}
