<?php

namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Plugin;

class Freemius {
    private $root_dir;

    public function __construct( $root_dir ) {
        $this->root_dir = $root_dir;
    }

    public function load_config() {
        if ( !file_exists( $this->root_dir . '/.saltus' ) ) {
            return;
        }
        $env = file_get_contents( $this->root_dir . '/.saltus' );
        $lines = explode( "\n", $env );
        foreach ( $lines as $line ) {
            preg_match( '/([^#]+)\\=(.*)/', $line, $matches );
            if ( isset( $matches[2] ) ) {
                putenv( trim( $line ) );
            }
        }
    }

    public function init( $fs_is_premium_variant ) {
        global $ig_fs;
        if ( isset( $ig_fs ) ) {
            return $ig_fs;
        }
        if ( !file_exists( $this->root_dir . '/vendor/freemius/wordpress-sdk/start.php' ) ) {
            return null;
        }
        require_once $this->root_dir . '/vendor/freemius/wordpress-sdk/start.php';
        if ( !function_exists( 'fs_dynamic_init' ) ) {
            return null;
        }
        $fs_secret_key = getenv( 'fs_secret_key' );
        $args = [
            'id'                  => '14919',
            'slug'                => 'interactive-globes',
            'type'                => 'plugin',
            'public_key'          => 'pk_bf374640397ee6130fcd4ea1ef141',
            'is_premium'          => $fs_is_premium_variant,
            'premium_suffix'      => 'Pro',
            'has_premium_version' => true,
            'has_addons'          => true,
            'has_paid_plans'      => true,
            'trial'               => array(
                'days'               => 7,
                'is_require_payment' => true,
            ),
            'menu'                => array(
                'slug'    => 'edit.php?post_type=iglobe',
                'support' => false,
            ),
            'secret_key'          => $fs_secret_key,
        ];
        $ig_fs = fs_dynamic_init( $args );
        // Signal that SDK was initiated.
        do_action( 'ig_fs_loaded' );
        add_action( 'admin_init', array($this, 'admin_init_hook__premium_only') );
        if ( $this->is_pro() ) {
            // this variable toggles which features it should load
            if ( !defined( 'SALTUS_PLAN' ) ) {
                define( 'SALTUS_PLAN', 'pro' );
                // possible: pro, free, other?
            }
        }
        // default is free version
        if ( !defined( 'SALTUS_PLAN' ) ) {
            define( 'SALTUS_PLAN', 'free' );
            // possible: pro, free, other?
        }
        add_action( 'admin_notices', array($this, 'activate_license_admin_notice') );
        return $ig_fs;
    }

    public static function fs() {
        global $ig_fs;
        return $ig_fs;
    }

    /**
     */
    public function admin_init_hook__premium_only() {
        global $pagenow;
        global $ig_fs;
        $premium_models = ['itt_globe_region', 'itt_globe_line'];
        $pro_plan = $ig_fs->is_plan( 'pro', true );
        // if pro, its fine
        if ( $pro_plan ) {
            return;
        }
        $error_msg = '<div style="text-align: center; padding: 20px;">
						<img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAiIGhlaWdodD0iNTAiIHZpZXdCb3g9IjAgMCA1MCA1MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICA8Y2lyY2xlIGN4PSIyNSIgY3k9IjI1IiByPSIyNSIgZmlsbD0iI0ZGMjMzMyIvPgogIDxsaW5lIHgxPSIyNSIgeTE9IjExIiB4Mj0iMjUiIHkyPSIyOCIgc3Ryb2tlPSIjRkZGRkZGIiBzdHJva2Utd2lkdGg9IjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgogIDxjaXJjbGUgY3g9IjI1IiBjeT0iMzQiIHI9IjMiIGZpbGw9IiNGRkZGRkYiLz4KPC9zdmc+" alt="' . esc_html__( 'Error', 'interactive-globes' ) . '" style="width: 50px; margin-bottom: 20px;">
						<h3 style="color: #0066cc;">' . esc_html__( 'Your license does not have permission to use this premium feature.', 'interactive-globes' ) . '</h3>
						<p style="font-size: 16px; color: #333;"><a href="' . esc_url( admin_url( 'edit.php?post_type=iglobe&page=interactive-globes-contact' ) ) . '">Upgrade</a> or <a href="mailto:support@example.com">contact support</a>.</p>
						<a href="' . esc_url( admin_url( 'edit.php?post_type=iglobe' ) ) . '" style="display: inline-block; margin-top: 10px; padding: 10px 15px; background-color: #0073aa; color: #fff; text-decoration: none; border-radius: 4px;">' . esc_html__( 'Return Home', 'interactive-globes' ) . '</a>
					</div>';
        // Check if we are on the CPT listing page
        if ( $pagenow == 'edit.php' && isset( $_GET['post_type'] ) && in_array( $_GET['post_type'], $premium_models, true ) ) {
            wp_die( $error_msg, esc_html__( 'Interactive Globes - Error', 'interactive-globes' ) );
        }
        // Check if we are on the edit post screen for the specified CPT
        if ( $pagenow == 'post.php' && isset( $_GET['post'] ) ) {
            $post_id = intval( $_GET['post'] );
            $post = get_post( $post_id );
            if ( in_array( $post->post_type, $premium_models, true ) ) {
                wp_die( $error_msg, esc_html__( 'Interactive Globes - Error', 'interactive-globes' ) );
            }
        }
    }

    public function is_pro() {
        if ( !self::fs() ) {
            return false;
        }
        return self::fs()->can_use_premium_code();
    }

    public function activate_license_admin_notice() {
        // Get the current screen
        $screen = get_current_screen();
        // Check if the screen is for the custom post type 'iglobe'
        if ( isset( $screen->post_type ) && $screen->post_type !== 'iglobe' ) {
            return;
        }
        global $ig_fs;
        if ( !$ig_fs->is_free_plan() ) {
            return;
        }
        ?>
		<div class="notice notice-warning is-dismissible">
			<p><?php 
        _e( 'You are on the Interactive Globes Free plan. To activate your license, set it here: <a onclick="document.querySelector(\'.fs-modal.fs-modal-license-activation-interactive-globes\').classList.add(\'active\');" id="igfs-show-license-box" href="#">Activate license</a>,', 'interactive-globes' );
        ?></p>

		</div>
		<?php 
        $ig_fs->_add_license_activation_dialog_box();
    }

}
