<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Features\ClickActions;

if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}
use Saltus\WP\Framework\Infrastructure\Plugin\Registerable;
use Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Assets\AssetsCore;
use Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Assets\HasAssets;

class DisplayIframeLightbox implements ClickActionOption, Registerable, HasAssets {

	private $option_label;

	public function __construct() {
		$this->option_label   = __( 'Display URL in a Lightbox (iframe)', 'interactive-globes' );
	}

	/**
	 * Register HTML for Action
	 */
	public function register() {
		// nothing to add to page
		return;
	}

	public function get_option() {
		return $this->option_label;
	}

	public function register_assets( $assets ) {

		if ( ! is_a( $assets, AssetsCore::class ) ) {
			return;
		}
		$local_asset = '/assets/js/vendor/public/glightbox.js';

		$asset_url = apply_filters( 'itt_globes/assets/public_assets', $local_asset );

		// if same, it didn't get changed, so its a local file
		if ( $asset_url === $local_asset ) {
			$asset_url = plugins_url( $assets->dir . $local_asset, $assets->root_file_path );
		}
		$name = $assets->register_fullpath_script(
			$asset_url,
			[
				'/assets/js/public/globe.js',
				'/assets/js/vendor/public/globe.gl.js',
			],
			true
		);
		wp_enqueue_script( $name );


		// styles
		$local_asset = '/assets/css/vendor/public/glightbox.css';
		$asset_url   = apply_filters( 'itt_globes/assets/public_assets', $local_asset );
		if ( $asset_url === $local_asset ) {
			$asset_url = plugins_url( $assets->dir . $local_asset, $assets->root_file_path );
		}
		$name = $assets->register_fullpath_style(
			$asset_url,
			[
				'/assets/css/public/itt-globes-style.css',
			],
			true
		);
		wp_enqueue_style( $name );
	}

}
