<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Features\ClickActions;

if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}
use Saltus\WP\Framework\Infrastructure\Plugin\Registerable;

class DisplayContentBelowScroll implements ClickActionOption, Registerable {

	private $position;
	private $option_label;
	private $content_filter;

	public function __construct() {

		$this->position = 'below';
		$this->option_label = __( 'Display content below & scroll', 'interactive-globes' );
		$this->content_filter = 'itt_globes/render/content_after';
	
	}

	/**
	 * Register HTML for Action
	 */
	public function register() {
		// add globe container class
		add_filter(
			'itt_globes/render/container_class',
			function ( $container_class, $id ) {
				$container_class .= ' itt_globe_display_content_' . $this->position;
				return $container_class;
			},
			2,
			2
		);

		// add container div
		add_filter(
			$this->content_filter,
			function ( $content, $id ) {

				$default = ''; // no default for now

				$html = sprintf(
					'<div class="itt_globe_content itt_globe_content_%2$s" id="itt_globe_content_%2$s_%1$s"> %3$s </div>',
					$id,
					$this->position,
					$default
				);
				if ( $content !== $html ) {
					$content = $html . $content;
				}
				return $content;
			},
			1, // we set it to low priority to be added at straight away, so it ends up after the content right container
			2 
		);
	}

	public function get_option() {
		return $this->option_label;
	}
}
