<?php
use Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Base\SafeNL2BR;

if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}
global $ig_fs;
if ( ! isset( $ig_fs ) ) {
	return [];
}
if ( ! $ig_fs->can_use_premium_code() ) {
	return [];
}

$options               = get_option( 'ittglobes' );
$capability            = isset( $options['capability'] ) && ! empty( $options['capability'] ) ? $options['capability'] : 'page';
$coordinates_editor    = isset( $options['map_field'] ) && $options['map_field'] ? 'map' : 'fieldset';
$tooltip_editor        = isset( $options['tooltip_editor'] ) && ! empty( $options['tooltip_editor'] ) ? $options['tooltip_editor'] : 'textarea';
$action_content_editor = isset( $options['actionContent_editor'] ) && ! empty( $options['actionContent_editor'] ) ? $options['actionContent_editor'] : 'text';
$public_cpts           = isset( $options['public_cpts'] ) && $options['public_cpts'] ? true : false;
$actions_default       = apply_filters( 'itt_globes/click_actions', [ 'default' => __( 'Default', 'interactive-globes' ) ] );


$html_markers = [
	'active'       => true,
	'type'         => 'cpt',
	'name'         => 'itt_globe_html',
	'features'     => [
		'duplicate'  => array(
			'label'      => __( 'Clone HTML Marker', 'interactive-globes' ),
			'attr_title' => __( 'Create a copy of this HTML Marker', 'interactive-globes' ),
		),
		'admin_cols' => array(
			'title',
			'id'       => array(
				'title'      => 'ID',
				'post_field' => 'ID',
			),
			'globe_id' => array(
				'title'    => __( 'Parent Globe', 'interactive-globes' ),
				'function' => function () {
						global $post;
						$globe_id = get_post_meta( $post->ID, 'globe_id', true );
					if ( $globe_id ) {
						$globe_title = get_the_title( $globe_id );
						if ( $globe_title ) {
							echo esc_html( $globe_title );
						} else {
							echo esc_html( $globe_id );
						}
					}
				},
			),
		),
	],
	'supports'     => [
		'title',
		'custom-fields',
	],
	'labels'       => [
		'has_one'   => 'HTML Marker',
		'has_many'  => 'HTML Markers',
		// optional, but better for translation
		'overrides' => array(
			'labels'        => array(
				'name'                  => __( 'HTML Markers', 'interactive-globes' ),
				'singular_name'         => __( 'HTML Marker', 'interactive-globes' ),
				'menu_name'             => __( 'Markers', 'interactive-globes' ),
				'name_admin_bar'        => __( 'Markers', 'interactive-globes' ),
				'add_new'               => __( 'Create New', 'interactive-globes' ),
				'add_new_item'          => __( 'Create New HTML Marker', 'interactive-globes' ),
				'edit_item'             => __( 'Edit', 'interactive-globes' ),
				'new_item'              => __( 'New HTML Marker', 'interactive-globes' ),
				'view_item'             => __( 'View HTML Marker', 'interactive-globes' ),
				'view_items'            => __( 'View HTML Markers', 'interactive-globes' ),
				'search_items'          => __( 'Search HTML Markers', 'interactive-globes' ),
				'not_found'             => __( 'No HTML Markers found.', 'interactive-globes' ),
				'not_found_in_trash'    => __( 'No HTML Markers found in Trash.', 'interactive-globes' ),
				'parent_item-colon'     => __( 'Parent Globe:', 'interactive-globes' ),
				'all_items'             => '&#9900; ' . __( 'HTML Markers', 'interactive-globes' ),
				'archives'              => __( 'HTML Marker Archives', 'interactive-globes' ),
				'attributes'            => __( 'HTML Marker Attributes', 'interactive-globes' ),
				'insert_into_item'      => __( 'Insert into HTML Marker', 'interactive-globes' ),
				'uploaded_to_this_item' => __( 'Uploaded to this Point', 'interactive-globes' ),
				'filter_items_list'     => __( 'Filter Point list', 'interactive-globes' ),
				'items_list_navigation' => __( 'Point list navigation', 'interactive-globes' ),
				'items_list'            => __( 'Point list', 'interactive-globes' ),
				'featured_image'        => __( 'HTML Marker Cover Image', 'interactive-globes' ),
				'set_featured_image'    => __( 'Set HTML Marker Cover Image', 'interactive-globes' ),
				'remove_featured_image' => __( 'Remove HTML Marker Cover', 'interactive-globes' ),
				'use_featured_image'    => __( 'Use as HTML Marker Cover', 'interactive-globes' ),
			),
			// you can use the placeholders {permalink}, {preview_url}, {date}
			'messages'      => array(
				'post_updated'         => __( 'HTML Marker information updated. <a href="{permalink}" target="_blank">View Globe</a>', 'interactive-globes' ),
				'post_updated_short'   => __( 'HTML Marker info updated', 'interactive-globes' ),
				'custom_field_updated' => __( 'Custom field updated', 'interactive-globes' ),
				'custom_field_deleted' => __( 'Custom field deleted', 'interactive-globes' ),
				'restored_to_revision' => __( 'HTML Marker content restored from revision', 'interactive-globes' ),
				'post_published'       => __( 'HTML Marker Published', 'interactive-globes' ),
				'post_saved'           => __( 'HTML Marker information saved.', 'interactive-globes' ),
				'post_submitted'       => __( 'HTML Marker submitted. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
				'post_schedulled'      => __( 'HTML Marker scheduled for {date}. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
				'post_draft_updated'   => __( 'HTML Marker draft updated. <a href="{preview_url}" target="_blank">Preview</a>', 'interactive-globes' ),
			),
			'bulk_messages' => array(
				'updated_singular'   => __( 'HTML Marker updated. Yay!', 'interactive-globes' ),
				'updated_plural'     => __( '%s HTML Marker updated. Yay!', 'interactive-globes' ),
				'locked_singular'    => __( 'HTML Marker not updated, somebody is editing it', 'interactive-globes' ),
				'locked_plural'      => __( '%s HTML Marker not updated, somebody is editing them', 'interactive-globes' ),
				'deleted_singular'   => __( 'HTML Marker permanetly deleted. Fahrenheit 451 team was here?', 'interactive-globes' ),
				'deleted_plural'     => __( '%s HTML Marker permanently deleted. Why? :(', 'interactive-globes' ),
				'trashed_singular'   => __( 'HTML Marker moved to the trash. I\'m sad :(', 'interactive-globes' ),
				'trashed_plural'     => __( '%s HTML Marker moved to the trash. Why? :(', 'interactive-globes' ),
				'untrashed_singular' => __( 'HTML Marker recovered from trash. Well done!', 'interactive-globes' ),
				'untrashed_plural'   => __( '%s HTML Marker saved from the enemies!', 'interactive-globes' ),
			),
			// overrides some of the available button labels and placeholders
			'ui'            => array(
				'enter_title_here' => __( 'Enter HTML Marker name here', 'interactive-globes' ),
			),
		),
	],
	'options'      => [
		'public'              => false,
		'publicly_queryable'  => false,
		'exclude_from_search' => true,
		'show_in_rest'        => true,
		'show_in_nav_menus'   => $public_cpts,
		'show_ui'             => true,
		'capability_type'     => $capability,
		'show_in_menu'        => $public_cpts ? 'edit.php?post_type=iglobe' : false,
	],
	'block_editor' => false,
	'meta'         => [
		'html_info'        => [
			'id'                => 'html_info',
			'data_type'         => 'serialize',
			'register_rest_api' => true,
			'title'             => __( 'Information', 'interactive-globes' ),
			'nav'               => 'inline',
			'sections'          => [
				'details' => [
					'icon'   => 'fa fa-info-circle fa-lg',
					'title'  => __( 'Details', 'interactive-globes' ),
					'fields' => array(
						'coordinates'    => array(
							'type'     => $coordinates_editor,
							'title'    => __( 'Coordinates', 'interactive-globes' ),
							'register' => true,
							'fields'   => array(
								'zoom'      => array(
									'type'       => 'text',
									'title'      => __( 'zoom', 'interactive-globes' ),
									'class'      => 'geocoding geocoding-hide',
									'attributes' => array(
										'class' => 'geocoding-input',
									),
									'default'    => 2,
								),
								'address'   => array(
									'type'       => 'text',
									'title'      => __( 'address', 'interactive-globes' ),
									'class'      => 'geocoding geocoding-hide',
									'attributes' => array(
										'class' => 'geocoding-input',
									),
								),
								'latitude'  => array(
									'type'     => 'text',
									'title'    => __( 'Latitude', 'interactive-globes' ),
									'validate' => 'csf_validate_numeric',
									'default'  => ! empty( $_GET['latitude'] ) ? (float) $_GET['latitude'] : '',

								),
								'longitude' => array(
									'type'     => 'text',
									'title'    => __( 'Longitude', 'interactive-globes' ),
									'validate' => 'csf_validate_numeric',
									'default'  => ! empty( $_GET['longitude'] ) ? (float) $_GET['longitude'] : '',
								),
							),
							// if it's a map field, defaults have a different syntax and are set at this level
							'default'  => array(
								'latitude'  => ! empty( $_GET['latitude'] ) ? (float) $_GET['latitude'] : '',
								'longitude' => ! empty( $_GET['longitude'] ) ? (float) $_GET['longitude'] : '',
							),
						),
						'content'        => array(
							'type'     => $action_content_editor,
							'title'    => __( 'Action Content', 'interactive-globes' ),
							'subtitle' => __( 'URL or content to trigger when marker is clicked.', 'interactive-globes' ),
							'register' => true,
						),
					),
				],
				'custom'  => [
					'title'  => __( 'Customize', 'interactive-globes' ),
					'icon'   => 'fa fa-cog fa-lg',
					'fields' => array(
						'useCustom' => [
							'type'     => 'switcher',
							'title'    => __( 'Use Custom Options', 'interactive-globes' ),
							'subtitle' => __( 'Define individual click action and template.', 'interactive-globes' ),
							'default'  => false,
						],
						'action'    => array(
							'type'       => 'select',
							'title'      => __( 'Click Action', 'interactive-globes' ),
							'desc'       => '',
							'options'    => $actions_default,
							'default'    => 'default',
							'dependency' => [ 'useCustom', '==', true ],
						),
						'htmlTemplate' => array(
							'type'  => 'textarea',
							'title' => __( 'HTML Marker Template', 'interactive-globes' ),
							'desc'  => __( 'Template for the HTML content. You can use HTML code and if necessary use the <code>{title}</code> or <code>{content}</code> variable to insert the content of the entry.', 'interactive-globes' ),
							'default' => '<div class="itt_globe_html_marker">{title}</div>',
							'dependency' => [ 'useCustom', '==', true ],
						),
					),
				],
			],
		],
		'relationship_html' => [
			'id'                => 'html_globe',
			'title'             => __( 'Globe rel', 'interactive-globes' ),
			'class'             => isset( $_GET['iframe'] ) ? 'hidden' : '',
			'register_rest_api' => true,
			'sections'          => [
				'details' => [
					'fields' => array(
						'globe_id'        => [
							'type'              => 'number',
							'title'             => __( 'Associated Globe', 'interactive-globes' ),
							'attributes'        => [ 'id' => 'globe_id_number' ],
							'title'             => __( 'Associated Globe', 'interactive-globes' ),
							'class'             => 'hidden',
							'register_rest_api' => true,
						],
						'globe_id_select' => array(
							'placeholder'       => __( 'Select a Parent Globe', 'interactive-globes' ),
							'attributes'        => [ 'id' => 'globe_id_select' ],
							'type'              => 'select',
							'options'           => 'pages',
							'query_args'        => array(
								'post_type'      => 'iglobe',
								'posts_per_page' => -1,
								'post_status'    => 'any',
							),
							'class'             => isset( $_GET['iframe'] ) ? 'hidden' : '',
							'title'             => __( 'Associated Globe', 'interactive-globes' ),
							'register_rest_api' => true,
						),
					),
				],
			],
		],
	],
];

add_filter( 'itt_globes/meta/remove_meta_box_post_types', 'add_itt_globe_html_post_type', 10, 2 );
function add_itt_globe_html_post_type( $post_types ) {
	$post_types[] = 'itt_globe_html';
	return $post_types;
}

add_filter( 'itt_globes/render/post_setup_meta', 'add_html_to_shortcode', 10, 2 );
function add_html_to_shortcode( $globe_meta, $globe_id ) {
	$args          = [
		'post_type'      => 'itt_globe_html',
		'posts_per_page' => -1,
		'meta_query'     => [
			[
				'key'     => 'globe_id',
				'value'   => $globe_id,
				'compare' => '=',
				'type'    => 'NUMERIC',
			],
		],
	];
	$cpt_list      = [];
	$cpt_query     = new \WP_Query( $args );
	$click_actions = [];
	if ( isset( $globe_meta['htmlDefaults']['action'] ) &&
		$globe_meta['htmlDefaults']['action'] !== 'none' ) {
		$click_actions[] = $globe_meta['htmlDefaults']['action'];
	}

	if ( $cpt_query->have_posts() ) {
		while ( $cpt_query->have_posts() ) {
			$cpt_query->the_post();
			$cpt_id   = get_the_ID();
			$metadata = get_post_meta( $cpt_id );

			if ( empty( $metadata['html_info'][0] ) ) {
				continue;
			}
			$cpt_info          = maybe_unserialize( $metadata['html_info'][0] );
			$cpt_info['id']    = $cpt_id;
			$cpt_info['title'] = get_the_title();

			// convert natural line breaks to <br>
			$cpt_info['content']        = SafeNL2BR::convert( $cpt_info['content'] );
			$cpt_info['globe_id']       = $globe_id;

			$cpt_info['html'] = '';

			// populate with default values if useCustom does not exist or is false
			if ( ! isset( $cpt_info['useCustom'] ) || empty( $cpt_info['useCustom'] ) ) {
				$cpt_info = array_merge($cpt_info, $globe_meta['htmlDefaults']);
				$cpt_info['html'] = $globe_meta['htmlDefaults']['htmlTemplate'];
			} else {
				$cpt_info['html'] = $cpt_info['htmlTemplate'];
			}

			// Replace placeholders in html template with values from cpt_info
			$cpt_info['html'] = preg_replace_callback('/\{([^}]+)\}/', function($matches) use ($cpt_info) {
				$key = $matches[1];
				return isset($cpt_info[$key]) ? $cpt_info[$key] : '';
			}, $cpt_info['html']);


			if ( ! empty( $cpt_info['action'] ) &&
				$cpt_info['action'] !== 'none' ) {

				if(is_array($cpt_info['action'])) {
					$cpt_info['action'] = $cpt_info['action'][0];
				}

				$click_actions[] = $cpt_info['action'];
			}

			$cpt_info['type'] = 'html';

			$cpt_list[] = $cpt_info;

		}
	}

	wp_reset_query();

	$globe_meta['html'] = $cpt_list;

	$globe_meta['enabled_click_actions'] = $globe_meta['enabled_click_actions'] ?? [];
	$globe_meta['enabled_click_actions'] = array_merge( $globe_meta['enabled_click_actions'], $click_actions );
	$globe_meta['enabled_click_actions'] = array_unique( $globe_meta['enabled_click_actions'] );

	return $globe_meta;
}


$html_markers = apply_filters( 'itt_globes/html/model', $html_markers );
return $html_markers;
