<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}

global $ig_fs;
if ( ! isset( $ig_fs ) ) {
	return [];
}
if ( ! $ig_fs->can_use_premium_code() ) {
	return [];
}

$options = get_option( 'ittglobes' );

$cpts = [ 'iglobe', 'itt_globe_dotlabel', 'itt_globe_point', 'itt_globe_region', 'itt_globe_line' ];

$taxonomies   = isset( $options['taxonomies'] ) && ! empty( $options['taxonomies'] ) ? $options['taxonomies'] : false;
$show_in_menu = isset( $options['show_in_menu_tax'] ) && $options['show_in_menu_tax'] ? true : false;

if ( ! $taxonomies ) {
	return [];
}

foreach ( $taxonomies as $k => $pro_taxonomy ) {
	$pro_tax = [
		'type'         => isset( $pro_taxonomy['hierarchical'] ) && $pro_taxonomy['hierarchical'] ? 'category' : 'tag',
		'name'         => ! empty( $pro_taxonomy['slug'] ) ? sanitize_title( $pro_taxonomy['slug'] ) : sanitize_title( $pro_taxonomy['name'] ),
		'labels'       => [
			'has_one'  => '- ' . $pro_taxonomy['name'],
			'has_many' => '- ' . $pro_taxonomy['name'],
		],
		// args - third parameter for register_taxonomy
		'options' => [
			'public'       => true,
			'show_in_menu' => $show_in_menu,
		],
		// object_type - second parameter for register_taxonomy
		'associations' => $cpts,
	];

	array_push( $taxonomies, $pro_tax );
}

return $taxonomies;
