<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}

global $ig_fs;
if ( ! isset( $ig_fs ) ) {
	return [];
}
if ( ! $ig_fs->can_use_premium_code() ) {
	return [];
}

// Assemblers
use Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Assembler;
use Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Base;
use Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Pro;

function itt_globe_model_pro_custom_model( $globe_model, $settings ) {

	$globe_model['features'] = [
		'duplicate'     => array(
			'label'      => __( 'Clone Globe', 'interactive-globes' ),
			'attr_title' => __( 'Create a copy of this globe', 'interactive-globes' ),
		),
		'single_export' => array(
			'label' => __( 'Download Globe Export File', 'interactive-globes' ),
		),
		'admin_cols'    => array(
			'title',
			'id'        => array(
				'title'      => 'ID',
				'post_field' => 'ID',
			),
			'shortcode' => array(
				'title'    => __( 'Shortcode', 'interactive-globes' ),
				'function' => function () {
					global $post;
					echo esc_html( '[display-globe id="' . $post->ID . '"]' );
				},
			),
		),
		'remember_tabs' => true,
	];

	// PRO SETTINGS
	$globe_model['settings'] = array(
		'interactive-globes' => array(
			'id'         => 'interactive-globe-settings',
			'title'      => __( 'Plugin Settings', 'interactive-globes' ),
			'capability' => 'manage_options',
			'menu_title' => __( 'Settings', 'interactive-globes' ),
			'sections'   => array(
				'editing' => array(
					'title'  => __( 'Editing', 'interactive-globes' ),
					'desc'   => __( 'Edit screen settings', 'interactive-globes' ),
					'icon'   => 'fa fa-pencil-square-o fa-lg',
					'fields' => array(
						'map_field' => [
							'type'    => 'switcher',
							'title'   => __( 'Use OpenStreeMap', 'interactive-globes' ),
							'desc'    => __( 'If you want to select the coordinates using a visual map with search features, you can enable this option. <br>It might slow down the editor screen a bit, but it could be very helpful. <br> It uses the free Nominatim Geolocation service, which might block you if you do too many requests with the search form. <a href="https://operations.osmfoundation.org/policies/nominatim/" target="_blank">Usage Policy</a>', 'interactive-globes' ) . '<span class="dashicons dashicons-external"></span>',
							'default' => false,
						],
						'tooltip_editor'     => [
							'type'    => 'select',
							/* translators: field type = input type (textarea, rich text editor...) */
							'title'   => __( 'Tooltip field type', 'interactive-globes' ),
							'desc'    => __( 'Type of field to use to edit the tooltip content.', 'interactive-globes' ),
							'default' => 'textarea',
							'options' => [
								'textarea'  => __( 'Textarea', 'interactive-globes' ),
								/* translators: equivalent to classic editor in a way */
								'wp_editor' => __( 'WP Rich Text Editor', 'interactive-globes' ),
								'text'      => __( 'Text Input', 'interactive-globes' ),
							],
						],

						'actionContent_editor'     => [
							'type'    => 'select',
							/* translators: field type = input type (textarea, rich text editor...) */
							'title'   => __( 'Action Content field type', 'interactive-globes' ),
							'desc'    => __( 'Type of field to use to edit the tooltip content.', 'interactive-globes' ),
							'default' => 'textarea',
							'options' => [
								'textarea'  => __( 'Textarea', 'interactive-globes' ),
								/* translators: equivalent to classic editor in a way */
								'wp_editor' => __( 'WP Rich Text Editor', 'interactive-globes' ),
								'text'      => __( 'Text Input', 'interactive-globes' ),
							],
						],

						'defaultsFieldsHeader' => [
							'type'    => 'subheading',
							'content' => __( 'Defaults', 'interactive-globes' ),
						],

						'defaultActiveColor' => [
							'type'    => 'color',
							'default' => '#99d8c9',
							'title'   => __( 'Default Active Colour', 'interactive-globes' ),
							'desc' => __( 'Set the default colour for the active colour field, when you create new maps.', 'interactive-globes' ),
						],

						'defaultHoverColor' => [
							'type'    => 'color',
							'default' => '#2ca25f',
							'title'   => __( 'Default Hover Colour', 'interactive-globes' ),
							'desc' => __( 'Set the default colour for the hover colour field, when you create new maps.', 'interactive-globes' ),
						],
					),
				),

				'visuals'  => array(
					'title'  => __( 'Visuals', 'interactive-globes' ),
					'icon'   => 'fa fa-cog fa-lg',
					'fields' => array(
						'filterMenuStyles'  => [
							'type'    => 'fieldset',
							'title'   => __( 'Filter Menu Styles', 'interactive-globes' ),
							'desc'    => __( 'Customize the styles of the filter menu.', 'interactive-globes' ),
							'fields' => array(
								'color' => [
									'type'    => 'color',
									'title'   => __( 'Color', 'interactive-globes' ),
									'default' => '#000',
								],
								'hover' => [
									'type'    => 'color',
									'title'   => __( 'Hover Color', 'interactive-globes' ),
									'default' => '#000',
								],
								'active' => [
									'type'    => 'color',
									'title'   => __( 'Active Color', 'interactive-globes' ),
									'default' => '#000',
								],
								'borderRadius' => [
									'type'    => 'spinner',
									'title'   => __( 'Border Radius', 'interactive-globes' ),
									'default' => 0,
								],
							),
						],
					),
				),

				'capabilities'  => array(
					'title'  => __( 'Capabilities', 'interactive-globes' ),
					'desc'   => __( 'Add custom styles to the pages loading the layouts.', 'interactive-globes' ),
					'icon'   => 'fa fa-cog fa-lg',
					'fields' => array(
						'capability'  => [
							'type'    => 'text',
							'title'   => __( 'Capability Type', 'interactive-globes' ),
							'desc'    => __( 'Refer to the <code>capability_type</code> argument from the <code>register_post_type</code>. <a target="_blank" href="https://developer.wordpress.org/reference/functions/register_post_type/#capability_type">More information</a>.', 'interactive-globes' ),
							'default' => 'page',
						],
					),
				),


			),
		),
	);

	// PRO META
	// actions - when implementing custom action, each series will need it's own array
	$actions_default['default'] = __( 'Use default', 'interactive-globes' );

	// points pro features
	$globe_model['meta']['globe_info']['sections']['points']['fields']['points']['fields'] = array_merge(
		$globe_model['meta']['globe_info']['sections']['points']['fields']['points']['fields'],
		array(
			'useDefaults'   => [
				'type'     => 'switcher',
				'title'    => __( 'Use defaults', 'interactive-globes' ),
				'subtitle' => __( 'Use default colors and actions.', 'interactive-globes' ),
				'default'  => true,
			],
			'action' => array(
				'type'    => 'select',
				'title'   => __( 'Click Action', 'interactive-globes' ),
				'desc'    => '',
				'options' => $actions_default,
				'default' => 'default',
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'radius'   => array(
				'type'    => 'spinner',
				'default' => 2,
				'step'    => 0.1,
				'title'   => __( 'Radius / Size', 'interactive-globes' ),
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'altitude' => array(
				'type'    => 'spinner',
				'default' => 1,
				'step'    => 0.01,
				'title'   => __( 'Altitude', 'interactive-globes' ),
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'color'    => array(
				'type'    => 'color',
				'title'   => __( 'Fill Color', 'interactive-globes' ),
				'default' => isset( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#99d8c9',
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'hover'    => array(
				'type'    => 'color',
				'title'   => __( 'Hover Color', 'interactive-globes' ),
				'default' => isset( $options['defaultHoverColor'] ) ? $options['defaultHoverColor'] : '#2ca25f',
				'dependency' => [ 'useDefaults', '==', false ],
			),
		)
	);

	// dot labels Pro features
	$globe_model['meta']['globe_info']['sections']['labels']['fields']['labels']['fields'] = array_merge(
		$globe_model['meta']['globe_info']['sections']['labels']['fields']['labels']['fields'], array(
			'useDefaults'   => [
				'type'     => 'switcher',
				'title'    => __( 'Use defaults', 'interactive-globes' ),
				'subtitle' => __( 'Use default colors and actions.', 'interactive-globes' ),
				'default'  => true,
			],
			'action'         => array(
				'type'    => 'select',
				'title'   => __( 'Click Action', 'interactive-globes' ),
				'desc'    => '',
				'options' => $actions_default,
				'default' => 'default',
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'altitude'       => array(
				'type'    => 'spinner',
				'default' => 1,
				'step'    => 0.01,
				'title'   => __( 'Altitude', 'interactive-globes' ),
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'size'           => array(
				'type'    => 'spinner',
				'default' => 2,
				'step'    => 0.01,
				'title'   => __( 'Label Size', 'interactive-globes' ),
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'color'          => array(
				'type'    => 'color',
				'title'   => __( 'Fill Color', 'interactive-globes' ),
				'default' => isset( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#99d8c9',
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'hover'          => array(
				'type'    => 'color',
				'title'   => __( 'Hover Color', 'interactive-globes' ),
				'default' => isset( $options['defaultHoverColor'] ) ? $options['defaultHoverColor'] : '#2ca25f',
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'includeDot'     => array(
				'title'   => __( 'Display Dot', 'interactive-globes' ),
				'desc'    => __( 'Display a dot marker next to the text indicating the exact coordinates of the label.', 'interactive-globes' ),
				'type'    => 'switcher',
				'default' => true,
				'dependency' => [ 'useDefaults', '==', false ],
			),
			'radius'         => array(
				'type'       => 'spinner',
				'default'    => 2,
				'step'       => 0.1,
				'title'      => __( 'Dot Radius', 'interactive-globes' ),
				'dependency' => [ [ 'includeDot', '==', true ], [ 'useDefaults', '==', false ] ],
			),
			'dotOrientation' => array(
				'type'       => 'select',
				'default'    => 'bottom',
				'options'    => array(
					'bottom' => __( 'Bottom', 'interactive-globes' ),
					'top'    => __( 'Top', 'interactive-globes' ),
					'right'  => __( 'Right', 'interactive-globes' ),
				),
				'title'      => __( 'Dot Orientation', 'interactive-globes' ),
				'dependency' => array( array( 'includeDot', '==', true ), array( 'useDefaults', '==', false ) ),
			),
		)
	);

	$globe_model['meta']['globe_info']['sections']['globe']['fields']['rotate'] = array(
		'type'   => 'fieldset',
		/* translators: legend refers to a caption or visual element explaining colours on map */
		'title'  => __( 'Auto Rotate', 'interactive-globes' ),
		'desc'   => __( 'Rotate animation', 'interactive-globes' ),
		'fields' => [
			'enabled' => [
				'type'   => 'switcher',
				/* translators: legend refers to a caption or visual element explaining colours on map */
				'title'  => __( 'Auto Rotate', 'interactive-globes' ),
				'desc'   => __( 'Rotate animation', 'interactive-globes' ),
				'default' => false,
			],
			'speed' => [
				'type'       => 'spinner',
				'default'    => 1.5,
				'step'       => 0.1,
				'title'      => __( 'Speed', 'interactive-globes' ),
				'dependency' => [ [ 'enabled', '==', true ] ],
			]
		],
	);

	// END PRO META
	return $globe_model;
}

function itt_globe_model_pro() {

	// setup the settings
	$path     = dirname( __DIR__ );
	$custom   = [];
	$settings = Base\Settings::get( $path );

	$settings['actions_default'] = Pro\ClickActions::merge( $settings['actions_default'] );

	$settings = Assembler::create_settings( $settings, $custom );
	$settings = Assembler::run_actions( $settings );

	$globe_options = Pro\Options::get( $settings );

	// setup the base layer
	$globe_model    = Base\Model::get();
	$globe_labels   = Base\Labels::get();
	$globe_meta     = Base\Meta::get( $settings );
	$globe_meta     = Base\MetaPoint::merge( $globe_meta, $settings );
	$globe_meta     = Pro\MetaPoint::merge( $globe_meta, $settings );
	$globe_meta     = Base\MetaDotLabel::merge( $globe_meta, $settings );
	$globe_meta     = Pro\MetaDotLabel::merge( $globe_meta, $settings );
	$globe_meta     = Pro\MetaRotate::merge( $globe_meta );
	$globe_meta     = Pro\MetaHTML::merge( $globe_meta, $settings );
	$globe_meta     = Pro\MetaRegions::merge( $globe_meta, $settings );
	
	$globe_meta     = Pro\MetaLines::merge( $globe_meta, $settings );
	$globe_meta     = Pro\MetaSearch::merge( $globe_meta );
	$globe_meta     = Pro\MetaTooltip::merge( $globe_meta, $settings );
	$globe_meta     = Pro\MetaLayers::merge( $globe_meta );
	$globe_meta     = Pro\MetaColor::merge( $globe_meta, $settings );
	$globe_features = Base\Features::get();
	$globe_settings = Pro\PluginSettings::get();
	$globe_model    = array_merge(
		$globe_model,
		[
			'labels'   => $globe_labels,
			'options'  => $globe_options,
			'meta'     => $globe_meta,
			'features' => $globe_features,
			'settings' => $globe_settings,
		]
	);

	// apply the custom pro features
	$globe_model = apply_filters( 'itt_globes/globe/model', $globe_model );

	return $globe_model;
}

return itt_globe_model_pro();
