<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Pro;

/**
 * Manage Settings
 */
class PluginSettings {

	public static function get() {
		$plugin_settings = array(
			'ittglobes' => array(
				'id'         => 'ittglobes',
				'title'      => __( 'Plugin Settings', 'interactive-globes' ),
				'capability' => 'manage_options',
				'menu_title' => __( 'Settings', 'interactive-globes' ),
				'footer_text'             => 'Interactive Globes Pro',
				'footer_after'            => '',
				'footer_credit'           => '',
				'sections'   => array(
					'editing' => array(
						'title'  => __( 'Editing', 'interactive-globes' ),
						'desc'   => __( 'Edit screen settings', 'interactive-globes' ),
						'icon'   => 'fa fa-edit fa-lg',
						'fields' => array(
							'map_field' => [
								'type'    => 'switcher',
								'title'   => __( 'Use OpenStreeMap', 'interactive-globes' ),
								'desc'    => __( 'If you want to select the coordinates using a visual map with search features, you can enable this option. <br>It might slow down the editor screen a bit, but it could be very helpful. <br> It uses the free Nominatim Geolocation service, which might block you if you do too many requests with the search form. <a href="https://operations.osmfoundation.org/policies/nominatim/" target="_blank">Usage Policy</a>', 'interactive-globes' ) . '<span class="dashicons dashicons-external"></span>',
								'default' => false,
							],
							'tooltip_editor'     => [
								'type'    => 'select',
								/* translators: field type = input type (textarea, rich text editor...) */
								'title'   => __( 'Tooltip field type', 'interactive-globes' ),
								'desc'    => __( 'Type of field to use to edit the tooltip content.', 'interactive-globes' ),
								'default' => 'textarea',
								'options' => [
									'textarea'  => __( 'Textarea', 'interactive-globes' ),
									/* translators: equivalent to classic editor in a way */
									'wp_editor' => __( 'WP Rich Text Editor', 'interactive-globes' ),
									'text'      => __( 'Text Input', 'interactive-globes' ),
								],
							],

							'actionContent_editor'     => [
								'type'    => 'select',
								/* translators: field type = input type (textarea, rich text editor...) */
								'title'   => __( 'Action Content field type', 'interactive-globes' ),
								'desc'    => __( 'Type of field to use to edit the tooltip content.', 'interactive-globes' ),
								'default' => 'textarea',
								'options' => [
									'textarea'  => __( 'Textarea', 'interactive-globes' ),
									/* translators: equivalent to classic editor in a way */
									'wp_editor' => __( 'WP Rich Text Editor', 'interactive-globes' ),
									'text'      => __( 'Text Input', 'interactive-globes' ),
								],
							],

							'template_editor'     => [
								'type'    => 'select',
								/* translators: field type = input type (textarea, rich text editor...) */
								'title'   => __( 'Templates field type', 'interactive-globes' ),
								'desc'    => __( 'Type of field to use to edit the tooltip and action content templates.', 'interactive-globes' ),
								'default' => 'text',
								'options' => [
									'textarea'  => __( 'Textarea', 'interactive-globes' ),
									/* translators: equivalent to classic editor in a way */
									'wp_editor' => __( 'WP Rich Text Editor', 'interactive-globes' ),
									'text'      => __( 'Text Input', 'interactive-globes' ),
								],
							],

							'defaultsFieldsHeader' => [
								'type'    => 'subheading',
								'content' => __( 'Defaults', 'interactive-globes' ),
							],

							'defaultActiveColor' => [
								'type'    => 'color',
								'default' => '#99d8c9',
								'title'   => __( 'Default Active Colour', 'interactive-globes' ),
								'desc' => __( 'Set the default colour for the active colour field, when you create new maps.', 'interactive-globes' ),
							],

							'defaultHoverColor' => [
								'type'    => 'color',
								'default' => '#2ca25f',
								'title'   => __( 'Default Hover Colour', 'interactive-globes' ),
								'desc' => __( 'Set the default colour for the hover colour field, when you create new maps.', 'interactive-globes' ),
							],
						),
					),
					'visuals'  => array(
					'title'  => __( 'Visuals', 'interactive-globes' ),
					'icon'   => 'fa fa-palette fa-lg',
					'fields' => array(
						'filterMenuStyles'  => [
							'type'    => 'fieldset',
							'title'   => __( 'Filter Menu Styles', 'interactive-globes' ),
							'desc'    => __( 'Customize the styles of the filter menu.', 'interactive-globes' ),
							'fields' => array(
								'menuItemColor' => [
									'type'    => 'link_color',
									'title'   => __( 'Color', 'interactive-globes' ),
									'default'   => array(
										'color'   => '#f5f5f5',
										'hover'   => '#cccccc',
										'active'  => '#cccccc',
									),
									'color'     => true,
									'hover'     => true,
									'active'    => true,
								],
								'menuItemTextColor' => [
									'type'    => 'link_color',
									'title'   => __( 'Text Color', 'interactive-globes' ),
									'default'   => array(
										'color'   => '#000000',
										'hover'   => '#000000',
										'active'  => '#000000',
									),
									'color'     => true,
									'hover'     => true,
									'active'    => true,
								],
								'borderRadius' => [
									'type'    => 'spinner',
									'title'   => __( 'Border Radius', 'interactive-globes' ),
									'default' => 3,
								],
							),
						],
						),
					),

					'capabilities'  => array(
						'title'  => __( 'Capabilities', 'interactive-globes' ),
						'desc'   => __( 'Add custom styles to the pages loading the layouts.', 'interactive-globes' ),
						'icon'   => 'fa fa-cog fa-lg',
						'fields' => array(
							'capability'  => [
								'type'    => 'text',
								'title'   => __( 'Capability Type', 'interactive-globes' ),
								'desc'    => __( 'Refer to the <code>capability_type</code> argument from the <code>register_post_type</code>. <a target="_blank" href="https://developer.wordpress.org/reference/functions/register_post_type/#capability_type">More information</a>.', 'interactive-globes' ),
								'default' => 'page',
							],

							'public_cpts' => [
								'type'    => 'switcher',
								'title'   => __( 'Expose Data Types', 'interactive-globes' ),
								'desc'    => __( 'If enabled, data types like points, dot labels, regions and others will display in the main menu and you can edit them as a custom post type entry.', 'interactive-globes' ),
								'default' => false,
							],
							'single_pages' => array(
								'type'   => 'fieldset',
								'title'  => __( 'Globe single pages', 'interactive-globes' ),
								'subtitle'   => __( 'When enabled the globes will automatically have a single page where you can preview it.', 'interactive-globes' ),
								'fields' => [
									'enabled' => [
										'type'    => 'switcher',
										/* translators: field type = input type (textarea, rich text editor...) */
										'title'   => __( 'Enable', 'interactive-globes' ),
										'default' => false,
									],
									'slug' => [
										'type'       => 'text',
										'title'      => __( 'slug', 'interactive-globes' ),
										'desc'       => __( 'URL slug to use on single globe pages. You might need to resave your permalink settings in you get "Page not found" errors.', 'interactive-globes' ),
										'default'    => 'globe',
										'dependency' => [ 'enabled', '==', true ],
									],
								],
							),
						),
					),

					/*
					'taxonomies'  => array(
						'title'  => __( 'Taxonomies', 'interactive-globes' ),
						'desc'   => __( 'Enable custom taxonomies for the different types of data.', 'interactive-globes' ),
						'icon'   => 'fa fa-tags fa-lg',
						'fields' => array(
							'taxonomies' => array(
								'type'         => 'group',
								'button_title' => __( 'Add New Taxonomy', 'interactive-globes' ),
								'fields'       => array(
									'name' => array(
										'type'       => 'text',
										'title'      => __( 'Title', 'interactive-globes' ),
									),
									'slug' => array(
										'type'  => 'text',
										'title' => __( 'Slug', 'interactive-globes' ),
										'desc'  => __( 'Note that if you change the slug after there are already terms in the taxonomy, these will be lost.', 'interactive-globes' ),
									),

									'hierarchical'        => array(
										'type'     => 'switcher',
										'default'  => false,
										'title'    => __( 'hierarchical', 'interactive-globes' ),
										'subtitle' => __( 'If enabled, it will act as categories, if disabled it will act as tags.', 'interactive-globes' ),
									),

								),
							),
							'show_in_menu_tax' => [
								'type'    => 'switcher',
								'title'   => __( 'Show in UI', 'interactive-globes' ),
								'desc'    => __( 'Show taxonomies in plugin menu.', 'interactive-globes' ),
								'default' => false,
							],
						),
					), */
				),
			),
		);
		return $plugin_settings;
	}
}
