<?php
namespace Saltus\WP\Plugin\InteractiveGlobes;

use Saltus\WP\Plugin\InteractiveGlobes\Features\Shortcode\ShortcodeFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\Meta\MetaFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\SinglePage\SinglePageFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\Duplicate\DuplicateFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\Tooltip\TooltipFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\SearchDropdown\SearchDropdownFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\LiveFilter\LiveFilterFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\RegionCounter\RegionCounterFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\CptManager\CptManagerFeature;
use Saltus\WP\Plugin\InteractiveGlobes\Features\Updater\UpdateFeature;
// services
use Saltus\WP\Plugin\InteractiveGlobes\Services\Assets\AssetsService;

/**
 * The core class, where logic is defined.
 */
class CorePro extends Core {

	/**
	 * Start the logic for this plugins.
	 *
	 * Runs on 'plugins_loaded' which is pre- 'init' filter
	 */
	public function init() {
		global $ig_fs;

		if ( ! isset( $ig_fs ) ) {
			return;
		}
		if ( ! $ig_fs->can_use_premium_code() ) {
			return;
		}

		$this->do_lifecylce();

		$this->set_locale();

		// main scripts and styles
		$this->set_assets();

		// load services
		$service_list = $this->get_services_classes();
		$this->register_services( $service_list );

		// 1- Loads features
		$feature_list = $this->get_features_classes();
		$this->register_features( $feature_list );

		// temp fix for admin
		if ( is_admin() ) {
			$this->register_shortcode();
		}
	}

	/**
	 * Get the list of features to register.
	 *
	 * @return array<string> Associative array of identifiers mapped to fully
	 *                       qualified class names.
	 */
	private function get_features_classes(): array {
		return [
			'CPTManager'     => CptManagerFeature::class,
			'Meta'           => MetaFeature::class,
			'SearchDropdown' => SearchDropdownFeature::class,
			'SinglePage'     => SinglePageFeature::class,
			'Duplicate'      => DuplicateFeature::class,
			'shortcode'      => ShortcodeFeature::class,
			'Tooltip'        => TooltipFeature::class,
			'Updater'        => UpdateFeature::class,
			'LiveFilter'     => LiveFilterFeature::class,
			'RegionCounter'  => RegionCounterFeature::class,
		];
	}


	private function get_services_classes() {
		return [
			'assets' => AssetsService::class,
		];
	}
}
