/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-19 14:02:31 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=501 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=39954 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-01-21 08:20:14", "2025-01-21 08:20:14", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "1", "Free Premium WordPress Themes &amp; Plugins Nulled", "info@t.me", "https://sigmaweb.online/Telegram", "41.248.207.245", "2025-01-28 01:29:35", "2025-01-28 01:29:35", "<a href=\"https://sigmaweb.online/Telegram\" rel=\"nofollow ugc\">🚀 Attention WordPress admins! Join our Telegram group for free premium themes and plugins nulled with the latest updates. Stay ahead with free exclusive tools for your website! 👉 https://t.me/+CH-Dy6wxFaszM2E8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "1", "Bobby3701", "Bobby3701@gmail.com", "", "177.220.180.249", "2025-04-13 11:52:14", "2025-04-13 11:52:14", "<a href=\"https://honda-fit.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=7031\" rel=\"nofollow ugc\">https://honda-fit.ru/forums/index.php?autocom=gallery&amp;req=si&amp;img=7031</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "1", "Cayden1269", "Cayden1269@gmail.com", "", "103.165.167.190", "2025-04-20 16:11:30", "2025-04-20 16:11:30", "Very good <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "1", "Makayla2230", "Makayla2230@gmail.com", "", "163.47.70.97", "2025-04-22 22:53:40", "2025-04-22 22:53:40", "Awesome <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "1", "Bennett3114", "Bennett3114@gmail.com", "", "14.178.144.17", "2025-04-23 01:22:50", "2025-04-23 01:22:50", "Good <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "1", "Drake3130", "Drake3130@gmail.com", "", "49.36.138.200", "2025-04-23 17:35:50", "2025-04-23 17:35:50", "Very good <a href=\"https://shorturl.at/2breu\" rel=\"nofollow ugc\">https://shorturl.at/2breu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "1", "Harlan4315", "Harlan4315@gmail.com", "", "201.238.253.27", "2025-04-23 22:14:22", "2025-04-23 22:14:22", "Very good <a href=\"https://shorturl.at/2breu\" rel=\"nofollow ugc\">https://shorturl.at/2breu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "1", "Mark817", "Mark817@gmail.com", "", "167.62.173.22", "2025-04-24 03:35:21", "2025-04-24 03:35:21", "Awesome <a href=\"https://shorturl.at/2breu\" rel=\"nofollow ugc\">https://shorturl.at/2breu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "1", "Sarah4760", "Sarah4760@gmail.com", "", "112.163.160.249", "2025-04-24 21:44:37", "2025-04-24 21:44:37", "Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "1", "Felicity4115", "Felicity4115@gmail.com", "", "36.227.241.110", "2025-04-25 02:35:17", "2025-04-25 02:35:17", "Very good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "1", "Devon2487", "Devon2487@gmail.com", "", "115.74.8.89", "2025-04-25 11:39:18", "2025-04-25 11:39:18", "Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "1", "Kenny817", "Kenny817@gmail.com", "", "178.124.76.102", "2025-04-25 12:08:22", "2025-04-25 12:08:22", "Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "1", "Gloria4640", "Gloria4640@gmail.com", "", "116.105.161.212", "2025-04-25 23:11:57", "2025-04-25 23:11:57", "Good <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "1", "Teresa1044", "Teresa1044@gmail.com", "", "203.150.113.81", "2025-04-26 04:01:33", "2025-04-26 04:01:33", "Awesome <a href=\"https://lc.cx/xjXBQT\" rel=\"nofollow ugc\">https://lc.cx/xjXBQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "1", "Jasper3209", "Jasper3209@gmail.com", "", "66.181.186.186", "2025-04-27 02:58:37", "2025-04-27 02:58:37", "Awesome <a href=\"https://t.ly/tndaA\" rel=\"nofollow ugc\">https://t.ly/tndaA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "1", "Neal3358", "Neal3358@gmail.com", "", "122.150.204.57", "2025-04-27 04:26:46", "2025-04-27 04:26:46", "Very good <a href=\"https://t.ly/tndaA\" rel=\"nofollow ugc\">https://t.ly/tndaA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "1", "Evan3450", "Evan3450@gmail.com", "", "142.247.80.157", "2025-04-27 10:54:58", "2025-04-27 10:54:58", "Awesome <a href=\"https://t.ly/tndaA\" rel=\"nofollow ugc\">https://t.ly/tndaA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "1", "Whitney1245", "Whitney1245@gmail.com", "", "154.223.78.211", "2025-04-27 17:29:43", "2025-04-27 17:29:43", "Good <a href=\"https://urlr.me/zH3wE5\" rel=\"nofollow ugc\">https://urlr.me/zH3wE5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "1", "Russell2670", "Russell2670@gmail.com", "", "152.174.8.194", "2025-04-27 19:54:22", "2025-04-27 19:54:22", "Good <a href=\"https://urlr.me/zH3wE5\" rel=\"nofollow ugc\">https://urlr.me/zH3wE5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "1", "Erica3841", "Erica3841@gmail.com", "", "38.25.17.101", "2025-04-27 20:26:34", "2025-04-27 20:26:34", "Good <a href=\"https://urlr.me/zH3wE5\" rel=\"nofollow ugc\">https://urlr.me/zH3wE5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "1", "Pearl4770", "Pearl4770@gmail.com", "", "120.25.199.3", "2025-04-28 04:10:41", "2025-04-28 04:10:41", "Good <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "1", "Destiny4389", "Destiny4389@gmail.com", "", "119.73.97.142", "2025-04-28 07:27:51", "2025-04-28 07:27:51", "Good <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "1", "Elliott3380", "Elliott3380@gmail.com", "", "46.101.104.251", "2025-04-28 08:32:37", "2025-04-28 08:32:37", "Good <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("25", "1", "Julie4306", "Julie4306@gmail.com", "", "83.110.89.217", "2025-04-28 11:11:59", "2025-04-28 11:11:59", "Good <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "1", "Lily4365", "Lily4365@gmail.com", "", "101.10.238.75", "2025-04-28 12:57:35", "2025-04-28 12:57:35", "Awesome <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("27", "1", "Kimberly1612", "Kimberly1612@gmail.com", "", "45.177.255.62", "2025-04-28 13:32:54", "2025-04-28 13:32:54", "Awesome <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("28", "1", "Lynda2400", "Lynda2400@gmail.com", "", "190.232.101.170", "2025-04-28 14:24:53", "2025-04-28 14:24:53", "Good <a href=\"https://rb.gy/4gq2o4\" rel=\"nofollow ugc\">https://rb.gy/4gq2o4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("29", "1", "Nevaeh2045", "Nevaeh2045@gmail.com", "", "3.92.227.253", "2025-04-28 16:47:06", "2025-04-28 16:47:06", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("30", "1", "Briana1287", "Briana1287@gmail.com", "", "190.158.28.64", "2025-04-28 17:41:02", "2025-04-28 17:41:02", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("31", "1", "Chandler2553", "Chandler2553@gmail.com", "", "64.225.63.189", "2025-04-28 21:27:50", "2025-04-28 21:27:50", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("32", "1", "Adelyn4401", "Adelyn4401@gmail.com", "", "170.253.189.36", "2025-04-28 21:31:13", "2025-04-28 21:31:13", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("33", "1", "Vanessa2996", "Vanessa2996@gmail.com", "", "41.90.69.136", "2025-04-28 23:31:38", "2025-04-28 23:31:38", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("34", "1", "Carson1040", "Carson1040@gmail.com", "", "186.113.106.225", "2025-04-29 03:55:17", "2025-04-29 03:55:17", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("35", "1", "Holden1752", "Holden1752@gmail.com", "", "142.198.91.102", "2025-04-29 14:32:43", "2025-04-29 14:32:43", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("36", "1", "Katie3365", "Katie3365@gmail.com", "", "181.29.233.118", "2025-04-29 15:13:14", "2025-04-29 15:13:14", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("37", "1", "Alexis1103", "Alexis1103@gmail.com", "", "128.201.83.69", "2025-04-29 21:11:24", "2025-04-29 21:11:24", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("38", "1", "Brett4912", "Brett4912@gmail.com", "", "190.112.99.32", "2025-04-29 21:21:29", "2025-04-29 21:21:29", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("39", "1", "Blanca2754", "Blanca2754@gmail.com", "", "190.120.246.46", "2025-04-29 23:25:54", "2025-04-29 23:25:54", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("40", "1", "Graham2593", "Graham2593@gmail.com", "", "115.132.251.27", "2025-04-30 03:08:55", "2025-04-30 03:08:55", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("41", "1", "Devon4529", "Devon4529@gmail.com", "", "49.48.47.252", "2025-04-30 03:16:01", "2025-04-30 03:16:01", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("42", "1", "Elaine1809", "Elaine1809@gmail.com", "", "173.56.17.51", "2025-04-30 04:07:48", "2025-04-30 04:07:48", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("43", "1", "Vincent1905", "Vincent1905@gmail.com", "", "43.135.180.26", "2025-04-30 05:02:43", "2025-04-30 05:02:43", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("44", "1", "Betsy176", "Betsy176@gmail.com", "", "103.166.244.175", "2025-04-30 08:02:53", "2025-04-30 08:02:53", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("45", "1", "Sharon2084", "Sharon2084@gmail.com", "", "171.239.235.205", "2025-04-30 08:29:06", "2025-04-30 08:29:06", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("46", "1", "Alison2376", "Alison2376@gmail.com", "", "174.138.219.248", "2025-04-30 13:15:00", "2025-04-30 13:15:00", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("47", "1", "Emmanuel2712", "Emmanuel2712@gmail.com", "", "190.102.13.27", "2025-04-30 17:05:45", "2025-04-30 17:05:45", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("48", "1", "Danny640", "Danny640@gmail.com", "", "189.252.122.225", "2025-04-30 18:08:23", "2025-04-30 18:08:23", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("49", "1", "Lila3405", "Lila3405@gmail.com", "", "193.141.127.108", "2025-04-30 22:44:52", "2025-04-30 22:44:52", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("50", "1", "Harmony2422", "Harmony2422@gmail.com", "", "138.19.36.204", "2025-05-01 00:12:19", "2025-05-01 00:12:19", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("51", "1", "Albert1817", "Albert1817@gmail.com", "", "150.107.247.74", "2025-05-01 00:56:50", "2025-05-01 00:56:50", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("52", "1", "Nigel2305", "Nigel2305@gmail.com", "", "152.173.92.1", "2025-05-01 03:55:39", "2025-05-01 03:55:39", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("53", "1", "Jason1095", "Jason1095@gmail.com", "", "182.53.22.189", "2025-05-01 03:57:17", "2025-05-01 03:57:17", "Awesome <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("54", "1", "Bridget2359", "Bridget2359@gmail.com", "", "113.132.112.169", "2025-05-01 07:06:43", "2025-05-01 07:06:43", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("55", "1", "Jared1367", "Jared1367@gmail.com", "", "64.119.30.17", "2025-05-01 08:55:16", "2025-05-01 08:55:16", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("56", "1", "Julian3853", "Julian3853@gmail.com", "", "188.50.104.191", "2025-05-01 11:24:38", "2025-05-01 11:24:38", "Good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("57", "1", "Dominique1392", "Dominique1392@gmail.com", "", "174.91.79.244", "2025-05-01 13:33:13", "2025-05-01 13:33:13", "Very good <a href=\"https://is.gd/N1ikS2\" rel=\"nofollow ugc\">https://is.gd/N1ikS2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("58", "1", "Sean2143", "Sean2143@gmail.com", "", "114.31.148.96", "2025-05-23 20:02:25", "2025-05-23 20:02:25", "Good partner program <a href=\"https://shorturl.fm/m8ueY\" rel=\"nofollow ugc\">https://shorturl.fm/m8ueY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("59", "1", "Hailee2013", "Hailee2013@gmail.com", "", "74.38.32.12", "2025-05-24 00:33:11", "2025-05-24 00:33:11", "Very good <a href=\"https://shorturl.fm/TbTre\" rel=\"nofollow ugc\">https://shorturl.fm/TbTre</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("60", "1", "Anthony2449", "Anthony2449@gmail.com", "", "175.107.214.65", "2025-05-24 01:28:07", "2025-05-24 01:28:07", "Very good partnership <a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("61", "1", "Virginia1242", "Virginia1242@gmail.com", "", "36.72.212.185", "2025-05-24 04:34:25", "2025-05-24 04:34:25", "Very good <a href=\"https://shorturl.fm/TbTre\" rel=\"nofollow ugc\">https://shorturl.fm/TbTre</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("62", "1", "Gerald1863", "Gerald1863@gmail.com", "", "58.152.152.213", "2025-05-24 05:13:12", "2025-05-24 05:13:12", "Very good <a href=\"https://shorturl.fm/bODKa\" rel=\"nofollow ugc\">https://shorturl.fm/bODKa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("63", "1", "Dante931", "Dante931@gmail.com", "", "159.65.7.192", "2025-05-24 08:36:13", "2025-05-24 08:36:13", "Cool partnership <a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("64", "1", "Mary3087", "Mary3087@gmail.com", "", "111.88.196.150", "2025-05-24 17:04:42", "2025-05-24 17:04:42", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("65", "1", "Melinda919", "Melinda919@gmail.com", "", "171.247.172.201", "2025-05-25 08:43:38", "2025-05-25 08:43:38", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("66", "1", "Kourtney3468", "Kourtney3468@gmail.com", "", "61.141.244.88", "2025-05-25 10:14:14", "2025-05-25 10:14:14", "<a href=\"https://shorturl.fm/j3kEj\" rel=\"nofollow ugc\">https://shorturl.fm/j3kEj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("67", "1", "Gabrielle1193", "Gabrielle1193@gmail.com", "", "124.217.51.219", "2025-05-25 13:49:28", "2025-05-25 13:49:28", "<a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("68", "1", "Leon444", "Leon444@gmail.com", "", "202.188.12.171", "2025-05-26 05:14:56", "2025-05-26 05:14:56", "<a href=\"https://shorturl.fm/68Y8V\" rel=\"nofollow ugc\">https://shorturl.fm/68Y8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("69", "1", "Flora1238", "Flora1238@gmail.com", "", "103.81.113.40", "2025-05-26 07:19:48", "2025-05-26 07:19:48", "<a href=\"https://shorturl.fm/N6nl1\" rel=\"nofollow ugc\">https://shorturl.fm/N6nl1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("70", "1", "Cassandra2737", "Cassandra2737@gmail.com", "", "201.87.68.61", "2025-05-26 19:56:47", "2025-05-26 19:56:47", "<a href=\"https://shorturl.fm/oYjg5\" rel=\"nofollow ugc\">https://shorturl.fm/oYjg5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("71", "1", "Shirley4502", "Shirley4502@gmail.com", "", "170.199.221.111", "2025-05-27 22:57:08", "2025-05-27 22:57:08", "<a href=\"https://shorturl.fm/TbTre\" rel=\"nofollow ugc\">https://shorturl.fm/TbTre</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("72", "1", "Howard1138", "Howard1138@gmail.com", "", "216.121.145.246", "2025-05-28 02:03:52", "2025-05-28 02:03:52", "<a href=\"https://shorturl.fm/XIZGD\" rel=\"nofollow ugc\">https://shorturl.fm/XIZGD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("73", "1", "Leland2214", "Leland2214@gmail.com", "", "203.176.176.146", "2025-05-28 02:34:07", "2025-05-28 02:34:07", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("74", "1", "Jeffrey769", "Jeffrey769@gmail.com", "", "34.84.145.146", "2025-05-28 02:56:15", "2025-05-28 02:56:15", "<a href=\"https://shorturl.fm/FIJkD\" rel=\"nofollow ugc\">https://shorturl.fm/FIJkD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("75", "1", "Camden2378", "Camden2378@gmail.com", "", "103.57.95.173", "2025-05-28 11:56:31", "2025-05-28 11:56:31", "<a href=\"https://shorturl.fm/m8ueY\" rel=\"nofollow ugc\">https://shorturl.fm/m8ueY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("76", "1", "Gary228", "Gary228@gmail.com", "", "104.222.18.13", "2025-05-28 22:49:18", "2025-05-28 22:49:18", "<a href=\"https://shorturl.fm/9fnIC\" rel=\"nofollow ugc\">https://shorturl.fm/9fnIC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("77", "1", "Kiley2584", "Kiley2584@gmail.com", "", "27.79.153.77", "2025-05-28 23:56:40", "2025-05-28 23:56:40", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("78", "1", "Giselle2179", "Giselle2179@gmail.com", "", "103.136.57.180", "2025-05-29 02:29:29", "2025-05-29 02:29:29", "<a href=\"https://shorturl.fm/N6nl1\" rel=\"nofollow ugc\">https://shorturl.fm/N6nl1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("79", "1", "Anahi2874", "Anahi2874@gmail.com", "", "123.20.67.44", "2025-05-29 23:01:35", "2025-05-29 23:01:35", "<a href=\"https://shorturl.fm/6539m\" rel=\"nofollow ugc\">https://shorturl.fm/6539m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("80", "1", "Cynthia2937", "Cynthia2937@gmail.com", "", "45.140.143.77", "2025-05-30 11:43:11", "2025-05-30 11:43:11", "<a href=\"https://shorturl.fm/9fnIC\" rel=\"nofollow ugc\">https://shorturl.fm/9fnIC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("81", "1", "Kyle2385", "Kyle2385@gmail.com", "", "190.22.41.156", "2025-05-30 22:26:55", "2025-05-30 22:26:55", "<a href=\"https://shorturl.fm/I3T8M\" rel=\"nofollow ugc\">https://shorturl.fm/I3T8M</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("82", "1", "Harlan1566", "Harlan1566@gmail.com", "", "115.72.174.216", "2025-05-30 22:42:01", "2025-05-30 22:42:01", "<a href=\"https://shorturl.fm/TDuGJ\" rel=\"nofollow ugc\">https://shorturl.fm/TDuGJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("83", "1", "Jay1384", "Jay1384@gmail.com", "", "189.36.206.99", "2025-05-31 01:35:55", "2025-05-31 01:35:55", "<a href=\"https://shorturl.fm/nqe5E\" rel=\"nofollow ugc\">https://shorturl.fm/nqe5E</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("84", "1", "Amber3089", "Amber3089@gmail.com", "", "134.35.2.130", "2025-05-31 09:32:28", "2025-05-31 09:32:28", "<a href=\"https://shorturl.fm/I3T8M\" rel=\"nofollow ugc\">https://shorturl.fm/I3T8M</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("85", "1", "Ayla4849", "Ayla4849@gmail.com", "", "49.206.35.111", "2025-05-31 14:17:32", "2025-05-31 14:17:32", "<a href=\"https://shorturl.fm/fSv4z\" rel=\"nofollow ugc\">https://shorturl.fm/fSv4z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("86", "1", "Jake4260", "Jake4260@gmail.com", "", "179.209.143.209", "2025-05-31 16:04:42", "2025-05-31 16:04:42", "<a href=\"https://shorturl.fm/PFOiP\" rel=\"nofollow ugc\">https://shorturl.fm/PFOiP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("87", "1", "Helen135", "Helen135@gmail.com", "", "104.28.210.23", "2025-06-01 01:35:42", "2025-06-01 01:35:42", "<a href=\"https://shorturl.fm/MVjF1\" rel=\"nofollow ugc\">https://shorturl.fm/MVjF1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("88", "1", "Jesus2591", "Jesus2591@gmail.com", "", "103.137.110.239", "2025-06-01 22:23:07", "2025-06-01 22:23:07", "<a href=\"https://shorturl.fm/I3T8M\" rel=\"nofollow ugc\">https://shorturl.fm/I3T8M</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("89", "1", "Bridget664", "Bridget664@gmail.com", "", "190.20.255.16", "2025-06-02 03:52:33", "2025-06-02 03:52:33", "<a href=\"https://shorturl.fm/IPXDm\" rel=\"nofollow ugc\">https://shorturl.fm/IPXDm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("90", "1", "Amelie3903", "Amelie3903@gmail.com", "", "125.26.212.218", "2025-06-02 05:25:13", "2025-06-02 05:25:13", "<a href=\"https://shorturl.fm/retLL\" rel=\"nofollow ugc\">https://shorturl.fm/retLL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("91", "1", "Tyler409", "Tyler409@gmail.com", "", "98.147.254.12", "2025-06-02 10:31:37", "2025-06-02 10:31:37", "<a href=\"https://shorturl.fm/0oNbA\" rel=\"nofollow ugc\">https://shorturl.fm/0oNbA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("92", "1", "Kendra575", "Kendra575@gmail.com", "", "195.62.50.247", "2025-07-09 07:06:17", "2025-07-09 07:06:17", "Become our affiliate—tap into unlimited earning potential! <a href=\"https://shorturl.fm/D6okQ\" rel=\"nofollow ugc\">https://shorturl.fm/D6okQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("93", "1", "Natasha3719", "Natasha3719@gmail.com", "", "181.174.231.45", "2025-07-09 09:21:39", "2025-07-09 09:21:39", "Start sharing our link and start earning today! <a href=\"https://shorturl.fm/2tHvb\" rel=\"nofollow ugc\">https://shorturl.fm/2tHvb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("94", "1", "Phoebe794", "Phoebe794@gmail.com", "", "4.242.91.54", "2025-07-09 15:49:01", "2025-07-09 15:49:01", "Promote our brand and get paid—enroll in our affiliate program! <a href=\"https://shorturl.fm/gfwhZ\" rel=\"nofollow ugc\">https://shorturl.fm/gfwhZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("95", "1", "Roberto1292", "Roberto1292@gmail.com", "", "1.55.60.74", "2025-07-09 21:05:37", "2025-07-09 21:05:37", "Get paid for every referral—sign up for our affiliate program now! <a href=\"https://shorturl.fm/dEWrL\" rel=\"nofollow ugc\">https://shorturl.fm/dEWrL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("96", "1", "Wayne4960", "Wayne4960@gmail.com", "", "95.9.50.41", "2025-07-10 02:10:53", "2025-07-10 02:10:53", "Start sharing, start earning—become our affiliate today! <a href=\"https://shorturl.fm/NY8av\" rel=\"nofollow ugc\">https://shorturl.fm/NY8av</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("97", "1", "Ann3335", "Ann3335@gmail.com", "", "75.119.141.8", "2025-07-10 06:03:34", "2025-07-10 06:03:34", "Refer friends, collect commissions—sign up now! <a href=\"https://shorturl.fm/CWq9Y\" rel=\"nofollow ugc\">https://shorturl.fm/CWq9Y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("98", "1", "Bonnie43", "Bonnie43@gmail.com", "", "118.68.173.116", "2025-07-10 08:33:19", "2025-07-10 08:33:19", "Join our affiliate program and start earning today—sign up now! <a href=\"https://shorturl.fm/toLAd\" rel=\"nofollow ugc\">https://shorturl.fm/toLAd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("99", "1", "Eileen3392", "Eileen3392@gmail.com", "", "58.186.130.143", "2025-07-10 14:47:39", "2025-07-10 14:47:39", "Earn passive income with every click—sign up today! <a href=\"https://shorturl.fm/zZypM\" rel=\"nofollow ugc\">https://shorturl.fm/zZypM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("100", "1", "Holden385", "Holden385@gmail.com", "", "1.4.250.186", "2025-07-10 21:52:09", "2025-07-10 21:52:09", "Get rewarded for every recommendation—join our affiliate network! <a href=\"https://shorturl.fm/xTp9h\" rel=\"nofollow ugc\">https://shorturl.fm/xTp9h</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("101", "1", "Natasha4231", "Natasha4231@gmail.com", "", "101.108.116.49", "2025-07-11 01:01:12", "2025-07-11 01:01:12", "Apply now and receive dedicated support for affiliates! <a href=\"https://shorturl.fm/tQTLL\" rel=\"nofollow ugc\">https://shorturl.fm/tQTLL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("102", "1", "Kaden2649", "Kaden2649@gmail.com", "", "180.248.173.112", "2025-07-11 02:16:41", "2025-07-11 02:16:41", "Partner with us and earn recurring commissions—join the affiliate program! <a href=\"https://shorturl.fm/daJRN\" rel=\"nofollow ugc\">https://shorturl.fm/daJRN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("103", "1", "Toby2459", "Toby2459@gmail.com", "", "92.246.129.49", "2025-07-11 09:32:31", "2025-07-11 09:32:31", "Partner with us for high-paying affiliate deals—join now! <a href=\"https://shorturl.fm/9kbWW\" rel=\"nofollow ugc\">https://shorturl.fm/9kbWW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("104", "1", "Brett4398", "Brett4398@gmail.com", "", "1.65.179.65", "2025-07-11 15:53:02", "2025-07-11 15:53:02", "Refer friends and colleagues—get paid for every signup! <a href=\"https://shorturl.fm/xfSmc\" rel=\"nofollow ugc\">https://shorturl.fm/xfSmc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("105", "1", "Lorelei283", "Lorelei283@gmail.com", "", "58.186.220.79", "2025-07-11 16:24:32", "2025-07-11 16:24:32", "Become our partner and turn clicks into cash—join the affiliate program today! <a href=\"https://shorturl.fm/Oks7Y\" rel=\"nofollow ugc\">https://shorturl.fm/Oks7Y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("106", "1", "Hayes1204", "Hayes1204@gmail.com", "", "101.109.62.163", "2025-07-11 23:36:26", "2025-07-11 23:36:26", "Earn recurring commissions with each referral—enroll today! <a href=\"https://shorturl.fm/CZRUU\" rel=\"nofollow ugc\">https://shorturl.fm/CZRUU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("107", "1", "Laila4168", "Laila4168@gmail.com", "", "1.2.176.240", "2025-07-12 02:37:05", "2025-07-12 02:37:05", "Earn recurring commissions with each referral—enroll today! <a href=\"https://shorturl.fm/Ox9YB\" rel=\"nofollow ugc\">https://shorturl.fm/Ox9YB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("108", "1", "Kaitlyn3688", "Kaitlyn3688@gmail.com", "", "183.80.8.141", "2025-07-12 09:02:21", "2025-07-12 09:02:21", "Share your link, earn rewards—sign up for our affiliate program! <a href=\"https://shorturl.fm/fmGVT\" rel=\"nofollow ugc\">https://shorturl.fm/fmGVT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("109", "1", "Morgan2579", "Morgan2579@gmail.com", "", "115.74.9.203", "2025-07-12 10:40:20", "2025-07-12 10:40:20", "Earn passive income with every click—sign up today! <a href=\"https://shorturl.fm/slcb7\" rel=\"nofollow ugc\">https://shorturl.fm/slcb7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("110", "1", "Chandler1617", "Chandler1617@gmail.com", "", "188.166.209.247", "2025-07-12 11:08:17", "2025-07-12 11:08:17", "Invite your network, boost your income—sign up for our affiliate program now! <a href=\"https://shorturl.fm/m8oP4\" rel=\"nofollow ugc\">https://shorturl.fm/m8oP4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("111", "1", "Dora2161", "Dora2161@gmail.com", "", "84.239.43.170", "2025-07-12 13:50:00", "2025-07-12 13:50:00", "Earn passive income this month—become an affiliate partner and get paid! <a href=\"https://shorturl.fm/f7ZbG\" rel=\"nofollow ugc\">https://shorturl.fm/f7ZbG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("112", "1", "Amber4376", "Amber4376@gmail.com", "", "115.77.163.254", "2025-07-12 14:03:13", "2025-07-12 14:03:13", "Start earning on autopilot—become our affiliate partner! <a href=\"https://shorturl.fm/feC6H\" rel=\"nofollow ugc\">https://shorturl.fm/feC6H</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("113", "1", "Walter2499", "Walter2499@gmail.com", "", "116.107.202.92", "2025-07-12 22:47:31", "2025-07-12 22:47:31", "Share our products and watch your earnings grow—join our affiliate program! <a href=\"https://shorturl.fm/shOru\" rel=\"nofollow ugc\">https://shorturl.fm/shOru</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("114", "1", "Walter1499", "Walter1499@gmail.com", "", "183.80.23.173", "2025-07-14 07:53:20", "2025-07-14 07:53:20", "Promote our products and earn real money—apply today! <a href=\"https://shorturl.fm/SIbrt\" rel=\"nofollow ugc\">https://shorturl.fm/SIbrt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("115", "1", "Kane1045", "Kane1045@gmail.com", "", "27.79.220.148", "2025-07-14 12:53:32", "2025-07-14 12:53:32", "Share your unique link and earn up to 40% commission! <a href=\"https://shorturl.fm/PIGTn\" rel=\"nofollow ugc\">https://shorturl.fm/PIGTn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("116", "1", "Emilie2900", "Emilie2900@gmail.com", "", "42.180.0.58", "2025-07-14 13:42:31", "2025-07-14 13:42:31", "Grow your income stream—apply to our affiliate program today! <a href=\"https://shorturl.fm/TwkU5\" rel=\"nofollow ugc\">https://shorturl.fm/TwkU5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("117", "1", "Norman4055", "Norman4055@gmail.com", "", "115.77.172.20", "2025-07-14 21:18:49", "2025-07-14 21:18:49", "Partner with us for high-paying affiliate deals—join now! <a href=\"https://shorturl.fm/XckRK\" rel=\"nofollow ugc\">https://shorturl.fm/XckRK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("118", "1", "Billie4914", "Billie4914@gmail.com", "", "27.79.196.150", "2025-07-15 04:34:14", "2025-07-15 04:34:14", "Monetize your audience with our high-converting offers—apply today! <a href=\"https://shorturl.fm/9bgvV\" rel=\"nofollow ugc\">https://shorturl.fm/9bgvV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("119", "1", "Leon2527", "Leon2527@gmail.com", "", "149.233.176.249", "2025-07-15 13:38:25", "2025-07-15 13:38:25", "Partner with us for generous payouts—sign up today! <a href=\"https://shorturl.fm/G5N7s\" rel=\"nofollow ugc\">https://shorturl.fm/G5N7s</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("120", "1", "Steven1785", "Steven1785@gmail.com", "", "42.117.128.95", "2025-07-15 21:33:46", "2025-07-15 21:33:46", "Share your link and rake in rewards—join our affiliate team! <a href=\"https://shorturl.fm/Qqgxj\" rel=\"nofollow ugc\">https://shorturl.fm/Qqgxj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("121", "1", "Gavin203", "Gavin203@gmail.com", "", "207.166.177.178", "2025-07-16 02:25:05", "2025-07-16 02:25:05", "Grow your income stream—apply to our affiliate program today! <a href=\"https://shorturl.fm/gBwdi\" rel=\"nofollow ugc\">https://shorturl.fm/gBwdi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("122", "1", "Corey1", "Corey1@gmail.com", "", "27.79.184.217", "2025-07-16 09:36:51", "2025-07-16 09:36:51", "Refer friends, earn cash—sign up now! <a href=\"https://shorturl.fm/biFkI\" rel=\"nofollow ugc\">https://shorturl.fm/biFkI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("123", "1", "Corinne3081", "Corinne3081@gmail.com", "", "116.103.27.176", "2025-07-16 14:11:48", "2025-07-16 14:11:48", "Promote our brand and watch your income grow—join today! <a href=\"https://shorturl.fm/oi2D5\" rel=\"nofollow ugc\">https://shorturl.fm/oi2D5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("124", "1", "Mary1828", "Mary1828@gmail.com", "", "125.24.172.113", "2025-07-16 15:18:20", "2025-07-16 15:18:20", "Share your unique link and cash in—join now! <a href=\"https://shorturl.fm/CeIwj\" rel=\"nofollow ugc\">https://shorturl.fm/CeIwj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("125", "1", "Teagan2747", "Teagan2747@gmail.com", "", "42.180.0.58", "2025-07-16 18:53:31", "2025-07-16 18:53:31", "Sign up for our affiliate program and watch your earnings grow! <a href=\"https://shorturl.fm/SbJUQ\" rel=\"nofollow ugc\">https://shorturl.fm/SbJUQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("126", "1", "Miranda2795", "Miranda2795@gmail.com", "", "207.166.178.207", "2025-07-17 04:22:16", "2025-07-17 04:22:16", "Earn passive income with every click—sign up today! <a href=\"https://shorturl.fm/IwJvn\" rel=\"nofollow ugc\">https://shorturl.fm/IwJvn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("127", "1", "Anika149", "Anika149@gmail.com", "", "35.209.196.221", "2025-07-17 07:02:22", "2025-07-17 07:02:22", "Partner with us and enjoy recurring commission payouts! <a href=\"https://shorturl.fm/NDhZG\" rel=\"nofollow ugc\">https://shorturl.fm/NDhZG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("128", "1", "Haven2834", "Haven2834@gmail.com", "", "171.239.236.177", "2025-07-17 09:48:30", "2025-07-17 09:48:30", "Boost your income effortlessly—join our affiliate network now! <a href=\"https://shorturl.fm/98H3V\" rel=\"nofollow ugc\">https://shorturl.fm/98H3V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("129", "1", "Shirley2344", "Shirley2344@gmail.com", "", "212.56.53.87", "2025-07-17 21:10:47", "2025-07-17 21:10:47", "Unlock top-tier commissions—become our affiliate partner now! <a href=\"https://shorturl.fm/LiTPI\" rel=\"nofollow ugc\">https://shorturl.fm/LiTPI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("130", "1", "Braxton2611", "Braxton2611@gmail.com", "", "160.22.24.115", "2025-07-18 01:43:49", "2025-07-18 01:43:49", "Your influence, your income—join our affiliate network today! <a href=\"https://shorturl.fm/SFene\" rel=\"nofollow ugc\">https://shorturl.fm/SFene</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("131", "1", "Alyssa131", "Alyssa131@gmail.com", "", "27.79.199.10", "2025-07-18 04:46:28", "2025-07-18 04:46:28", "Your network, your earnings—apply to our affiliate program now! <a href=\"https://shorturl.fm/ZyPgt\" rel=\"nofollow ugc\">https://shorturl.fm/ZyPgt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("132", "1", "Isabelle4347", "Isabelle4347@gmail.com", "", "49.48.103.57", "2025-07-18 06:59:27", "2025-07-18 06:59:27", "Refer friends, earn cash—sign up now! <a href=\"https://shorturl.fm/4ZSGF\" rel=\"nofollow ugc\">https://shorturl.fm/4ZSGF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("133", "1", "Jasmine1640", "Jasmine1640@gmail.com", "", "1.53.116.174", "2025-07-18 13:01:53", "2025-07-18 13:01:53", "Become our affiliate and watch your wallet grow—apply now! <a href=\"https://shorturl.fm/scSXJ\" rel=\"nofollow ugc\">https://shorturl.fm/scSXJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("134", "1", "Brielle2136", "Brielle2136@gmail.com", "", "178.153.175.233", "2025-07-18 13:08:33", "2025-07-18 13:08:33", "Partner with us and enjoy high payouts—apply now! <a href=\"https://shorturl.fm/N9RaW\" rel=\"nofollow ugc\">https://shorturl.fm/N9RaW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("135", "1", "Elaine4056", "Elaine4056@gmail.com", "", "176.126.103.194", "2025-07-18 18:57:20", "2025-07-18 18:57:20", "Tap into unlimited earnings—sign up for our affiliate program! <a href=\"https://shorturl.fm/AQ1XJ\" rel=\"nofollow ugc\">https://shorturl.fm/AQ1XJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("136", "1", "Francisco4065", "Francisco4065@gmail.com", "", "182.52.66.3", "2025-07-19 06:18:42", "2025-07-19 06:18:42", "Drive sales, collect commissions—join our affiliate team! <a href=\"https://shorturl.fm/EKUXA\" rel=\"nofollow ugc\">https://shorturl.fm/EKUXA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("137", "1", "Brennan1980", "Brennan1980@gmail.com", "", "159.192.226.173", "2025-07-20 03:17:21", "2025-07-20 03:17:21", "Get paid for every referral—sign up for our affiliate program now! <a href=\"https://shorturl.fm/vypDv\" rel=\"nofollow ugc\">https://shorturl.fm/vypDv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("138", "1", "Ignacio2600", "Ignacio2600@gmail.com", "", "118.68.241.78", "2025-07-20 04:30:48", "2025-07-20 04:30:48", "Start earning passive income—become our affiliate partner! <a href=\"https://shorturl.fm/bCnSy\" rel=\"nofollow ugc\">https://shorturl.fm/bCnSy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("139", "1", "Chelsea3299", "Chelsea3299@gmail.com", "", "222.78.122.151", "2025-07-20 05:05:18", "2025-07-20 05:05:18", "Join our affiliate program and start earning today—sign up now! <a href=\"https://shorturl.fm/TFhjA\" rel=\"nofollow ugc\">https://shorturl.fm/TFhjA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("140", "1", "Aileen3353", "Aileen3353@gmail.com", "", "23.237.210.82", "2025-07-20 09:45:29", "2025-07-20 09:45:29", "Unlock exclusive rewards with every referral—apply to our affiliate program now! <a href=\"https://shorturl.fm/Sko5p\" rel=\"nofollow ugc\">https://shorturl.fm/Sko5p</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("141", "1", "Stanley1957", "Stanley1957@gmail.com", "", "34.159.180.128", "2025-07-20 14:39:47", "2025-07-20 14:39:47", "Monetize your audience with our high-converting offers—apply today! <a href=\"https://shorturl.fm/2E4kV\" rel=\"nofollow ugc\">https://shorturl.fm/2E4kV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("142", "1", "Marian3954", "Marian3954@gmail.com", "", "183.197.194.76", "2025-07-21 01:58:57", "2025-07-21 01:58:57", "<a href=\"https://shorturl.fm/48e71\" rel=\"nofollow ugc\">https://shorturl.fm/48e71</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("143", "1", "Mark4726", "Mark4726@gmail.com", "", "1.55.61.220", "2025-07-21 04:55:18", "2025-07-21 04:55:18", "<a href=\"https://shorturl.fm/1eb7S\" rel=\"nofollow ugc\">https://shorturl.fm/1eb7S</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("144", "1", "Haven4449", "Haven4449@gmail.com", "", "118.68.28.130", "2025-07-21 08:25:14", "2025-07-21 08:25:14", "<a href=\"https://shorturl.fm/g5SoY\" rel=\"nofollow ugc\">https://shorturl.fm/g5SoY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("145", "1", "Abbie2096", "Abbie2096@gmail.com", "", "101.109.104.137", "2025-07-21 13:03:30", "2025-07-21 13:03:30", "<a href=\"https://shorturl.fm/AdImq\" rel=\"nofollow ugc\">https://shorturl.fm/AdImq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("146", "1", "Bethany2631", "Bethany2631@gmail.com", "", "116.103.129.12", "2025-07-21 15:28:12", "2025-07-21 15:28:12", "<a href=\"https://shorturl.fm/nwRAZ\" rel=\"nofollow ugc\">https://shorturl.fm/nwRAZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("147", "1", "Roberto1213", "Roberto1213@gmail.com", "", "84.239.28.14", "2025-07-22 09:01:00", "2025-07-22 09:01:00", "<a href=\"https://shorturl.fm/5B5ke\" rel=\"nofollow ugc\">https://shorturl.fm/5B5ke</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("148", "1", "Sergio2626", "Sergio2626@gmail.com", "", "51.159.159.73", "2025-07-22 10:01:12", "2025-07-22 10:01:12", "<a href=\"https://shorturl.fm/22jUA\" rel=\"nofollow ugc\">https://shorturl.fm/22jUA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("149", "1", "Courtney3303", "Courtney3303@gmail.com", "", "123.20.4.0", "2025-07-22 10:11:34", "2025-07-22 10:11:34", "<a href=\"https://shorturl.fm/ERTHA\" rel=\"nofollow ugc\">https://shorturl.fm/ERTHA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("150", "1", "Brody3626", "Brody3626@gmail.com", "", "212.113.112.84", "2025-07-22 16:45:05", "2025-07-22 16:45:05", "<a href=\"https://shorturl.fm/PHSlp\" rel=\"nofollow ugc\">https://shorturl.fm/PHSlp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("151", "1", "Emerson1226", "Emerson1226@gmail.com", "", "103.145.34.141", "2025-07-22 18:25:09", "2025-07-22 18:25:09", "<a href=\"https://shorturl.fm/zHqa4\" rel=\"nofollow ugc\">https://shorturl.fm/zHqa4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("152", "1", "Blair3232", "Blair3232@gmail.com", "", "49.49.190.109", "2025-07-22 19:45:50", "2025-07-22 19:45:50", "<a href=\"https://shorturl.fm/8sxMw\" rel=\"nofollow ugc\">https://shorturl.fm/8sxMw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("153", "1", "Lucia4189", "Lucia4189@gmail.com", "", "193.95.53.131", "2025-07-23 02:15:17", "2025-07-23 02:15:17", "<a href=\"https://shorturl.fm/ikzP2\" rel=\"nofollow ugc\">https://shorturl.fm/ikzP2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("154", "1", "Ebony4260", "Ebony4260@gmail.com", "", "58.186.174.232", "2025-07-23 05:43:46", "2025-07-23 05:43:46", "<a href=\"https://shorturl.fm/V1rpm\" rel=\"nofollow ugc\">https://shorturl.fm/V1rpm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("155", "1", "Curtis1421", "Curtis1421@gmail.com", "", "77.110.123.32", "2025-07-23 08:18:18", "2025-07-23 08:18:18", "<a href=\"https://shorturl.fm/59g47\" rel=\"nofollow ugc\">https://shorturl.fm/59g47</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("156", "1", "Armando2233", "Armando2233@gmail.com", "", "1.53.92.56", "2025-07-23 08:31:36", "2025-07-23 08:31:36", "<a href=\"https://shorturl.fm/6Nlnb\" rel=\"nofollow ugc\">https://shorturl.fm/6Nlnb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("157", "1", "Briley546", "Briley546@gmail.com", "", "138.199.58.36", "2025-07-23 12:42:15", "2025-07-23 12:42:15", "<a href=\"https://shorturl.fm/YSHok\" rel=\"nofollow ugc\">https://shorturl.fm/YSHok</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("158", "1", "Michelle542", "Michelle542@gmail.com", "", "113.22.48.210", "2025-07-23 13:26:56", "2025-07-23 13:26:56", "<a href=\"https://shorturl.fm/6eyza\" rel=\"nofollow ugc\">https://shorturl.fm/6eyza</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("159", "1", "Parker2686", "Parker2686@gmail.com", "", "42.117.128.132", "2025-07-23 20:45:32", "2025-07-23 20:45:32", "<a href=\"https://shorturl.fm/oMgUy\" rel=\"nofollow ugc\">https://shorturl.fm/oMgUy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("160", "1", "Don2297", "Don2297@gmail.com", "", "1.53.92.92", "2025-07-24 07:34:51", "2025-07-24 07:34:51", "<a href=\"https://shorturl.fm/d0nPw\" rel=\"nofollow ugc\">https://shorturl.fm/d0nPw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("161", "1", "Oliver1115", "Oliver1115@gmail.com", "", "182.52.26.42", "2025-07-24 07:53:15", "2025-07-24 07:53:15", "<a href=\"https://shorturl.fm/byDcA\" rel=\"nofollow ugc\">https://shorturl.fm/byDcA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("162", "1", "Emilia2739", "Emilia2739@gmail.com", "", "42.113.21.130", "2025-07-24 08:01:57", "2025-07-24 08:01:57", "<a href=\"https://shorturl.fm/EgHoM\" rel=\"nofollow ugc\">https://shorturl.fm/EgHoM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("163", "1", "Cora3105", "Cora3105@gmail.com", "", "134.35.171.253", "2025-07-24 08:36:02", "2025-07-24 08:36:02", "<a href=\"https://shorturl.fm/ecUdx\" rel=\"nofollow ugc\">https://shorturl.fm/ecUdx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("164", "1", "Steve4124", "Steve4124@gmail.com", "", "192.121.102.204", "2025-07-24 11:17:27", "2025-07-24 11:17:27", "<a href=\"https://shorturl.fm/9rQjj\" rel=\"nofollow ugc\">https://shorturl.fm/9rQjj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("165", "1", "Ariana1351", "Ariana1351@gmail.com", "", "146.70.163.204", "2025-07-24 16:10:48", "2025-07-24 16:10:48", "<a href=\"https://shorturl.fm/b4Zk5\" rel=\"nofollow ugc\">https://shorturl.fm/b4Zk5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("166", "1", "Drew63", "Drew63@gmail.com", "", "58.186.163.165", "2025-07-24 19:07:24", "2025-07-24 19:07:24", "<a href=\"https://shorturl.fm/cQK3Z\" rel=\"nofollow ugc\">https://shorturl.fm/cQK3Z</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("167", "1", "Aubrey1813", "Aubrey1813@gmail.com", "", "42.118.74.151", "2025-07-25 01:49:25", "2025-07-25 01:49:25", "<a href=\"https://shorturl.fm/mU0Th\" rel=\"nofollow ugc\">https://shorturl.fm/mU0Th</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("168", "1", "Victor2515", "Victor2515@gmail.com", "", "104.238.30.17", "2025-07-25 08:49:19", "2025-07-25 08:49:19", "<a href=\"https://shorturl.fm/A1YZ0\" rel=\"nofollow ugc\">https://shorturl.fm/A1YZ0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("169", "1", "Brent827", "Brent827@gmail.com", "", "1.54.82.30", "2025-07-25 15:58:02", "2025-07-25 15:58:02", "<a href=\"https://shorturl.fm/I2zTO\" rel=\"nofollow ugc\">https://shorturl.fm/I2zTO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("170", "1", "Clementine138", "Clementine138@gmail.com", "", "116.98.239.16", "2025-07-25 19:47:46", "2025-07-25 19:47:46", "<a href=\"https://shorturl.fm/x6fbL\" rel=\"nofollow ugc\">https://shorturl.fm/x6fbL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("171", "1", "Beryl266", "Beryl266@gmail.com", "", "118.99.91.5", "2025-07-26 06:46:26", "2025-07-26 06:46:26", "<a href=\"https://shorturl.fm/JxEzb\" rel=\"nofollow ugc\">https://shorturl.fm/JxEzb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("172", "1", "Adrian805", "Adrian805@gmail.com", "", "116.98.178.20", "2025-07-26 08:37:56", "2025-07-26 08:37:56", "<a href=\"https://shorturl.fm/YlnV0\" rel=\"nofollow ugc\">https://shorturl.fm/YlnV0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("173", "1", "Raymond2494", "Raymond2494@gmail.com", "", "94.59.193.161", "2025-07-26 10:31:41", "2025-07-26 10:31:41", "<a href=\"https://shorturl.fm/jV0Ai\" rel=\"nofollow ugc\">https://shorturl.fm/jV0Ai</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("174", "1", "Isla3281", "Isla3281@gmail.com", "", "190.102.4.62", "2025-07-26 11:14:38", "2025-07-26 11:14:38", "<a href=\"https://shorturl.fm/OjpdD\" rel=\"nofollow ugc\">https://shorturl.fm/OjpdD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("175", "1", "Chance3810", "Chance3810@gmail.com", "", "45.170.226.132", "2025-07-26 17:22:45", "2025-07-26 17:22:45", "<a href=\"https://shorturl.fm/Wif9u\" rel=\"nofollow ugc\">https://shorturl.fm/Wif9u</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("176", "1", "Jillian1972", "Jillian1972@gmail.com", "", "171.238.77.140", "2025-07-26 18:27:05", "2025-07-26 18:27:05", "<a href=\"https://shorturl.fm/N66tF\" rel=\"nofollow ugc\">https://shorturl.fm/N66tF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("177", "1", "Britney1867", "Britney1867@gmail.com", "", "92.98.247.109", "2025-07-27 08:00:08", "2025-07-27 08:00:08", "<a href=\"https://shorturl.fm/70fmQ\" rel=\"nofollow ugc\">https://shorturl.fm/70fmQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("178", "1", "Kaden447", "Kaden447@gmail.com", "", "42.119.152.136", "2025-07-27 08:31:32", "2025-07-27 08:31:32", "<a href=\"https://shorturl.fm/zZGbO\" rel=\"nofollow ugc\">https://shorturl.fm/zZGbO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("179", "1", "Donna245", "Donna245@gmail.com", "", "42.118.3.41", "2025-07-27 08:43:41", "2025-07-27 08:43:41", "<a href=\"https://shorturl.fm/qroP5\" rel=\"nofollow ugc\">https://shorturl.fm/qroP5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("180", "1", "Chris1805", "Chris1805@gmail.com", "", "2.88.137.184", "2025-07-27 10:35:57", "2025-07-27 10:35:57", "<a href=\"https://shorturl.fm/lDQ0G\" rel=\"nofollow ugc\">https://shorturl.fm/lDQ0G</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("181", "1", "Marissa4704", "Marissa4704@gmail.com", "", "97.120.6.91", "2025-07-27 18:54:17", "2025-07-27 18:54:17", "<a href=\"https://shorturl.fm/D0kys\" rel=\"nofollow ugc\">https://shorturl.fm/D0kys</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("182", "1", "Keegan1334", "Keegan1334@gmail.com", "", "58.187.70.115", "2025-07-28 00:08:19", "2025-07-28 00:08:19", "<a href=\"https://shorturl.fm/eiDnH\" rel=\"nofollow ugc\">https://shorturl.fm/eiDnH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("183", "1", "Felix1120", "Felix1120@gmail.com", "", "170.0.56.154", "2025-07-28 14:27:38", "2025-07-28 14:27:38", "<a href=\"https://shorturl.fm/ce51C\" rel=\"nofollow ugc\">https://shorturl.fm/ce51C</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("184", "1", "Anthony3913", "Anthony3913@gmail.com", "", "45.236.151.37", "2025-07-28 20:14:16", "2025-07-28 20:14:16", "<a href=\"https://shorturl.fm/8sHD3\" rel=\"nofollow ugc\">https://shorturl.fm/8sHD3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("185", "1", "Imelda2440", "Imelda2440@gmail.com", "", "47.115.35.231", "2025-07-29 11:09:46", "2025-07-29 11:09:46", "<a href=\"https://shorturl.fm/FF2Bj\" rel=\"nofollow ugc\">https://shorturl.fm/FF2Bj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("186", "1", "Keegan4345", "Keegan4345@gmail.com", "", "99.38.246.74", "2025-07-29 16:00:15", "2025-07-29 16:00:15", "<a href=\"https://shorturl.fm/7vwaS\" rel=\"nofollow ugc\">https://shorturl.fm/7vwaS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("187", "1", "Fiona4324", "Fiona4324@gmail.com", "", "115.72.165.63", "2025-07-29 18:24:32", "2025-07-29 18:24:32", "<a href=\"https://shorturl.fm/Hjld8\" rel=\"nofollow ugc\">https://shorturl.fm/Hjld8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("188", "1", "Hope3569", "Hope3569@gmail.com", "", "179.26.127.8", "2025-07-29 23:17:36", "2025-07-29 23:17:36", "<a href=\"https://shorturl.fm/pwEP2\" rel=\"nofollow ugc\">https://shorturl.fm/pwEP2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("189", "1", "Naomi3693", "Naomi3693@gmail.com", "", "71.197.211.224", "2025-07-30 03:39:53", "2025-07-30 03:39:53", "<a href=\"https://shorturl.fm/VSmqf\" rel=\"nofollow ugc\">https://shorturl.fm/VSmqf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("190", "1", "Martin3758", "Martin3758@gmail.com", "", "171.5.186.141", "2025-07-30 04:07:08", "2025-07-30 04:07:08", "<a href=\"https://shorturl.fm/qGaWl\" rel=\"nofollow ugc\">https://shorturl.fm/qGaWl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("191", "1", "Maxwell1419", "Maxwell1419@gmail.com", "", "42.106.176.244", "2025-07-30 07:23:10", "2025-07-30 07:23:10", "<a href=\"https://shorturl.fm/hBffN\" rel=\"nofollow ugc\">https://shorturl.fm/hBffN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("192", "1", "Andre2509", "Andre2509@gmail.com", "", "14.225.212.81", "2025-07-30 15:46:45", "2025-07-30 15:46:45", "<a href=\"https://shorturl.fm/NqfsD\" rel=\"nofollow ugc\">https://shorturl.fm/NqfsD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("193", "1", "Lyla1668", "Lyla1668@gmail.com", "", "203.177.230.117", "2025-07-31 00:44:42", "2025-07-31 00:44:42", "<a href=\"https://shorturl.fm/Va0JN\" rel=\"nofollow ugc\">https://shorturl.fm/Va0JN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("194", "1", "Jolie1625", "Jolie1625@gmail.com", "", "116.103.135.25", "2025-07-31 06:53:03", "2025-07-31 06:53:03", "<a href=\"https://shorturl.fm/ThDGw\" rel=\"nofollow ugc\">https://shorturl.fm/ThDGw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("195", "1", "Logan2255", "Logan2255@gmail.com", "", "180.180.19.17", "2025-07-31 17:00:51", "2025-07-31 17:00:51", "<a href=\"https://shorturl.fm/0hZQM\" rel=\"nofollow ugc\">https://shorturl.fm/0hZQM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("196", "1", "Leonard1445", "Leonard1445@gmail.com", "", "104.28.229.228", "2025-08-01 16:22:12", "2025-08-01 16:22:12", "<a href=\"https://shorturl.fm/WOAzF\" rel=\"nofollow ugc\">https://shorturl.fm/WOAzF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("197", "1", "Christopher777", "Christopher777@gmail.com", "", "59.153.115.192", "2025-08-01 18:42:02", "2025-08-01 18:42:02", "<a href=\"https://shorturl.fm/LBqlW\" rel=\"nofollow ugc\">https://shorturl.fm/LBqlW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("198", "1", "Savannah1417", "Savannah1417@gmail.com", "", "14.34.157.40", "2025-08-01 22:24:29", "2025-08-01 22:24:29", "<a href=\"https://shorturl.fm/hX7a7\" rel=\"nofollow ugc\">https://shorturl.fm/hX7a7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("199", "1", "Denise4002", "Denise4002@gmail.com", "", "167.57.4.120", "2025-08-01 22:55:18", "2025-08-01 22:55:18", "<a href=\"https://shorturl.fm/hX7a7\" rel=\"nofollow ugc\">https://shorturl.fm/hX7a7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("200", "1", "Tiffany1030", "Tiffany1030@gmail.com", "", "42.180.0.58", "2025-08-02 07:48:25", "2025-08-02 07:48:25", "<a href=\"https://shorturl.fm/OJVZh\" rel=\"nofollow ugc\">https://shorturl.fm/OJVZh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("201", "1", "Roy572", "Roy572@gmail.com", "", "182.3.51.66", "2025-08-02 12:06:28", "2025-08-02 12:06:28", "<a href=\"https://shorturl.fm/cY5FX\" rel=\"nofollow ugc\">https://shorturl.fm/cY5FX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("202", "1", "Ryder3451", "Ryder3451@gmail.com", "", "122.252.180.152", "2025-08-03 02:06:14", "2025-08-03 02:06:14", "<a href=\"https://shorturl.fm/ieT8O\" rel=\"nofollow ugc\">https://shorturl.fm/ieT8O</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("203", "1", "Raymond2764", "Raymond2764@gmail.com", "", "188.71.248.21", "2025-08-03 02:31:24", "2025-08-03 02:31:24", "<a href=\"https://shorturl.fm/tprq8\" rel=\"nofollow ugc\">https://shorturl.fm/tprq8</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("204", "1", "Caleb3653", "Caleb3653@gmail.com", "", "49.48.41.79", "2025-08-03 12:32:25", "2025-08-03 12:32:25", "<a href=\"https://shorturl.fm/DnTdu\" rel=\"nofollow ugc\">https://shorturl.fm/DnTdu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("205", "1", "Darby2109", "Darby2109@gmail.com", "", "177.161.161.100", "2025-08-03 19:09:19", "2025-08-03 19:09:19", "<a href=\"https://shorturl.fm/PuIPr\" rel=\"nofollow ugc\">https://shorturl.fm/PuIPr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("206", "1", "Esther3373", "Esther3373@gmail.com", "", "134.236.231.193", "2025-08-03 22:10:23", "2025-08-03 22:10:23", "<a href=\"https://shorturl.fm/dnSVG\" rel=\"nofollow ugc\">https://shorturl.fm/dnSVG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("207", "1", "Damian3808", "Damian3808@gmail.com", "", "58.186.110.157", "2025-08-04 01:33:04", "2025-08-04 01:33:04", "<a href=\"https://shorturl.fm/oUbfT\" rel=\"nofollow ugc\">https://shorturl.fm/oUbfT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("208", "1", "Kristin2122", "Kristin2122@gmail.com", "", "1.54.76.155", "2025-08-04 03:26:09", "2025-08-04 03:26:09", "<a href=\"https://shorturl.fm/igyOq\" rel=\"nofollow ugc\">https://shorturl.fm/igyOq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("209", "1", "Colt395", "Colt395@gmail.com", "", "125.24.182.78", "2025-08-04 05:59:29", "2025-08-04 05:59:29", "<a href=\"https://shorturl.fm/OajIh\" rel=\"nofollow ugc\">https://shorturl.fm/OajIh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("210", "1", "Edna3094", "Edna3094@gmail.com", "", "182.253.9.66", "2025-08-05 01:17:09", "2025-08-05 01:17:09", "<a href=\"https://shorturl.fm/QpyEN\" rel=\"nofollow ugc\">https://shorturl.fm/QpyEN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("211", "1", "Makenzie2978", "Makenzie2978@gmail.com", "", "186.54.55.230", "2025-08-05 02:07:37", "2025-08-05 02:07:37", "<a href=\"https://shorturl.fm/yJ4xB\" rel=\"nofollow ugc\">https://shorturl.fm/yJ4xB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("212", "1", "Drake1003", "Drake1003@gmail.com", "", "118.173.88.41", "2025-08-05 05:12:16", "2025-08-05 05:12:16", "<a href=\"https://shorturl.fm/EY2zu\" rel=\"nofollow ugc\">https://shorturl.fm/EY2zu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("213", "1", "Marcel3306", "Marcel3306@gmail.com", "", "160.187.174.194", "2025-08-05 09:37:57", "2025-08-05 09:37:57", "<a href=\"https://shorturl.fm/F1tJA\" rel=\"nofollow ugc\">https://shorturl.fm/F1tJA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("214", "1", "Melinda3601", "Melinda3601@gmail.com", "", "42.113.21.213", "2025-08-05 15:36:48", "2025-08-05 15:36:48", "<a href=\"https://shorturl.fm/3emIv\" rel=\"nofollow ugc\">https://shorturl.fm/3emIv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("215", "1", "Horace4772", "Horace4772@gmail.com", "", "184.82.18.34", "2025-08-06 13:17:14", "2025-08-06 13:17:14", "<a href=\"https://shorturl.fm/afkWi\" rel=\"nofollow ugc\">https://shorturl.fm/afkWi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("216", "1", "Ron4086", "Ron4086@gmail.com", "", "189.60.190.57", "2025-08-06 14:22:55", "2025-08-06 14:22:55", "<a href=\"https://shorturl.fm/ua5au\" rel=\"nofollow ugc\">https://shorturl.fm/ua5au</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("217", "1", "Ashley1201", "Ashley1201@gmail.com", "", "142.147.56.185", "2025-08-06 17:01:50", "2025-08-06 17:01:50", "<a href=\"https://shorturl.fm/GY43N\" rel=\"nofollow ugc\">https://shorturl.fm/GY43N</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("218", "1", "Lorenzo3289", "Lorenzo3289@gmail.com", "", "102.38.9.241", "2025-08-06 18:12:57", "2025-08-06 18:12:57", "<a href=\"https://shorturl.fm/Stdeq\" rel=\"nofollow ugc\">https://shorturl.fm/Stdeq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("219", "1", "Miley2873", "Miley2873@gmail.com", "", "41.128.183.13", "2025-08-07 00:19:28", "2025-08-07 00:19:28", "<a href=\"https://shorturl.fm/gFqUF\" rel=\"nofollow ugc\">https://shorturl.fm/gFqUF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("220", "1", "Jordan3089", "Jordan3089@gmail.com", "", "186.189.46.251", "2025-08-07 19:29:56", "2025-08-07 19:29:56", "<a href=\"https://shorturl.fm/XGN90\" rel=\"nofollow ugc\">https://shorturl.fm/XGN90</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("221", "1", "Emilie105", "Emilie105@gmail.com", "", "185.100.245.26", "2025-08-08 05:24:05", "2025-08-08 05:24:05", "<a href=\"https://shorturl.fm/tHK6R\" rel=\"nofollow ugc\">https://shorturl.fm/tHK6R</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("222", "1", "Alanna1527", "Alanna1527@gmail.com", "", "27.124.75.2", "2025-08-08 06:38:23", "2025-08-08 06:38:23", "<a href=\"https://shorturl.fm/ldDzt\" rel=\"nofollow ugc\">https://shorturl.fm/ldDzt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("223", "1", "Melanie3454", "Melanie3454@gmail.com", "", "112.200.134.47", "2025-08-08 11:50:20", "2025-08-08 11:50:20", "<a href=\"https://shorturl.fm/2ku9f\" rel=\"nofollow ugc\">https://shorturl.fm/2ku9f</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("224", "1", "Dina1074", "Dina1074@gmail.com", "", "212.70.108.139", "2025-08-08 13:12:32", "2025-08-08 13:12:32", "<a href=\"https://shorturl.fm/qIJPM\" rel=\"nofollow ugc\">https://shorturl.fm/qIJPM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("225", "1", "Rory3867", "Rory3867@gmail.com", "", "181.119.124.130", "2025-08-08 17:15:56", "2025-08-08 17:15:56", "<a href=\"https://shorturl.fm/T1Bkv\" rel=\"nofollow ugc\">https://shorturl.fm/T1Bkv</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("226", "1", "Harmony1369", "Harmony1369@gmail.com", "", "38.246.152.6", "2025-08-08 17:29:16", "2025-08-08 17:29:16", "<a href=\"https://shorturl.fm/GxhbS\" rel=\"nofollow ugc\">https://shorturl.fm/GxhbS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("227", "1", "Emerson1321", "Emerson1321@gmail.com", "", "58.136.173.181", "2025-08-08 23:18:41", "2025-08-08 23:18:41", "<a href=\"https://shorturl.fm/RigaB\" rel=\"nofollow ugc\">https://shorturl.fm/RigaB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("228", "1", "Brandon1816", "Brandon1816@gmail.com", "", "116.105.101.232", "2025-08-09 04:31:44", "2025-08-09 04:31:44", "<a href=\"https://shorturl.fm/gX3kr\" rel=\"nofollow ugc\">https://shorturl.fm/gX3kr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("229", "1", "Carolina551", "Carolina551@gmail.com", "", "171.237.103.254", "2025-08-09 22:57:43", "2025-08-09 22:57:43", "<a href=\"https://shorturl.fm/v5tEH\" rel=\"nofollow ugc\">https://shorturl.fm/v5tEH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("230", "1", "Martha150", "Martha150@gmail.com", "", "171.237.111.157", "2025-08-10 12:55:59", "2025-08-10 12:55:59", "<a href=\"https://shorturl.fm/JgvQT\" rel=\"nofollow ugc\">https://shorturl.fm/JgvQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("231", "1", "Carla2499", "Carla2499@gmail.com", "", "201.23.36.75", "2025-08-10 18:31:51", "2025-08-10 18:31:51", "<a href=\"https://shorturl.fm/ZsLKW\" rel=\"nofollow ugc\">https://shorturl.fm/ZsLKW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("232", "1", "Julie110", "Julie110@gmail.com", "", "170.78.23.189", "2025-08-10 20:09:31", "2025-08-10 20:09:31", "<a href=\"https://shorturl.fm/oUkUG\" rel=\"nofollow ugc\">https://shorturl.fm/oUkUG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("233", "1", "Mateo1047", "Mateo1047@gmail.com", "", "88.177.212.204", "2025-08-11 14:01:33", "2025-08-11 14:01:33", "<a href=\"https://shorturl.fm/EJAaI\" rel=\"nofollow ugc\">https://shorturl.fm/EJAaI</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("234", "1", "Doug2768", "Doug2768@gmail.com", "", "171.239.6.99", "2025-08-12 00:21:45", "2025-08-12 00:21:45", "<a href=\"https://shorturl.fm/1jJgE\" rel=\"nofollow ugc\">https://shorturl.fm/1jJgE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("235", "1", "Edna562", "Edna562@gmail.com", "", "49.51.231.97", "2025-08-12 03:03:00", "2025-08-12 03:03:00", "<a href=\"https://shorturl.fm/OStpQ\" rel=\"nofollow ugc\">https://shorturl.fm/OStpQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("236", "1", "Harold2902", "Harold2902@gmail.com", "", "27.79.153.234", "2025-08-13 00:48:01", "2025-08-13 00:48:01", "<a href=\"https://shorturl.fm/m6Nza\" rel=\"nofollow ugc\">https://shorturl.fm/m6Nza</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("237", "1", "Zachary4164", "Zachary4164@gmail.com", "", "118.210.99.97", "2025-08-13 10:37:48", "2025-08-13 10:37:48", "<a href=\"https://shorturl.fm/NPdiy\" rel=\"nofollow ugc\">https://shorturl.fm/NPdiy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("238", "1", "Ryder4811", "Ryder4811@gmail.com", "", "223.205.35.112", "2025-08-13 13:37:39", "2025-08-13 13:37:39", "<a href=\"https://shorturl.fm/e62u9\" rel=\"nofollow ugc\">https://shorturl.fm/e62u9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("239", "1", "Jayla382", "Jayla382@gmail.com", "", "62.234.206.73", "2025-08-13 21:53:55", "2025-08-13 21:53:55", "<a href=\"https://shorturl.fm/XOplX\" rel=\"nofollow ugc\">https://shorturl.fm/XOplX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("240", "1", "Brennan4118", "Brennan4118@gmail.com", "", "101.108.78.59", "2025-08-13 22:28:04", "2025-08-13 22:28:04", "<a href=\"https://shorturl.fm/0Ke8V\" rel=\"nofollow ugc\">https://shorturl.fm/0Ke8V</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("241", "1", "Edith1437", "Edith1437@gmail.com", "", "134.35.13.214", "2025-08-13 23:27:59", "2025-08-13 23:27:59", "<a href=\"https://shorturl.fm/hlhtb\" rel=\"nofollow ugc\">https://shorturl.fm/hlhtb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("242", "1", "Millie2580", "Millie2580@gmail.com", "", "103.210.221.129", "2025-08-14 01:03:10", "2025-08-14 01:03:10", "<a href=\"https://shorturl.fm/pc3AS\" rel=\"nofollow ugc\">https://shorturl.fm/pc3AS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("243", "1", "Alex286", "Alex286@gmail.com", "", "89.189.77.221", "2025-08-14 06:01:13", "2025-08-14 06:01:13", "<a href=\"https://shorturl.fm/yMuMB\" rel=\"nofollow ugc\">https://shorturl.fm/yMuMB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("244", "1", "Alfredo2611", "Alfredo2611@gmail.com", "", "39.106.149.155", "2025-08-14 11:26:25", "2025-08-14 11:26:25", "<a href=\"https://shorturl.fm/1ii5H\" rel=\"nofollow ugc\">https://shorturl.fm/1ii5H</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("245", "1", "Jordyn4724", "Jordyn4724@gmail.com", "", "115.72.44.233", "2025-08-14 19:34:06", "2025-08-14 19:34:06", "<a href=\"https://shorturl.fm/QOvVw\" rel=\"nofollow ugc\">https://shorturl.fm/QOvVw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("246", "1", "Lindsey174", "Lindsey174@gmail.com", "", "34.101.127.208", "2025-08-14 20:32:55", "2025-08-14 20:32:55", "<a href=\"https://shorturl.fm/O61mJ\" rel=\"nofollow ugc\">https://shorturl.fm/O61mJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("247", "1", "Darwin2914", "Darwin2914@gmail.com", "", "115.74.6.222", "2025-08-14 23:55:11", "2025-08-14 23:55:11", "<a href=\"https://shorturl.fm/Mioz4\" rel=\"nofollow ugc\">https://shorturl.fm/Mioz4</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("248", "1", "Adele4106", "Adele4106@gmail.com", "", "165.154.230.201", "2025-08-15 13:02:33", "2025-08-15 13:02:33", "<a href=\"https://shorturl.fm/IystU\" rel=\"nofollow ugc\">https://shorturl.fm/IystU</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("249", "1", "Karl1891", "Karl1891@gmail.com", "", "103.135.254.0", "2025-08-15 16:18:54", "2025-08-15 16:18:54", "<a href=\"https://shorturl.fm/nPjou\" rel=\"nofollow ugc\">https://shorturl.fm/nPjou</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("250", "1", "Anton2963", "Anton2963@gmail.com", "", "181.80.68.82", "2025-08-16 01:51:15", "2025-08-16 01:51:15", "<a href=\"https://shorturl.fm/gtX8Y\" rel=\"nofollow ugc\">https://shorturl.fm/gtX8Y</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("251", "1", "Louis1686", "Louis1686@gmail.com", "", "186.7.167.152", "2025-08-16 03:39:40", "2025-08-16 03:39:40", "<a href=\"https://shorturl.fm/yKJrY\" rel=\"nofollow ugc\">https://shorturl.fm/yKJrY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("252", "1", "Adam3342", "Adam3342@gmail.com", "", "125.24.178.192", "2025-08-16 09:52:54", "2025-08-16 09:52:54", "<a href=\"https://shorturl.fm/Lljyq\" rel=\"nofollow ugc\">https://shorturl.fm/Lljyq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("253", "1", "Gina3983", "Gina3983@gmail.com", "", "171.224.189.169", "2025-08-16 11:32:12", "2025-08-16 11:32:12", "<a href=\"https://shorturl.fm/ozTua\" rel=\"nofollow ugc\">https://shorturl.fm/ozTua</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("254", "1", "Mya567", "Mya567@gmail.com", "", "219.89.24.190", "2025-08-16 18:52:26", "2025-08-16 18:52:26", "<a href=\"https://shorturl.fm/s8SQ0\" rel=\"nofollow ugc\">https://shorturl.fm/s8SQ0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("255", "1", "Eleanor4083", "Eleanor4083@gmail.com", "", "27.79.254.44", "2025-08-17 00:09:57", "2025-08-17 00:09:57", "<a href=\"https://shorturl.fm/uasKm\" rel=\"nofollow ugc\">https://shorturl.fm/uasKm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("256", "1", "Bradley1032", "Bradley1032@gmail.com", "", "66.181.190.91", "2025-08-17 06:44:27", "2025-08-17 06:44:27", "<a href=\"https://shorturl.fm/XCfWY\" rel=\"nofollow ugc\">https://shorturl.fm/XCfWY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("257", "1", "Lindsay2846", "Lindsay2846@gmail.com", "", "118.200.157.243", "2025-08-17 09:28:13", "2025-08-17 09:28:13", "<a href=\"https://shorturl.fm/ZB0Lw\" rel=\"nofollow ugc\">https://shorturl.fm/ZB0Lw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("258", "1", "Irma4770", "Irma4770@gmail.com", "", "223.205.25.113", "2025-08-17 10:48:21", "2025-08-17 10:48:21", "<a href=\"https://shorturl.fm/SOFJQ\" rel=\"nofollow ugc\">https://shorturl.fm/SOFJQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("259", "1", "Bryan4453", "Bryan4453@gmail.com", "", "49.206.196.44", "2025-08-17 14:55:41", "2025-08-17 14:55:41", "<a href=\"https://shorturl.fm/3y1yG\" rel=\"nofollow ugc\">https://shorturl.fm/3y1yG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("260", "1", "Vincent3306", "Vincent3306@gmail.com", "", "103.212.145.254", "2025-08-17 16:25:07", "2025-08-17 16:25:07", "<a href=\"https://shorturl.fm/qCAqD\" rel=\"nofollow ugc\">https://shorturl.fm/qCAqD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("261", "1", "Peter2767", "Peter2767@gmail.com", "", "187.190.63.27", "2025-08-18 02:38:54", "2025-08-18 02:38:54", "<a href=\"https://shorturl.fm/EwZ3O\" rel=\"nofollow ugc\">https://shorturl.fm/EwZ3O</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("262", "1", "Kaitlyn492", "Kaitlyn492@gmail.com", "", "190.166.182.75", "2025-08-18 16:18:07", "2025-08-18 16:18:07", "<a href=\"https://shorturl.fm/S9W6P\" rel=\"nofollow ugc\">https://shorturl.fm/S9W6P</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("263", "1", "Darryl996", "Darryl996@gmail.com", "", "49.36.78.246", "2025-08-19 09:17:11", "2025-08-19 09:17:11", "<a href=\"https://shorturl.fm/Yj3sT\" rel=\"nofollow ugc\">https://shorturl.fm/Yj3sT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("264", "1", "Darwin4613", "Darwin4613@gmail.com", "", "140.213.1.227", "2025-08-19 10:02:05", "2025-08-19 10:02:05", "<a href=\"https://shorturl.fm/8qPZh\" rel=\"nofollow ugc\">https://shorturl.fm/8qPZh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("265", "1", "Roger981", "Roger981@gmail.com", "", "161.142.148.3", "2025-08-19 11:22:53", "2025-08-19 11:22:53", "<a href=\"https://shorturl.fm/CvfID\" rel=\"nofollow ugc\">https://shorturl.fm/CvfID</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("266", "1", "Marc3852", "Marc3852@gmail.com", "", "27.79.229.250", "2025-08-19 18:52:46", "2025-08-19 18:52:46", "<a href=\"https://shorturl.fm/SyvTb\" rel=\"nofollow ugc\">https://shorturl.fm/SyvTb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("267", "1", "Collin718", "Collin718@gmail.com", "", "200.56.106.56", "2025-08-20 09:09:43", "2025-08-20 09:09:43", "<a href=\"https://shorturl.fm/3VKKT\" rel=\"nofollow ugc\">https://shorturl.fm/3VKKT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("268", "1", "Sally4742", "Sally4742@gmail.com", "", "113.172.116.178", "2025-08-20 18:19:57", "2025-08-20 18:19:57", "<a href=\"https://shorturl.fm/MPusi\" rel=\"nofollow ugc\">https://shorturl.fm/MPusi</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("269", "1", "Elias4628", "Elias4628@gmail.com", "", "186.78.60.95", "2025-08-20 21:03:15", "2025-08-20 21:03:15", "<a href=\"https://shorturl.fm/G26oy\" rel=\"nofollow ugc\">https://shorturl.fm/G26oy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("270", "1", "Kai4980", "Kai4980@gmail.com", "", "172.83.229.35", "2025-08-21 03:44:34", "2025-08-21 03:44:34", "<a href=\"https://shorturl.fm/YKpEH\" rel=\"nofollow ugc\">https://shorturl.fm/YKpEH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("271", "1", "Abby711", "Abby711@gmail.com", "", "59.99.187.68", "2025-08-21 11:00:55", "2025-08-21 11:00:55", "<a href=\"https://shorturl.fm/NULE6\" rel=\"nofollow ugc\">https://shorturl.fm/NULE6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("272", "1", "Brianna4054", "Brianna4054@gmail.com", "", "163.61.50.1", "2025-08-21 20:33:26", "2025-08-21 20:33:26", "<a href=\"https://shorturl.fm/jYmma\" rel=\"nofollow ugc\">https://shorturl.fm/jYmma</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("273", "1", "Isaac497", "Isaac497@gmail.com", "", "27.79.166.50", "2025-08-22 01:28:43", "2025-08-22 01:28:43", "<a href=\"https://shorturl.fm/PwbCQ\" rel=\"nofollow ugc\">https://shorturl.fm/PwbCQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("274", "1", "Anika2973", "Anika2973@gmail.com", "", "223.204.122.167", "2025-08-22 02:50:35", "2025-08-22 02:50:35", "<a href=\"https://shorturl.fm/CKfwY\" rel=\"nofollow ugc\">https://shorturl.fm/CKfwY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("275", "1", "Oliver2376", "Oliver2376@gmail.com", "", "181.105.45.241", "2025-08-22 15:18:52", "2025-08-22 15:18:52", "<a href=\"https://shorturl.fm/zXmdC\" rel=\"nofollow ugc\">https://shorturl.fm/zXmdC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("276", "1", "Eugene3076", "Eugene3076@gmail.com", "", "92.97.166.151", "2025-08-22 21:34:42", "2025-08-22 21:34:42", "<a href=\"https://shorturl.fm/ZXOFX\" rel=\"nofollow ugc\">https://shorturl.fm/ZXOFX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("277", "1", "Amber3251", "Amber3251@gmail.com", "", "171.4.20.182", "2025-08-23 09:50:36", "2025-08-23 09:50:36", "<a href=\"https://shorturl.fm/H8q92\" rel=\"nofollow ugc\">https://shorturl.fm/H8q92</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("278", "1", "Holden2028", "Holden2028@gmail.com", "", "161.0.156.132", "2025-08-23 14:38:46", "2025-08-23 14:38:46", "<a href=\"https://shorturl.fm/kDnjL\" rel=\"nofollow ugc\">https://shorturl.fm/kDnjL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("279", "1", "Liam4630", "Liam4630@gmail.com", "", "84.255.184.198", "2025-08-23 15:27:15", "2025-08-23 15:27:15", "<a href=\"https://shorturl.fm/uB9o3\" rel=\"nofollow ugc\">https://shorturl.fm/uB9o3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("280", "1", "Felicity916", "Felicity916@gmail.com", "", "72.201.206.154", "2025-08-23 21:43:55", "2025-08-23 21:43:55", "<a href=\"https://shorturl.fm/Q82df\" rel=\"nofollow ugc\">https://shorturl.fm/Q82df</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("281", "1", "Bonnie998", "Bonnie998@gmail.com", "", "95.140.154.183", "2025-08-24 03:21:10", "2025-08-24 03:21:10", "<a href=\"https://shorturl.fm/RFc7I\" rel=\"nofollow ugc\">https://shorturl.fm/RFc7I</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("282", "1", "Audrey660", "Audrey660@gmail.com", "", "181.232.183.210", "2025-08-24 13:47:04", "2025-08-24 13:47:04", "<a href=\"https://shorturl.fm/azWvs\" rel=\"nofollow ugc\">https://shorturl.fm/azWvs</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("283", "1", "Edmund3620", "Edmund3620@gmail.com", "", "106.219.84.108", "2025-08-25 07:34:24", "2025-08-25 07:34:24", "<a href=\"https://shorturl.fm/8kBbq\" rel=\"nofollow ugc\">https://shorturl.fm/8kBbq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("284", "1", "Raphael4017", "Raphael4017@gmail.com", "", "108.215.126.18", "2025-08-25 09:13:38", "2025-08-25 09:13:38", "<a href=\"https://shorturl.fm/qJsJw\" rel=\"nofollow ugc\">https://shorturl.fm/qJsJw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("285", "1", "Jaime2849", "Jaime2849@gmail.com", "", "49.48.83.68", "2025-08-25 17:41:00", "2025-08-25 17:41:00", "<a href=\"https://shorturl.fm/eZFl6\" rel=\"nofollow ugc\">https://shorturl.fm/eZFl6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("286", "1", "Adrienne3180", "Adrienne3180@gmail.com", "", "123.21.25.138", "2025-08-26 19:15:54", "2025-08-26 19:15:54", "<a href=\"https://shorturl.fm/Nxa4U\" rel=\"nofollow ugc\">https://shorturl.fm/Nxa4U</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("287", "1", "Aurora2309", "Aurora2309@gmail.com", "", "181.130.0.29", "2025-08-26 20:44:56", "2025-08-26 20:44:56", "<a href=\"https://shorturl.fm/uMhFC\" rel=\"nofollow ugc\">https://shorturl.fm/uMhFC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("288", "1", "Ally1180", "Ally1180@gmail.com", "", "99.142.84.131", "2025-08-27 03:34:59", "2025-08-27 03:34:59", "<a href=\"https://shorturl.fm/nrUEA\" rel=\"nofollow ugc\">https://shorturl.fm/nrUEA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("289", "1", "Joy2201", "Joy2201@gmail.com", "", "201.108.5.152", "2025-08-27 07:27:17", "2025-08-27 07:27:17", "<a href=\"https://shorturl.fm/LJGFa\" rel=\"nofollow ugc\">https://shorturl.fm/LJGFa</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("290", "1", "Anne974", "Anne974@gmail.com", "", "5.195.106.238", "2025-08-27 10:11:43", "2025-08-27 10:11:43", "<a href=\"https://shorturl.fm/J3Gdk\" rel=\"nofollow ugc\">https://shorturl.fm/J3Gdk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("291", "1", "Emmett428", "Emmett428@gmail.com", "", "158.140.165.4", "2025-08-27 23:23:22", "2025-08-27 23:23:22", "<a href=\"https://shorturl.fm/qa5Fg\" rel=\"nofollow ugc\">https://shorturl.fm/qa5Fg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("292", "1", "McKenzie2635", "McKenzie2635@gmail.com", "", "120.140.41.71", "2025-08-28 01:58:37", "2025-08-28 01:58:37", "<a href=\"https://shorturl.fm/YiG2b\" rel=\"nofollow ugc\">https://shorturl.fm/YiG2b</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("293", "1", "Jade1473", "Jade1473@gmail.com", "", "103.18.76.174", "2025-08-28 02:02:42", "2025-08-28 02:02:42", "<a href=\"https://shorturl.fm/cCwHN\" rel=\"nofollow ugc\">https://shorturl.fm/cCwHN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("294", "1", "Cameron3107", "Cameron3107@gmail.com", "", "200.118.18.17", "2025-08-28 03:24:09", "2025-08-28 03:24:09", "<a href=\"https://shorturl.fm/uwJVz\" rel=\"nofollow ugc\">https://shorturl.fm/uwJVz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("295", "1", "Gabrielle756", "Gabrielle756@gmail.com", "", "49.49.193.22", "2025-08-28 13:02:05", "2025-08-28 13:02:05", "<a href=\"https://shorturl.fm/ntYt0\" rel=\"nofollow ugc\">https://shorturl.fm/ntYt0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("296", "1", "Chase4732", "Chase4732@gmail.com", "", "189.174.237.155", "2025-08-28 23:27:49", "2025-08-28 23:27:49", "<a href=\"https://shorturl.fm/B8KHw\" rel=\"nofollow ugc\">https://shorturl.fm/B8KHw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("297", "1", "Jared3718", "Jared3718@gmail.com", "", "24.194.166.98", "2025-08-30 01:02:19", "2025-08-30 01:02:19", "<a href=\"https://shorturl.fm/cV8cn\" rel=\"nofollow ugc\">https://shorturl.fm/cV8cn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("298", "1", "Charlotte4929", "Charlotte4929@gmail.com", "", "113.177.130.225", "2025-08-30 11:59:05", "2025-08-30 11:59:05", "<a href=\"https://shorturl.fm/1u53L\" rel=\"nofollow ugc\">https://shorturl.fm/1u53L</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("299", "1", "Brenda1312", "Brenda1312@gmail.com", "", "181.140.46.170", "2025-08-30 16:20:19", "2025-08-30 16:20:19", "<a href=\"https://shorturl.fm/zzqRr\" rel=\"nofollow ugc\">https://shorturl.fm/zzqRr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("300", "1", "Nelly3782", "Nelly3782@gmail.com", "", "181.61.246.222", "2025-08-30 17:23:27", "2025-08-30 17:23:27", "<a href=\"https://shorturl.fm/i6143\" rel=\"nofollow ugc\">https://shorturl.fm/i6143</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("301", "1", "Andrea2942", "Andrea2942@gmail.com", "", "116.105.172.68", "2025-08-31 09:11:39", "2025-08-31 09:11:39", "<a href=\"https://shorturl.fm/39vn3\" rel=\"nofollow ugc\">https://shorturl.fm/39vn3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("302", "1", "Josephine626", "Josephine626@gmail.com", "", "71.57.152.201", "2025-08-31 18:07:25", "2025-08-31 18:07:25", "<a href=\"https://shorturl.fm/xwrQK\" rel=\"nofollow ugc\">https://shorturl.fm/xwrQK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("303", "1", "Colin4518", "Colin4518@gmail.com", "", "27.147.202.188", "2025-09-01 03:51:36", "2025-09-01 03:51:36", "<a href=\"https://shorturl.fm/0ls9x\" rel=\"nofollow ugc\">https://shorturl.fm/0ls9x</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("304", "1", "Emilie4910", "Emilie4910@gmail.com", "", "201.141.26.202", "2025-09-01 06:17:47", "2025-09-01 06:17:47", "<a href=\"https://shorturl.fm/ACGNG\" rel=\"nofollow ugc\">https://shorturl.fm/ACGNG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("305", "1", "Wade1463", "Wade1463@gmail.com", "", "113.23.39.122", "2025-09-01 06:33:00", "2025-09-01 06:33:00", "<a href=\"https://shorturl.fm/2lOcH\" rel=\"nofollow ugc\">https://shorturl.fm/2lOcH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("306", "1", "Kayla3001", "Kayla3001@gmail.com", "", "187.172.120.187", "2025-09-01 17:17:05", "2025-09-01 17:17:05", "<a href=\"https://shorturl.fm/kM8zr\" rel=\"nofollow ugc\">https://shorturl.fm/kM8zr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("307", "1", "Ruth351", "Ruth351@gmail.com", "", "49.48.66.19", "2025-09-01 18:39:23", "2025-09-01 18:39:23", "<a href=\"https://shorturl.fm/dcvAn\" rel=\"nofollow ugc\">https://shorturl.fm/dcvAn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("308", "1", "Nigel314", "Nigel314@gmail.com", "", "38.7.3.47", "2025-09-01 22:02:11", "2025-09-01 22:02:11", "<a href=\"https://shorturl.fm/wdLol\" rel=\"nofollow ugc\">https://shorturl.fm/wdLol</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("309", "1", "Lorraine647", "Lorraine647@gmail.com", "", "109.98.148.216", "2025-09-02 06:28:10", "2025-09-02 06:28:10", "<a href=\"https://shorturl.fm/o99JP\" rel=\"nofollow ugc\">https://shorturl.fm/o99JP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("310", "1", "Erik3851", "Erik3851@gmail.com", "", "49.36.137.182", "2025-09-02 10:57:39", "2025-09-02 10:57:39", "<a href=\"https://shorturl.fm/GiFB6\" rel=\"nofollow ugc\">https://shorturl.fm/GiFB6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("311", "1", "Fernando783", "Fernando783@gmail.com", "", "47.251.43.115", "2025-09-02 19:19:32", "2025-09-02 19:19:32", "<a href=\"https://shorturl.fm/CMYbA\" rel=\"nofollow ugc\">https://shorturl.fm/CMYbA</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("312", "1", "Lindsay2610", "Lindsay2610@gmail.com", "", "192.82.65.8", "2025-09-03 01:22:59", "2025-09-03 01:22:59", "<a href=\"https://shorturl.fm/DdqQl\" rel=\"nofollow ugc\">https://shorturl.fm/DdqQl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("313", "1", "Lane3547", "Lane3547@gmail.com", "", "180.75.44.55", "2025-09-03 05:17:05", "2025-09-03 05:17:05", "<a href=\"https://shorturl.fm/gZrcg\" rel=\"nofollow ugc\">https://shorturl.fm/gZrcg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("314", "1", "Amalia2719", "Amalia2719@gmail.com", "", "121.144.91.105", "2025-09-03 06:04:54", "2025-09-03 06:04:54", "<a href=\"https://shorturl.fm/ySQ22\" rel=\"nofollow ugc\">https://shorturl.fm/ySQ22</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("315", "1", "Collin4697", "Collin4697@gmail.com", "", "65.216.167.69", "2025-09-03 14:06:03", "2025-09-03 14:06:03", "<a href=\"https://shorturl.fm/FZ9Hw\" rel=\"nofollow ugc\">https://shorturl.fm/FZ9Hw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("316", "1", "Carey1589", "Carey1589@gmail.com", "", "187.170.171.54", "2025-09-03 20:22:16", "2025-09-03 20:22:16", "<a href=\"https://shorturl.fm/mb1dk\" rel=\"nofollow ugc\">https://shorturl.fm/mb1dk</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("317", "1", "Carson3712", "Carson3712@gmail.com", "", "172.212.113.5", "2025-09-03 21:47:42", "2025-09-03 21:47:42", "<a href=\"https://shorturl.fm/AyrHu\" rel=\"nofollow ugc\">https://shorturl.fm/AyrHu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("318", "1", "Andrew2510", "Andrew2510@gmail.com", "", "121.176.51.80", "2025-09-04 01:51:44", "2025-09-04 01:51:44", "<a href=\"https://shorturl.fm/5xOYG\" rel=\"nofollow ugc\">https://shorturl.fm/5xOYG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("319", "1", "Matthias3968", "Matthias3968@gmail.com", "", "109.177.33.63", "2025-09-04 11:09:03", "2025-09-04 11:09:03", "<a href=\"https://shorturl.fm/4r4hB\" rel=\"nofollow ugc\">https://shorturl.fm/4r4hB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("320", "1", "Trent1424", "Trent1424@gmail.com", "", "171.5.116.247", "2025-09-04 20:18:54", "2025-09-04 20:18:54", "<a href=\"https://shorturl.fm/YFKSP\" rel=\"nofollow ugc\">https://shorturl.fm/YFKSP</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("321", "1", "Bernadette1787", "Bernadette1787@gmail.com", "", "218.212.71.19", "2025-09-05 12:30:31", "2025-09-05 12:30:31", "<a href=\"https://shorturl.fm/Y6E6u\" rel=\"nofollow ugc\">https://shorturl.fm/Y6E6u</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("322", "1", "Camille4900", "Camille4900@gmail.com", "", "118.68.213.178", "2025-09-05 13:36:10", "2025-09-05 13:36:10", "<a href=\"https://shorturl.fm/CT0CF\" rel=\"nofollow ugc\">https://shorturl.fm/CT0CF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("323", "1", "Trent1356", "Trent1356@gmail.com", "", "181.153.56.211", "2025-09-06 01:08:47", "2025-09-06 01:08:47", "<a href=\"https://shorturl.fm/1lmmp\" rel=\"nofollow ugc\">https://shorturl.fm/1lmmp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("324", "1", "Evie3941", "Evie3941@gmail.com", "", "49.49.22.104", "2025-09-06 08:34:23", "2025-09-06 08:34:23", "<a href=\"https://shorturl.fm/LH3Wm\" rel=\"nofollow ugc\">https://shorturl.fm/LH3Wm</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("325", "1", "Leila2251", "Leila2251@gmail.com", "", "186.96.20.137", "2025-09-06 15:48:06", "2025-09-06 15:48:06", "<a href=\"https://shorturl.fm/OczOO\" rel=\"nofollow ugc\">https://shorturl.fm/OczOO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("326", "1", "Alexandra3860", "Alexandra3860@gmail.com", "", "174.112.95.109", "2025-09-06 23:22:47", "2025-09-06 23:22:47", "<a href=\"https://shorturl.fm/8amhs\" rel=\"nofollow ugc\">https://shorturl.fm/8amhs</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("327", "1", "1xbet_rfSr", "xuoqcnzfmSr@luck-and-magic.site", "https://1xbetapkegypt.com/", "62.113.116.213", "2025-09-07 12:55:22", "2025-09-07 12:55:22", "للاستمتاع بجميع الوظائف والمراهنات الرياضية، قم بما يلي <a href=\"https://1xbetapkegypt.com/\" / rel=\"nofollow ugc\">كيف تفتح الملفات apk؟</a> وقم بتثبيت التطبيق على جهازك. \r\nمباشرة للغاية.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("328", "1", "Sergio3468", "Sergio3468@gmail.com", "", "187.49.187.143", "2025-09-07 14:15:35", "2025-09-07 14:15:35", "<a href=\"https://shorturl.fm/hcqt9\" rel=\"nofollow ugc\">https://shorturl.fm/hcqt9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("329", "1", "Anna3178", "Anna3178@gmail.com", "", "27.71.143.145", "2025-09-07 22:07:29", "2025-09-07 22:07:29", "<a href=\"https://shorturl.fm/WbDPd\" rel=\"nofollow ugc\">https://shorturl.fm/WbDPd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("330", "1", "Josh1974", "Josh1974@gmail.com", "", "183.80.22.204", "2025-09-08 04:01:21", "2025-09-08 04:01:21", "<a href=\"https://shorturl.fm/A5emp\" rel=\"nofollow ugc\">https://shorturl.fm/A5emp</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("331", "1", "Allan2757", "Allan2757@gmail.com", "", "103.46.8.102", "2025-09-08 12:20:27", "2025-09-08 12:20:27", "<a href=\"https://shorturl.fm/0vsXO\" rel=\"nofollow ugc\">https://shorturl.fm/0vsXO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("332", "1", "Lynn1637", "Lynn1637@gmail.com", "", "180.241.34.166", "2025-09-08 19:07:54", "2025-09-08 19:07:54", "<a href=\"https://shorturl.fm/43tyy\" rel=\"nofollow ugc\">https://shorturl.fm/43tyy</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("333", "1", "Francesco4820", "Francesco4820@gmail.com", "", "38.41.18.10", "2025-09-08 21:54:14", "2025-09-08 21:54:14", "<a href=\"https://shorturl.fm/7LosM\" rel=\"nofollow ugc\">https://shorturl.fm/7LosM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("334", "1", "Hailee2081", "Hailee2081@gmail.com", "", "116.96.102.139", "2025-09-08 23:17:49", "2025-09-08 23:17:49", "<a href=\"https://shorturl.fm/3Knog\" rel=\"nofollow ugc\">https://shorturl.fm/3Knog</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("335", "1", "Christine2260", "Christine2260@gmail.com", "", "165.101.14.254", "2025-09-09 05:12:13", "2025-09-09 05:12:13", "<a href=\"https://shorturl.fm/8Eovt\" rel=\"nofollow ugc\">https://shorturl.fm/8Eovt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("336", "1", "Ron2627", "Ron2627@gmail.com", "", "38.25.17.49", "2025-09-09 14:55:42", "2025-09-09 14:55:42", "<a href=\"https://shorturl.fm/LvQqe\" rel=\"nofollow ugc\">https://shorturl.fm/LvQqe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("337", "1", "Serena4089", "Serena4089@gmail.com", "", "205.237.104.203", "2025-09-09 16:50:33", "2025-09-09 16:50:33", "<a href=\"https://shorturl.fm/u6Q2L\" rel=\"nofollow ugc\">https://shorturl.fm/u6Q2L</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("338", "1", "Nathan3795", "Nathan3795@gmail.com", "", "152.53.204.57", "2025-09-09 17:04:48", "2025-09-09 17:04:48", "<a href=\"https://shorturl.fm/wjM6q\" rel=\"nofollow ugc\">https://shorturl.fm/wjM6q</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("339", "1", "Priscilla3970", "Priscilla3970@gmail.com", "", "111.185.115.62", "2025-09-10 00:07:08", "2025-09-10 00:07:08", "<a href=\"https://shorturl.fm/nlP9w\" rel=\"nofollow ugc\">https://shorturl.fm/nlP9w</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("340", "1", "Brian3241", "Brian3241@gmail.com", "", "220.245.29.202", "2025-09-10 12:15:56", "2025-09-10 12:15:56", "<a href=\"https://shorturl.fm/c8r6U\" rel=\"nofollow ugc\">https://shorturl.fm/c8r6U</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("341", "1", "Rhys4266", "Rhys4266@gmail.com", "", "181.166.101.169", "2025-09-10 13:35:37", "2025-09-10 13:35:37", "<a href=\"https://shorturl.fm/dmvFE\" rel=\"nofollow ugc\">https://shorturl.fm/dmvFE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("342", "1", "Eliana4013", "Eliana4013@gmail.com", "", "190.3.40.227", "2025-09-10 16:24:37", "2025-09-10 16:24:37", "<a href=\"https://shorturl.fm/nSNzg\" rel=\"nofollow ugc\">https://shorturl.fm/nSNzg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("343", "1", "McKenzie4239", "McKenzie4239@gmail.com", "", "176.150.143.106", "2025-09-11 01:26:24", "2025-09-11 01:26:24", "<a href=\"https://shorturl.fm/pQVyD\" rel=\"nofollow ugc\">https://shorturl.fm/pQVyD</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("344", "1", "Florence2493", "Florence2493@gmail.com", "", "43.224.116.222", "2025-09-11 08:58:58", "2025-09-11 08:58:58", "<a href=\"https://shorturl.fm/ZUmqB\" rel=\"nofollow ugc\">https://shorturl.fm/ZUmqB</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("345", "1", "Sharon3090", "Sharon3090@gmail.com", "", "103.147.246.17", "2025-09-11 14:28:41", "2025-09-11 14:28:41", "<a href=\"https://shorturl.fm/hCmTW\" rel=\"nofollow ugc\">https://shorturl.fm/hCmTW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("346", "1", "Pedro1510", "Pedro1510@gmail.com", "", "128.90.43.149", "2025-09-11 23:36:45", "2025-09-11 23:36:45", "<a href=\"https://shorturl.fm/rzSi7\" rel=\"nofollow ugc\">https://shorturl.fm/rzSi7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("347", "1", "Francis3269", "Francis3269@gmail.com", "", "167.62.250.223", "2025-09-12 00:52:34", "2025-09-12 00:52:34", "<a href=\"https://shorturl.fm/mSv7H\" rel=\"nofollow ugc\">https://shorturl.fm/mSv7H</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("348", "1", "Regina4008", "Regina4008@gmail.com", "", "157.15.139.138", "2025-09-12 21:24:59", "2025-09-12 21:24:59", "<a href=\"https://shorturl.fm/gNW8U\" rel=\"nofollow ugc\">https://shorturl.fm/gNW8U</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("349", "1", "Audrey2807", "Audrey2807@gmail.com", "", "103.153.39.37", "2025-09-12 21:49:48", "2025-09-12 21:49:48", "<a href=\"https://shorturl.fm/Xlwb7\" rel=\"nofollow ugc\">https://shorturl.fm/Xlwb7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("350", "1", "Agnes2770", "Agnes2770@gmail.com", "", "102.222.233.135", "2025-09-13 05:36:17", "2025-09-13 05:36:17", "<a href=\"https://shorturl.fm/r3VuH\" rel=\"nofollow ugc\">https://shorturl.fm/r3VuH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("351", "1", "Leonardo2320", "Leonardo2320@gmail.com", "", "43.224.116.222", "2025-09-13 16:52:29", "2025-09-13 16:52:29", "<a href=\"https://shorturl.fm/jVWfb\" rel=\"nofollow ugc\">https://shorturl.fm/jVWfb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("352", "1", "Alistair404", "Alistair404@gmail.com", "", "190.233.3.195", "2025-09-14 00:31:10", "2025-09-14 00:31:10", "<a href=\"https://shorturl.fm/Ih995\" rel=\"nofollow ugc\">https://shorturl.fm/Ih995</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("353", "1", "Felix3961", "Felix3961@gmail.com", "", "49.147.107.236", "2025-09-14 03:10:52", "2025-09-14 03:10:52", "<a href=\"https://shorturl.fm/AGsCb\" rel=\"nofollow ugc\">https://shorturl.fm/AGsCb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("354", "1", "Silas4136", "Silas4136@gmail.com", "", "39.185.41.192", "2025-09-14 07:39:48", "2025-09-14 07:39:48", "<a href=\"https://shorturl.fm/YJkR7\" rel=\"nofollow ugc\">https://shorturl.fm/YJkR7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("355", "1", "Halle3248", "Halle3248@gmail.com", "", "124.13.128.16", "2025-09-15 01:59:27", "2025-09-15 01:59:27", "<a href=\"https://shorturl.fm/vAyB6\" rel=\"nofollow ugc\">https://shorturl.fm/vAyB6</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("356", "1", "Frederick3164", "Frederick3164@gmail.com", "", "116.103.136.64", "2025-09-15 05:09:06", "2025-09-15 05:09:06", "<a href=\"https://shorturl.fm/Z2SCK\" rel=\"nofollow ugc\">https://shorturl.fm/Z2SCK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("357", "1", "Wesley1608", "Wesley1608@gmail.com", "", "217.164.43.50", "2025-09-15 10:54:13", "2025-09-15 10:54:13", "<a href=\"https://shorturl.fm/b1IHc\" rel=\"nofollow ugc\">https://shorturl.fm/b1IHc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("358", "1", "Makayla1495", "Makayla1495@gmail.com", "", "181.29.27.53", "2025-09-15 20:35:20", "2025-09-15 20:35:20", "<a href=\"https://shorturl.fm/xe6lT\" rel=\"nofollow ugc\">https://shorturl.fm/xe6lT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("359", "1", "Manuel1568", "Manuel1568@gmail.com", "", "171.245.67.64", "2025-09-16 02:17:52", "2025-09-16 02:17:52", "<a href=\"https://shorturl.fm/NXwds\" rel=\"nofollow ugc\">https://shorturl.fm/NXwds</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("360", "1", "Helen1466", "Helen1466@gmail.com", "", "208.87.243.199", "2025-09-16 08:21:24", "2025-09-16 08:21:24", "<a href=\"https://shorturl.fm/1c1Gx\" rel=\"nofollow ugc\">https://shorturl.fm/1c1Gx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("361", "1", "Jeremiah3927", "Jeremiah3927@gmail.com", "", "186.215.43.199", "2025-09-16 10:31:56", "2025-09-16 10:31:56", "<a href=\"https://shorturl.fm/XzqSJ\" rel=\"nofollow ugc\">https://shorturl.fm/XzqSJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("362", "1", "Judith2480", "Judith2480@gmail.com", "", "103.171.82.215", "2025-09-16 12:52:48", "2025-09-16 12:52:48", "<a href=\"https://shorturl.fm/DhAeG\" rel=\"nofollow ugc\">https://shorturl.fm/DhAeG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("363", "1", "Bernard3965", "Bernard3965@gmail.com", "", "167.99.71.71", "2025-09-17 09:11:44", "2025-09-17 09:11:44", "<a href=\"https://shorturl.fm/r6zuH\" rel=\"nofollow ugc\">https://shorturl.fm/r6zuH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("364", "1", "Felicity2791", "Felicity2791@gmail.com", "", "92.96.129.62", "2025-09-17 14:59:28", "2025-09-17 14:59:28", "<a href=\"https://shorturl.fm/2Krux\" rel=\"nofollow ugc\">https://shorturl.fm/2Krux</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("365", "1", "Mateo697", "Mateo697@gmail.com", "", "133.201.213.192", "2025-09-17 15:06:03", "2025-09-17 15:06:03", "<a href=\"https://shorturl.fm/3sQyw\" rel=\"nofollow ugc\">https://shorturl.fm/3sQyw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("366", "1", "888starz_leKn", "defqoeodrKn@cosmicbridge.site", "https://888starz-uzbekistan.ru/", "62.113.116.213", "2025-09-17 21:06:46", "2025-09-17 21:06:46", "Ushbu platformada barcha tranzaksiyalar maxfiy holda amalga oshiriladi. \r\n \r\nPlatformada turli xil tikish strategiyalarini sinab koʻrish mumkin. \r\n \r\nHar oyda turli aksiyalar va cashback imkoniyatlari ishlab chiqiladi. \r\n \r\nPlastik kartalar, elektron hamyonlar va kriptovalyutalar qabul qilinadi. \r\n \r\n888starz <a href=\"https://www.888starz-uzbekistan.ru\" rel=\"nofollow ugc\">https://888starz-uzbekistan.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("367", "1", "Brett1230", "Brett1230@gmail.com", "", "101.109.217.109", "2025-09-18 07:52:25", "2025-09-18 07:52:25", "<a href=\"https://shorturl.fm/OBAut\" rel=\"nofollow ugc\">https://shorturl.fm/OBAut</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("368", "1", "Guillermo1705", "Guillermo1705@gmail.com", "", "101.109.223.220", "2025-09-18 08:05:19", "2025-09-18 08:05:19", "<a href=\"https://shorturl.fm/AvuoS\" rel=\"nofollow ugc\">https://shorturl.fm/AvuoS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("369", "1", "Jared1027", "Jared1027@gmail.com", "", "59.91.135.8", "2025-09-18 15:01:51", "2025-09-18 15:01:51", "<a href=\"https://shorturl.fm/gIqj1\" rel=\"nofollow ugc\">https://shorturl.fm/gIqj1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("370", "1", "888starz_vwer", "nbvlpudhcer@galaxygate.store", "https://888starz2.ru/", "89.110.99.186", "2025-09-18 17:54:07", "2025-09-18 17:54:07", "888starz – это один из, которое предлагает. это заведение. помогают обеспечить. \r\n \r\nИгроки в 888starz, предлагаемых на платформе. известными провайдерами и обладает и увлекательным сюжетом. живую рулетку и карточные игры, что придаёт. \r\n \r\nявляется. разнообразные методы депозита и вывода средств, что удобным и быстрым. современными технологиями шифрования, что гарантирует. \r\n \r\nдля пользователей. работает, в любое время суток. через чат или электронную почту и на любые вопросы. Таким образом, комфорт. \r\nказино 888starz узбекистан <a href=\"http://www.888starz2.ru/\" / rel=\"nofollow ugc\">https://888starz2.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("371", "1", "888starz_dxPr", "lzfkuwywgPr@nebulanexus.site", "https://888starz-egypt-eg.com/", "178.20.42.76", "2025-09-18 23:59:25", "2025-09-18 23:59:25", "تتميز 888starz بشعبيتها في مجال القمار على الإنترنت. يتميز الموقع بتقديم العديد من أنواع الألعاب التي تلبي احتياجات جميع اللاعبين. تكمن الألعاب التي يوفرها الموقع في الرهانات الرياضية وألعاب الكازينو. \r\n \r\nتتميز 888starz بتصميم سهل الاستخدام. يمكن للمستخدمين التنقل بين الأقسام بسهولة. يؤدي ذلك إلى تحسين تجربة اللعب. \r\n \r\nتقدم 888starz مجموعة من العروض الترويجية لجذب اللاعبين الجدد. تشمل هذه المكافآت مكافآت الترحيب بالإضافة إلى العروض الدورية. تعد هذه العروض وسيلة فعالة لزيادة قاعدة اللاعبين. \r\n \r\nيشكل الأمان عنصرًا أساسيًا في اهتمامات 888starz. تعتمد المنصة على تقنيات متطورة لضمان حماية معلومات اللاعبين. يضمن ذلك للأعضاء تجربة لعب خالية من المخاطر. \r\nتسجيل الدخول 888starz <a href=\"http://www.888starz-egypt-eg.com/\" / rel=\"nofollow ugc\">https://888starz-egypt-eg.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("372", "1", "Jermaine3016", "Jermaine3016@gmail.com", "", "104.28.236.82", "2025-09-19 01:47:21", "2025-09-19 01:47:21", "<a href=\"https://shorturl.fm/7zuh3\" rel=\"nofollow ugc\">https://shorturl.fm/7zuh3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("373", "1", "Hendrix2149", "Hendrix2149@gmail.com", "", "117.210.178.179", "2025-09-19 02:51:28", "2025-09-19 02:51:28", "<a href=\"https://shorturl.fm/oqi6H\" rel=\"nofollow ugc\">https://shorturl.fm/oqi6H</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("374", "1", "Terry3312", "Terry3312@gmail.com", "", "123.110.173.172", "2025-09-20 01:06:42", "2025-09-20 01:06:42", "<a href=\"https://shorturl.fm/JtSJJ\" rel=\"nofollow ugc\">https://shorturl.fm/JtSJJ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("375", "1", "Daphne113", "Daphne113@gmail.com", "", "219.69.83.185", "2025-09-20 02:39:20", "2025-09-20 02:39:20", "<a href=\"https://shorturl.fm/XTGXj\" rel=\"nofollow ugc\">https://shorturl.fm/XTGXj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("376", "1", "Emmanuel928", "Emmanuel928@gmail.com", "", "45.123.222.34", "2025-09-20 03:41:42", "2025-09-20 03:41:42", "<a href=\"https://shorturl.fm/FshI3\" rel=\"nofollow ugc\">https://shorturl.fm/FshI3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("377", "1", "Drake4666", "Drake4666@gmail.com", "", "99.236.46.2", "2025-09-20 04:32:31", "2025-09-20 04:32:31", "<a href=\"https://shorturl.fm/qC6qW\" rel=\"nofollow ugc\">https://shorturl.fm/qC6qW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("378", "1", "Elsa2403", "Elsa2403@gmail.com", "", "120.158.135.83", "2025-09-20 07:53:15", "2025-09-20 07:53:15", "<a href=\"https://shorturl.fm/CYWZs\" rel=\"nofollow ugc\">https://shorturl.fm/CYWZs</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("379", "1", "Weston3579", "Weston3579@gmail.com", "", "31.215.122.82", "2025-09-20 09:51:53", "2025-09-20 09:51:53", "<a href=\"https://shorturl.fm/uwcun\" rel=\"nofollow ugc\">https://shorturl.fm/uwcun</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("380", "1", "Angelina1220", "Angelina1220@gmail.com", "", "190.134.192.46", "2025-09-20 20:14:15", "2025-09-20 20:14:15", "<a href=\"https://shorturl.fm/6Ilyt\" rel=\"nofollow ugc\">https://shorturl.fm/6Ilyt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("381", "1", "Lincoln683", "Lincoln683@gmail.com", "", "115.72.174.160", "2025-09-20 21:09:36", "2025-09-20 21:09:36", "<a href=\"https://shorturl.fm/8Opvg\" rel=\"nofollow ugc\">https://shorturl.fm/8Opvg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("382", "1", "Erik4542", "Erik4542@gmail.com", "", "119.18.149.18", "2025-09-21 08:19:52", "2025-09-21 08:19:52", "<a href=\"https://shorturl.fm/eIAep\" rel=\"nofollow ugc\">https://shorturl.fm/eIAep</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("383", "1", "888starz_jzPr", "uhljayhpvPr@nebulanexus.site", "https://888starz-egypt-eg.com/", "178.20.42.76", "2025-09-21 09:47:13", "2025-09-21 09:47:13", "تعتبر 888starz منصة معروفة في صناعة الألعاب الإلكترونية. يوفر الموقع مجموعة كبيرة من خيارات الألعاب التي تلبي احتياجات جميع اللاعبين. تكمن الألعاب التي يوفرها الموقع في الرهانات الرياضية وألعاب الكازينو. \r\n \r\nتتميز 888starz بتصميم سهل الاستخدام. يمكن للمستخدمين التنقل بين الأقسام بسهولة. يؤدي ذلك إلى تحسين تجربة اللعب. \r\n \r\nتقدم 888starz مجموعة من العروض الترويجية لجذب اللاعبين الجدد. يشمل ذلك مكافآت الترحيب والمكافآت الدورية. تعتبر هذه المكافآت آلية فعالة لجذب المزيد من اللاعبين. \r\n \r\nالأمان هو أحد أولويات 888starz. تستخدم المنصة تقنيات حديثة لحماية بيانات المستخدمين. هذا يضمن تجربة لعب آمنة. \r\n888starz apk download <a href=\"https://888starz-egypt-eg.com/apk\" rel=\"nofollow ugc\">https://888starz-egypt-eg.com/apk/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("384", "1", "April2293", "April2293@gmail.com", "", "113.11.64.18", "2025-09-21 13:44:01", "2025-09-21 13:44:01", "<a href=\"https://shorturl.fm/Iq6IK\" rel=\"nofollow ugc\">https://shorturl.fm/Iq6IK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("385", "1", "Elvira3614", "Elvira3614@gmail.com", "", "115.72.5.74", "2025-09-21 18:30:34", "2025-09-21 18:30:34", "<a href=\"https://shorturl.fm/Pf2qj\" rel=\"nofollow ugc\">https://shorturl.fm/Pf2qj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("386", "1", "Amanda1314", "Amanda1314@gmail.com", "", "115.72.5.74", "2025-09-21 21:16:49", "2025-09-21 21:16:49", "<a href=\"https://shorturl.fm/r7Xfz\" rel=\"nofollow ugc\">https://shorturl.fm/r7Xfz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("387", "1", "Effie2147", "Effie2147@gmail.com", "", "212.70.119.4", "2025-09-22 02:26:15", "2025-09-22 02:26:15", "<a href=\"https://shorturl.fm/juPUK\" rel=\"nofollow ugc\">https://shorturl.fm/juPUK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("388", "1", "Maria4842", "Maria4842@gmail.com", "", "101.50.43.12", "2025-09-22 05:00:29", "2025-09-22 05:00:29", "<a href=\"https://shorturl.fm/GMkxn\" rel=\"nofollow ugc\">https://shorturl.fm/GMkxn</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("389", "1", "Elmer4739", "Elmer4739@gmail.com", "", "223.204.177.190", "2025-09-22 06:00:24", "2025-09-22 06:00:24", "<a href=\"https://shorturl.fm/93PR2\" rel=\"nofollow ugc\">https://shorturl.fm/93PR2</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("390", "1", "Cheyenne2668", "Cheyenne2668@gmail.com", "", "103.4.147.181", "2025-09-22 14:12:06", "2025-09-22 14:12:06", "<a href=\"https://shorturl.fm/f6t2B\" rel=\"nofollow ugc\">https://shorturl.fm/f6t2B</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("391", "1", "Turoperato_ywsn", "smvlizmyusn@2-construction.store", "https://bluebirdtravel.ru", "212.115.49.78", "2025-09-22 20:39:11", "2025-09-22 20:39:11", "С компанией Sun Fun вы можете легко организовать поездку в Турцию из Москвы. \r\n<a href=\"https://bluebirdtravel.ru\" rel=\"nofollow ugc\">Туроператор Фан Сан туры в Турции из Москвы</a> \r\nНаши менеджеры помогут вам создать тур, полностью соответствующий вашим желаниям.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("392", "1", "Jennifer1286", "Jennifer1286@gmail.com", "", "27.34.64.124", "2025-09-23 17:54:43", "2025-09-23 17:54:43", "<a href=\"https://shorturl.fm/PmwyQ\" rel=\"nofollow ugc\">https://shorturl.fm/PmwyQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("393", "1", "Alejandra207", "Alejandra207@gmail.com", "", "66.29.156.102", "2025-09-24 03:39:15", "2025-09-24 03:39:15", "<a href=\"https://shorturl.fm/4tzx5\" rel=\"nofollow ugc\">https://shorturl.fm/4tzx5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("394", "1", "Weston2941", "Weston2941@gmail.com", "", "45.123.142.86", "2025-09-24 06:18:56", "2025-09-24 06:18:56", "<a href=\"https://shorturl.fm/xzeLw\" rel=\"nofollow ugc\">https://shorturl.fm/xzeLw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("395", "1", "Gavin426", "Gavin426@gmail.com", "", "115.72.14.186", "2025-09-24 17:39:18", "2025-09-24 17:39:18", "<a href=\"https://shorturl.fm/H35Io\" rel=\"nofollow ugc\">https://shorturl.fm/H35Io</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("396", "1", "Wesley4420", "Wesley4420@gmail.com", "", "115.72.161.72", "2025-09-24 17:51:08", "2025-09-24 17:51:08", "<a href=\"https://shorturl.fm/bIdYN\" rel=\"nofollow ugc\">https://shorturl.fm/bIdYN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("397", "1", "Keith3537", "Keith3537@gmail.com", "", "189.203.97.33", "2025-09-24 20:31:23", "2025-09-24 20:31:23", "<a href=\"https://shorturl.fm/o2DFO\" rel=\"nofollow ugc\">https://shorturl.fm/o2DFO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("398", "1", "Manuel4348", "Manuel4348@gmail.com", "", "102.129.165.115", "2025-09-25 04:43:56", "2025-09-25 04:43:56", "<a href=\"https://shorturl.fm/iuizQ\" rel=\"nofollow ugc\">https://shorturl.fm/iuizQ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("399", "1", "Nolan3806", "Nolan3806@gmail.com", "", "132.255.10.77", "2025-09-25 06:48:32", "2025-09-25 06:48:32", "<a href=\"https://shorturl.fm/RShF1\" rel=\"nofollow ugc\">https://shorturl.fm/RShF1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("400", "1", "Elijah2177", "Elijah2177@gmail.com", "", "36.90.146.79", "2025-09-25 13:55:21", "2025-09-25 13:55:21", "<a href=\"https://shorturl.fm/u5cJT\" rel=\"nofollow ugc\">https://shorturl.fm/u5cJT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("401", "1", "Alicia3232", "Alicia3232@gmail.com", "", "38.25.51.192", "2025-09-26 00:16:21", "2025-09-26 00:16:21", "<a href=\"https://shorturl.fm/BcZ6m\" rel=\"nofollow ugc\">https://shorturl.fm/BcZ6m</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("402", "1", "Zoe28", "Zoe28@gmail.com", "", "84.232.74.0", "2025-09-26 01:08:02", "2025-09-26 01:08:02", "<a href=\"https://shorturl.fm/83rv3\" rel=\"nofollow ugc\">https://shorturl.fm/83rv3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("403", "1", "Clifton293", "Clifton293@gmail.com", "", "61.198.79.66", "2025-09-26 03:22:35", "2025-09-26 03:22:35", "<a href=\"https://shorturl.fm/8raDo\" rel=\"nofollow ugc\">https://shorturl.fm/8raDo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("404", "1", "Gail391", "Gail391@gmail.com", "", "180.235.118.82", "2025-09-26 08:29:56", "2025-09-26 08:29:56", "<a href=\"https://shorturl.fm/rR6YH\" rel=\"nofollow ugc\">https://shorturl.fm/rR6YH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("405", "1", "Ruby1666", "Ruby1666@gmail.com", "", "118.173.88.172", "2025-09-27 00:49:59", "2025-09-27 00:49:59", "<a href=\"https://shorturl.fm/MFR8I\" rel=\"nofollow ugc\">https://shorturl.fm/MFR8I</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("406", "1", "Teresa2643", "Teresa2643@gmail.com", "", "5.30.220.119", "2025-09-27 10:41:30", "2025-09-27 10:41:30", "<a href=\"https://shorturl.fm/rAGNw\" rel=\"nofollow ugc\">https://shorturl.fm/rAGNw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("407", "1", "Phoebe1067", "Phoebe1067@gmail.com", "", "47.79.123.93", "2025-09-27 11:44:06", "2025-09-27 11:44:06", "<a href=\"https://shorturl.fm/hsboE\" rel=\"nofollow ugc\">https://shorturl.fm/hsboE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("408", "1", "Elvira1870", "Elvira1870@gmail.com", "", "120.28.247.135", "2025-09-27 16:14:34", "2025-09-27 16:14:34", "<a href=\"https://shorturl.fm/dyYSr\" rel=\"nofollow ugc\">https://shorturl.fm/dyYSr</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("409", "1", "suchtthera_vnsr", "rrrtifguqsr@skachat-melbet.info", "https://entzugsklinik.pro/", "178.20.42.76", "2025-09-27 20:47:15", "2025-09-27 20:47:15", "Jeder Mensch bringt seine einzigartigen Erfahrungen und Geschichten mit. \r\nbeste private entzugsklinik deutschland <a href=\"https://www.entzugsklinik.pro\" rel=\"nofollow ugc\">https://entzugsklinik.pro/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("410", "1", "Anabel3364", "Anabel3364@gmail.com", "", "49.147.120.48", "2025-09-28 01:49:53", "2025-09-28 01:49:53", "<a href=\"https://shorturl.fm/DOYkf\" rel=\"nofollow ugc\">https://shorturl.fm/DOYkf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("411", "1", "Eddie424", "Eddie424@gmail.com", "", "202.5.50.75", "2025-09-28 02:45:15", "2025-09-28 02:45:15", "<a href=\"https://shorturl.fm/qmxU5\" rel=\"nofollow ugc\">https://shorturl.fm/qmxU5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("412", "1", "888starz_fjor", "cyzkctaaeor@888starz.tech", "https://888starz-bet-casino.com/", "88.210.35.166", "2025-09-28 05:32:28", "2025-09-28 05:32:28", "888starz ensures smooth communication through various support platforms. \r\n888starz скачать на андроид <a href=\"https://www.888starz-bet-casino.com/ru/skachat-na-android\" rel=\"nofollow ugc\">https://888starz-bet-casino.com/ru/skachat-na-android/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("413", "1", "Ava1365", "Ava1365@gmail.com", "", "220.86.193.243", "2025-09-28 06:43:19", "2025-09-28 06:43:19", "<a href=\"https://shorturl.fm/utx9l\" rel=\"nofollow ugc\">https://shorturl.fm/utx9l</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("414", "1", "Lewis1040", "Lewis1040@gmail.com", "", "45.135.228.132", "2025-09-28 13:45:54", "2025-09-28 13:45:54", "<a href=\"https://shorturl.fm/X9Kjx\" rel=\"nofollow ugc\">https://shorturl.fm/X9Kjx</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("415", "1", "Adelyn4219", "Adelyn4219@gmail.com", "", "181.22.156.129", "2025-09-28 16:46:18", "2025-09-28 16:46:18", "<a href=\"https://shorturl.fm/X1ZQT\" rel=\"nofollow ugc\">https://shorturl.fm/X1ZQT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("416", "1", "Heather1630", "Heather1630@gmail.com", "", "84.232.74.0", "2025-09-29 09:37:56", "2025-09-29 09:37:56", "<a href=\"https://shorturl.fm/OTifw\" rel=\"nofollow ugc\">https://shorturl.fm/OTifw</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("417", "1", "Caroline706", "Caroline706@gmail.com", "", "103.49.146.90", "2025-09-29 15:49:01", "2025-09-29 15:49:01", "<a href=\"https://shorturl.fm/udLov\" rel=\"nofollow ugc\">https://shorturl.fm/udLov</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("418", "1", "Vincent2829", "Vincent2829@gmail.com", "", "103.169.41.42", "2025-09-29 15:49:27", "2025-09-29 15:49:27", "<a href=\"https://shorturl.fm/nvtt7\" rel=\"nofollow ugc\">https://shorturl.fm/nvtt7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("419", "1", "Corey1407", "Corey1407@gmail.com", "", "43.224.118.34", "2025-09-29 21:00:32", "2025-09-29 21:00:32", "<a href=\"https://shorturl.fm/q2q3h\" rel=\"nofollow ugc\">https://shorturl.fm/q2q3h</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("420", "1", "Zoe3695", "Zoe3695@gmail.com", "", "115.72.9.173", "2025-09-29 22:16:41", "2025-09-29 22:16:41", "<a href=\"https://shorturl.fm/iPuY3\" rel=\"nofollow ugc\">https://shorturl.fm/iPuY3</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("421", "1", "Juan1521", "Juan1521@gmail.com", "", "2.50.137.156", "2025-09-30 06:09:53", "2025-09-30 06:09:53", "<a href=\"https://shorturl.fm/WYpqC\" rel=\"nofollow ugc\">https://shorturl.fm/WYpqC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("422", "1", "Emilia4847", "Emilia4847@gmail.com", "", "98.221.43.11", "2025-09-30 19:11:24", "2025-09-30 19:11:24", "<a href=\"https://shorturl.fm/9MTqt\" rel=\"nofollow ugc\">https://shorturl.fm/9MTqt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("423", "1", "Leslie854", "Leslie854@gmail.com", "", "193.43.140.82", "2025-10-01 01:13:26", "2025-10-01 01:13:26", "<a href=\"https://shorturl.fm/EWJX7\" rel=\"nofollow ugc\">https://shorturl.fm/EWJX7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("424", "1", "Zachary4987", "Zachary4987@gmail.com", "", "181.208.245.14", "2025-10-01 01:28:13", "2025-10-01 01:28:13", "<a href=\"https://shorturl.fm/XHRSj\" rel=\"nofollow ugc\">https://shorturl.fm/XHRSj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("425", "1", "Junior1040", "Junior1040@gmail.com", "", "115.74.1.9", "2025-10-01 09:50:43", "2025-10-01 09:50:43", "<a href=\"https://shorturl.fm/ol5jq\" rel=\"nofollow ugc\">https://shorturl.fm/ol5jq</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("426", "1", "Dylan1101", "Dylan1101@gmail.com", "", "178.128.91.150", "2025-10-02 09:39:40", "2025-10-02 09:39:40", "<a href=\"https://shorturl.fm/mdXeM\" rel=\"nofollow ugc\">https://shorturl.fm/mdXeM</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("427", "1", "Caitlin3168", "Caitlin3168@gmail.com", "", "123.114.102.246", "2025-10-02 11:38:39", "2025-10-02 11:38:39", "<a href=\"https://shorturl.fm/STJSj\" rel=\"nofollow ugc\">https://shorturl.fm/STJSj</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("428", "1", "Irene1653", "Irene1653@gmail.com", "", "82.124.141.23", "2025-10-02 18:31:00", "2025-10-02 18:31:00", "<a href=\"https://shorturl.fm/WC69C\" rel=\"nofollow ugc\">https://shorturl.fm/WC69C</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("429", "1", "1win_lbPt", "inpvyglyfPt@casino-kent.pro", "https://1win-app.bet", "62.113.116.213", "2025-10-03 07:06:54", "2025-10-03 07:06:54", "Many users appreciate the convenient interface and comprehensive options the 1win app presents.  \r\n1win скачать приложение <a href=\"1win-app.bet/ru\" rel=\"nofollow ugc\">https://1win-app.bet/ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("430", "1", "David4244", "David4244@gmail.com", "", "24.4.223.35", "2025-10-03 15:11:33", "2025-10-03 15:11:33", "<a href=\"https://shorturl.fm/7nqac\" rel=\"nofollow ugc\">https://shorturl.fm/7nqac</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("431", "1", "June605", "June605@gmail.com", "", "210.87.74.15", "2025-10-03 17:43:32", "2025-10-03 17:43:32", "<a href=\"https://shorturl.fm/nu3pl\" rel=\"nofollow ugc\">https://shorturl.fm/nu3pl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("432", "1", "Beckett4158", "Beckett4158@gmail.com", "", "182.253.136.240", "2025-10-04 06:00:22", "2025-10-04 06:00:22", "<a href=\"https://shorturl.fm/hQDH9\" rel=\"nofollow ugc\">https://shorturl.fm/hQDH9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("433", "1", "Hendrix4492", "Hendrix4492@gmail.com", "", "171.251.42.192", "2025-10-04 06:19:32", "2025-10-04 06:19:32", "<a href=\"https://shorturl.fm/ORodg\" rel=\"nofollow ugc\">https://shorturl.fm/ORodg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("434", "1", "Georgia3481", "Georgia3481@gmail.com", "", "125.253.110.21", "2025-10-04 11:55:07", "2025-10-04 11:55:07", "<a href=\"https://shorturl.fm/xoxfC\" rel=\"nofollow ugc\">https://shorturl.fm/xoxfC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("435", "1", "888starz_bjSl", "irzzvpwgpSl@skachat-melbet.info", "https://888starz-egypts.com", "178.20.42.76", "2025-10-04 12:11:41", "2025-10-04 12:11:41", "تعتبر الأمان والموثوقية من أهم العوامل التي تميز 888starz مصر.  \r\n888starz app <a href=\"http://888starz-egypts.com/apk/\" / rel=\"nofollow ugc\">https://888starz-egypts.com/apk/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("436", "1", "Jerry658", "Jerry658@gmail.com", "", "223.205.102.232", "2025-10-04 12:54:24", "2025-10-04 12:54:24", "<a href=\"https://shorturl.fm/s2FbO\" rel=\"nofollow ugc\">https://shorturl.fm/s2FbO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("437", "1", "Theresa2230", "Theresa2230@gmail.com", "", "143.198.45.15", "2025-10-05 07:04:04", "2025-10-05 07:04:04", "<a href=\"https://shorturl.fm/7VnVe\" rel=\"nofollow ugc\">https://shorturl.fm/7VnVe</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("438", "1", "Elizabeth1539", "Elizabeth1539@gmail.com", "", "122.151.104.189", "2025-10-05 11:39:08", "2025-10-05 11:39:08", "<a href=\"https://shorturl.fm/t7xk7\" rel=\"nofollow ugc\">https://shorturl.fm/t7xk7</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("439", "1", "Reese709", "Reese709@gmail.com", "", "46.235.67.218", "2025-10-05 14:10:37", "2025-10-05 14:10:37", "<a href=\"https://shorturl.fm/yUCEY\" rel=\"nofollow ugc\">https://shorturl.fm/yUCEY</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("440", "1", "Josh2647", "Josh2647@gmail.com", "", "107.159.65.192", "2025-10-06 01:42:41", "2025-10-06 01:42:41", "<a href=\"https://shorturl.fm/qeNHR\" rel=\"nofollow ugc\">https://shorturl.fm/qeNHR</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("441", "1", "Elmer506", "Elmer506@gmail.com", "", "179.6.8.60", "2025-10-06 02:01:13", "2025-10-06 02:01:13", "<a href=\"https://shorturl.fm/inlGf\" rel=\"nofollow ugc\">https://shorturl.fm/inlGf</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("442", "1", "Randy2998", "Randy2998@gmail.com", "", "27.79.243.196", "2025-10-06 06:49:34", "2025-10-06 06:49:34", "<a href=\"https://shorturl.fm/YjB1E\" rel=\"nofollow ugc\">https://shorturl.fm/YjB1E</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("443", "1", "Jaxon161", "Jaxon161@gmail.com", "", "70.51.6.212", "2025-10-06 12:58:37", "2025-10-06 12:58:37", "<a href=\"https://shorturl.fm/E02LG\" rel=\"nofollow ugc\">https://shorturl.fm/E02LG</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("444", "1", "Micah3849", "Micah3849@gmail.com", "", "172.104.169.134", "2025-10-06 15:44:32", "2025-10-06 15:44:32", "<a href=\"https://shorturl.fm/YlMNH\" rel=\"nofollow ugc\">https://shorturl.fm/YlMNH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("445", "1", "Chad476", "Chad476@gmail.com", "", "14.38.252.114", "2025-10-07 02:47:48", "2025-10-07 02:47:48", "<a href=\"https://shorturl.fm/I8JPW\" rel=\"nofollow ugc\">https://shorturl.fm/I8JPW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("446", "1", "Iris3218", "Iris3218@gmail.com", "", "125.167.112.180", "2025-10-07 02:54:36", "2025-10-07 02:54:36", "<a href=\"https://shorturl.fm/kOxQb\" rel=\"nofollow ugc\">https://shorturl.fm/kOxQb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("447", "1", "Tori2584", "Tori2584@gmail.com", "", "168.195.160.92", "2025-10-07 11:55:58", "2025-10-07 11:55:58", "<a href=\"https://shorturl.fm/OYiz0\" rel=\"nofollow ugc\">https://shorturl.fm/OYiz0</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("448", "1", "Chandler3547", "Chandler3547@gmail.com", "", "189.37.78.20", "2025-10-07 12:40:32", "2025-10-07 12:40:32", "<a href=\"https://shorturl.fm/zp3ib\" rel=\"nofollow ugc\">https://shorturl.fm/zp3ib</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("449", "1", "Maureen4933", "Maureen4933@gmail.com", "", "202.5.48.88", "2025-10-07 14:14:38", "2025-10-07 14:14:38", "<a href=\"https://shorturl.fm/eyRHu\" rel=\"nofollow ugc\">https://shorturl.fm/eyRHu</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("450", "1", "888starz_umEt", "gswcvysufEt@skachat-winline.pro", "https://888starzuzs.com/", "62.113.116.213", "2025-10-08 03:55:25", "2025-10-08 03:55:25", "tejamkor yondashuvlar orqali o\'yin jarayonini  mumkin.  Bu o\'yin maydoni  taqdim etadi. \r\nbo\'lishi mumkin . Ushbu platformada  mumkin. \r\n qo\'shimcha imkoniyatlar yordam beradi. bo\'yicha  joylashgan  maqolalar  mavjud. \r\n himoya vositalarini.  hisob ma\'lumotlari.  bemalol kirishlari mumkin. \r\n888starz скачать приложение <a href=\"https://888starzuzs.com/apk/\" / rel=\"nofollow ugc\">https://888starzuzs.com/apk/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("451", "1", "Alexis1512", "Alexis1512@gmail.com", "", "106.215.180.222", "2025-10-08 06:57:57", "2025-10-08 06:57:57", "<a href=\"https://shorturl.fm/LOoZ9\" rel=\"nofollow ugc\">https://shorturl.fm/LOoZ9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("452", "1", "razdel_jbsi", "sggpvlmazsi@razdel-imushchestva33.ru", "https://razdel-imushchestva33.ru", "212.34.138.196", "2025-10-08 08:14:18", "2025-10-08 08:14:18", "Для получения квалифицированной помощи в вопросах раздела имущества, обратитесь к специалистам на <a href=\"https://razdel-imushchestva33.ru\" rel=\"nofollow ugc\">раздел имущества супругов судебная практика</a>. \r\nОпыт юристов позволяет им качественно защищать интересы своих клиентов.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("453", "1", "Reese4092", "Reese4092@gmail.com", "", "170.210.231.64", "2025-10-08 12:33:14", "2025-10-08 12:33:14", "<a href=\"https://shorturl.fm/o4PUS\" rel=\"nofollow ugc\">https://shorturl.fm/o4PUS</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("454", "1", "Jake3357", "Jake3357@gmail.com", "", "43.252.237.81", "2025-10-08 15:04:17", "2025-10-08 15:04:17", "<a href=\"https://shorturl.fm/wXXFN\" rel=\"nofollow ugc\">https://shorturl.fm/wXXFN</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("455", "1", "vykup_svOl", "bpuzdlndbOl@888starz.tech", "https://vykup-bityh-avto-posle-dtp.ru", "88.210.35.166", "2025-10-09 16:50:43", "2025-10-09 16:50:43", "Привлекательный способ аварийным автомобилем – это выкуп таких машин. Некоторые автолюбители попадали с вопросом своего поврежденного автомобиля. Безусловно, это времени и денег. \r\n \r\nФирмы, занимающиеся выкупом битых авто, дают варианты выкупа. Они. предлагаемые условия впечатляют, и они с радостью свои авто. \r\n \r\nобратиться услугами покупки, актуальные в данной области. конкурентной цене, существует и множество преимущества, заинтересовать к сотрудничеству. Среди таких аргументов – бесплатная оценка технического состояния. \r\n \r\nОпытные специалисты оценивают и клиентам наилучший выход. содействует, чтобы обменять автомобиль быстро. Пользуйтесь услугам обмена битых авто чтобы. \r\nвыкуп битых авто в москве на запчасти <a href=\"https://vykup-bityh-avto-posle-dtp.ru\" rel=\"nofollow ugc\">https://vykup-bityh-avto-posle-dtp.ru/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("456", "1", "Damian3422", "Damian3422@gmail.com", "", "103.126.87.134", "2025-10-09 20:31:24", "2025-10-09 20:31:24", "<a href=\"https://shorturl.fm/oE8oh\" rel=\"nofollow ugc\">https://shorturl.fm/oE8oh</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("457", "1", "Dina1708", "Dina1708@gmail.com", "", "1.254.236.31", "2025-10-09 23:44:18", "2025-10-09 23:44:18", "<a href=\"https://shorturl.fm/yqUh5\" rel=\"nofollow ugc\">https://shorturl.fm/yqUh5</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("458", "1", "Robin74", "Robin74@gmail.com", "", "103.155.64.47", "2025-10-09 23:59:26", "2025-10-09 23:59:26", "<a href=\"https://shorturl.fm/ckM7d\" rel=\"nofollow ugc\">https://shorturl.fm/ckM7d</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("459", "1", "Levi1995", "Levi1995@gmail.com", "", "24.16.69.3", "2025-10-10 02:00:03", "2025-10-10 02:00:03", "<a href=\"https://shorturl.fm/yZQAg\" rel=\"nofollow ugc\">https://shorturl.fm/yZQAg</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("460", "1", "Dante4512", "Dante4512@gmail.com", "", "24.20.147.62", "2025-10-10 04:27:48", "2025-10-10 04:27:48", "<a href=\"https://shorturl.fm/j5VOH\" rel=\"nofollow ugc\">https://shorturl.fm/j5VOH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("461", "1", "Preston3847", "Preston3847@gmail.com", "", "103.102.64.10", "2025-10-10 06:26:02", "2025-10-10 06:26:02", "<a href=\"https://shorturl.fm/jKd0W\" rel=\"nofollow ugc\">https://shorturl.fm/jKd0W</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("462", "1", "Jayla3822", "Jayla3822@gmail.com", "", "103.172.71.202", "2025-10-10 14:13:25", "2025-10-10 14:13:25", "<a href=\"https://shorturl.fm/mJEii\" rel=\"nofollow ugc\">https://shorturl.fm/mJEii</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("463", "1", "Brinley2187", "Brinley2187@gmail.com", "", "103.151.227.189", "2025-10-10 21:07:24", "2025-10-10 21:07:24", "<a href=\"https://shorturl.fm/EQAkc\" rel=\"nofollow ugc\">https://shorturl.fm/EQAkc</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("464", "1", "Alexandra3989", "Alexandra3989@gmail.com", "", "170.246.128.152", "2025-10-11 03:14:44", "2025-10-11 03:14:44", "<a href=\"https://shorturl.fm/qfBSX\" rel=\"nofollow ugc\">https://shorturl.fm/qfBSX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("465", "1", "Helen3358", "Helen3358@gmail.com", "", "190.173.64.183", "2025-10-11 13:40:43", "2025-10-11 13:40:43", "<a href=\"https://shorturl.fm/GEjyC\" rel=\"nofollow ugc\">https://shorturl.fm/GEjyC</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("466", "1", "Daniella3276", "Daniella3276@gmail.com", "", "49.150.52.122", "2025-10-11 23:55:31", "2025-10-11 23:55:31", "<a href=\"https://shorturl.fm/r0dOd\" rel=\"nofollow ugc\">https://shorturl.fm/r0dOd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("467", "1", "Natalie3313", "Natalie3313@gmail.com", "", "102.218.195.152", "2025-10-12 03:08:58", "2025-10-12 03:08:58", "<a href=\"https://shorturl.fm/SoySW\" rel=\"nofollow ugc\">https://shorturl.fm/SoySW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("468", "1", "Nia1267", "Nia1267@gmail.com", "", "1.146.108.146", "2025-10-12 05:03:29", "2025-10-12 05:03:29", "<a href=\"https://shorturl.fm/6oQTs\" rel=\"nofollow ugc\">https://shorturl.fm/6oQTs</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("469", "1", "888starz_uvSa", "ugduggvlySa@ugaritopari.site", "https://888starz-888stars.com", "62.113.116.213", "2025-10-12 05:08:59", "2025-10-12 05:08:59", "Whether you are a novice or an expert, you will find something to enjoy. \r\n888starz kod <a href=\"https://www.888starz-888stars.com/pl/kod-promocyjny\" rel=\"nofollow ugc\">https://888starz-888stars.com/pl/kod-promocyjny/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("470", "1", "Hunter497", "Hunter497@gmail.com", "", "157.15.82.184", "2025-10-12 08:24:19", "2025-10-12 08:24:19", "<a href=\"https://shorturl.fm/U2zDd\" rel=\"nofollow ugc\">https://shorturl.fm/U2zDd</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("471", "1", "Jill4148", "Jill4148@gmail.com", "", "191.15.77.17", "2025-10-12 14:25:57", "2025-10-12 14:25:57", "<a href=\"https://shorturl.fm/RtSHb\" rel=\"nofollow ugc\">https://shorturl.fm/RtSHb</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("472", "1", "Jack974", "Jack974@gmail.com", "", "49.147.132.132", "2025-10-12 22:37:08", "2025-10-12 22:37:08", "<a href=\"https://shorturl.fm/ynyqW\" rel=\"nofollow ugc\">https://shorturl.fm/ynyqW</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("473", "1", "Alex3592", "Alex3592@gmail.com", "", "24.51.99.80", "2025-10-13 13:36:11", "2025-10-13 13:36:11", "<a href=\"https://shorturl.fm/SLILE\" rel=\"nofollow ugc\">https://shorturl.fm/SLILE</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("474", "1", "Raymond949", "Raymond949@gmail.com", "", "89.148.9.221", "2025-10-13 17:31:05", "2025-10-13 17:31:05", "<a href=\"https://shorturl.fm/UP6Xo\" rel=\"nofollow ugc\">https://shorturl.fm/UP6Xo</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("475", "1", "Leanne1994", "Leanne1994@gmail.com", "", "115.164.33.23", "2025-10-13 19:23:41", "2025-10-13 19:23:41", "<a href=\"https://shorturl.fm/03G60\" rel=\"nofollow ugc\">https://shorturl.fm/03G60</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("476", "1", "Benjamin218", "Benjamin218@gmail.com", "", "73.42.172.57", "2025-10-14 00:05:02", "2025-10-14 00:05:02", "<a href=\"https://shorturl.fm/OOfZ9\" rel=\"nofollow ugc\">https://shorturl.fm/OOfZ9</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("477", "1", "Janice2539", "Janice2539@gmail.com", "", "99.152.118.3", "2025-10-14 04:18:16", "2025-10-14 04:18:16", "<a href=\"https://shorturl.fm/zJzAt\" rel=\"nofollow ugc\">https://shorturl.fm/zJzAt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("478", "1", "June4078", "June4078@gmail.com", "", "193.43.145.124", "2025-10-14 21:55:31", "2025-10-14 21:55:31", "<a href=\"https://shorturl.fm/UxbBH\" rel=\"nofollow ugc\">https://shorturl.fm/UxbBH</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("479", "1", "Jamal324", "Jamal324@gmail.com", "", "121.33.142.0", "2025-10-15 03:04:49", "2025-10-15 03:04:49", "<a href=\"https://shorturl.fm/6Kr0A\" rel=\"nofollow ugc\">https://shorturl.fm/6Kr0A</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("480", "1", "888starz_npPt", "tkarcxkvlPt@888starz.tech", "https://888-starz-eg.com", "88.210.35.166", "2025-10-15 04:01:19", "2025-10-15 04:01:19", "تعتبر 888starz واحدة من أحدث المنصات المبتكرة في مجال الألعاب. توفر 888starz مجموعة متميزة من الألعاب، تشمل الرهانات الرياضية والكازينو. \r\nتهدف 888starz إلى توفير تجربة مستخدم فريدة وسلسة، مما يجعل العملية أكثر سلاسة. تعد 888starz متعددة اللغات، مما يسهل الوصول إليها من قبل المستخدمين من مختلف البلدان. \r\nتتبع 888starz معايير أمان عالية لضمان حماية معلومات اللاعبين. تسعى 888starz لتقديم دعم فني فعال، حيث يمكن للمستخدمين التواصل مع فريق الدعم في أي وقت. \r\nتتميز 888starz بعروض ومكافآت مغرية تجعل تجربة اللعب أكثر إثارة. تقدم المنصة مكافآت متنوعة، بما في ذلك حوافز ترحيبية وعروض موسمية مميزة. \r\nتسجيل الدخول 888starz <a href=\"https://www.888-starz-eg.com\" rel=\"nofollow ugc\">https://888-starz-eg.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("481", "1", "Vincent2029", "Vincent2029@gmail.com", "", "36.76.122.10", "2025-10-15 11:41:04", "2025-10-15 11:41:04", "<a href=\"https://shorturl.fm/1QK3p\" rel=\"nofollow ugc\">https://shorturl.fm/1QK3p</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("482", "1", "Daria4614", "Daria4614@gmail.com", "", "128.210.106.61", "2025-10-15 15:29:03", "2025-10-15 15:29:03", "<a href=\"https://shorturl.fm/cTlPz\" rel=\"nofollow ugc\">https://shorturl.fm/cTlPz</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("483", "1", "Franklin52", "Franklin52@gmail.com", "", "99.236.177.170", "2025-10-15 18:12:56", "2025-10-15 18:12:56", "<a href=\"https://shorturl.fm/tqLPF\" rel=\"nofollow ugc\">https://shorturl.fm/tqLPF</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("484", "1", "razdelzver", "vcppjdfsmer@razdel-imushchestva6.ru", "https://razdel-imushchestva6.ru", "212.34.138.196", "2025-10-15 18:28:18", "2025-10-15 18:28:18", "Получите профессиональную <a href=\"https://razdel-imushchestva6.ru\" rel=\"nofollow ugc\">мировое соглашение по разделу имущества</a> услугами. \r\n \r\nЭто сложный процесс, требующий внимательного подхода и знания юридических нюансов.", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("485", "1", "kupit_kpSn", "lomkrfuiiSn@ugaritopari.site", "https://kupit-uggi-moskva.ru/", "62.113.116.213", "2025-10-15 21:02:56", "2025-10-15 21:02:56", "Примерка уггов гарантирует, что вы выберете подходящий размер. \r\nтапки угги женские домашние <a href=\"https://www.uggiaustralia-msk.ru/collection/ugg-tapochki/\" / rel=\"nofollow ugc\">https://uggiaustralia-msk.ru/collection/ugg-tapochki/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("486", "1", "Kaden3484", "Kaden3484@gmail.com", "", "119.18.147.67", "2025-10-15 23:34:36", "2025-10-15 23:34:36", "<a href=\"https://shorturl.fm/19pXT\" rel=\"nofollow ugc\">https://shorturl.fm/19pXT</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("487", "1", "Zoe2242", "Zoe2242@gmail.com", "", "167.58.172.186", "2025-10-16 00:47:15", "2025-10-16 00:47:15", "<a href=\"https://shorturl.fm/46fZZ\" rel=\"nofollow ugc\">https://shorturl.fm/46fZZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("488", "1", "Spencer1905", "Spencer1905@gmail.com", "", "45.166.144.239", "2025-10-16 12:40:11", "2025-10-16 12:40:11", "<a href=\"https://shorturl.fm/ssEEl\" rel=\"nofollow ugc\">https://shorturl.fm/ssEEl</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("489", "1", "Gus139", "Gus139@gmail.com", "", "79.44.70.42", "2025-10-16 23:08:17", "2025-10-16 23:08:17", "<a href=\"https://shorturl.fm/hUJK1\" rel=\"nofollow ugc\">https://shorturl.fm/hUJK1</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("490", "1", "Freddie142", "Freddie142@gmail.com", "", "180.74.227.49", "2025-10-17 03:45:13", "2025-10-17 03:45:13", "<a href=\"https://shorturl.fm/toUVX\" rel=\"nofollow ugc\">https://shorturl.fm/toUVX</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("491", "1", "Greg248", "Greg248@gmail.com", "", "177.94.21.5", "2025-10-17 13:03:34", "2025-10-17 13:03:34", "<a href=\"https://shorturl.fm/BLmNL\" rel=\"nofollow ugc\">https://shorturl.fm/BLmNL</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("492", "1", "Aubrey3667", "Aubrey3667@gmail.com", "", "101.108.116.214", "2025-10-18 04:46:40", "2025-10-18 04:46:40", "<a href=\"https://shorturl.fm/BkxRO\" rel=\"nofollow ugc\">https://shorturl.fm/BkxRO</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("493", "1", "Derek2951", "Derek2951@gmail.com", "", "90.55.245.88", "2025-10-18 06:29:34", "2025-10-18 06:29:34", "<a href=\"https://shorturl.fm/M5yHt\" rel=\"nofollow ugc\">https://shorturl.fm/M5yHt</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("494", "1", "Lindsey3536", "Lindsey3536@gmail.com", "", "218.1.149.195", "2025-10-18 08:23:40", "2025-10-18 08:23:40", "<a href=\"https://shorturl.fm/IbaBK\" rel=\"nofollow ugc\">https://shorturl.fm/IbaBK</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("495", "1", "Emilie4819", "Emilie4819@gmail.com", "", "171.242.43.142", "2025-10-18 10:26:30", "2025-10-18 10:26:30", "<a href=\"https://shorturl.fm/syz2B\" rel=\"nofollow ugc\">https://shorturl.fm/syz2B</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("496", "1", "minecraft_gzMn", "ibwizmjjwMn@ingushetdomaz.pro", "https://minecraftbedrock-apk.com/", "178.20.42.76", "2025-10-18 14:55:16", "2025-10-18 14:55:16", "Players can enjoy smoother gameplay with fewer lags, making it a pleasant experience. \r\nminecraft latest version <a href=\"https://www.minecraftbedrock-apk.com/downloading/\" / rel=\"nofollow ugc\">https://minecraftbedrock-apk.com/downloading/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("497", "1", "Morgan1103", "Morgan1103@gmail.com", "", "49.207.203.37", "2025-10-18 17:21:39", "2025-10-18 17:21:39", "<a href=\"https://shorturl.fm/wPOFZ\" rel=\"nofollow ugc\">https://shorturl.fm/wPOFZ</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("498", "1", "Stanley3996", "Stanley3996@gmail.com", "", "14.51.116.159", "2025-10-19 07:27:28", "2025-10-19 07:27:28", "<a href=\"https://shorturl.fm/086UV\" rel=\"nofollow ugc\">https://shorturl.fm/086UV</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("499", "1", "Eric4309", "Eric4309@gmail.com", "", "95.47.103.245", "2025-10-19 08:01:15", "2025-10-19 08:01:15", "<a href=\"https://shorturl.fm/gO1Ju\" rel=\"nofollow ugc\">https://shorturl.fm/gO1Ju</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("500", "1", "1win_unMi", "jejculhjkMi@igurant1.online", "https://1win-app-apk.com", "88.210.35.166", "2025-10-19 12:00:21", "2025-10-19 12:00:21", "By enabling betting on live events, the app significantly increases the engagement level for users. \r\n1win aviator <a href=\"http://1win-app-apk.com/\" / rel=\"nofollow ugc\">https://1win-app-apk.com/</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251019_worldmapradio", "5944bc1b47c70c444568_20251019140227", "21", "2025-10-19 14:02:31", "farhad", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-19 14:02:27\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"11.4.8\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:22:\"20251019_worldmapradio\";s:4:\"Hash\";s:35:\"5944bc1b47c70c444568_20251019140227\";s:8:\"NameHash\";s:58:\"20251019_worldmapradio_5944bc1b47c70c444568_20251019140227\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20251019_worldmapradio_5944bc1b47c70c444568_20251019140227_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.5\";s:6:\"WPUser\";s:6:\"farhad\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20251019_worldmapradio_5944bc1b47c70c444568_20251019140227_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/persiwgq/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1181;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:5835;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-19 14:02:27\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"11.4.8\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20251019_worldmapradio\";s:4:\"Hash\";s:35:\"5944bc1b47c70c444568_20251019140227\";s:8:\"NameHash\";s:58:\"20251019_worldmapradio_5944bc1b47c70c444568_20251019140227\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20251019_worldmapradio_5944bc1b47c70c444568_20251019140227_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/persiwgq/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:71:\"20251019_worldmapradio_5944bc1b47c70c444568_20251019140227_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:130:\"/home/persiwgq/public_html/wp-content/backups-dup-lite/tmp/20251019_worldmapradio_5944bc1b47c70c444568_20251019140227_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/persiwgq/public_html/wp-admin\";i:1;s:38:\"/home/persiwgq/public_html/wp-includes\";i:2;s:47:\"/home/persiwgq/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/persiwgq/public_html\";i:1;s:26:\"/home/persiwgq/public_html\";i:2;s:37:\"/home/persiwgq/public_html/wp-content\";i:3;s:45:\"/home/persiwgq/public_html/wp-content/uploads\";i:4;s:45:\"/home/persiwgq/public_html/wp-content/plugins\";i:5;s:48:\"/home/persiwgq/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/persiwgq/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/persiwgq/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:15:{i:1760883615;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760888289;a:1:{s:31:\"fs_data_sync_interactive-globes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760905231;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760908813;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760910613;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760912413;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760948415;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760948431;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760948434;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760968800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761034861;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761034877;a:1:{s:24:\"astra_delete_docs_folder\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761121215;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761932020;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://persianradio.online", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://persianradio.online", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "WORLD MAP RADIO", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "sia1352@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:200:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:33:\"globe/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"globe/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"globe/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"globe/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"globe/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"globe/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"globe/([^/]+)/embed/?$\";s:39:\"index.php?iglobe=$matches[1]&embed=true\";s:26:\"globe/([^/]+)/trackback/?$\";s:33:\"index.php?iglobe=$matches[1]&tb=1\";s:34:\"globe/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?iglobe=$matches[1]&paged=$matches[2]\";s:41:\"globe/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?iglobe=$matches[1]&cpage=$matches[2]\";s:30:\"globe/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?iglobe=$matches[1]&page=$matches[2]\";s:22:\"globe/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"globe/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"globe/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"globe/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"globe/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"globe/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"itt_globe_dotlabel/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"itt_globe_dotlabel/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"itt_globe_dotlabel/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"itt_globe_dotlabel/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"itt_globe_dotlabel/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"itt_globe_dotlabel/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"itt_globe_dotlabel/([^/]+)/embed/?$\";s:51:\"index.php?itt_globe_dotlabel=$matches[1]&embed=true\";s:39:\"itt_globe_dotlabel/([^/]+)/trackback/?$\";s:45:\"index.php?itt_globe_dotlabel=$matches[1]&tb=1\";s:47:\"itt_globe_dotlabel/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?itt_globe_dotlabel=$matches[1]&paged=$matches[2]\";s:54:\"itt_globe_dotlabel/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?itt_globe_dotlabel=$matches[1]&cpage=$matches[2]\";s:43:\"itt_globe_dotlabel/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?itt_globe_dotlabel=$matches[1]&page=$matches[2]\";s:35:\"itt_globe_dotlabel/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"itt_globe_dotlabel/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"itt_globe_dotlabel/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"itt_globe_dotlabel/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"itt_globe_dotlabel/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"itt_globe_dotlabel/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"itt_globe_point/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"itt_globe_point/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"itt_globe_point/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"itt_globe_point/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"itt_globe_point/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"itt_globe_point/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"itt_globe_point/([^/]+)/embed/?$\";s:48:\"index.php?itt_globe_point=$matches[1]&embed=true\";s:36:\"itt_globe_point/([^/]+)/trackback/?$\";s:42:\"index.php?itt_globe_point=$matches[1]&tb=1\";s:44:\"itt_globe_point/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?itt_globe_point=$matches[1]&paged=$matches[2]\";s:51:\"itt_globe_point/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?itt_globe_point=$matches[1]&cpage=$matches[2]\";s:40:\"itt_globe_point/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?itt_globe_point=$matches[1]&page=$matches[2]\";s:32:\"itt_globe_point/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"itt_globe_point/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"itt_globe_point/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"itt_globe_point/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"itt_globe_point/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"itt_globe_point/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"itt_globe_line/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"itt_globe_line/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"itt_globe_line/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"itt_globe_line/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"itt_globe_line/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"itt_globe_line/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"itt_globe_line/([^/]+)/embed/?$\";s:47:\"index.php?itt_globe_line=$matches[1]&embed=true\";s:35:\"itt_globe_line/([^/]+)/trackback/?$\";s:41:\"index.php?itt_globe_line=$matches[1]&tb=1\";s:43:\"itt_globe_line/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?itt_globe_line=$matches[1]&paged=$matches[2]\";s:50:\"itt_globe_line/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?itt_globe_line=$matches[1]&cpage=$matches[2]\";s:39:\"itt_globe_line/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?itt_globe_line=$matches[1]&page=$matches[2]\";s:31:\"itt_globe_line/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"itt_globe_line/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"itt_globe_line/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"itt_globe_line/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"itt_globe_line/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"itt_globe_line/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"itt_globe_region/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"itt_globe_region/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"itt_globe_region/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"itt_globe_region/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"itt_globe_region/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"itt_globe_region/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"itt_globe_region/([^/]+)/embed/?$\";s:49:\"index.php?itt_globe_region=$matches[1]&embed=true\";s:37:\"itt_globe_region/([^/]+)/trackback/?$\";s:43:\"index.php?itt_globe_region=$matches[1]&tb=1\";s:45:\"itt_globe_region/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?itt_globe_region=$matches[1]&paged=$matches[2]\";s:52:\"itt_globe_region/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?itt_globe_region=$matches[1]&cpage=$matches[2]\";s:41:\"itt_globe_region/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?itt_globe_region=$matches[1]&page=$matches[2]\";s:33:\"itt_globe_region/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"itt_globe_region/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"itt_globe_region/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"itt_globe_region/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"itt_globe_region/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"itt_globe_region/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"itt_globe_html/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"itt_globe_html/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"itt_globe_html/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"itt_globe_html/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"itt_globe_html/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"itt_globe_html/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"itt_globe_html/([^/]+)/embed/?$\";s:47:\"index.php?itt_globe_html=$matches[1]&embed=true\";s:35:\"itt_globe_html/([^/]+)/trackback/?$\";s:41:\"index.php?itt_globe_html=$matches[1]&tb=1\";s:43:\"itt_globe_html/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?itt_globe_html=$matches[1]&paged=$matches[2]\";s:50:\"itt_globe_html/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?itt_globe_html=$matches[1]&cpage=$matches[2]\";s:39:\"itt_globe_html/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?itt_globe_html=$matches[1]&page=$matches[2]\";s:31:\"itt_globe_html/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"itt_globe_html/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"itt_globe_html/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"itt_globe_html/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"itt_globe_html/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"itt_globe_html/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=7&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:3:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:49:\"interactive-globes-premium/interactive-globes.php\";i:2;s:51:\"tuxedo-big-file-uploads/tuxedo_big_file_uploads.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "astra", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "astra", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "7", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1752999613", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "2", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"header-widget\";a:0:{}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.1\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("126", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"ee61af87ae652291f9f1e4e22bb12b2f\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("127", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("151", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("152", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("160", "current_theme", "Astra", "auto");
INSERT INTO `wp_options` VALUES("161", "theme_mods_astra", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}", "on");
INSERT INTO `wp_options` VALUES("162", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("167", "astra-settings", "a:5:{s:18:\"theme-auto-version\";s:5:\"4.9.0\";s:22:\"is_theme_queue_running\";b:0;s:20:\"header-desktop-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:0:{}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:0:{}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:20:\"footer-desktop-items\";a:5:{s:5:\"above\";a:6:{s:7:\"above_1\";a:0:{}s:7:\"above_2\";a:0:{}s:7:\"above_3\";a:0:{}s:7:\"above_4\";a:0:{}s:7:\"above_5\";a:0:{}s:7:\"above_6\";a:0:{}}s:7:\"primary\";a:6:{s:9:\"primary_1\";a:0:{}s:9:\"primary_2\";a:0:{}s:9:\"primary_3\";a:0:{}s:9:\"primary_4\";a:0:{}s:9:\"primary_5\";a:0:{}s:9:\"primary_6\";a:0:{}}s:5:\"below\";a:6:{s:7:\"below_1\";a:0:{}s:7:\"below_2\";a:0:{}s:7:\"below_3\";a:0:{}s:7:\"below_4\";a:0:{}s:7:\"below_5\";a:0:{}s:7:\"below_6\";a:0:{}}s:5:\"popup\";a:1:{s:13:\"popup_content\";a:0:{}}s:4:\"flag\";b:1;}s:22:\"v4-9-0-backward-option\";b:0;}", "on");
INSERT INTO `wp_options` VALUES("170", "nps-survey-astra", "a:6:{s:13:\"dismiss_count\";i:0;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:0:\"\";s:12:\"dismiss_time\";s:0:\"\";s:16:\"dismiss_timespan\";N;s:17:\"first_render_time\";i:1737447677;}", "auto");
INSERT INTO `wp_options` VALUES("174", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("175", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:56:\"interactive-globes-premium/vendor/freemius/wordpress-sdk\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.11.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1738772153;s:11:\"plugin_path\";s:49:\"interactive-globes-premium/interactive-globes.php\";}}s:7:\"abspath\";s:27:\"/home/persiwgq/public_html/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:49:\"interactive-globes-premium/interactive-globes.php\";s:8:\"sdk_path\";s:56:\"interactive-globes-premium/vendor/freemius/wordpress-sdk\";s:7:\"version\";s:6:\"2.11.0\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1738772153;}}", "auto");
INSERT INTO `wp_options` VALUES("176", "fs_debug_mode", "", "auto");
INSERT INTO `wp_options` VALUES("177", "fs_accounts", "a:15:{s:21:\"id_slug_type_path_map\";a:1:{i:14919;a:3:{s:4:\"slug\";s:18:\"interactive-globes\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:49:\"interactive-globes-premium/interactive-globes.php\";}}s:11:\"plugin_data\";a:1:{s:18:\"interactive-globes\";a:29:{s:19:\"last_load_timestamp\";i:1760830647;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:49:\"interactive-globes-premium/interactive-globes.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1737447763;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:5:\"2.9.0\";s:11:\"sdk_version\";s:6:\"2.11.0\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:5:\"1.4.4\";s:14:\"plugin_version\";s:5:\"1.4.6\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:19:\"persianradio.online\";s:9:\"server_ip\";s:14:\"212.64.199.131\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1743263923;s:7:\"version\";s:5:\"1.4.6\";}s:15:\"prev_is_premium\";b:1;s:30:\"is_diagnostic_tracking_allowed\";b:1;s:30:\"is_extensions_tracking_allowed\";b:0;s:14:\"has_trial_plan\";b:1;s:19:\"keepalive_timestamp\";i:1743263923;s:16:\"last_license_key\";s:32:\"7f0f50f629c5694f2f2fe9e2c033a354\";s:20:\"last_license_user_id\";N;s:15:\"is_whitelabeled\";b:0;s:20:\"activation_timestamp\";i:1737447780;s:9:\"sync_cron\";O:8:\"stdClass\":5:{s:7:\"version\";s:5:\"1.4.2\";s:7:\"blog_id\";i:0;s:11:\"sdk_version\";s:5:\"2.9.0\";s:9:\"timestamp\";i:1737447788;s:2:\"on\";b:1;}s:9:\"beta_data\";a:2:{s:7:\"is_beta\";b:0;s:7:\"version\";s:6:\"1.4.10\";}s:14:\"sync_timestamp\";i:1743263923;s:22:\"install_sync_timestamp\";i:1743263923;s:13:\"subscriptions\";a:1:{i:0;O:15:\"FS_Subscription\":20:{s:7:\"user_id\";s:7:\"7874829\";s:10:\"install_id\";s:8:\"16953237\";s:7:\"plan_id\";s:5:\"24838\";s:10:\"license_id\";s:7:\"1658207\";s:11:\"total_gross\";i:0;s:16:\"amount_per_cycle\";i:59;s:13:\"billing_cycle\";i:0;s:19:\"outstanding_balance\";i:0;s:15:\"failed_payments\";i:0;s:7:\"gateway\";s:6:\"stripe\";s:11:\"external_id\";s:28:\"sub_1QjcDmFmXz63vF5vylFEcLZs\";s:10:\"trial_ends\";s:19:\"2025-01-29 07:50:02\";s:12:\"next_payment\";s:19:\"2025-01-28 07:50:02\";s:11:\"canceled_at\";N;s:6:\"vat_id\";N;s:12:\"country_code\";s:2:\"tr\";s:2:\"id\";s:6:\"639002\";s:7:\"updated\";s:19:\"2025-01-21 07:55:34\";s:7:\"created\";s:19:\"2025-01-21 07:50:04\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}}s:13:\"file_slug_map\";a:1:{s:49:\"interactive-globes-premium/interactive-globes.php\";s:18:\"interactive-globes\";}s:7:\"plugins\";a:1:{s:18:\"interactive-globes\";O:9:\"FS_Plugin\":24:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:26:\"Interactive Globes Premium\";s:4:\"slug\";s:18:\"interactive-globes\";s:12:\"premium_slug\";s:26:\"interactive-globes-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:49:\"interactive-globes-premium/interactive-globes.php\";s:7:\"version\";s:5:\"1.4.6\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:1;s:14:\"premium_suffix\";s:3:\"Pro\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;s:10:\"public_key\";s:32:\"pk_bf374640397ee6130fcd4ea1ef141\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"14919\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"bfa35c0fba58acda0c60dbc7ab54e768\";s:5:\"plans\";a:1:{s:18:\"interactive-globes\";a:2:{i:0;O:14:\"FS_Plugin_Plan\":24:{s:9:\"plugin_id\";s:8:\"MTQ5MTk=\";s:4:\"name\";s:8:\"ZnJlZQ==\";s:5:\"title\";s:8:\"RnJlZQ==\";s:11:\"description\";N;s:17:\"is_free_localhost\";s:4:\"MQ==\";s:17:\"is_block_features\";s:4:\"MQ==\";s:12:\"license_type\";s:4:\"MA==\";s:16:\"is_https_support\";s:0:\"\";s:12:\"trial_period\";N;s:23:\"is_require_subscription\";s:0:\"\";s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";s:0:\"\";s:11:\"is_featured\";s:0:\"\";s:9:\"is_hidden\";s:4:\"MQ==\";s:7:\"pricing\";N;s:8:\"features\";N;s:2:\"id\";s:8:\"MjQ4Mzc=\";s:7:\"updated\";s:28:\"MjAyNC0wOC0xMyAxMzo1MDoyMw==\";s:7:\"created\";s:28:\"MjAyNC0wMi0wNiAyMzo0MDozOA==\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:14:\"FS_Plugin_Plan\":24:{s:9:\"plugin_id\";s:8:\"MTQ5MTk=\";s:4:\"name\";s:4:\"cHJv\";s:5:\"title\";s:4:\"UHJv\";s:11:\"description\";N;s:17:\"is_free_localhost\";s:4:\"MQ==\";s:17:\"is_block_features\";s:4:\"MQ==\";s:12:\"license_type\";s:4:\"MA==\";s:16:\"is_https_support\";s:0:\"\";s:12:\"trial_period\";s:4:\"Nw==\";s:23:\"is_require_subscription\";s:4:\"MQ==\";s:10:\"support_kb\";s:64:\"aHR0cHM6Ly93cGludGVyYWN0aXZlZ2xvYmVzLmNvbS9kb2N1bWVudGF0aW9uLw==\";s:13:\"support_forum\";N;s:13:\"support_email\";s:44:\"c3VwcG9ydEB3cGludGVyYWN0aXZlZ2xvYmVzLmNvbQ==\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";s:0:\"\";s:11:\"is_featured\";s:4:\"MQ==\";s:9:\"is_hidden\";s:0:\"\";s:7:\"pricing\";N;s:8:\"features\";N;s:2:\"id\";s:8:\"MjQ4Mzg=\";s:7:\"updated\";s:28:\"MjAyNS0wMS0wMyAxNDo0MjozMw==\";s:7:\"created\";s:28:\"MjAyNC0wMi0wNiAyMzo0MzoxMQ==\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}s:5:\"sites\";a:1:{s:18:\"interactive-globes\";O:7:\"FS_Site\":26:{s:7:\"site_id\";s:9:\"256286218\";s:7:\"blog_id\";N;s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:5:\"title\";s:15:\"WORLD MAP RADIO\";s:3:\"url\";s:27:\"https://persianradio.online\";s:7:\"version\";s:5:\"1.4.6\";s:8:\"language\";s:5:\"en-US\";s:16:\"platform_version\";s:5:\"6.7.2\";s:11:\"sdk_version\";s:6:\"2.11.0\";s:28:\"programming_language_version\";s:6:\"7.4.33\";s:7:\"plan_id\";s:5:\"24838\";s:10:\"license_id\";s:7:\"1665856\";s:13:\"trial_plan_id\";s:5:\"24838\";s:10:\"trial_ends\";s:19:\"2025-01-29 07:50:02\";s:10:\"is_premium\";b:1;s:15:\"is_disconnected\";b:0;s:9:\"is_active\";b:1;s:14:\"is_uninstalled\";b:0;s:7:\"is_beta\";b:0;s:10:\"public_key\";s:32:\"pk_fbaaab1ce3afc402fcd4d7b7712cb\";s:10:\"secret_key\";s:32:\"sk_v{7M_QB(kbEYDRE&3M7u5QP%(DdBG\";s:2:\"id\";s:8:\"16953237\";s:7:\"updated\";s:19:\"2025-03-29 15:58:44\";s:7:\"created\";s:19:\"2025-01-21 07:55:34\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:5:\"users\";a:1:{i:7874829;O:7:\"FS_User\":12:{s:5:\"email\";s:22:\"pwrstudio.tu@gmail.com\";s:5:\"first\";s:6:\"farhad\";s:4:\"last\";s:10:\"Pourkazemi\";s:11:\"is_verified\";b:1;s:11:\"customer_id\";N;s:5:\"gross\";N;s:10:\"public_key\";s:32:\"pk_9a4325a657ee4b39a514606fefdba\";s:10:\"secret_key\";s:32:\"sk_0Bt53M%u<z2Q.g8B=Pm.@1X47V.vy\";s:2:\"id\";s:7:\"7874829\";s:7:\"updated\";s:19:\"2025-01-21 08:04:23\";s:7:\"created\";s:19:\"2024-01-23 08:29:46\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:23:\"user_id_license_ids_map\";a:1:{i:14919;a:1:{i:7874829;a:2:{i:0;i:1665856;i:1;i:1658207;}}}s:12:\"all_licenses\";a:1:{i:14919;a:2:{i:0;O:17:\"FS_Plugin_License\":21:{s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24838\";s:16:\"parent_plan_name\";N;s:17:\"parent_plan_title\";N;s:17:\"parent_license_id\";N;s:8:\"products\";N;s:10:\"pricing_id\";s:5:\"30130\";s:5:\"quota\";i:1;s:9:\"activated\";i:1;s:15:\"activated_local\";i:0;s:10:\"expiration\";N;s:10:\"secret_key\";s:32:\"sk_X263yFJXP1U=?7P;yQHuu1uU-y:&a\";s:15:\"is_whitelabeled\";b:0;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"is_cancelled\";b:0;s:2:\"id\";s:7:\"1665856\";s:7:\"updated\";N;s:7:\"created\";s:19:\"2025-02-05 16:15:27\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:17:\"FS_Plugin_License\":21:{s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24838\";s:16:\"parent_plan_name\";N;s:17:\"parent_plan_title\";N;s:17:\"parent_license_id\";N;s:8:\"products\";N;s:10:\"pricing_id\";s:5:\"30130\";s:5:\"quota\";i:1;s:9:\"activated\";i:0;s:15:\"activated_local\";i:0;s:10:\"expiration\";s:19:\"2025-01-29 07:50:02\";s:10:\"secret_key\";s:32:\"sk_F94M4+&UhH1nyuSJ0+#6o8ir6ZU5l\";s:15:\"is_whitelabeled\";b:0;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"is_cancelled\";b:0;s:2:\"id\";s:7:\"1658207\";s:7:\"updated\";s:19:\"2025-01-29 15:55:50\";s:7:\"created\";s:19:\"2025-01-21 07:50:04\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}s:6:\"addons\";a:1:{i:14919;a:1:{i:0;O:9:\"FS_Plugin\":24:{s:16:\"parent_plugin_id\";s:5:\"14919\";s:5:\"title\";s:16:\"Extended Sources\";s:4:\"slug\";s:35:\"interactive-globes-extended-sources\";s:12:\"premium_slug\";s:43:\"interactive-globes-extended-sources-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";N;s:19:\"is_wp_org_compliant\";b:0;s:22:\"premium_releases_count\";i:6;s:4:\"file\";N;s:7:\"version\";N;s:11:\"auto_update\";N;s:4:\"info\";O:14:\"FS_Plugin_Info\":13:{s:9:\"plugin_id\";s:5:\"16680\";s:11:\"description\";N;s:17:\"short_description\";s:88:\"Get Globe data from CPTs, JSON, Google Spreadsheets, taxonomies and other custom sources\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/16680/banner.png\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/16680/card_banner.jpg\";s:15:\"selling_point_0\";N;s:15:\"selling_point_1\";N;s:15:\"selling_point_2\";N;s:11:\"screenshots\";N;s:2:\"id\";s:4:\"4486\";s:7:\"updated\";s:19:\"2024-11-11 19:57:10\";s:7:\"created\";s:19:\"2024-10-06 21:09:58\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;s:10:\"public_key\";s:32:\"pk_2ed18410e6b420036b53130c0b43e\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"16680\";s:7:\"updated\";s:19:\"2025-10-18 23:48:32\";s:7:\"created\";s:19:\"2024-10-03 10:10:02\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}s:7:\"updates\";a:1:{i:14919;O:13:\"FS_Plugin_Tag\":12:{s:7:\"version\";s:6:\"1.4.10\";s:3:\"url\";s:388:\"https://api.freemius.com/v1/installs/16953237/updates/91126.zip?is_premium=true&authorization=FSLA+16953237%3AkvPQ2LRonbwcYFldfkfqQFlbCnG6b1bpNztTA_x5KgGEos93B-LJabRLWNBUTlrVfXhn_hmU6eBniGB10Qf0Hs6xQvWTi7r68oAFXJ--oOaUyvWzQi3v_egYB_fMucpUWzyz8BYxlQhwFOVsA8Kixtmhix7DZxMGRYaF0ko5e8OtwXY1CcbyzX_2lZgboAvrfwarMiI3ad_wzQ0wVZELTvObS20aL9nrjhk6YqSlBLb4d3r_Y-3vZiIJunKlYUkdfyY1x-AMpQg5N86F5R4hGQ\";s:25:\"requires_platform_version\";s:3:\"5.0\";s:37:\"requires_programming_language_version\";s:3:\"7.0\";s:20:\"tested_up_to_version\";s:3:\"6.8\";s:8:\"has_free\";b:1;s:11:\"has_premium\";b:1;s:12:\"release_mode\";s:8:\"released\";s:2:\"id\";s:5:\"91126\";s:7:\"updated\";i:1760882490;s:7:\"created\";s:19:\"2025-06-05 07:25:52\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:13:\"admin_notices\";a:1:{s:18:\"interactive-globes\";a:1:{s:13:\"plan_upgraded\";a:10:{s:7:\"message\";s:36:\"Your plan was successfully upgraded.\";s:5:\"title\";s:8:\"Yee-haw!\";s:4:\"type\";s:7:\"success\";s:6:\"sticky\";b:1;s:2:\"id\";s:13:\"plan_upgraded\";s:10:\"manager_id\";s:18:\"interactive-globes\";s:6:\"plugin\";s:26:\"Interactive Globes Premium\";s:10:\"wp_user_id\";N;s:11:\"dismissible\";b:1;s:4:\"data\";a:0:{}}}}}", "auto");
INSERT INTO `wp_options` VALUES("178", "fs_api_cache", "a:19:{s:26:\"get:/v1/users/7874829.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":10:{s:5:\"email\";s:22:\"pwrstudio.tu@gmail.com\";s:5:\"first\";s:6:\"farhad\";s:4:\"last\";s:10:\"Pourkazemi\";s:11:\"is_verified\";b:1;s:4:\"auth\";s:8:\"password\";s:10:\"secret_key\";s:32:\"sk_0Bt53M%u<z2Q.g8B=Pm.@1X47V.vy\";s:10:\"public_key\";s:32:\"pk_9a4325a657ee4b39a514606fefdba\";s:2:\"id\";s:7:\"7874829\";s:7:\"created\";s:19:\"2024-01-23 08:29:46\";s:7:\"updated\";s:19:\"2025-01-21 08:04:23\";}s:7:\"created\";i:1737447780;s:9:\"timestamp\";i:1737534180;}s:30:\"get:/v1/installs/16953237.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":33:{s:7:\"site_id\";s:9:\"256286218\";s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:3:\"url\";s:27:\"https://persianradio.online\";s:5:\"title\";s:13:\"World Map TWR\";s:7:\"version\";s:5:\"1.4.2\";s:7:\"plan_id\";s:5:\"24838\";s:10:\"license_id\";s:7:\"1658207\";s:13:\"trial_plan_id\";s:5:\"24838\";s:10:\"trial_ends\";s:19:\"2025-01-29 07:50:02\";s:15:\"subscription_id\";s:6:\"639002\";s:5:\"gross\";i:0;s:12:\"country_code\";s:2:\"tr\";s:8:\"language\";s:5:\"en-US\";s:16:\"platform_version\";s:5:\"6.7.1\";s:11:\"sdk_version\";s:5:\"2.9.0\";s:28:\"programming_language_version\";s:6:\"7.4.33\";s:9:\"is_active\";b:1;s:15:\"is_disconnected\";b:0;s:10:\"is_premium\";b:1;s:14:\"is_uninstalled\";b:0;s:9:\"is_locked\";b:0;s:6:\"source\";i:0;s:8:\"upgraded\";N;s:12:\"last_seen_at\";s:19:\"2025-01-21 08:23:04\";s:26:\"last_served_update_version\";s:5:\"1.4.2\";s:10:\"secret_key\";s:32:\"sk_v{7M_QB(kbEYDRE&3M7u5QP%(DdBG\";s:10:\"public_key\";s:32:\"pk_fbaaab1ce3afc402fcd4d7b7712cb\";s:2:\"id\";s:8:\"16953237\";s:7:\"created\";s:19:\"2025-01-21 07:55:34\";s:7:\"updated\";s:19:\"2025-01-21 08:02:03\";s:7:\"charset\";N;s:7:\"is_beta\";b:0;}s:7:\"created\";i:1737447780;s:9:\"timestamp\";i:1737534180;}s:46:\"get:/v1/users/7874829/plugins/14919/plans.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:5:\"plans\";a:2:{i:0;O:14:\"FS_Plugin_Plan\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:7:\"pricing\";N;s:8:\"features\";N;s:2:\"id\";s:5:\"24837\";s:7:\"updated\";s:19:\"2024-08-13 13:50:23\";s:7:\"created\";s:19:\"2024-02-06 23:40:38\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:14:\"FS_Plugin_Plan\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:1;s:10:\"support_kb\";s:46:\"https://wpinteractiveglobes.com/documentation/\";s:13:\"support_forum\";N;s:13:\"support_email\";s:31:\"support@wpinteractiveglobes.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:7:\"pricing\";N;s:8:\"features\";N;s:2:\"id\";s:5:\"24838\";s:7:\"updated\";s:19:\"2025-01-03 14:42:33\";s:7:\"created\";s:19:\"2024-02-06 23:43:11\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}s:7:\"created\";i:1738772129;s:9:\"timestamp\";i:1738858529;}s:66:\"get:/v1/users/7874829/plugins/14919/licenses.json?is_enriched=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:8:\"licenses\";a:2:{i:0;O:17:\"FS_Plugin_License\":21:{s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24838\";s:16:\"parent_plan_name\";N;s:17:\"parent_plan_title\";N;s:17:\"parent_license_id\";N;s:8:\"products\";N;s:10:\"pricing_id\";s:5:\"30130\";s:5:\"quota\";i:1;s:9:\"activated\";i:1;s:15:\"activated_local\";i:0;s:10:\"expiration\";N;s:10:\"secret_key\";s:32:\"sk_X263yFJXP1U=?7P;yQHuu1uU-y:&a\";s:15:\"is_whitelabeled\";b:0;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"is_cancelled\";b:0;s:2:\"id\";s:7:\"1665856\";s:7:\"updated\";N;s:7:\"created\";s:19:\"2025-02-05 16:15:27\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:17:\"FS_Plugin_License\":21:{s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24838\";s:16:\"parent_plan_name\";N;s:17:\"parent_plan_title\";N;s:17:\"parent_license_id\";N;s:8:\"products\";N;s:10:\"pricing_id\";s:5:\"30130\";s:5:\"quota\";i:1;s:9:\"activated\";i:0;s:15:\"activated_local\";i:0;s:10:\"expiration\";s:19:\"2025-01-29 07:50:02\";s:10:\"secret_key\";s:32:\"sk_F94M4+&UhH1nyuSJ0+#6o8ir6ZU5l\";s:15:\"is_whitelabeled\";b:0;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"is_cancelled\";b:0;s:2:\"id\";s:7:\"1658207\";s:7:\"updated\";s:19:\"2025-01-29 15:55:50\";s:7:\"created\";s:19:\"2025-01-21 07:50:04\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}}s:7:\"created\";i:1738772129;s:9:\"timestamp\";i:1738858529;}s:60:\"get:/v1/installs/16953237/addons.json?enriched=true&count=50\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:7:\"plugins\";a:1:{i:0;O:8:\"stdClass\":34:{s:16:\"parent_plugin_id\";s:5:\"14919\";s:12:\"developer_id\";s:4:\"6323\";s:8:\"store_id\";s:4:\"6575\";s:10:\"install_id\";s:8:\"16110427\";s:4:\"slug\";s:35:\"interactive-globes-extended-sources\";s:5:\"title\";s:16:\"Extended Sources\";s:11:\"environment\";i:0;s:4:\"icon\";s:48:\"//img.freemius.com/plugin-icon-blue-noshadow.png\";s:15:\"default_plan_id\";s:5:\"28368\";s:5:\"plans\";i:28368;s:8:\"features\";N;s:17:\"money_back_period\";N;s:13:\"refund_policy\";N;s:24:\"annual_renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:11:\"is_released\";b:1;s:15:\"is_sdk_required\";b:1;s:18:\"is_pricing_visible\";b:1;s:19:\"is_wp_org_compliant\";b:0;s:6:\"is_off\";b:0;s:24:\"is_only_for_new_installs\";b:0;s:14:\"installs_limit\";N;s:19:\"free_releases_count\";i:0;s:22:\"premium_releases_count\";i:6;s:17:\"accepted_payments\";i:0;s:7:\"plan_id\";s:1:\"0\";s:4:\"type\";s:6:\"plugin\";s:9:\"is_static\";b:0;s:10:\"public_key\";s:32:\"pk_2ed18410e6b420036b53130c0b43e\";s:2:\"id\";s:5:\"16680\";s:7:\"created\";s:19:\"2024-10-03 10:10:02\";s:7:\"updated\";s:19:\"2025-10-18 23:48:32\";s:4:\"info\";O:8:\"stdClass\":13:{s:9:\"plugin_id\";s:5:\"16680\";s:3:\"url\";N;s:11:\"description\";N;s:17:\"short_description\";s:88:\"Get Globe data from CPTs, JSON, Google Spreadsheets, taxonomies and other custom sources\";s:10:\"banner_url\";s:68:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/16680/banner.png\";s:15:\"card_banner_url\";s:73:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/16680/card_banner.jpg\";s:15:\"selling_point_0\";N;s:15:\"selling_point_1\";N;s:15:\"selling_point_2\";N;s:11:\"screenshots\";N;s:2:\"id\";s:4:\"4486\";s:7:\"created\";s:19:\"2024-10-06 21:09:58\";s:7:\"updated\";s:19:\"2024-11-11 19:57:10\";}s:12:\"premium_slug\";s:43:\"interactive-globes-extended-sources-premium\";}}}s:7:\"created\";i:1760882442;s:9:\"timestamp\";i:1760968842;}s:90:\"get:/v1/installs/16953237/updates/latest.json?is_premium=true&newer_than=1.4.2&readme=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:5:\"error\";O:8:\"stdClass\":3:{s:7:\"message\";s:40:\"There\'s no newer release of the product.\";s:4:\"code\";s:23:\"newer_version_not_found\";s:4:\"http\";i:404;}}s:7:\"created\";i:1737926444;s:9:\"timestamp\";i:1737926444;}s:169:\"get:/v1/plugins/14919/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=install&s_ctx_id=16953237&s_ctx_ts=1737465825&s_ctx_secure=b5ea11fc93f8168b743f62b87c07be89\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":13:{s:6:\"plugin\";O:8:\"stdClass\":12:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:18:\"interactive-globes\";s:5:\"title\";s:18:\"Interactive Globes\";s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/14919/icons/1d2f9b323394b39032de5da707b43682.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:6:\"strict\";s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"is_wp_org_compliant\";b:1;s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_bf374640397ee6130fcd4ea1ef141\";s:2:\"id\";s:5:\"14919\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:2:{i:0;O:8:\"stdClass\":22:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"24837\";s:7:\"created\";s:19:\"2024-02-06 23:40:38\";s:7:\"updated\";s:19:\"2024-08-13 13:50:23\";}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:1;s:10:\"support_kb\";s:46:\"https://wpinteractiveglobes.com/documentation/\";s:13:\"support_forum\";N;s:13:\"support_email\";s:31:\"support@wpinteractiveglobes.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"24838\";s:7:\"created\";s:19:\"2024-02-06 23:43:11\";s:7:\"updated\";s:19:\"2025-01-03 14:42:33\";s:7:\"pricing\";a:1:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"24838\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:29;s:14:\"lifetime_price\";i:59;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"30130\";s:7:\"created\";s:19:\"2024-02-06 23:43:43\";s:7:\"updated\";s:19:\"2025-01-03 14:42:26\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:3:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:9:\"Arc Lines\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17658\";s:7:\"created\";s:19:\"2024-07-29 22:36:05\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:26:\"Interactive vector regions\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17659\";s:7:\"created\";s:19:\"2024-07-29 22:36:19\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:15:\"Tooltip Styling\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17660\";s:7:\"created\";s:19:\"2024-07-29 22:36:29\";s:7:\"updated\";N;}}}}s:7:\"reviews\";a:0:{}s:15:\"active_installs\";i:0;s:9:\"downloads\";i:0;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":2:{s:5:\"24837\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:5:\"24838\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:2.4166666666667;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:29;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:59;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;s:7:\"install\";O:8:\"stdClass\":3:{s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24838\";s:2:\"id\";s:8:\"16953237\";}}s:7:\"created\";i:1737465826;s:9:\"timestamp\";i:1737552226;}s:69:\"get:/v1/users/7874829/plugins/14919/payments.json?include_addons=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":2:{s:8:\"payments\";a:2:{i:0;O:10:\"FS_Payment\":19:{s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:10:\"install_id\";s:8:\"16953237\";s:15:\"subscription_id\";N;s:7:\"plan_id\";s:5:\"24838\";s:10:\"license_id\";s:7:\"1665856\";s:5:\"gross\";i:59;s:8:\"currency\";s:3:\"usd\";s:16:\"bound_payment_id\";N;s:11:\"external_id\";s:27:\"ch_3QpBG5FmXz63vF5v1zIc6Qg2\";s:7:\"gateway\";s:6:\"stripe\";s:12:\"country_code\";s:2:\"tr\";s:6:\"vat_id\";N;s:3:\"vat\";i:0;s:6:\"source\";i:0;s:2:\"id\";s:7:\"1572131\";s:7:\"updated\";N;s:7:\"created\";s:19:\"2025-02-05 16:15:27\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}i:1;O:10:\"FS_Payment\":19:{s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:10:\"install_id\";s:8:\"16953237\";s:15:\"subscription_id\";s:6:\"639002\";s:7:\"plan_id\";s:5:\"24838\";s:10:\"license_id\";s:7:\"1658207\";s:5:\"gross\";i:0;s:8:\"currency\";s:3:\"usd\";s:16:\"bound_payment_id\";N;s:11:\"external_id\";s:27:\"in_1QjcDmFmXz63vF5vnijktSms\";s:7:\"gateway\";s:6:\"stripe\";s:12:\"country_code\";s:2:\"tr\";s:6:\"vat_id\";N;s:3:\"vat\";i:0;s:6:\"source\";i:0;s:2:\"id\";s:7:\"1558244\";s:7:\"updated\";s:19:\"2025-01-21 07:55:34\";s:7:\"created\";s:19:\"2025-01-21 07:50:05\";s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"discounts\";a:0:{}}s:7:\"created\";i:1738772129;s:9:\"timestamp\";i:1738858529;}s:34:\"get:/v1/users/7874829/billing.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":19:{s:9:\"entity_id\";s:7:\"7874829\";s:11:\"entity_type\";s:4:\"user\";s:13:\"business_name\";s:3:\"Pwr\";s:5:\"first\";N;s:4:\"last\";N;s:5:\"email\";N;s:5:\"phone\";i:905380249584;s:7:\"website\";N;s:6:\"tax_id\";N;s:14:\"address_street\";s:38:\"Aziziye Mah, Andrey Karlov Sok., No:13\";s:11:\"address_apt\";N;s:12:\"address_city\";s:6:\"Ankara\";s:15:\"address_country\";s:6:\"Turkey\";s:20:\"address_country_code\";s:2:\"TR\";s:13:\"address_state\";s:13:\"Andrey Karlov\";s:11:\"address_zip\";s:5:\"06690\";s:2:\"id\";s:6:\"252734\";s:7:\"created\";s:19:\"2024-01-23 08:29:50\";s:7:\"updated\";s:19:\"2024-12-12 06:02:06\";}s:7:\"created\";i:1738772129;s:9:\"timestamp\";i:1738858529;}s:169:\"get:/v1/plugins/14919/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=install&s_ctx_id=16953237&s_ctx_ts=1737465877&s_ctx_secure=cdeaed305cc9f51185860bd89eaff014\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":13:{s:6:\"plugin\";O:8:\"stdClass\":12:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:18:\"interactive-globes\";s:5:\"title\";s:18:\"Interactive Globes\";s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/14919/icons/1d2f9b323394b39032de5da707b43682.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:6:\"strict\";s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"is_wp_org_compliant\";b:1;s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_bf374640397ee6130fcd4ea1ef141\";s:2:\"id\";s:5:\"14919\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:2:{i:0;O:8:\"stdClass\":22:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"24837\";s:7:\"created\";s:19:\"2024-02-06 23:40:38\";s:7:\"updated\";s:19:\"2024-08-13 13:50:23\";}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:1;s:10:\"support_kb\";s:46:\"https://wpinteractiveglobes.com/documentation/\";s:13:\"support_forum\";N;s:13:\"support_email\";s:31:\"support@wpinteractiveglobes.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"24838\";s:7:\"created\";s:19:\"2024-02-06 23:43:11\";s:7:\"updated\";s:19:\"2025-01-03 14:42:33\";s:7:\"pricing\";a:1:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"24838\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:29;s:14:\"lifetime_price\";i:59;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"30130\";s:7:\"created\";s:19:\"2024-02-06 23:43:43\";s:7:\"updated\";s:19:\"2025-01-03 14:42:26\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:3:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:9:\"Arc Lines\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17658\";s:7:\"created\";s:19:\"2024-07-29 22:36:05\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:26:\"Interactive vector regions\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17659\";s:7:\"created\";s:19:\"2024-07-29 22:36:19\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:15:\"Tooltip Styling\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17660\";s:7:\"created\";s:19:\"2024-07-29 22:36:29\";s:7:\"updated\";N;}}}}s:7:\"reviews\";a:0:{}s:15:\"active_installs\";i:0;s:9:\"downloads\";i:0;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":2:{s:5:\"24837\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:5:\"24838\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:2.4166666666667;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:29;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:59;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;s:7:\"install\";O:8:\"stdClass\":3:{s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24838\";s:2:\"id\";s:8:\"16953237\";}}s:7:\"created\";i:1737465878;s:9:\"timestamp\";i:1737552278;}s:169:\"get:/v1/plugins/14919/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=install&s_ctx_id=16953237&s_ctx_ts=1737465962&s_ctx_secure=7ad3eaf8c5fd78ce711748022035acc8\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":13:{s:6:\"plugin\";O:8:\"stdClass\":12:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:18:\"interactive-globes\";s:5:\"title\";s:18:\"Interactive Globes\";s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/14919/icons/1d2f9b323394b39032de5da707b43682.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:6:\"strict\";s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"is_wp_org_compliant\";b:1;s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_bf374640397ee6130fcd4ea1ef141\";s:2:\"id\";s:5:\"14919\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:2:{i:0;O:8:\"stdClass\":22:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"24837\";s:7:\"created\";s:19:\"2024-02-06 23:40:38\";s:7:\"updated\";s:19:\"2024-08-13 13:50:23\";}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:1;s:10:\"support_kb\";s:46:\"https://wpinteractiveglobes.com/documentation/\";s:13:\"support_forum\";N;s:13:\"support_email\";s:31:\"support@wpinteractiveglobes.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"24838\";s:7:\"created\";s:19:\"2024-02-06 23:43:11\";s:7:\"updated\";s:19:\"2025-01-03 14:42:33\";s:7:\"pricing\";a:1:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"24838\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:29;s:14:\"lifetime_price\";i:59;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"30130\";s:7:\"created\";s:19:\"2024-02-06 23:43:43\";s:7:\"updated\";s:19:\"2025-01-03 14:42:26\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:3:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:9:\"Arc Lines\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17658\";s:7:\"created\";s:19:\"2024-07-29 22:36:05\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:26:\"Interactive vector regions\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17659\";s:7:\"created\";s:19:\"2024-07-29 22:36:19\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:15:\"Tooltip Styling\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17660\";s:7:\"created\";s:19:\"2024-07-29 22:36:29\";s:7:\"updated\";N;}}}}s:7:\"reviews\";a:0:{}s:15:\"active_installs\";i:0;s:9:\"downloads\";i:0;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":2:{s:5:\"24837\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:5:\"24838\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:2.4166666666667;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:29;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:59;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;s:7:\"install\";O:8:\"stdClass\":3:{s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24838\";s:2:\"id\";s:8:\"16953237\";}}s:7:\"created\";i:1737465963;s:9:\"timestamp\";i:1737552363;}s:61:\"get:/v1/installs/16953237/licenses/1658207/subscriptions.json\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:13:\"subscriptions\";a:1:{i:0;O:8:\"stdClass\":33:{s:8:\"tax_rate\";i:0;s:11:\"total_gross\";i:0;s:16:\"amount_per_cycle\";i:59;s:14:\"initial_amount\";i:59;s:14:\"renewal_amount\";i:59;s:17:\"renewals_discount\";N;s:22:\"renewals_discount_type\";s:10:\"percentage\";s:13:\"billing_cycle\";i:0;s:19:\"outstanding_balance\";i:0;s:15:\"failed_payments\";i:0;s:10:\"trial_ends\";s:19:\"2025-01-29 07:50:02\";s:12:\"next_payment\";s:19:\"2025-01-28 07:50:02\";s:11:\"canceled_at\";N;s:7:\"user_id\";s:7:\"7874829\";s:10:\"install_id\";s:8:\"16953237\";s:7:\"plan_id\";s:5:\"24838\";s:10:\"pricing_id\";s:5:\"30130\";s:10:\"license_id\";s:7:\"1658207\";s:2:\"ip\";s:12:\"94.54.21.247\";s:12:\"country_code\";s:2:\"tr\";s:15:\"zip_postal_code\";i:6690;s:6:\"vat_id\";N;s:9:\"coupon_id\";N;s:12:\"user_card_id\";s:6:\"520161\";s:6:\"source\";i:0;s:9:\"plugin_id\";s:5:\"14919\";s:11:\"external_id\";s:28:\"sub_1QjcDmFmXz63vF5vylFEcLZs\";s:7:\"gateway\";s:6:\"stripe\";s:11:\"environment\";i:0;s:2:\"id\";s:6:\"639002\";s:7:\"created\";s:19:\"2025-01-21 07:50:04\";s:7:\"updated\";s:19:\"2025-01-21 07:55:34\";s:8:\"currency\";s:3:\"usd\";}}}s:7:\"created\";i:1738083512;s:9:\"timestamp\";i:1738169912;}s:169:\"get:/v1/plugins/14919/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=install&s_ctx_id=16953237&s_ctx_ts=1738771617&s_ctx_secure=20eb9f19349f7efbd0171db72c4f9196\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":13:{s:6:\"plugin\";O:8:\"stdClass\":12:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:18:\"interactive-globes\";s:5:\"title\";s:18:\"Interactive Globes\";s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/14919/icons/1d2f9b323394b39032de5da707b43682.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:6:\"strict\";s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"is_wp_org_compliant\";b:1;s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_bf374640397ee6130fcd4ea1ef141\";s:2:\"id\";s:5:\"14919\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:2:{i:0;O:8:\"stdClass\":22:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"24837\";s:7:\"created\";s:19:\"2024-02-06 23:40:38\";s:7:\"updated\";s:19:\"2024-08-13 13:50:23\";}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:1;s:10:\"support_kb\";s:46:\"https://wpinteractiveglobes.com/documentation/\";s:13:\"support_forum\";N;s:13:\"support_email\";s:31:\"support@wpinteractiveglobes.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"24838\";s:7:\"created\";s:19:\"2024-02-06 23:43:11\";s:7:\"updated\";s:19:\"2025-01-03 14:42:33\";s:7:\"pricing\";a:1:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"24838\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:29;s:14:\"lifetime_price\";i:59;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"30130\";s:7:\"created\";s:19:\"2024-02-06 23:43:43\";s:7:\"updated\";s:19:\"2025-01-03 14:42:26\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:3:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:9:\"Arc Lines\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17658\";s:7:\"created\";s:19:\"2024-07-29 22:36:05\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:26:\"Interactive vector regions\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17659\";s:7:\"created\";s:19:\"2024-07-29 22:36:19\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:15:\"Tooltip Styling\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17660\";s:7:\"created\";s:19:\"2024-07-29 22:36:29\";s:7:\"updated\";N;}}}}s:7:\"reviews\";a:0:{}s:15:\"active_installs\";i:0;s:9:\"downloads\";i:0;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":2:{s:5:\"24837\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:5:\"24838\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:2.4166666666667;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:29;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:59;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;s:7:\"install\";O:8:\"stdClass\":3:{s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24837\";s:2:\"id\";s:8:\"16953237\";}}s:7:\"created\";i:1738771618;s:9:\"timestamp\";i:1738858018;}s:169:\"get:/v1/plugins/14919/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=install&s_ctx_id=16953237&s_ctx_ts=1738771672&s_ctx_secure=22cf327bdb1b98e9f8e2159a1e7358c9\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":13:{s:6:\"plugin\";O:8:\"stdClass\":12:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:18:\"interactive-globes\";s:5:\"title\";s:18:\"Interactive Globes\";s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/14919/icons/1d2f9b323394b39032de5da707b43682.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:6:\"strict\";s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"is_wp_org_compliant\";b:1;s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_bf374640397ee6130fcd4ea1ef141\";s:2:\"id\";s:5:\"14919\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:2:{i:0;O:8:\"stdClass\":22:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"24837\";s:7:\"created\";s:19:\"2024-02-06 23:40:38\";s:7:\"updated\";s:19:\"2024-08-13 13:50:23\";}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:1;s:10:\"support_kb\";s:46:\"https://wpinteractiveglobes.com/documentation/\";s:13:\"support_forum\";N;s:13:\"support_email\";s:31:\"support@wpinteractiveglobes.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"24838\";s:7:\"created\";s:19:\"2024-02-06 23:43:11\";s:7:\"updated\";s:19:\"2025-01-03 14:42:33\";s:7:\"pricing\";a:1:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"24838\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:29;s:14:\"lifetime_price\";i:59;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"30130\";s:7:\"created\";s:19:\"2024-02-06 23:43:43\";s:7:\"updated\";s:19:\"2025-01-03 14:42:26\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:3:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:9:\"Arc Lines\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17658\";s:7:\"created\";s:19:\"2024-07-29 22:36:05\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:26:\"Interactive vector regions\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17659\";s:7:\"created\";s:19:\"2024-07-29 22:36:19\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:15:\"Tooltip Styling\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17660\";s:7:\"created\";s:19:\"2024-07-29 22:36:29\";s:7:\"updated\";N;}}}}s:7:\"reviews\";a:0:{}s:15:\"active_installs\";i:0;s:9:\"downloads\";i:0;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":2:{s:5:\"24837\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:5:\"24838\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:2.4166666666667;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:29;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:59;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;s:7:\"install\";O:8:\"stdClass\":3:{s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24837\";s:2:\"id\";s:8:\"16953237\";}}s:7:\"created\";i:1738771673;s:9:\"timestamp\";i:1738858073;}s:169:\"get:/v1/plugins/14919/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=install&s_ctx_id=16953237&s_ctx_ts=1738771791&s_ctx_secure=40d637dceab62e951fbcc927d8899e87\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":13:{s:6:\"plugin\";O:8:\"stdClass\":12:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:18:\"interactive-globes\";s:5:\"title\";s:18:\"Interactive Globes\";s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/14919/icons/1d2f9b323394b39032de5da707b43682.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:6:\"strict\";s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"is_wp_org_compliant\";b:1;s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_bf374640397ee6130fcd4ea1ef141\";s:2:\"id\";s:5:\"14919\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:2:{i:0;O:8:\"stdClass\":22:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"24837\";s:7:\"created\";s:19:\"2024-02-06 23:40:38\";s:7:\"updated\";s:19:\"2024-08-13 13:50:23\";}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:1;s:10:\"support_kb\";s:46:\"https://wpinteractiveglobes.com/documentation/\";s:13:\"support_forum\";N;s:13:\"support_email\";s:31:\"support@wpinteractiveglobes.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"24838\";s:7:\"created\";s:19:\"2024-02-06 23:43:11\";s:7:\"updated\";s:19:\"2025-01-03 14:42:33\";s:7:\"pricing\";a:1:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"24838\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:29;s:14:\"lifetime_price\";i:59;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"30130\";s:7:\"created\";s:19:\"2024-02-06 23:43:43\";s:7:\"updated\";s:19:\"2025-01-03 14:42:26\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:3:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:9:\"Arc Lines\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17658\";s:7:\"created\";s:19:\"2024-07-29 22:36:05\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:26:\"Interactive vector regions\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17659\";s:7:\"created\";s:19:\"2024-07-29 22:36:19\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:15:\"Tooltip Styling\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17660\";s:7:\"created\";s:19:\"2024-07-29 22:36:29\";s:7:\"updated\";N;}}}}s:7:\"reviews\";a:0:{}s:15:\"active_installs\";i:0;s:9:\"downloads\";i:0;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":2:{s:5:\"24837\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:5:\"24838\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:2.4166666666667;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:29;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:59;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;s:7:\"install\";O:8:\"stdClass\":3:{s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24837\";s:2:\"id\";s:8:\"16953237\";}}s:7:\"created\";i:1738771791;s:9:\"timestamp\";i:1738858191;}s:169:\"get:/v1/plugins/14919/pricing.json?is_enriched=1&trial=0&sandbox=0&s_ctx_type=install&s_ctx_id=16953237&s_ctx_ts=1738771861&s_ctx_secure=264441e42b1fe91cb1970d2ca5c65ece\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":13:{s:6:\"plugin\";O:8:\"stdClass\":12:{s:16:\"parent_plugin_id\";N;s:4:\"slug\";s:18:\"interactive-globes\";s:5:\"title\";s:18:\"Interactive Globes\";s:4:\"icon\";s:100:\"https://s3-us-west-2.amazonaws.com/freemius/plugins/14919/icons/1d2f9b323394b39032de5da707b43682.png\";s:17:\"money_back_period\";i:30;s:13:\"refund_policy\";s:6:\"strict\";s:22:\"renewals_discount_type\";s:10:\"percentage\";s:19:\"is_wp_org_compliant\";b:1;s:4:\"type\";s:6:\"plugin\";s:10:\"public_key\";s:32:\"pk_bf374640397ee6130fcd4ea1ef141\";s:2:\"id\";s:5:\"14919\";s:19:\"has_premium_version\";b:1;}s:5:\"plans\";a:2:{i:0;O:8:\"stdClass\":22:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:4:\"free\";s:5:\"title\";s:4:\"Free\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";N;s:23:\"is_require_subscription\";b:0;s:10:\"support_kb\";N;s:13:\"support_forum\";N;s:13:\"support_email\";N;s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:0;s:9:\"is_hidden\";b:1;s:2:\"id\";s:5:\"24837\";s:7:\"created\";s:19:\"2024-02-06 23:40:38\";s:7:\"updated\";s:19:\"2024-08-13 13:50:23\";}i:1;O:8:\"stdClass\":24:{s:9:\"plugin_id\";s:5:\"14919\";s:4:\"name\";s:3:\"pro\";s:5:\"title\";s:3:\"Pro\";s:11:\"description\";N;s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:25:\"is_block_features_monthly\";b:1;s:12:\"license_type\";i:0;s:16:\"is_https_support\";b:0;s:12:\"trial_period\";i:7;s:23:\"is_require_subscription\";b:1;s:10:\"support_kb\";s:46:\"https://wpinteractiveglobes.com/documentation/\";s:13:\"support_forum\";N;s:13:\"support_email\";s:31:\"support@wpinteractiveglobes.com\";s:13:\"support_phone\";N;s:13:\"support_skype\";N;s:18:\"is_success_manager\";b:0;s:11:\"is_featured\";b:1;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"24838\";s:7:\"created\";s:19:\"2024-02-06 23:43:11\";s:7:\"updated\";s:19:\"2025-01-03 14:42:33\";s:7:\"pricing\";a:1:{i:0;O:8:\"stdClass\":11:{s:7:\"plan_id\";s:5:\"24838\";s:8:\"licenses\";i:1;s:13:\"monthly_price\";N;s:12:\"annual_price\";i:29;s:14:\"lifetime_price\";i:59;s:15:\"is_whitelabeled\";b:0;s:9:\"is_hidden\";b:0;s:2:\"id\";s:5:\"30130\";s:7:\"created\";s:19:\"2024-02-06 23:43:43\";s:7:\"updated\";s:19:\"2025-01-03 14:42:26\";s:8:\"currency\";s:3:\"usd\";}}s:8:\"features\";a:3:{i:0;O:8:\"stdClass\":9:{s:5:\"value\";N;s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:9:\"Arc Lines\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17658\";s:7:\"created\";s:19:\"2024-07-29 22:36:05\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:26:\"Interactive vector regions\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17659\";s:7:\"created\";s:19:\"2024-07-29 22:36:19\";s:7:\"updated\";N;}i:2;O:8:\"stdClass\":9:{s:5:\"value\";s:0:\"\";s:7:\"plan_id\";s:5:\"24838\";s:9:\"plugin_id\";s:5:\"14919\";s:5:\"title\";s:15:\"Tooltip Styling\";s:11:\"description\";N;s:11:\"is_featured\";b:1;s:2:\"id\";s:5:\"17660\";s:7:\"created\";s:19:\"2024-07-29 22:36:29\";s:7:\"updated\";N;}}}}s:7:\"reviews\";a:0:{}s:15:\"active_installs\";i:0;s:9:\"downloads\";i:0;s:29:\"all_plans_single_site_pricing\";O:8:\"stdClass\":2:{s:5:\"24837\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:0;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}s:5:\"24838\";O:8:\"stdClass\":3:{s:13:\"monthly_price\";O:8:\"stdClass\":3:{s:3:\"usd\";d:2.4166666666667;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:12:\"annual_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:29;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}s:14:\"lifetime_price\";O:8:\"stdClass\":3:{s:3:\"usd\";i:59;s:3:\"gbp\";i:0;s:3:\"eur\";i:0;}}}s:12:\"checkout_url\";s:29:\"https://checkout.freemius.com\";s:18:\"fs_wp_endpoint_url\";s:23:\"https://wp.freemius.com\";s:10:\"trial_mode\";b:0;s:14:\"trial_utilized\";b:0;s:23:\"skip_directly_to_paypal\";b:0;s:19:\"is_paypal_supported\";b:1;s:7:\"install\";O:8:\"stdClass\":3:{s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24837\";s:2:\"id\";s:8:\"16953237\";}}s:7:\"created\";i:1738771861;s:9:\"timestamp\";i:1738858261;}s:90:\"get:/v1/installs/16953237/updates/latest.json?is_premium=true&newer_than=1.4.4&readme=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:5:\"error\";O:8:\"stdClass\":3:{s:7:\"message\";s:40:\"There\'s no newer release of the product.\";s:4:\"code\";s:23:\"newer_version_not_found\";s:4:\"http\";i:404;}}s:7:\"created\";i:1739958692;s:9:\"timestamp\";i:1739958692;}s:47:\"get:/v1/users/7874829/licenses.json?type=active\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:8:\"licenses\";a:2:{i:0;O:8:\"stdClass\":18:{s:9:\"plugin_id\";s:5:\"14919\";s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"24838\";s:10:\"pricing_id\";s:5:\"30130\";s:5:\"quota\";i:1;s:9:\"activated\";i:1;s:15:\"activated_local\";i:0;s:10:\"expiration\";N;s:10:\"secret_key\";s:32:\"sk_X263yFJXP1U=?7P;yQHuu1uU-y:&a\";s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"is_cancelled\";b:0;s:15:\"is_whitelabeled\";b:0;s:11:\"environment\";i:0;s:6:\"source\";i:0;s:2:\"id\";s:7:\"1665856\";s:7:\"created\";s:19:\"2025-02-05 16:15:27\";s:7:\"updated\";N;}i:1;O:8:\"stdClass\":18:{s:9:\"plugin_id\";s:4:\"8684\";s:7:\"user_id\";s:7:\"7874829\";s:7:\"plan_id\";s:5:\"14508\";s:10:\"pricing_id\";s:5:\"16016\";s:5:\"quota\";i:1;s:9:\"activated\";i:1;s:15:\"activated_local\";i:5;s:10:\"expiration\";N;s:10:\"secret_key\";s:32:\"sk_bx;e.I53u;@7a~eBIY#slcUUF9&iK\";s:17:\"is_free_localhost\";b:1;s:17:\"is_block_features\";b:1;s:12:\"is_cancelled\";b:0;s:15:\"is_whitelabeled\";b:0;s:11:\"environment\";i:0;s:6:\"source\";i:0;s:2:\"id\";s:7:\"1272626\";s:7:\"created\";s:19:\"2024-01-23 08:29:50\";s:7:\"updated\";s:19:\"2024-10-28 16:13:51\";}}}s:7:\"created\";i:1760882442;s:9:\"timestamp\";i:1760968842;}s:90:\"get:/v1/installs/16953237/updates/latest.json?is_premium=true&newer_than=1.4.6&readme=true\";O:8:\"stdClass\":3:{s:6:\"result\";O:8:\"stdClass\":1:{s:5:\"error\";O:8:\"stdClass\":3:{s:7:\"message\";s:40:\"There\'s no newer release of the product.\";s:4:\"code\";s:23:\"newer_version_not_found\";s:4:\"http\";i:404;}}s:7:\"created\";i:1743499239;s:9:\"timestamp\";i:1743499239;}}", "off");
INSERT INTO `wp_options` VALUES("185", "fs_gdpr", "a:1:{s:2:\"u1\";a:1:{s:18:\"show_opt_in_notice\";b:0;}}", "auto");
INSERT INTO `wp_options` VALUES("186", "_site_transient_timeout_fs_locked_1", "2052807784", "off");
INSERT INTO `wp_options` VALUES("187", "_site_transient_fs_locked_1", "1", "off");
INSERT INTO `wp_options` VALUES("188", "ittglobes", "a:11:{s:9:\"map_field\";b:0;s:14:\"tooltip_editor\";s:8:\"textarea\";s:20:\"actionContent_editor\";s:8:\"textarea\";s:15:\"template_editor\";s:4:\"text\";s:20:\"defaultsFieldsHeader\";s:0:\"\";s:18:\"defaultActiveColor\";s:7:\"#99d8c9\";s:17:\"defaultHoverColor\";s:7:\"#2ca25f\";s:16:\"filterMenuStyles\";s:0:\"\";s:10:\"capability\";s:4:\"page\";s:11:\"public_cpts\";b:0;s:12:\"single_pages\";s:0:\"\";}", "auto");
INSERT INTO `wp_options` VALUES("189", "ittglobe_version", "1.4.6", "auto");
INSERT INTO `wp_options` VALUES("225", "tuxedo_big_file_uploads_reviews_time", "1738660491", "off");
INSERT INTO `wp_options` VALUES("226", "tuxbfu_settings", "a:2:{s:7:\"by_role\";b:0;s:6:\"limits\";a:4:{s:3:\"all\";a:2:{s:5:\"bytes\";i:5242880;s:6:\"format\";s:2:\"MB\";}s:13:\"administrator\";a:2:{s:5:\"bytes\";i:2097152;s:6:\"format\";s:2:\"MB\";}s:6:\"editor\";a:2:{s:5:\"bytes\";i:2097152;s:6:\"format\";s:2:\"MB\";}s:6:\"author\";a:2:{s:5:\"bytes\";i:2097152;s:6:\"format\";s:2:\"MB\";}}}", "off");
INSERT INTO `wp_options` VALUES("404", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":4,\"critical\":1}", "on");
INSERT INTO `wp_options` VALUES("581", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("3081", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:17:\"sia1352@gmail.com\";s:7:\"version\";s:5:\"6.8.3\";s:9:\"timestamp\";i:1759267942;}", "off");
INSERT INTO `wp_options` VALUES("25416", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("37101", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.8.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.8.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1760882476;s:15:\"version_checked\";s:5:\"6.8.3\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("39853", "_site_transient_timeout_fs_garbage_collection", "1760934137", "off");
INSERT INTO `wp_options` VALUES("39854", "_site_transient_fs_garbage_collection", "1", "off");
INSERT INTO `wp_options` VALUES("39882", "_transient_timeout_d2699ad6bd75de6a4fda65302f716157", "1760908891", "off");
INSERT INTO `wp_options` VALUES("39883", "_transient_d2699ad6bd75de6a4fda65302f716157", "O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:11:\"api_blocked\";a:1:{i:0;s:52:\"{&quot;plugins&quot;:[],&quot;translations&quot;:[]}\";}}s:10:\"error_data\";a:0:{}s:18:\"\0*\0additional_data\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("39886", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1760882477;s:7:\"checked\";a:4:{s:5:\"astra\";s:5:\"4.9.0\";s:16:\"twentytwentyfive\";s:3:\"1.1\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:2:{s:5:\"astra\";a:6:{s:5:\"theme\";s:5:\"astra\";s:11:\"new_version\";s:7:\"4.11.13\";s:3:\"url\";s:35:\"https://wordpress.org/themes/astra/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/theme/astra.4.11.13.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.3\";}s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.3.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}}s:9:\"no_update\";a:2:{s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("39915", "_transient_timeout_astra-theme-cron-test-ok", "1760884376", "off");
INSERT INTO `wp_options` VALUES("39916", "_transient_astra-theme-cron-test-ok", "1", "off");
INSERT INTO `wp_options` VALUES("39917", "_site_transient_timeout_wp_theme_files_patterns-8770f287c76506d28292ac625e026450", "1760883161", "off");
INSERT INTO `wp_options` VALUES("39918", "_site_transient_wp_theme_files_patterns-8770f287c76506d28292ac625e026450", "a:2:{s:7:\"version\";s:5:\"4.9.0\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("39919", "_site_transient_timeout_wp_theme_files_patterns-fe1dc227a8def1ecf8f8c2b49eff9a71", "1760884242", "off");
INSERT INTO `wp_options` VALUES("39920", "_site_transient_wp_theme_files_patterns-fe1dc227a8def1ecf8f8c2b49eff9a71", "a:2:{s:7:\"version\";b:0;s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("39921", "_site_transient_timeout_browser_2204ee63bef2f351470a66ffe1bb020e", "1761487245", "off");
INSERT INTO `wp_options` VALUES("39922", "_site_transient_browser_2204ee63bef2f351470a66ffe1bb020e", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"141.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("39923", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1761487245", "off");
INSERT INTO `wp_options` VALUES("39924", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:0;s:13:\"is_acceptable\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("39925", "_site_transient_timeout_community-events-9b0d039417c2fb441f16ceb99f9d98ba", "1760925647", "off");
INSERT INTO `wp_options` VALUES("39926", "_site_transient_community-events-9b0d039417c2fb441f16ceb99f9d98ba", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"85.106.119.0\";}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:20:\"WordCamp Athens 2025\";s:3:\"url\";s:33:\"https://athens.wordcamp.org/2025/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2025-11-08 08:45:00\";s:8:\"end_date\";s:19:\"2025-11-08 08:45:00\";s:20:\"start_unix_timestamp\";i:1762584300;s:18:\"end_unix_timestamp\";i:1762584300;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Athens\";s:7:\"country\";s:2:\"GR\";s:8:\"latitude\";d:38.0496425;s:9:\"longitude\";d:23.7885963;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:19:\"WordCamp Sofia 2025\";s:3:\"url\";s:32:\"https://sofia.wordcamp.org/2025/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2025-11-29 00:00:00\";s:8:\"end_date\";s:19:\"2025-11-30 00:00:00\";s:20:\"start_unix_timestamp\";i:1764367200;s:18:\"end_unix_timestamp\";i:1764453600;s:8:\"location\";a:4:{s:8:\"location\";s:15:\"Sofia, Bulgaria\";s:7:\"country\";s:2:\"BG\";s:8:\"latitude\";d:42.6851492;s:9:\"longitude\";d:23.3190108;}}}}", "off");
INSERT INTO `wp_options` VALUES("39927", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1760925648", "off");
INSERT INTO `wp_options` VALUES("39928", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 20:04:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60929\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WordPress 6.8.3 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 19:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"WordPress 6.8.3 is now available! This is a security release that features two fixes. Because this is a security release, it is recommended that you update your sites immediately. You can download WordPress 6.8.3 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4937:\"\n<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.3.zip\">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-9/\">version 6.9</a>, which is planned for December 2nd, 2025.<br>For more information on WordPress 6.8.3, please visit the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-8-3/\">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href=\"https://hackerone.com/wordpress?type=team\">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href=\"https://hackerone.com/mnelson4\">Mike Nelson</a>, <a href=\"https://hackerone.com/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, and <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href=\"https://x.com/Savphill\">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/andraganescu%20\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phillsav\">Phill</a>, <a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://app.slack.com/client/T024MFP4J/C02RQBWTW\">#core</a> Slack channel. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a> for reviewing.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Portland Welcomes WordCamp US 2025: A Community Gathering\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Aug 2025 03:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19074\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:66040:\"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95c586&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95c586\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19080\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19080\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95c88f&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95c88f\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19081\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19081\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95cb4b&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95cb4b\" class=\"wp-block-image size-large wp-lightbox-container\"><img decoding=\"async\" width=\"1707\" height=\"2560\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19087\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1\" alt=\"\" class=\"wp-image-19087\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95cddc&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95cddc\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19084\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19084\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95d08a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95d08a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19082\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19082\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95d32f&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95d32f\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19085\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19085\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95d5c3&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95d5c3\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19086\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19086\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95d857&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95d857\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19090\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19090\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95db24&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95db24\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19089\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19089\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95ddcb&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95ddcb\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19092\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19092\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95e069&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95e069\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19088\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19088\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95e317&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95e317\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19091\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19091\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95e5ab&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95e5ab\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19083\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19083\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href=\"https://youtu.be/PGvh7fCOUk0\">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href=\"https://youtu.be/F4NEPcwGRCI\">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a>. Panelists <a href=\"https://youtu.be/ARqM9U0ESvo\">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href=\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href=\"https://youtu.be/v_0O6dQ4Q4E\">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19103\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href=\"https://youtu.be/vBjNqdacbh4\">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href=\"https://youtu.be/O7FPiFpRI3o\">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href=\"https://youtu.be/ORnJTpjA-4w\">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/45HRzzc0waU?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href=\"https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00\">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95f148&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95f148\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19112\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19112\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95f41b&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95f41b\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19124\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19124\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95f6ce&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95f6ce\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19122\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19122\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95f963&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95f963\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19107\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19107\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95fc33&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95fc33\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"675\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19108\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1\" alt=\"\" class=\"wp-image-19108\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb95feca&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb95feca\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19113\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19113\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb96016c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb96016c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"433\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19106\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1\" alt=\"\" class=\"wp-image-19106\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb960411&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb960411\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19110\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19110\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb9606d1&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb9606d1\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19119\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19119\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb96097e&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb96097e\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19133\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19133\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Portland, Are You Ready? The WCUS 2025 Schedule Has Arrived!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2025/08/portland-are-you-ready-the-wcus-2025-schedule-has-arrived/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Aug 2025 20:03:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"WCUS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19004\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:402:\"We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5698:\"\n<p>We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the future of WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19026\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p class=\"has-text-align-center\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-blue-1-background-color has-background wp-element-button\" href=\"https://us.wordcamp.org/2025/schedule/\">View The Schedule</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day — Connect, Collaborate, and Give Back</h2>\n\n\n\n<p>Kicking off the week on Tuesday, August 26 is Contributor Day, it is your chance to roll up your sleeves and make a direct impact on WordPress. Whether you’re a seasoned developer, creative designer, translator, marketer, or simply passionate about open source, there’s a place for you to get involved. Join WordPress teams working on real projects, share your skills, and connect with people across the global community. Contributor Day is also a fantastic place for hiring managers or business owners to meet emerging talent and see contributors in action. Lunch is provided, and both in-person and select remote participation options are available. If you’ve ever wanted to help shape the future of WordPress, this is your moment!<br></p>\n\n\n\n<p>Read more: <a href=\"https://us.wordcamp.org/2025/schedule/#contributor-day\">Start planning your Contributor Day activities &gt;&gt;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day — See WordPress in Action</h2>\n\n\n\n<p>Showcase Day on Wednesday, August 27, shines a spotlight on what&#8217;s possible with WordPress. Get inspired by live demos, case studies, and actionable presentations from experts and innovators using WordPress in creative and impactful ways. You’ll see how changemakers, nonprofits, publishers, and agencies use WordPress to solve real-world problems, build new products, and drive the web forward. Highlights include hands-on workshops, technical talks, and practical sessions covering everything from design systems to modern AI. It’s a full day dedicated to celebrating the talent, creativity, and innovation of the WordPress community.</p>\n\n\n\n<p>Read more: <a href=\"https://us.wordcamp.org/2025/schedule/#showcase-day\">See where these inspirational showcases take you &gt;&gt;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Conference Days — Learn, Connect, and Level Up</h2>\n\n\n\n<p>The main event days for Thursday and Friday, August 28-29, feature a robust mix of technical deep-dives, product masterclasses, and sessions designed for all experience levels. Whether you’re a developer, designer, business owner, or just starting out, you’ll find plenty to explore—from future-focused discussions on AI and performance to hands-on workshops and networking events that bring the community together.</p>\n\n\n\n<p><strong>Keynote Highlights:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Amy Sample Ward, CEO of NTEN:</strong> The Tech That Comes Next: How Changemakers, Philanthropists, and Technologists Can Build an Equitable World. Featured Wednesday, August 27.</li>\n\n\n\n<li><strong>Danny Sullivan, from Google Search</strong>: Industry leader, featured Thursday, August 28.</li>\n\n\n\n<li><strong>Matt Mullenweg, Co-founder of WordPress:</strong> Featured Friday, August 29.</li>\n\n\n\n<li>More keynotes announcing soon!</li>\n</ul>\n\n\n\n<p>With dozens of sessions across multiple tracks, plus workshops and networking opportunities, WordCamp US is set to be an unforgettable experience. Don’t miss your chance to connect, share ideas, and help shape the future of the web.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-blue-1-background-color has-background wp-element-button\" href=\"https://us.wordcamp.org/2025/schedule/\">View The Schedule</a></div>\n</div>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19004\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Maintenance Releases for WordPress branches 4.7 to 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wordpress.org/news/2025/08/maintenance-releases-for-wordpress-branches-4-7-to-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Aug 2025 19:11:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18997\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"Following on from the WordPress 6.8.2 maintenance release last month, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2119:\"\n<p>Following on from <a href=\"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/\">the WordPress 6.8.2 maintenance release last month</a>, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on <a href=\"https://core.trac.wordpress.org/ticket/62811\">the Core Trac ticket</a>.</p>\n\n\n\n<p>A new maintenance release for each branch from 4.7 to 6.7 is now available. If you have sites on these branches and they support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The latest and only supported version of WordPress remains as 6.8.2. This is being done as a courtesy for sites still running older versions of WordPress. You can <a href=\"https://wordpress.org/wordpress-6.8.2.zip\">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/peterwilsoncc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>peterwilsoncc</a>, <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a>, <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a>, and <a href=\'https://profiles.wordpress.org/johnbillion/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>johnbillion</a> for backporting and releasing this update.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18997\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.8.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Jul 2025 15:41:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18903\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"WordPress 6.8.2 is now available! This minor release includes fixes for 20 Core tickets and 15 Block Editor issues. For a full list of bug fixes, please refer to the release candidate announcement. WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025. If you have sites that support [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10720:\"\n<h2 class=\"wp-block-heading\">WordPress 6.8.2 is now available!</h2>\n\n\n\n<p>This minor release includes fixes for <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.8.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">20 Core tickets</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/70557\">15 Block Editor issues</a>. For a full list of bug fixes, please refer to the <a href=\"https://make.wordpress.org/core/2025/07/08/wordpress-6-8-2-rc1-is-now-available/\">release candidate announcement.</a></p>\n\n\n\n<p>WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.2.zip\">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-8-2\">visit the HelpHub version page</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Dropping security updates for WordPress versions 4.1 through 4.6</h2>\n\n\n\n<p>This is not directly related to the 6.8.2 maintenance release, but <a href=\"https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/\">branches 4.1 to 4.6 had their final release today</a>. These branches won&#8217;t receive any security update anymore.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>WordPress 6.8.2 was led by <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a>.</p>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/sergeybiryukov/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sergeybiryukov</a>, <a href=\'https://profiles.wordpress.org/mamaduka/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mamaduka</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> and <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a> for their help on specific release tasks.</p>\n\n\n\n<p>WordPress 6.8.2 would not have been possible without the contributions of the following 96 people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-medium has-white-color has-midnight-gradient-background has-text-color has-background has-link-color has-normal-font-size wp-elements-2ad7deb15a87fd29427f001e4c18a1ac\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/alexstine\">Alex Stine</a>, <a href=\"https://profiles.wordpress.org/anatolbroder\">Anatol Broder</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/ankitkumarshah\">Ankit Kumar Shah</a>, <a href=\"https://profiles.wordpress.org/annezazu\">annezazu</a>, <a href=\"https://profiles.wordpress.org/azharderaiya\">Azhar Deraiya</a>, <a href=\"https://profiles.wordpress.org/benjamingosset\">Benjamin Gosset</a>, <a href=\"https://profiles.wordpress.org/bhubbard\">Brandon Hubbard</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brhodes\">brhodes</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/czarate\">Chris Zarate</a>, <a href=\"https://profiles.wordpress.org/courane01\">Courtney Robertson</a>, <a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/darshitrajyaguru97\">Darshit Rajyaguru</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhruvang21\">Dhruvang21</a>, <a href=\"https://profiles.wordpress.org/dilipbheda\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/divinenephron\">divinenephron</a>, <a href=\"https://profiles.wordpress.org/dustintechsmith\">dustintechsmith</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/im3dabasia1\">Eshaan Dabasiya</a>, <a href=\"https://profiles.wordpress.org/estelaris\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/faisalahammad\">Faisal Ahammad</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/guddu1315\">Gaurang Dabhi</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gernberg\">gernberg</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/harshgajipara\">Harsh Gajipara</a>, <a href=\"https://profiles.wordpress.org/helgatheviking\">HelgaTheViking</a>, <a href=\"https://profiles.wordpress.org/abcd95\">Himanshu Pathak</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/JeffPaul\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/luminuu\">Jessica Lyschik</a>, <a href=\"https://profiles.wordpress.org/jigarpanchal\">Jigar Panchal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/mindctrl\">John Parris</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/kausaralm\">Kausar Alam</a>, <a href=\"https://profiles.wordpress.org/kishanjasani\">Kishan Jasani</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/pfefferle\">Matthias Pfefferle</a>, <a href=\"https://profiles.wordpress.org/megane9988\">megane9988</a>, <a href=\"https://profiles.wordpress.org/mosescursor\">Moses Cursor Ssebunya</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/mwillman1991\">mwillman1991</a>, <a href=\"https://profiles.wordpress.org/bugnumber9\">Nazar Hotsa</a>, <a href=\"https://profiles.wordpress.org/nidhidhandhukiya\">nidhidhandhukiya</a>, <a href=\"https://profiles.wordpress.org/nikunj8866\">Nikunj Hatkar</a>, <a href=\"https://profiles.wordpress.org/oferlaor\">oferlaor</a>, <a href=\"https://profiles.wordpress.org/oglekler\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/paulstanos\">paulstanos</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/puggan\">puggan</a>, <a href=\"https://profiles.wordpress.org/ravigadhiyawp\">Ravi Gadhiya</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rollybueno\">Rolly Bueno</a>, <a href=\"https://profiles.wordpress.org/room34\">room34</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/sajjad67\">Sajjad Hossain Sagor</a>, <a href=\"https://profiles.wordpress.org/Sam_a\">sam_a</a>, <a href=\"https://profiles.wordpress.org/sandeepdahiya\">Sandeep Dahiya</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shanemuir\">Shane Muirhead</a>, <a href=\"https://profiles.wordpress.org/siliconforks\">siliconforks</a>, <a href=\"https://profiles.wordpress.org/sirlouen\">SirLouen</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/sukhendu2002\">Sukhendu Sekhar Guria</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/TobiasBg\">Tobias Bäthge</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/ugyensupport\">Ugyen Dorji</a>, <a href=\"https://profiles.wordpress.org/uxl\">uxl</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>, <a href=\"https://profiles.wordpress.org/getsyash\">Yash B</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar\">Yogesh Bhutkar</a>, and <a href=\"https://profiles.wordpress.org/zunaid321\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation on Slack, in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a> channels. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a> and <a href=\'https://profiles.wordpress.org/zunaid321/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>zunaid321</a> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Celebrating Kim Parsell: 2025 WordCamp US Scholarship Applications Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wordpress.org/news/2025/07/kim-parsell-2025-wcus-scholarship-applications-open/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Jul 2025 18:57:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18911\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"The WordPress Foundation is pleased to announce the return of the Kim Parsell Memorial Scholarship for WordCamp US 2025. Applications are being accepted until July 25, 2025. Remembering Kim Parsell Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6224:\"\n<p>The WordPress Foundation is pleased to announce the return of the <strong>Kim Parsell Memorial Scholarship</strong> for WordCamp US 2025. Applications are being accepted until <strong>July 25, 2025</strong>.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"604\" height=\"370\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=604%2C370&#038;ssl=1\" alt=\"\" class=\"wp-image-18912\" style=\"border-width:25px;border-radius:40px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?w=604&amp;ssl=1 604w, https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=300%2C184&amp;ssl=1 300w\" sizes=\"auto, (max-width: 604px) 100vw, 604px\" /></figure>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-6cbf45de wp-block-group-is-layout-constrained\" style=\"margin-top:48px;margin-bottom:48px;padding-top:24px;padding-bottom:24px\">\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:2%\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:96%\">\n<h2 class=\"wp-block-heading\">Remembering Kim Parsell</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:40%\">\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"400\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=400%2C400&#038;ssl=1\" alt=\"\" class=\"wp-image-18956\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?w=400&amp;ssl=1 400w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=150%2C150&amp;ssl=1 150w\" sizes=\"auto, (max-width: 400px) 100vw, 400px\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:60%\">\n<p>Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, both online and in person. Each year at WordCamp US, the WordPress Foundation celebrates Kim’s legacy by supporting contributors who share her commitment and enthusiasm. The Kim Parsell Memorial Scholarship aims to make it easier for deserving community members to attend WordCamp US, reflecting Kim’s belief in making WordPress accessible and inclusive for all.</p>\n</div>\n</div>\n\n\n\n<p style=\"padding-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10)\">If you’re unfamiliar with Kim’s story or her invaluable role in the community, we encourage you to <a href=\"https://us.wordcamp.org/2019/memories-of-kim-parsell/\">read these heartfelt tributes</a> collected from friends and colleagues.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:2%\"></div>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Scholarship Eligibility</h2>\n\n\n\n<p>This year, a single scholarship will be awarded. To qualify, applicants must:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Identify as a woman</li>\n\n\n\n<li>Be actively involved as a contributor to WordPress</li>\n\n\n\n<li>Have never attended WordCamp US before</li>\n\n\n\n<li>Demonstrate a need for financial support to attend the event</li>\n</ul>\n\n\n\n<p>If you meet these qualifications, we invite you to apply before the July 25 deadline. All applicants will be notified of the decision by August 7, 2025.</p>\n\n\n\n<p>For additional information, visit the <a href=\"https://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/\">Kim Parsell Memorial Scholarship page</a> hosted by the WordPress Foundation.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><strong>Ready to Apply?</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://wordcampcentral.survey.fm/wcus-2025-kim-parsell-scholarship-application\">Submit Your Application Today</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"333\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=500%2C333&#038;ssl=1\" alt=\"\" class=\"wp-image-18917\" style=\"border-width:25px;border-radius:40px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?w=500&amp;ssl=1 500w, https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=300%2C200&amp;ssl=1 300w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Join the Celebration</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Tickets for WordCamp US 2025 are now available—secure yours soon!</li>\n\n\n\n<li>Volunteer applications are open until July 11, 2025</li>\n\n\n\n<li>Interested in supporting the event? Explore our <a>sponsorship opportunities</a></li>\n</ul>\n\n\n\n<p>Help us spread the word about this opportunity and make WordCamp US 2025 even more special.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18911\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Introducing WordPress Credits: A New Contribution Internship Program for University Students\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Jul 2025 16:56:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"WordPress Credits\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18913\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Isotta Peira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4712:\"\n<p>The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in open source projects. This new program is designed to bridge that gap, nurturing future contributors and ensuring WordPress remains innovative, inclusive, and sustainable for years to come.</p>\n\n\n\n<p>The <a href=\"https://gamma.app/docs/EN-WordPress-Credits-vz0k2vr1ulg91qq?mode=doc\">pilot program</a>, developed in partnership with the University of Pisa, was announced on stage at WordCamp Europe 2025 by Matt Mullenweg and Mary Hubbard. Since then, it has attracted interest from students across various fields of study, including humanities, computer science, and communication. Companies in the WordPress ecosystem have also expressed support and interest in contributing to the project. In response to the growing interest from both community members and academic institutions, we are now inviting more universities to join the initiative.</p>\n\n\n\n<p>Open to students from all fields of study, the program blends structured onboarding with a personalized contribution project. Activities are adapted to each student’s degree program and familiarity with WordPress, aiming to develop transferable skills, academic-related competencies, and active participation in the WordPress community. Internship durations may vary depending on the university or educational institution. Some may align with academic semesters (typically 3–4 months), while others, like the University of Pisa, allow students to sign up year-round with a requirement to complete a set number of contribution hours (e.g. 150 hours). Flexible arrangements can be discussed to meet the specific requirements of each institution.</p>\n\n\n\n<p>Foundational Training includes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>An introduction to open source principles and the WordPress Foundation</li>\n\n\n\n<li>Getting familiar with community tools (Slack, Make blogs, Learn platform, GitHub)</li>\n\n\n\n<li>Setting up a personal WordPress site and publishing content</li>\n</ul>\n\n\n\n<p>Each student will choose a contribution area and design their own personal project within that area. Examples of possible projects include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Translating interfaces or documentation</li>\n\n\n\n<li>Creating multilingual subtitles for educational videos</li>\n\n\n\n<li>Contributing code or performing testing</li>\n\n\n\n<li>Supporting product development or design</li>\n\n\n\n<li>Writing or editing content</li>\n\n\n\n<li>Assisting with community event organization</li>\n\n\n\n<li>Developing training materials for Learn WordPress</li>\n\n\n\n<li>Creating open source tools</li>\n\n\n\n<li>And much more…<br></li>\n</ul>\n\n\n\n<p>Interns are guided by an experienced mentor specific to their chosen area and supported by a dedicated WordPress Foundation contact person throughout the program. All student contributions, whether code, translations, documentation, or educational materials, will be publicly visible and integrated into official WordPress projects and resources, directly benefiting the wider community.</p>\n\n\n\n<p><strong>Interested universities and educational institutions</strong> interested in participating can reach out by filling <a href=\"https://airtable.com/appIzQKfwTn5dyPVp/shrYvY0CDNIkILIre\">the interest form</a>.</p>\n\n\n\n<p>We also invite companies in the WordPress ecosystem to support this initiative by sponsoring mentors who will guide and empower the next generation of contributors, or by providing tools and resources that help students succeed in their contribution journey.&nbsp;</p>\n\n\n\n<p><strong>If your company is interested in getting involved</strong>, please visit the <a href=\"https://make.wordpress.org/handbook/wordpress-credits-contribution-internship-program/get-involved-company-guide/\">Company Guide</a> to learn more and <a href=\"https://airtable.com/appIzQKfwTn5dyPVp/shrKDkjeUdw8Fof34\">fill out the form</a> to join the program.</p>\n\n\n\n<p><em>By welcoming students, mentors, sponsors, and volunteers into this initiative, we are building a stronger and more connected WordPress community. Each person who takes part, whether they guide a student, share their experiences, provide sponsorship, or simply help spread the word, helps ensure that open source remains vibrant and accessible for all. Together, we are not just supporting individual contributors; we are shaping the future of WordPress and open source itself.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18913\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordCamp US 2025: See You in Portland, Oregon!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wordpress.org/news/2025/06/wordcamp-us-2025-see-you-in-portland-oregon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Jun 2025 18:14:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCUS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18884\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"WordCamp US 2025 is heading to vibrant Portland, Oregon, from August 26–29, 2025! Join fellow open source enthusiasts, developers, designers, and WordPress professionals from across the United States and around the world for four days of learning, networking, and collaboration at the Oregon Convention Center. Nestled in the Pacific Northwest, Portland is famous for its [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8274:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18885\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>WordCamp US 2025 is heading to vibrant Portland, Oregon, from August 26–29, 2025! Join fellow open source enthusiasts, developers, designers, and WordPress professionals from across the United States and around the world for four days of learning, networking, and collaboration at the Oregon Convention Center.</p>\n\n\n\n<p>Nestled in the Pacific Northwest, Portland is famous for its creative spirit, lush green spaces, and riverside trails, making it an inspiring backdrop for this year’s WordCamp. Whether building your first site or leading a digital agency, WordCamp US offers something for everyone, all set against the city’s stunning natural scenery.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://us.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What to Expect</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Contributor Day: August 26</h3>\n\n\n\n<p>Kick off your WordCamp US experience by giving back. Contributor Day welcomes all skill levels to collaborate on teams that help make WordPress better, from code to community to documentation. You can make a difference to the project, and build new friendships or rekindle old ones, perhaps even while enjoying views of Portland’s skyline and tree-lined streets.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Main Conference: August 27–29</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Showcase Day &#8211; August 27</h4>\n\n\n\n<p>As part of the main conference, day one will give us a look at project showcases, discover innovative uses of WordPress, see how people push the platform’s boundaries, and get inspired to try something new.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Session Days + Expo Hall &#8211; August 28-29</h4>\n\n\n\n<p>Experience another two days filled with inspiring keynotes, practical sessions, and deep dives into the latest trends in web development, design, content, accessibility, and more. Hear from some of the brightest minds in the WordPress ecosystem and explore topics that get to the heart of what makes WordPress unique. Also, take some time to explore the main floors of WCUS, like the Sponsors Hall.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Networking and Community</h3>\n\n\n\n<p>Meet WordPress friends new and old, exchange ideas with community leaders, and collaborate with people who share your passion for open source. Enjoy daily lunches and a memorable social event, all included with your ticket. Stroll along the Willamette River or explore nearby parks in between sessions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Venue &amp; Accommodations</h3>\n\n\n\n<p>This year, we’re gathering at the Oregon Convention Center in the heart of Portland—a city known for its vibrant neighborhoods and abundant green spaces. We’ve secured a special hotel block right across the street at the Hyatt Regency Portland for convenient, comfortable lodging during your stay.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f3e2.png\" alt=\"🏢\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></strong> <strong>Oregon Convention Center<br></strong>777 NE Martin Luther King Jr Blvd<br>Portland, OR 97232<br></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Hyatt Regency Portland</strong><br>375 NE Holladay Street<br>Portland, OR 97232<br><a href=\"https://www.hyatt.com/en-US/group-booking/PDXRP/G-CAMP\">Book your room!</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Registration and Tickets</h2>\n\n\n\n<p>Registration officially kicked off last month. Secure your spot early; tickets are selling quickly.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://us.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Ready to Plan Your WordCamp US Experience?</h2>\n\n\n\n<p>Keep checking the <a href=\"https://us.wordcamp.org/2025/\">WordCamp US site</a> for travel tips, to book accommodations, and to watch for the whole event schedule—coming soon! While here, why not plan to take in some of Portland’s scenic hiking trails, bike-friendly streets, or local food scene?</p>\n\n\n\n<p>Stay tuned for updates and announcements on <a href=\"https://make.wordpress.org/marketing/handbook/social-media/\">WordPress social media channels</a>, and join the conversation.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help Us Spread the Word!</h3>\n\n\n\n<p>Whether attending in person or following along online, share your experience and help welcome others to the WordPress community. Use the #WCUS and #WordPress hashtags and tell your story on social!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18898\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Portland is calling—see you at WordCamp US 2025! <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f332.png\" alt=\"🌲\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"Dropping security updates for WordPress versions 4.1 through 4.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2025 15:26:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18872\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"As of July 2025, the WordPress Security Team will no longer provide security updates for WordPress versions 4.1 through 4.6. These versions were first released nine or more years ago and over 99% of WordPress installations run a more recent version. The chances this will affect your site, or sites, is very small. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3132:\"\n<p>As of July 2025, the WordPress Security Team will no longer provide security updates for WordPress versions 4.1 through 4.6.</p>\n\n\n\n<p>These versions were first released nine or more years ago and over 99% of WordPress installations run a more recent version. The chances this will affect your site, or sites, is very small.</p>\n\n\n\n<p>If you are unsure if you are running an up-to-date version of WordPress, please log in to your site’s dashboard. Out of date versions will display a notice that looks like this:</p>\n\n\n\n<figure class=\"wp-block-image size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1048\" height=\"122\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=1048%2C122&#038;ssl=1\" alt=\"Dashboard notice: &quot;WordPress 6.8.1 is available! Please update now.&quot;\" class=\"has-border-color has-luminous-vivid-amber-border-color wp-image-18873\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?w=1048&amp;ssl=1 1048w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=300%2C35&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=1024%2C119&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=768%2C89&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>The version you are running is displayed in the bottom of the “At a Glance” section of the dashboard.</p>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"281\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1024%2C281&#038;ssl=1\" alt=\"At a glance widget showing a site running WordPress 4.1.41\" class=\"has-border-color has-cyan-bluish-gray-border-color wp-image-18875\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1024%2C281&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=300%2C82&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=768%2C211&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1536%2C421&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?w=1798&amp;ssl=1 1798w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>As a reminder, the only <em>actively</em> supported version of WordPress is the most recent one. Security updates are only backported to older branches as a courtesy.</p>\n\n\n\n<p>The Make WordPress Security blog has further details about <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\" data-type=\"link\" data-id=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">the process to end support</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18872\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WCEU 2025: A Community Celebration in the Swiss Sun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wordpress.org/news/2025/06/wceu-2025-a-community-celebration-in-the-swiss-sun/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jun 2025 19:19:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCEU\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18776\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:362:\"Over 1,723 attendees from 84 countries gathered at the Messe and Congress Center Basel in Switzerland, and 20,353 more joined online for WordCamp Europe 2025. I’m personally very excited&#8230; There’s so much I want to do. I think there’s a clear pathway to 7.0 and beyond. Matt Mullenweg, WordPress Cofounder The flagship WordPress event kicked [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:61400:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18837\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\"><em>Photo by Nilo Velez</em></figcaption></figure>\n\n\n\n<p>Over 1,723 attendees from 84 countries gathered at the Messe and Congress Center Basel in Switzerland, and 20,353 more joined online for WordCamp Europe 2025.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>I’m personally very excited&#8230; There’s so much I want to do. I think there’s a clear pathway to 7.0 and beyond.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The flagship WordPress event kicked off in Basel, Switzerland, with a dedicated Contributor Day. It was followed by two days of engaging talks, panels, hands-on workshops, and vibrant community connections. WordPress Cofounder Matt Mullenweg and Executive Director Mary Hubbard joined a diverse lineup of speakers and panelists, sharing insights in the heart of one of Europe’s most charming cities.</p>\n\n\n\n<p>Set against the backdrop of Basel’s historic streets and Rhine-side views, the sponsor hall buzzed with activity as companies from across the WordPress ecosystem showcased their latest innovations, offered live demos, and connected with attendees. Each day, participants refueled with a range of local and international cuisine — from Swiss specialties to global favorites — making mealtime a lively space for networking, collaboration, and sparking new ideas.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Basel</h2>\n\n\n\n<p>WordCamp Europe has long been one of the most anticipated WordPress events of the year — a space where community, creativity, and collaboration thrive. This year in Basel, the conference delivered an exciting and diverse program that reached every corner of the WordPress ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> &#8211; Across two full days, the conference featured informative talks, captivating keynotes, and dynamic discussions exploring WordPress and the broader web.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> &#8211; The stage welcomed 52 speakers from 23 countries across five continents, each bringing unique insights and global perspectives.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> &#8211; The schedule included 45 sessions and four hands-on workshops across three tracks, covering:\n<ul class=\"wp-block-list\">\n<li>Accessibility and key policy updates like the European Accessibility Act and the Cyber Resilience Act</li>\n\n\n\n<li>The evolving role of Artificial Intelligence in the open web</li>\n\n\n\n<li>Cutting-edge web design, development best practices, SEO, and content strategy</li>\n\n\n\n<li>Real-world case studies and showcases from across the community</li>\n</ul>\n</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> &#8211; Interactive workshops allowed attendees to roll up their sleeves and develop practical skills in a collaborative setting.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> &#8211; Whether developer, designer, content creator, or entrepreneur, every attendee found space to connect, learn, and grow within a vibrant and welcoming community.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day</h2>\n\n\n\n<p>WordCamp Europe began with a vibrant Contributor Day that brought together 640 contributors—including many first-timers—to collaborate, share knowledge, and support the WordPress project. Guided by 33 dedicated table leads, with 21 teams, attendees of all experience levels came together to exchange ideas, solve real challenges, and make meaningful contributions to open source. From accessibility improvements to theme development and translation efforts, every table played a part in moving WordPress forward.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-3 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb980ba1&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb980ba1\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18798\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18798\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb980ea9&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb980ea9\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18799\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18799\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb98116c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb98116c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18800\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18800\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb981429&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb981429\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18801\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18801\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Roan de Vries</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb9816dc&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb9816dc\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18802\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18802\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb981981&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb981981\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18803\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18803\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb981c0e&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb981c0e\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18804\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18804\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb981ec2&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb981ec2\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18805\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18805\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Levente András Tóth</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb98218a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb98218a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18806\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18806\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb982438&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb982438\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18807\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18807\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Levente András Tóth</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb9826c8&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb9826c8\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18808\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18808\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Sebastián Echeverri Jaramillo</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb98298d&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb98298d\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18809\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18809\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb982c31&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb982c31\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18810\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18810\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n</figure>\n\n\n\n<p>Contributor Day at WordCamp Europe 2025 brought together a mix of first-time and returning contributors across a wide range of teams, from Core and Accessibility to Polyglots, Training, and Community. Attendees tackled everything from onboarding and ticket triage to translating strings, improving documentation, and enhancing tools and workflows. Development-focused teams explored performance and testing improvements and worked through live coding exercises. Meanwhile, accessibility testers, support volunteers, and photo moderators contributed to efforts that directly impact users around the world.</p>\n\n\n\n<p>In parallel, teams like Marketing, Meta, Hosting, and Sustainability focused on future-facing initiatives—from promoting WordPress through the Showcase and social media campaigns to refining infrastructure, increasing accessibility, and preparing for long-term project growth. Whether contributing to plugins, themes, documentation, or new contributor experiences, participants reinforced the values that power the WordPress project: collaboration, inclusivity, and openness. The day served as a reminder that WordPress is not just software—it’s a community built by and for everyone.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Tomorrow Starts with WordPress</h2>\n\n\n\n<p>The first full day of WordCamp Europe 2025 brought the community together to celebrate the power of open source collaboration and innovation. Opening remarks from both global and local event leads reflected on the journey of WordCamp Europe—from its beginnings in 2013 in Leiden, Netherlands, to the vibrant event in Basel today. This full-circle moment underscored the growth of the WordPress community, united by a shared commitment to an open web.</p>\n\n\n\n<p>The day launched into an inspiring program with the keynote session, <em>WordPress Without Borders – The Fight for Digital Freedom</em>, delivered by Noel Tock. Drawing from his experiences—including time on the frontlines in Ukraine—Tock illustrated how open source supports global resilience and serves as a digital human right. His message called on contributors to see their work as part of something greater, offering a compelling and forward-looking vision to energize and unify the WordPress community.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordPress without Borders — The Fight for Digital Freedom | Noel Tock\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/tb_A-ABehnY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, the program unfolded across multiple tracks—each one sparking new conversations and insights. One standout session highlighted social entrepreneurship in Bulgaria, where WordPress is helping grassroots organizations drive change in education, journalism, and social justice. Petya Raykovska shared how nonprofits like Teenovator and the Bulgarian Fund for Women are using WordPress to amplify their work and strengthen their communities.</p>\n\n\n\n<p>Designers and developers explored ways to improve workflows and collaboration. In <em>Bridging Design and Development</em>, attendees learned how Figma Design Systems can connect design and development through shared structures mapped to block themes. Real-world examples, like the Novus Media Newspaper Design System, demonstrated how scalable, consistent design can power multi-brand platforms.</p>\n\n\n\n<p>Workshops played a key role throughout the day, including the interactive <em>Block Developer Cookbook: WCEU 2025 Edition</em>, where attendees worked through community-voted code recipes featuring the latest WordPress APIs. Sessions also dove into emerging technologies, such as <em>Automating WordPress Setup with Modern AI Tools</em>, which showcased how WP-CLI, scripting, and AI can accelerate project setup and reduce repetitive tasks.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18817\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\"><em>Photo by Marc Wieland</em></figcaption></figure>\n\n\n\n<p>Day Two of WordCamp Europe 2025 opened with a focus on the evolving role of the WordPress community in a rapidly changing digital world. Sessions explored how contributors—from local meetup organizers to global advocates—play a vital part in shaping WordPress’s future. Talks on inclusivity, such as <em>Over the Rainbow</em>, encouraged attendees to consider how individual actions can help build a more welcoming, representative open source ecosystem. Throughout the morning, the spirit of collaboration and shared purpose remained front and center.</p>\n\n\n\n<p>As the day progressed, attention turned to the tools and technologies pushing WordPress forward. From sessions on scaling multilingual sites and managing observability to hands-on workshops, developers explored new ways to streamline workflows and enhance performance. Highlights included <em>WordPress Gems for Devs</em>, which introduced the Interactivity API through live coding, and <em>Client-side Web AI Agents</em>, a look at cutting-edge browser-based AI that unlocks new possibilities for web experiences. These talks reflected the platform’s growing capacity to adapt to emerging trends while staying true to its open foundations.</p>\n\n\n\n<p>The afternoon brought a blend of practical guidance and inspiring stories across tracks. A case study on accessibility from Switzerland showed how thoughtful design can benefit all users, while a session on brand-building for women entrepreneurs highlighted the creative and economic opportunities WordPress enables. With topics spanning content strategy, business growth, regulatory readiness, and more, the second day of WCEU 2025 affirmed the strength of the WordPress ecosystem—not only as a technology platform, but as a global movement fueled by people, purpose, and possibility.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Fireside Chat</h2>\n\n\n\n<p>As the final day drew to a close, Matt and Mary shared some thoughts on EU regulation (Open Web Alliance), AI, and the introduction of the WordPress AI team, and then answered questions from the audience.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"Fireside chat with Q&amp;A | Mary Hubbard and Matt Mullenweg\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/mzJwYejWUbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>A heartfelt thank you to the dedicated organizers who brought WordCamp Europe 2025 to life in Basel, the speakers who shared their insights, the attendees who joined us in person, and those who followed along from afar. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-4 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb9833af&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb9833af\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18827\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18827\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb983671&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb983671\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18825\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18825\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Chris Clarke</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb983a2f&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb983a2f\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18824\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18824\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb983d66&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb983d66\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18823\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18823\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb98407f&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb98407f\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"684\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18822\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1024%2C684&#038;ssl=1\" alt=\"\" class=\"wp-image-18822\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1024%2C684&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=768%2C513&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Maksym Kaharlytskyi</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb9843e6&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb9843e6\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"799\" height=\"533\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18821\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=799%2C533&#038;ssl=1\" alt=\"\" class=\"wp-image-18821\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?w=799&amp;ssl=1 799w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=768%2C512&amp;ssl=1 768w\" sizes=\"auto, (max-width: 799px) 100vw, 799px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Chris Clarke</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb98477e&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb98477e\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18820\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18820\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Atsushi Ando</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb984a5a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb984a5a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18819\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18819\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb984d19&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb984d19\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18829\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18829\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f4eeb984fad&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f4eeb984fad\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"682\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18859\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1024%2C682&#038;ssl=1\" alt=\"\" class=\"wp-image-18859\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1024%2C682&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1536%2C1023&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the final major WordPress events in 2025: <a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a> (Portland, Oregon, USA). Then join us in <a href=\"https://europe.wordcamp.org/2026/\">Kraków, Poland for WordCamp Europe 2026</a>! Also, if you want to get involved with WCEU, the call for organisers is already open for 2026. </p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18776\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 19 Oct 2025 14:00:47 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 30 Sep 2025 20:04:41 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1760925648;s:23:\"__cache_expiration_time\";i:1760925648;}", "off");
INSERT INTO `wp_options` VALUES("39929", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1760925648", "off");
INSERT INTO `wp_options` VALUES("39930", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1760882448", "off");
INSERT INTO `wp_options` VALUES("39931", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("39932", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1760925649", "off");
INSERT INTO `wp_options` VALUES("39933", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Matt: Albumin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150261\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/10/albumin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1026:\"<p>Since reading the <a href=\"https://fourhourworkweek.com/\">Four Hour Workweek</a> and <a href=\"https://tim.blog/\">Tim Ferriss</a> I&#8217;ve been a bit of a bio-hacker, always trying weird and new stuff. Today was a new one! I did therapeutic plasma exchange (TPE), also known as plasmapheresis, which supposedly gives you all the <a href=\"https://en.wikipedia.org/wiki/Young_blood_transfusion\">benefits of parabiosis</a> without, you know, needing to be a vampire or <a href=\"https://www.youtube.com/watch?v=hBA0AH-LSbo\">having a blood boy</a>. So with the awesome folks at <a href=\"https://extension.health/\">Extension Health</a> I had my blood filtered and put back in, which took a few hours. My plasma <a href=\"https://x.com/bryan_johnson/status/1845950287032492378\">was not as clear as Bryan Johnson&#8217;s</a>, with 41 years of microplastics and mold and who knows what else in there. The process took a few hours, and afterward I got some chicken on rice from a Halal cart on Broadway so maybe it all evens out.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Oct 2025 00:42:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Gutenberg Times: Abilities API, Block Accessibility Check, Gutenberg Framework, AI creating Blocks and themes—Weekend Edition 345\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42268\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20610:\"<p>Hi there, </p>\n\n\n\n<p>A release party is coming up on <strong>Tuesday, October 21, at 15:00 UTC for WordPress 6.9 Beta 1.</strong> It&#8217;s the first time for this release squad. Good luck! </p>\n\n\n\n<p>Will you start testing WordPress 6.9 next week?  You can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester plugin</a> by <strong>Andy Fragen</strong> and install it on your test site. I am using <a href=\"https://developer.wordpress.com/studio/\">WordPress Studio</a> on my computer for systematic testing and prep work for the <em>Source of Truth</em> post to come out in a few weeks.</p>\n\n\n\n<p>The WordPress Test team already published a few pre-beta calls for testing, you can work through, and they are preparing a comprehensive post for all of WordPress 6.9 testing for next week. </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>Help test changes to template management</strong></a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\"><strong>Call for Testing: Ability to Hide Blocks</strong></a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\"><strong>Call for Testing: Accordion Block</strong></a> </li>\n</ul>\n\n\n\n<p>WordPress 6.9 is a big focus of my work now. As always, I&#8217;ll keep you updated. </p>\n\n\n\n<p>Have a fantastic weekend! </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n<p>PS:  On Monday, October 20th, I will be on the 353rd episode of <a href=\"https://wpbuilds.com/news-archive/\"><strong>This week in WordPress</strong></a> show together with Michelle Frechette, Tim Nash, and the brilliant host Nathan Wrigley. <a href=\"https://wpbuilds.com/live/\">You can join us live! </a><img alt=\"📺\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f4fa.png\" style=\"height: 1em;\" /></p>\n\n\n\n<p>PPS: This week, I celebrated the <a href=\"https://icodeforapurpose.com/five-year-anniversary-of-the-gutenberg-nightly/\">five-year anniversary of Gutenberg Nightly. </a><img alt=\"🎉\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f389.png\" style=\"height: 1em;\" /> </p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n</section>\n\n\n<div class=\"wp-block-spacer\" style=\"height: 21px;\"></div>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owner</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Yesterday, <strong>Matt Mullenweg</strong> talked briefly at <strong>WordCamp Canada</strong>, gave a demo, and then answered questions from the  the audience. The wizards behind the scenes already posted the recording of the session to YouTube. <a href=\"https://www.youtube.com/watch?v=RL-XccK30sY\"><strong>WordCamp Canada 2025—Ma.tt Mullenweg &#8220;Town Hall/AMA&#8221;</strong></a>. If you rather read about the talk on Mullenweg&#8217;s blog, <a href=\"https://ma.tt/2025/10/wordcamp-canada/\">WordCamp Canada Talk</a>. He also added the Q &amp; A transcript as well. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\">Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9</a> with Beth Soderberg of <a href=\"https://bethink.studio/\">Bethink Studio</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 122 with Beth Soderberg\" class=\"wp-image-42236\" height=\"193\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-11-at-12.32.48.png?resize=652%2C193&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owner</h2>\n\n\n\n<p>In his video <a href=\"https://www.youtube.com/watch?v=iCtjWwWi5sQ\"><strong>AI Builds WordPress Blocks</strong></a> , <strong>Jamie Marsland</strong> introduced <em><a href=\"https://telex.automattic.ai/\">Automattic Telex</a></em> and showed off about ten blocks he and other people built with it, like animated text, a countdown counter, and mermaid diagram and more. Check it out; it&#8217;s not only amazing, it borders on voodoo or magic. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tammie Lister</strong> continues her October Challenge on the <strong>Blocktober.fun</strong> site. The latest blocks are <a href=\"https://blocktober.fun/flip-card/\">Flip Card</a>, <a href=\"https://blocktober.fun/emoji-voting/\">Emoji Voting</a>, <a href=\"https://blocktober.fun/highlighter/\">Highlighter</a>, <a href=\"https://blocktober.fun/story-generator/\">Story Generator,</a>  <a href=\"https://blocktober.fun/watermark/\">Watermark</a> and <a href=\"https://blocktober.fun/make-the-logo-bigger/\">Make the logo bigger</a>. You not only can try them all out on Telex and remix them with your own ideas. Lister also shares here elaborate prompts you can study and learn how to skill up your AI work. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-42310\" height=\"460\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-18-at-14.04.11.png?resize=652%2C460&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Troy Chaplin</strong> released <strong><a href=\"https://wordpress.org/plugins/block-accessibility-checks/\">Block Accessibility Check v2.2</a></strong>! It introduces Heading structure validation,  alt-text pattern detection and provides an upgraded URL checks with real TLD validation + dev environment support&#8221;Along with the new release comes a <a href=\"https://blockaccessibilitychecks.com/\">new dedicated website</a> featuring improved docs, feature overviews, and developer API guide&#8221;. Chaplin wrote. The site is focused to assist content creators and developers alike. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Anne Katzeff</strong> shared how she created <a href=\"https://www.askdesign.biz/blog/2025/10/overlapping-columns-with-the-media-text-block/#google_vignette\"><strong>overlapping Columns with the Media &amp; Text Block</strong></a> and little Additional CSS. The step-by-step instructions show you how you can build some dynamic layouts with the core block features. </p>\n\n\n\n<figure class=\"wp-block-image\"><img alt=\"\" src=\"blob:https://gutenbergtimes.com/44a2bf47-9c14-481b-bbe1-29e1c6fe25d0\" /></figure>\n\n\n\n<p><strong>Katzeff</strong> also posted a video of her process on YouTube. <a href=\"https://www.youtube.com/watch?v=kNwkwlwKB4I\"><strong>Overlapping Columns With the Media &amp; Text Block</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Michael Manuel</strong>, WordPress VIP, posted a four-part series of short video: <a href=\"https://wpvip.com/blog/behind-the-build-modernize-publishing/\"><strong>Behind the Build: How Christianity Today Modernized its Publishing Experience</strong></a> and how the team of <em>WebDevStudios</em> helped transform editorial workflows, infrastructure, and content operations for one of America’s most trusted media brands.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Part 1: <strong>Editorial empowerment &amp; workflow efficiency</strong></li>\n\n\n\n<li>Part 2: <strong>Performance &amp; platform modernization</strong></li>\n\n\n\n<li>Part 3: <strong>Homepage &amp; design system overhaul</strong></li>\n\n\n\n<li>Part 4: <strong>Content migration &amp; CMS modernization</strong></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Brad Salomons</strong>, 8r4d Consulting, Ltd, created the <a href=\"https://wordpress.org/plugins/panoramic-slider-block/\"><strong>Panoramic Slider Block</strong></a> to scratch an itch. With this block you can post your Pano photos from your phone camera as it provides horizontal sliding controls.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Brad Salomons - screenshot of the Panoramic Slider Block in the editor. \" class=\"wp-image-42308\" height=\"312\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/screenshot-1-1.png?resize=652%2C312&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>On the WordPress Developer Blog, <strong>Nick Diego </strong>published a Snippet on <a href=\"https://developer.wordpress.org/news/snippets/how-to-add-custom-blocks-to-navigation-menus/\"><strong>How to add custom blocks to navigation menus</strong></a>. It shows how to use  the <code>blocks.registerBlockType</code> filter to extend the navigation block’s <code>allowedBlocks</code> array.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Elliott Richmond</strong> demonstrated <a href=\"https://www.youtube.com/watch?v=6sgJNNm5EOU\"><strong>how to create a block theme using Claude Code</strong></a> on YouTube. He built a theme from scratch with Claude Code, providing clear structure and Markdown tips for the AI tool. You&#8217;ll discover how to set up a CLAUDE.md file for AI-assisted theme development and how Claude works with the WordPress Block Theme structure.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The earlier years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><br /><strong><a href=\"https://x.com/muhsinlk\">Muhammad Muhsin</a> </strong>senior engineer at Fueled gave a talk on <a href=\"https://wordsesh.com/speakers/muhammad-muhsin\">Building a Web App with the Gutenberg Framework at WordSesh</a> earlier this year. <a href=\"https://wordpress.org/gutenberg-framework/\">What is Gutenberg as a Framework?</a> It&#8217;s a way to use the block editor in a JavaScript application outside of WordPress. Muhsin &#8220;built CareerVision.io using Gutenberg outside WordPress—a standalone React framework for block-based apps&#8221;. You can watch the <a href=\"https://www.youtube.com/watch?v=0JXbtZWA3zI\">presentation on YouTube</a> now.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> was the <a href=\"https://www.youtube.com/watch?v=T7kLXWvywww\"><strong>Pro WordPress Developer Watches AI Build a Custom Block… and is Blown Away!</strong></a> He put <a href=\"https://telex.automattic.ai/\">Automattic&#8217;s Telex</a> to the test,  to build a live audio visualizer block inspired by the classic iTunes music visualizer. The AI writes the React code, handles audio input, and even makes the block respond to live microphone sound, all in about 15 minutes. It’s an impressive look at how Telex could reshape the way developers build custom blocks for WordPress. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>JuanMa Garrido</strong>, developer advocate at Automattic,  livestreamed his ongoing discovery of the <a href=\"https://www.youtube.com/watch?v=m19VM2yIbHU\"><strong>Abilities API</strong></a>.  He explored how to register custom abilities, expose them to AI models, and understand how this fits into WordPress’ broader AI architecture alongside the MCP Adapter and PHP AI API. The recording is now available on YouTube.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Photo by MRFE MRFE on <a href=\"https://www.pexels.com/photo/vibrant-geometric-abstract-3d-blocks-design-34268918/\">Pexels.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 22:14:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: WordCamp Canada Talk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150251\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/10/wordcamp-canada/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46239:\"<p>Howdy and bonjour! First, thank you so much, merci beaucoup, for having me at your WordCamp. I love the spirit of local communities gathering and helping each other learn and grow together. I wasn&#8217;t actually planning to speak or even do a Q &amp; A; I was just going to attend this WordCamp. But since the organizers have given me a bit of your time, I will try to make the best of it. </p>\n\n\n\n<p>I love Canada. I first came here for <a href=\"https://en.wikipedia.org/wiki/Northern_Voice\">the Northern Voice conference</a> in 2006. Was anyone at that one? I think Dave Winer was actually there. It was a pretty awesome one. What&#8217;s that?</p>\n\n\n\n<p>[Here I think Dave said he wasn’t at that one, but a different conference, but can’t remember.]</p>\n\n\n\n<p>Well, that&#8217;s why we blog. My memory is not that good. [laughs] By the way, I think this week is your anniversary, right? </p>\n\n\n\n<p><strong>Dave Winer:</strong> It was actually a couple of weeks ago—31 years.</p>\n\n\n\n<p><strong>MM: </strong>Oh, wow. Thirty-one years. Round of applause! I think why I thought it was your anniversary is that on my blog’s related posts, it showed a post from 2014 that was congratulating you on your 20th because I think <em>The Register</em> or someone did a nice article. </p>\n\n\n\n<p>So yeah, I&#8217;ve since been back dozens of times, including several summers in Montreal, at the jazz festival there—they also do <a href=\"https://haitienfolie.com/\">Le Festival Haïti en Folie</a>, and <a href=\"https://montreal.hahaha.com/home/\">Just For Laughs</a>—and a few times here in Ottawa, where I&#8217;m on the board of a cybersecurity company called Field Effect. We might even have some Field Effect people here—oh, hi! Thanks for coming. </p>\n\n\n\n<p>Let me give a little update on what I’ve been up to. My life’s mission is to democratize publishing, commerce, and messaging. So I have some projects in each of those areas. In publishing, my main work is WordPress, the core software available to everyone. We host it on <a href=\"http://wordpress.com\">WordPress.com</a> and <a href=\"https://pressable.com/\">Pressable</a>, and allow others to host it with <a href=\"https://wpcloud.com/\">WP Cloud</a>—a cool product—and we use <a href=\"https://jetpack.com/\">Jetpack</a> to bring all the best cloud features to every WordPress, wherever it is running. And, of course, running the main community hubs at <a href=\"http://wordpress.org\">WordPress.org</a>, <a href=\"http://wordpress.tv\">WordPress.tv</a>, WordCamps, <a href=\"http://wordpress.net\">WordPress.net</a>, which probably some of y&#8217;all haven&#8217;t heard of, et cetera, et cetera. </p>\n\n\n\n<p>On the social side of publishing, I have <a href=\"https://tumblr.com/\">Tumblr</a>, which is a microblogging social network, but right now it&#8217;s on a different technical stack. I need to switch it over to WordPress, but it&#8217;s a big lift. It&#8217;s over 500 million blogs, actually, and as a business, it&#8217;s costing so much more to run than it generates in revenue. We&#8217;ve had to prioritize other projects to make it sustainable. It&#8217;s probably my biggest failure or missed opportunity right now, but we&#8217;re still working on it. </p>\n\n\n\n<p>I&#8217;m really excited about the personal publishing side of our products: <a href=\"https://dayoneapp.com\">Day One</a> and <a href=\"https://developer.wordpress.com/studio/\">WordPress.com Studio</a> and <a href=\"https://wordpress.org/playground/\">WordPress Playground</a>. Day One is a fully encrypted, shared, and synchronized blogging and journaling app that runs on every device and on the web. You can also have shared encrypted journals with others. It uses the same encryption as one password. It&#8217;s the first place I go to draft an idea—for example, to write this talk. Its editor is not as good as Gutenberg yet, but it&#8217;s pretty decent at allowing multimodal input—which means you can record voice notes, draw things, etc.—and capturing it all. It&#8217;s mostly replaced Evernote, Simplenote, and even private P2s for me. It has some fun features, like when you make a new entry it records, the location, what music you&#8217;re listening to on Apple Music, how many steps you&#8217;ve taken, the weather. Honestly, some features that would be nice to get into WordPress, at least as a plugin. Right now, I just copy and paste it in the WC admin or the Jetpack app if I want to publish something; that could also be made smoother in the future. </p>\n\n\n\n<p>So WordPress.com Studio is built on an open source project called Playground that we created to allow you to spin up WordPress in a WASM container in about 30 seconds, right inside your browser. Who’s tried Playground or Studio? It&#8217;s kind of wild, right? You know how hard it&#8217;s been to set up servers and databases and everything like that, and so to see a WordPress virtual machine spin up in like 30 seconds just blows my mind. There&#8217;s so much you can do with it. It&#8217;s the most sci-fi thing happening inside of WordPress right now, and we&#8217;ve just barely begun to take advantage of the massive technical and architectural shift it allows. For example, my colleague <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella</a> builds an iOS app called <a href=\"https://wordpress.org/playground/wordpress-for-native-ios-apps/\">Blocknotes</a>. It’s a lot like Simplenote, but it uses a Gutenberg editor, and it&#8217;s entirely a WordPress playground instance—the entire iOS app. </p>\n\n\n\n<p>Part of the evolution of WordPress has been going from a blogging system to a CMS to a full development platform. So what Dave talked about yesterday, and now that you can build entire mobile apps—which, by the way, can run on every platform, cross-platform, and run the same thing on the web—it&#8217;s kind of like a promise from back in the day of Java or other things, React, Native. It&#8217;s now very possible with this WordPress WASM stuff. WASM stands for <a href=\"https://webassembly.org/\">web assembly</a>. </p>\n\n\n\n<p>The main distractions and things holding back WordPress right now are the legal attacks from WP Engine and Silver Lake—I  can&#8217;t comment on that, but stay tuned for some major updates soon. </p>\n\n\n\n<p>I forgot to put this in my post—WooCommerce! On the commerce side, there&#8217;s, of course, WooCommerce, which is very, very exciting. You can think of it like an open-source Shopify, our enablers here in Ottawa. It now processes over $30 billion of GMV (gross merchant volume) per year, and you can customize it to do pretty much anything: subscriptions, digital, physical goods, everything. And of course, it&#8217;s fully open source and built on WordPress. It&#8217;s actually a WordPress plugin, so pretty exciting. WooCommerce is now on about 8% of all websites in the world—WordPress is 40, so it&#8217;s running on about a quarter of all WordPress sites. It&#8217;s been a big part of the growth of WordPress, actually, the past few years. </p>\n\n\n\n<p>In messaging, we have this product called Beeper. Anyone tried out Beeper yet? We got a Beeper super-user here, actually, in Robert. So Beeper basically takes all the different messaging apps—WhatsApp, Telegram, Instagram DMs, LinkedIn DMs, did you ever check those?—and it brings it all into one app, one interface, kind of like a Superhuman for messaging, and gives you cool features across all of them. Now this is obviously a pretty hard technical challenge, because we have to reverse engineer all the different networks for everything. But check it out, it&#8217;s a pretty fun little app. It&#8217;s, free for up to a couple accounts, and paid after that. </p>\n\n\n\n<p>There&#8217;s also an open source component of that as well. We&#8217;re going to make it easier for people to build bridges and connections to different networks, because there&#8217;s a lot that we don&#8217;t support yet that we get demand for, like <a href=\"https://kakaotalk.en.softonic.com/mac\">KakaoTalk</a> in Asia. People also want to do dating apps, which I guess have messaging platforms. So it’d be pretty fun to have everything all in one. </p>\n\n\n\n<p>I&#8217;ve been in the public a lot, doing lots of talks and actually blogging every single day now for 28 days, which will be 29 when we all hit the publish button at the end of this! So I&#8217;ve been blogging a lot. It&#8217;s a lot to keep up with. Actually been going every day since <a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a>, with one missed day in there. I got very, very inspired at WordCamp US. It was a fantastic event. I got to hang out a lot and go to a bunch of sessions, and it inspired me to blog a lot more. If you run Jetpack, there&#8217;s actually a pretty cool feature where the notifications will tell you what kind of streak you&#8217;re on. So whenever I post, I get this nice little notification, like 28 days. And it has little easter eggs when you get certain number of days in a row, which is fun. So I&#8217;m gonna have to add some of this to the post later—I riffed a little bit. We&#8217;ll get the recording. So now that this is all done, we can push the publish button together. </p>\n\n\n\n<p>This is a cool device called a Daylight computer. So cool. It’s from a startup I&#8217;m invested in through <a href=\"https://audrey.co/\">Audrey Capital</a> and Automattic. Think of it like a cross between a Kindle and an iPad. It works in the daylight, hence the name—it doesn&#8217;t emit any blue light. It&#8217;s great for kids. You can order it on <a href=\"http://daylightcomputer.com\">DaylightComputer.com</a>. It runs Android, so it&#8217;s super hackable. You can have apps like Beeper, Day One, WordPress, Jetpack, WooCommerce on it. Very, very neat device. I actually have WP Admin loaded right here; you can see you can scroll like super, super fast. Soon the wifi is going to work—it&#8217;s a wifi-only device. </p>\n\n\n\n<p>Later I&#8217;ll update this post with an mp3 recording enclosed an RSS in honor of Dave Winer, who spoke here, who invented podcasting and RSS. And actually, if you go way back in my RSS feeds, I have some mp3 enclosures from 2004 and 2005, some very funny early podcasts. Also, whenever they post this video to WordPress TV or YouTube, I&#8217;ll share that too, and I&#8217;ll add some links. Thank you. Merci beaucoup! If you want to follow more. Please check out my blog at <a href=\"https://ma.tt\">ma.tt</a>. No WWW, no .com. Just ma.tt. I cross post to ma.tt on Bluesky and Mastodon and on Tumblr, Instagram and Twitter/X at @photomatt. </p>\n\n\n\n<p>And now we&#8217;re going to push the button together. Y&#8217;all ready? Murphy willing, are you ready to publish? think I need to add a category and stuff, but I&#8217;ll do that later.</p>\n\n\n\n<span id=\"more-150251\"></span>\n\n\n\n<p><strong>Q: </strong>Hi, I’m Michelle Frechette, and I drove up from Rochester, New York on Wednesday, so it&#8217;s good to be here. [Applause] I love that our open source extends beyond just publishing websites and words, and that we have, for now several years, the photo directory, which is available to people—and we are closing in on 30,000 published photos, which I think is phenomenal. </p>\n\n\n\n<p><strong>MM: </strong>And all of those are, I think, <a href=\"https://creativecommons.org/public-domain/cc0/\">CC0</a>, Creative Commons Zero-licensed. So it&#8217;s compatible with GPL, embedded in WordPress themes. You can use it on your site. It&#8217;s very cool.</p>\n\n\n\n<p><strong>Q: </strong>Yeah, you don&#8217;t have to give attribution to anybody. You can just use the photos that are there, which I think is good. What are we going to do so that more people know that it exists, besides the 10,000 people who have submitted photos, because I think it&#8217;s still, it&#8217;s it&#8217;s growing. It&#8217;s huge. There&#8217;s a million beautiful there&#8217;s almost 30,000 beautiful photos in there, but I don&#8217;t think enough people know that it exists yet. So how can we get the word out, to get more people to use it?</p>\n\n\n\n<p><strong>MM: </strong>Well, I think first we should ask questions about it at WordCamps. </p>\n\n\n\n<p><strong>Q: </strong>I&#8217;m on it. </p>\n\n\n\n<p><strong>MM: </strong>So check. We&#8217;re actually just kind of on like a Version One of that whole idea. So in my mind, for things that we should do, is 1: I think we need to better integrate finding those photos in the media library, because right now, it&#8217;s kind of like you have to click a few buttons to get to it. 2: I would like, for every single WP admin when you upload a photo, for you to be able to set the licensing to it. And if it is licensed as CC0, we can submit it to the directory. And of course, the directory has some extra rules, right? Some of these rules, I think we might be able to re-examine now. So for example, right now, in the directory, we don&#8217;t allow anything that shows someone&#8217;s face, right? And the reason for this is, even if something&#8217;s CC0-licensed, to have someone&#8217;s face, you need a model release form. There&#8217;s different laws for that in different countries and things like that make sense, right? You wouldn&#8217;t want someone to take your photo at a WordCamp, and now they think it&#8217;s CC0, and you start seeing them running ads for, you know, some sort of new medicine or Viagra or something; it could be very embarrassing. However, when AI creates a face, there&#8217;s no such restrictions there. So something that we could actually start to do, because right now I think we have some anti-AI rules in the photo directory, I think we should probably start to look at evolving that. So, for example, you can take a picture of me right now, change my face with AI to a face that has never existed, and that could be CC0-licensed and anyone in the world could use it. So I think there&#8217;s some possibilities there. </p>\n\n\n\n<p>Because right now, the laws for AI-generated stuff vary from country to country. I think right now in America, it can&#8217;t be copywritten, at least in the same way. At least if it&#8217;s fully created; when a human starts to modify it, it can be. Sometimes I&#8217;m not familiar with the laws here yet, but I&#8217;m sure I&#8217;ll look them up later. So I think that would be a pretty interesting way to open it up right now, because in theory, we should have way more than 30,000 photos. Actually, I have 30,000 photos on my site, which are mostly GPL-licensed. So how can we—yeah, I do need to submit them. Some of them are already in WordPress Core. So remember <a href=\"https://wordpress.org/themes/twentyten/\">the Twenty Ten theme</a>, which has like the little sheep. People really love those sheep. So all those photos I GPL-licensed a long time ago—in my copious free time, yes. </p>\n\n\n\n<p>So I think those are some of the ideas for it. And also think about another project we do that people aren&#8217;t as familiar with, Openverse search. Has anyone used Openverse yet? It&#8217;s pretty cool. So actually, Creative Commons, the nonprofit, used to have a search engine that indexed the entire web and would allow you to find different types of Creative Commons content, including that requires attribution or other things. The foundation actually was shutting this down, and we took it over, and we now run it on WordPress.org We renamed it to Openverse instead of Creative Commons, but they still index the entire web, including audio files, video files, images, all sorts of stuff. So it&#8217;s a very, very cool project. It is embedded in WP Admin a bit, but again, we probably should combine that with a photo search and other things. </p>\n\n\n\n<p>I also think there&#8217;s some opportunities to use AI analysis of all the photos to give a better semantic understanding and a better search that we currently offer, which right now is typically monollingual, I don&#8217;t think it translates well into the, you know, 60-plus languages that WordPress supports, and it&#8217;s manual tagging. So there might be things to do, like a more automated understanding, which, of course, gets better over time. You know, we started to incorporate some of the AI models like Gemini and other things on WordPress.org to make us way more efficient on things like plug-in submissions and some code scanning. I actually think we&#8217;re very much in chapter one of where this is going to be. It can sort of massively [grow]—because WordPress.org relies on volunteers, basically. Some people are sponsored, but most are not. And we&#8217;re over 60,000 plugins now, or 10,000 themes, and actually, the rate of plugin submission, I think, has basically doubled since last year, and the team has gotten it down where before they had a six-month queue, they&#8217;ve got it down to basically under a week. So you know, we can definitely automate more and more and more and be vastly more efficient and support way more developers and more users, way more everything, and probably improve the code quality. So that&#8217;s another thing I&#8217;m pretty excited about. </p>\n\n\n\n<p><strong>Q: </strong>I love it. <a href=\"http://wordpress.org/photos\">WordPress.org/photos</a>, if you want to look at it. </p>\n\n\n\n<p><strong>MM: </strong>Thank you, Michelle! </p>\n\n\n\n<p><strong>Q: </strong>Hey, Matt. Courtney Robertson. Kind of related to Michelle&#8217;s question: This week, I saw <a href=\"https://iconick.io/\">Nick Hamze</a> recounting how when you go to submit a theme, the image that&#8217;s in the preview for the theme, if it is AI-generated that that&#8217;s getting rejected and the nuances Dion dug into—Dion is one of our long time core commiters, core leads, etc, in the project. A hidden gem. If you haven&#8217;t encountered Dion yet, please find Dion and meet him. So Nick is learning the legal ramifications of having an AI-generated image as part of the theme directory, like what we have to do in the theme directory. Because if the image that&#8217;s in the theme is generated by AI, there&#8217;s a lot of legal stuff about, can we do it? Can we not? And we would all like to just be like, “Yeah, whatever. Move on.” But then there&#8217;s some other ramifications. Is that on your radar? I know we&#8217;ve looked at criteria of what could go into the theme repo and some of those deals.  I don&#8217;t know if. I mean, once we get into legal stuff, that&#8217;s maybe beyond you and I.</p>\n\n\n\n<p><strong>MM: </strong>Well, unfortunately, I&#8217;m getting really good at legal stuff. [Laughter] It wasn&#8217;t on my roadmap for the past year or two, but yeah. So this is very much an evolving area, and the laws from country to country do vary a lot. However, there&#8217;s also some common sense things you can apply, and I think that there is a sort of rapidly—we&#8217;re not putting the genie back in the bottle with AI stuff. One,  just the companies; like, OpenAI is just too big to fail now. The entire economy and growth is based on these systems. The infrastructure buildouts, massive data centers, everything. It&#8217;s kind of incredible. Not to mention the usage, like it&#8217;s really transforming translation, code, so much. </p>\n\n\n\n<p>Now, WordPress.org, particularly, because a lot of this is volunteers, those folks aren&#8217;t comfortable making big policy decisions like this that could have ramifications. They already put a lot on the line. I kind of shield everyone from a legal point of view and everything like that, but in theory, people could go after them, and we have had instances where some of these folks can get oppressed by someone who gets something rejected, or banned from the forums for spamming or stuff like that. So we do try to provide some shelter. </p>\n\n\n\n<p>Now, on this issue, in particular, Nick is someone I talk to almost every day. He&#8217;s doing some very, very cool stuff across WordPress and some innovative things with themes. I like that he pushes the boundaries. So for example, right now, the theme directory is fairly conservative in for example, with the intention that we want the demo to look like the theme when you install it, or we don&#8217;t want it to rely on a plugin. And part of the intention there is that for WordPress, we want you to be able to switch between themes really easily. So one of the beauties of it is that you can take your entire blog site, click a button, and you have a brand new design. Now themes, as they start to incorporate more advanced functionality—which is pretty cool—those sorts of things aren&#8217;t allowed. In fact, one of my favorite examples of something that was in the theme directory a long time ago and is not allowed on the current guidelines, that I think we&#8217;ve made an exception, is the Command Line theme. Has anyone seen this? You load it up, it&#8217;s like a blinking terminal, and you interact with it by typing in commands, like “list,” “post,” and you can type “help,” and it gives you all the things. This is so cool! By the way, I don&#8217;t think it complies with, like, any of our standards. [laughter] Like accessibility, it probably breaks some rules there, all sorts of things. </p>\n\n\n\n<p>So I think part of it is, you know, how can we move? And I think Nick even did a post about this, like rules versus guardrails. So I think part of the way we can do this is as a marketplace. Right now, there&#8217;s certain things that we don&#8217;t allow, and in fact, those rules creep up and get bigger every time, right? Because each sub-team comes in and says, “Oh, I need my rules to be requirements.” Actually, accessibility is a great, great example of that. Now, I think what&#8217;s interesting in a marketplace is we can move these things from being rules to being like tags. So for example, if you were a university, you only want to see themes that were WCAG 2.0 or higher compliant—which are by the way, some pretty strict requirements that don&#8217;t apply to many websites, for good reasons, but that was a requirement. You should be able to do that as a search. Or if you want to see themes that are orange, or all these sorts of things: I feel like those should just be tags in the marketplace, and use the rating system as well to open up what we can host, but then give better tools for people to search and choose what they want. </p>\n\n\n\n<p><strong>Q: </strong>Thanks. Just a shout out. Please let Nick know that a lot of us are reading what he&#8217;s putting forward, and I forget his exact website domain. It&#8217;s <a href=\"https://iconick.io/\">Iconick</a>.</p>\n\n\n\n<p><strong>MM: </strong>It&#8217;s spelled in an interesting way. </p>\n\n\n\n<p><strong>Q: </strong>Yeah, it has his name in it. I wonder where he got that idea. [Laughter]</p>\n\n\n\n<p><strong>MM: </strong>Yeah. So it reads as “iconick.” Nick Hamze, H-A-M-Z-E. Google him. He&#8217;s got some really cool themes. He&#8217;s done a lot of cool projects, <a href=\"https://iconick.io/wapuu-slaps/\">a bunch of Wapuus</a>. Actually, I&#8217;m talking to them about how we can upgrade all the Wapuu stuff. By the way, y&#8217;all have some awesome ones at this event. I got the little swag pack with all the stickers and everything. All the sponsors have different ones. You have like, four or five of them. I&#8217;m actually gonna put this sticker on my laptop later, probably that WCF one, so keep an eye out for that.</p>\n\n\n\n<p><strong>Q: </strong>Paul Bearne. I want to talk about <a href=\"https://wordpress.org/plugins/hello-dolly/\">Hello Dolly</a>, the plugin, which shipped with Core.</p>\n\n\n\n<p><strong>MM: </strong>Which, by the way, people tried to get rid of because of copyright issues. Yeah, there&#8217;s actually some interesting things we did to get around that and make it fair use.</p>\n\n\n\n<p><strong>Q: </strong>Should it be removed?</p>\n\n\n\n<p><strong>MM: </strong>You&#8217;re asking the wrong guy.</p>\n\n\n\n<p><strong>Q: </strong>Well, it’s there because nobody wants to ask you to come and remove it.</p>\n\n\n\n<p><strong>MM: </strong>No, they ask me like once a year. [Laughter]</p>\n\n\n\n<p><strong>Q: </strong>If it stays, perhaps we could redo the description to indicate that it&#8217;s historic—it was the first plugin, it was the proof of concept—but please don&#8217;t copy it. It&#8217;s no longer good code.</p>\n\n\n\n<p><strong>MM: </strong>I completely disagree with that. Tell me why it&#8217;s not good code. Because it doesn&#8217;t use classes or object orientation? Why is it bad code?</p>\n\n\n\n<p><strong>Q:</strong> It’s not accessible, it’s not translatable. </p>\n\n\n\n<p><strong>MM: </strong>It is translatable. It actually goes through the translation functions.</p>\n\n\n\n<p><strong>Q:</strong> There’s no translation around the strings. </p>\n\n\n\n<p><strong>MM: </strong>That&#8217;s not true. </p>\n\n\n\n<p><strong>Q: ’</strong>Tis true. [Laughter]</p>\n\n\n\n<p><strong>MM: </strong>Then it was removed because it was one of the first things we did the underscore for. Well, let&#8217;s look it up later today, but it&#8217;s not true that no one&#8217;s ever asked me. It does get asked about once a year. There&#8217;s lots of issues on the bug tracker about it. And if there&#8217;s ways to improve it, like make it translatable, I think that&#8217;s great, and I know people have actually used that before to also just change the lyrics to, like, put different songs in there, different things they want to</p>\n\n\n\n<p>say. </p>\n\n\n\n<p><strong>Q: </strong>When it becomes translatable, the [inaudible] can have more fun with the translation strings.</p>\n\n\n\n<p><strong>MM: </strong>Yeah, but they don&#8217;t have to, right? That&#8217;s the fun thing.</p>\n\n\n\n<p><strong>Q: </strong>Then I look forward to some patches. </p>\n\n\n\n<p><strong>MM: </strong>What I don&#8217;t want to do is, I don&#8217;t want to make it super-complicated. I know we did some things, like we moved it to a sub-directory. It actually just used to be a single file, so there have been some minor upgrades there. But the whole idea is to show how easy it is to use the actions and filter system inside of WordPress. </p>\n\n\n\n<p><strong>Q: </strong>There are no actions or filters in that plugin.</p>\n\n\n\n<p><strong>MM: </strong>Yeah, that&#8217;s how it looks in the WP Admin.</p>\n\n\n\n<p><strong>Q: </strong>There&#8217;s no filter on the string</p>\n\n\n\n<p><strong>MM: </strong>Well. we can add a filter on the string. And maybe it&#8217;s, it&#8217;s actually a filter and not translation, might be actually better, because, like you said, like maybe the pot system is not appropriate for that. Although, why not? Like, I&#8217;m sure you can translate those lyrics to French and other things, they would be meaningful. And also the connection to jazz musicians. It was one of the first famous jazz songs by one of my idols, Louis Armstrong, and you know, since then, we&#8217;ve named every release of WordPress in honor of a jazz musician. So that&#8217;s one of the cool things about WordPress versus other software is it has soul. You know, it&#8217;s true. Code is poetry. You know, we honor musicians and artists. You know, one of the first blocks we did in Gutenberg was actually a poetry block, a prose block. Has anyone used this one? It&#8217;s one of these things people are always like, “we should remove this.” [Laughter] </p>\n\n\n\n<p>Actually, I did it because I took a writing poetry course, and the author, a famous poet, was complaining how, when she posted to WordPress she couldn&#8217;t have the formatting correctly—you know how a lot of poetry will use interesting formatting where the white space has significance? Or spacing that has kind of unusual things? So the behavior of the editor, which takes multiple line breaks and combines into one, and other things, all that was being collapsed. And so I said, “Oh!” I think it&#8217;s called the Prose block, but it&#8217;s basically a block inside Gutenberg that preserves white space, kind of like a “pre” tag, and it&#8217;s used by some of the poets out there. So sometimes we do these really niche features for like, very high-end users. So for example, I think three or four of the living Fields Medalists use WordPress—actually, WordPress.com. </p>\n\n\n\n<p>Does anyone know about the <a href=\"https://www.mathunion.org/imu-awards/fields-medal\">Fields Medal</a>? A couple people. So it&#8217;s a math award. It&#8217;s more prestigious than a Nobel Prize. They give away a Nobel Prize every year. This happens only every four years, and some of the smartest people in the world have it, like <a href=\"https://terrytao.wordpress.com/\">Terence Tao</a>, who is, if you don&#8217;t know about him, look him up. He is probably one of the top five smartest people in the world, amazing, brilliant mathematician—he actually just got defunded, but the <a href=\"https://www.simonsfoundation.org/\">Simons Foundation</a> is now sponsoring all his work, which is very exciting. If you don&#8217;t know Jim Simons, he&#8217;s the founder of <a href=\"https://www.rentec.com/Home.action?index=true\">Renaissance Technologies</a>. Has anyone heard of Renaissance Tech? RenTec? One or two people? Oh, I&#8217;m telling you all sorts of cool stuff now. </p>\n\n\n\n<p>So Renaissance Technologies is the most successful hedge fund ever in history. They show, I think, annualized returns of over 40% over 35 years. It&#8217;s actually physicists and mathematicians that came together. Jim Simons was one of them, he went out of business or bankrupt or something, and was like, “gosh, I need to make some money. Maybe I&#8217;ll check out the stocks and trading thing.” And they started out, and they actually did really well, but then in the 80s, it all crashed. Jiim’s big, big innovation was that he invented algorithmic trading. So he basically said, we have humans making decisions. One, they&#8217;re too slow. And two, we don&#8217;t know why it&#8217;s working. And so there must be some fundamental sort of physics or rules of the trading markets and the business systems. And so RenTec started to gather the most data of anyone in the world. The next hedge fund to do this well was Bridgewater, but basically they started getting data sets, like shipping back to the 1400s, like really obscure things. They go get stuff out of books and develop all this priority training data, use it to map the economy and essentially create these models that the mathematicians would come up with. You can only be an investor in this fund if you work for the company, which is pretty interesting. And of course, everyone there is like a decamillionaire and everything. I forget how many employees—200 or 150 or something. Really, really small. So legendary. And he passed away a few years ago, but his foundation funds a ton of fundamental research and physics and math and so he&#8217;s someone I really look up to and admire. I <a href=\"https://ma.tt/2024/07/jim-simons-rip/\">blogged about him</a> earlier last year. He reminds me a lot of my dad, just the way he looks and talks. My dad passed away in 2016, so I really like watching Jim Simon’s stuff. </p>\n\n\n\n<p>Oh, I forgot to say, the point of the Fields Medalists. The reason the Fields Medalists use WordPress is we support a LaTeX plugin. LaTeX is basically like a markup language for doing advanced math formulas. We&#8217;re actually working on an update to this to be a bit more user-friendly. We added support for it in 2005 because Terence Tao started a free WordPress.com account, and he was complaining about this and embedding these images. I followed his blog, and I was like, “oh, we should make a block for this kind of shortcode.” And this shortcode is actually built into Jetpack, so anyone who runs Jetpack has access to this, and it&#8217;s now a Gutenberg block as well. So we&#8217;re adding diversity. So maybe tell the math department here. It’d be awesome to get some more mathematicians and folks on WordPress.</p>\n\n\n\n<p><strong>Q: </strong>Matt, just want to give you a heads up. We’ve got about five minutes left. </p>\n\n\n\n<p><strong>MM: </strong>All right, rapid fire. Should I do some fast ones? I just need to talk a little less.</p>\n\n\n\n<p><strong>Q: </strong>I&#8217;m Chris, I work for Pantheon. As you obviously know, Pantheon does Drupal stuff. So I know WordPress, but I have been watching, particularly, the evolution of their development work in AI, specifically integration in the Drupal admin, and also how the Drupal CMS is onboarding new users to Drupal, and the <a href=\"https://www.drupal.org/project/experience_builder\">Experience Builder</a> that they&#8217;re building. As we gather here today, probably most WordPressers might not be aware that there&#8217;s actually DrupalCon Europe happening in Vienna right now, and there&#8217;s lots of things that are happening out of that. And there&#8217;s a lot of really interesting and exciting things happening in that Drupal space. I know you&#8217;ve had conversations with Dries, because at least Dries <em>says</em> that you&#8217;ve had conversations.</p>\n\n\n\n<p><strong>MM: </strong>We talk semi-regularly. You know, there&#8217;s only there&#8217;s like a dozen people in the world who, like their whole life, is creating CMSes, Dave&#8217;s actually one of them in the room. We&#8217;re just going to do it the rest of our lives. And Dries is one of them, so I have incredible respect. We actually did a talk together with Mike Little, the co-founder of WordPress. So if you look up Dries, Mullenweg, Mike Little, you&#8217;ll you&#8217;ll find this. It&#8217;s pretty cool talk. Actually, we got to talk about the history and everything. </p>\n\n\n\n<p><strong>Q: </strong>So the question here is: To what degree are you looking at or thinking about the types of developments that are happening in Drupal but other CMSes as well, and what can we, as WordPress, learn from those other ecosystems?</p>\n\n\n\n<p><strong>MM: </strong>Oh, it&#8217;s a great question. I’ve got to look up the user ID. I think I was one of the first couple hudnred people registered on drop.org, which is the predecessor to <a href=\"http://drupal.org\">drupal.org</a>. Dries was actually at that Northern Voice conference in 2006; he has a post about it on his blog with some photos. So yeah, I keep in pretty close contact with a number of the other CMSes. Well, I won&#8217;t say close contact, but usually about once a year we&#8217;ll get together with Anthony from Squarespace, Tobi from Shopify, with Dries, whenever we&#8217;re in the same country, or I&#8217;m over in Europe or Boston. I try to look them up, and I test out things pretty regularly. </p>\n\n\n\n<p>So I haven&#8217;t seen the very, very latest stuff for Drupal. I think I checked out one of the last iterations they did. I love that with companies like Pantheon now doing both WordPress and Drupal, we&#8217;re getting a lot of overlap between the communities. So I would say, please bring this stuff over. I mean, we&#8217;re both PHP, we&#8217;re both GPL. It&#8217;s one of the reasons I&#8217;ve always really supported Drupal, even though we&#8217;re kind of mutually exclusive solutions. I&#8217;m always going to be supportive with other open source projects. So yeah, for those people who overlap, like yourself, please make some suggestions. You know, start a P2  post, or do a blog post about it. We&#8217;ll get it in the newsletter, or maybe even if there&#8217;s something specific that we could bring over code wise, we can start to get that incentive into <a href=\"https://core.trac.wordpress.org/\">Trac</a> and everything. Cool. </p>\n\n\n\n<p>I think Drupal also has a plugin to use Gutenberg, right? Yeah, which is pretty cool. It was one of the reasons we designed Gutenberg to actually be portable to other CMSes, and why we&#8217;ve been putting it under license, dual-licensing it so to be embedded even more places, not just GPL.</p>\n\n\n\n<p><strong>Q: </strong>Forgive the AI translation of my words, but it&#8217;ll help me be concise. But here&#8217;s the question. Really, really simple—no, it’s not. WordPress has always thrived because of its open, community-driven ethos, but as the ecosystem grows, we&#8217;re seeing more like large, profit-driven players who don&#8217;t necessarily share the values. How can individual contributors and agencies like ours actively help protect WordPress and uphold the values and ethics that have sustained it from bad actors and people who might try to exploit the community? And do you see room for something more formal, like a certification for individuals and agencies that define what being a good actor is, to help educate clients and even the market, to help protect in a more proactive way from those sorts of bad actors?</p>\n\n\n\n<p><strong>MM: </strong>Well, that&#8217;s a big question. I&#8217;ll try to answer quickly. So first I will say, I don&#8217;t want to say that there&#8217;s bad actors. I think there might be bad actions sometimes, and just temporarily bad actors who hopefully will be good in the future. You know, every saint has a past, every sinner has a future. I never want to define any company or any person as permanently good or bad. Let&#8217;s talk about actions. </p>\n\n\n\n<p>Second, I think with these actions, we can start to create incentive systems, and it&#8217;s part of what we&#8217;re doing with Five for the Future, which is basically saying, you contribute back—which also implies that you&#8217;re not violating the GPL, or something like that. So we&#8217;ve got the hard stuff, like, if you violate the GPL, you&#8217;re gonna get a letter. Violate the trademark. You know, that was more of a legal thing. But also the gentle stuff, like, how can we encourage good behavior by giving people higher rankings in the directory or in the showcase, for example? </p>\n\n\n\n<p>Then finally, I&#8217;ll just say, vote with your wallet. Each one of you here has the ability to strongly influence these companies. If they&#8217;re commercially motivated, great, let&#8217;s commercially motivate them to do the right thing by giving more business to the good companies and less business to the other companies. This has actually been happening a lot the past year. I think I can say this: There&#8217;s a site called <a href=\"https://wordpressenginetracker.com/\">WordPress Engine Tracker</a> which is currently tracking a number of sites that have left a certain host. It&#8217;s about to cross 100,000 that have switched to others host. And 74,000 have gone offline since September of last year. We actually used to make all this data public. The whole list was on there. They got a court order so the data could be fact-checked by press or other people. There was actually a court order that made us that down. So again, trying to muzzle free speech and transparency. But you know, we&#8217;re allowed to keep that site up, so check it out while you can. </p>\n\n\n\n<p>Do we have time for one more. Is this last one?</p>\n\n\n\n<p><strong>Q: </strong>Okay, I don&#8217;t think this qualifies as rapid fire, but it&#8217;s a softball. First of all, I came to WordPress as an open source advocate. I became a b2 user. That&#8217;s how I got to WordPress. So my all-time favorite WordPress release is 1.5, because it has what I consider a killer feature. It&#8217;s not the one you&#8217;re thinking. It’s pages.</p>\n\n\n\n<p><strong>MM: </strong>1.5 right? Yeah, I remember introducing that. Originally. I had a different CMS I was going to release called ContentPress. Or Multipattern. I wasn&#8217;t sure what to call it, and so I had this whole other CMS. And I was like, man, we should just build this into WordPress, even though it&#8217;s a blogging system. I think having this pages feature put us ahead of Movable Type and others. So yeah, glad we did. I think we introduced themes and that I released him. </p>\n\n\n\n<p><strong>Q: </strong>Yes, themes was the was kind of the obvious big feature for it, but pages is the point at which I would say that WordPress went from blogging engine to CMS. So that&#8217;s my favorite. But what I was going to ask is—</p>\n\n\n\n<p><strong>MM: </strong>So it&#8217;s all been downhill since then? </p>\n\n\n\n<p>[Laughter]</p>\n\n\n\n<p><strong>Q: </strong>No, it was such a pivotal moment that helped with WordPress&#8217;s meteoric adoption rates. And for me, personally, at that time, it allowed me to take a whole bunch of static HTML and bring it into WordPress so I could manage it so much more easily. So my question was: can you tell us a story, or give us some fun facts about that? Softball question, unless it really taxes your memory.</p>\n\n\n\n<p><strong>MM: </strong>Well, luckily I blog. I&#8217;ll say that two of my favorites ever in history are 1.2 and 1.5—which actually came out right after each other, because we skipped a few releases; it was a time when we actually got pretty delayed. So 1.2 introduced the hooks and filter system, which was pretty revolutionary, I think still, as a unique programming paradigm. But before that, to modify WordPress, you&#8217;d actually open up files and change lines. I used to publish these, we called them hacks, and they were. At one point we introduced the hacks file, which made it a little bit better. But then our plugin hook system allowed a separation between the core and the add-ons, but you could go really deep to modify things. Then 1.5 was themes, I believe. So 1.2 was plugins, 1.5 was themes. And then the other big one—I think it was 2 or 2 point something, was when we introduced WYSIWYG for the first time. Which, by the way, was so controversial; people did <em>not</em> want basic WYSIWYG in WordPress, which was funny, like 10 years later, when they&#8217;re like, “Okay, this Gutenberg thing&#8217;s even worse.” I was like, “Ah, I’ve been through <em>this</em> before.” </p>\n\n\n\n<p>So I think that those are kind of the fun stories around there. Again, some of this stuff was pretty slow to be adopted at first. I wasn&#8217;t certain that this should be rolled into WordPress or there should be separate software, but I&#8217;m glad we did. You know, Movable Type was a dominant thing at the time, and their static page functionality wasn&#8217;t very robust. And so the other thing that WordPress did around this time that I thought was pretty awesome is really clean URLs. So where, prior, you know, people would have crufty URLs, like they’d have an ID in the number, or you&#8217;d have for WordPress,—the default’s still there, actually—is like “?p=123,” so creating the mapping system where we map dates, a hierarchy, and these clean slugs to the pages in the back, in the browsing system, essentially, I think was really crucial. And I love that URLs from 20-something years ago still work or redirect to proper things today. So I think that&#8217;s really, really important. Thank you. All right. Last one,</p>\n\n\n\n<p><strong>Q: </strong>Hey, Matt. I&#8217;m Raquel, and I love kitties and surprises. Just some facts. I have a another question around the community. I want to know how do you feel, what are your raw thoughts, on independent WordPress events that are happening in our space now?</p>\n\n\n\n<p><strong>MM: </strong>And do you want to disclose anything there?</p>\n\n\n\n<p><strong>Q: </strong>I mean, I am the one responsible for <a href=\"https://pressconf.events/\">PressConf</a>, so independent WordPress event. So, yeah, how do you feel? I’m just curious as to how we can all get better together, which tends to be my motto.</p>\n\n\n\n<p><strong>MM: </strong>I&#8217;m very much like a “let a thousand flowers bloom” kind of guy. So thank you. I know it&#8217;s a huge labor of love doing something like PressConf. That’s something that’s been very active in WordCamps and other things in the past, and hopefully with WordCamp US going to Phoenix, we’ll have an opportunity to do some work together there. </p>\n\n\n\n<p>So I think that&#8217;s my fundamental, you know, raw thoughts. You know, I do think about, you know, what do we want to encourage in the world as well? So I would just encourage you as an independent organizer. You know, there&#8217;s some beauty there that you don&#8217;t have to follow the rules or guidelines necessarily. And it&#8217;s commercial events. Well, like the tickets cost more than WordCamp and stuff, right? How much is a ticket?</p>\n\n\n\n<p><strong>Q: </strong>Depending on early bird to total, $700 average.</p>\n\n\n\n<p><strong>MM: </strong>And so that’s a bit of a smaller event, right? That&#8217;s part of what people like about it. So the ticket price actually becomes like a little bit of a barrier to entry. It&#8217;s more intimate. You get some really awesome attendees and talks there, as I think about this as well, just like, you know, what do we want to see more of in the world? And, you know, trying to focus time, particularly my time, to those types of things. So that&#8217;s why I came to WordCamp Canada. You know, this is not the biggest WordCamp in the world, but man, this spirit here, and the people and the everything, and like you know, what you’ve all put together, as it’s come together over the past few months, the incredible work of the organizers,the social media team&#8217;s been doing a great job getting some awesome speakers like Jill and Dave and like, I was like, man! That&#8217;s why I was just planning to come and attend. You know, just to check it out, because I was very interested in the content and everything y&#8217;all put together. So again, I guess we&#8217;re out of time. So I just want to say thank you. Thank you. Thank you. I&#8217;m going to run to the restroom, but then I&#8217;ll be right back out in the lobby. I&#8217;m going to take pictures, shake hands, kiss babies. </p>\n\n\n\n<p>[Laughter]</p>\n\n\n\n<p>I can shake the hand of a baby too. It&#8217;s whatever. I’m open-minded. But hey, thank you. I appreciate it.</p>\n\n\n\n<p><strong>Update:</strong> The video is up, it&#8217;s pretty bad I think the audio is pulling from a DJI thing not the microphones, <a href=\"https://www.youtube.com/watch?v=RL-XccK30sY\">but here it is</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 14:24:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: On Money Stuff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150241\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/10/money-stuff/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1862:\"<p>There are a few writers who I follow religiously, and one is <a href=\"https://www.bloomberg.com/opinion/authors/ARbTQlRLRjE/matthew-s-levine\">Matt Levine of Bloomberg&#8217;s Money Stuff</a>. For business and finance it&#8217;s one of the smartest and funniest things you can read. Yesterday, I think for the first time, <a href=\"https://www.bloomberg.com/opinion/newsletters/2025-10-15/openai-has-a-business-plan\">he mentioned WordPress</a>! In the context of his quote on this <a href=\"https://x.com/FhantomBets/status/1977410624343965999\">great X thread about how the Polymarket insider predicted the Nobel peace prize winner</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>This trader apparently <em>didn’t </em>have inside information, in the traditional bad sense of like bribing a Nobel committee staffer. Instead, web scraping:</p>\n\n\n\n<p>&#8220;The Nobel site runs on WordPress. Like many WordPress setups, it has an XML sitemap that lists every indexable page, even ones not yet public. If someone were monitoring this sitemap, they could easily notice a new page appear, something like &#8220;http://nobelprize.org/prizes/peace/2025/machado/facts/&#8221;</p>\n</blockquote>\n\n\n\n<p>If you run a WordPress site and want the best advice in the world for how to avoid this sort of thing, I <a href=\"https://wpvip.com/\">highly recommend our enterprise WordPress VIP service</a>! They help run some of the largest and most secure WordPress sites in the world, and could easily help navigate avoiding something like this from happening. WordPress is easy and cheap to run everywhere, <a href=\"https://projects.raspberrypi.org/en/projects/lamp-web-server-with-wordpress\">even on a Raspberry Pi</a>, but you get what you pay for, and any serious organization or mission-critical website should be on VIP.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 04:25:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: The Curse of the Muse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150237\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://ma.tt/2025/10/muse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2443:\"<p>Some days, like this morning when I almost missed <a href=\"https://ma.tt/2025/10/in-canada/\">my flight to WordCamp Canada in Ottawa</a>, I’m so overwhelmed with the maelstrom of ideas and sparks of creation that it feels like waves crashing against a dam. There are so many ways I can imagine new software, new products, new ways for the world to be.</p>\n\n\n\n<p>This is a beautiful process, but it&#8217;s also painful! The anguish and agony arise as you attempt to distill the ideas and sparks; the creativity dims, and the beauty and perfection of the original inspiration fade, as I try to translate it into something that can become real and be legible to others. That’s why I have to drop everything when inspiration strikes, because if I try to return to it later, I find the muse has left and I can’t bottle that energy anymore. (There&#8217;s a reason <a href=\"https://meyerweb.com/\">Eric</a>, <a href=\"https://tantek.com/\">Tantek</a>, and I put &#8220;muse&#8221; <a href=\"https://gmpg.org/xfn/background\">into the XFN standard</a>!)</p>\n\n\n\n<p>To the extent I’ve been successful at all in my life, it is because I’m able to contain this tornado and break it down into plans, business models, people, and teams.  <em>I’ve never done anything useful on my own</em>; it’s always been in conversation and partnership with others. </p>\n\n\n\n<p>I&#8217;m grateful to everyone I work with across <a href=\"https://automattic.com/\">Automattic</a>, WordPress, <a href=\"https://audrey.co/\">Audrey</a>, <a href=\"https://tinkertendo.com/\">TinkerTendo</a>, <a href=\"https://keysjazzbistro.com/\">Keys</a>, <a href=\"https://www.theinstitute.com/\">The Institute</a>, <a href=\"https://illuminate.org/\">Illuminate</a>, <a href=\"https://ecoamerica.org/\">EcoAmerica</a>, <a href=\"https://fieldeffect.com/\">Field Effect</a> (in Ottawa!), as well as all my <a href=\"https://www.facebook.com/saxmatt\">friends</a> and <a href=\"https://www.linkedin.com/in/mattm/\">professional connections</a>. They are the ones that help me shape this energy into things that actually have an impact in the world and aren’t just fever dreams.</p>\n\n\n\n<p>This essay itself had <a href=\"https://quoteinvestigator.com/2012/04/28/shorter-letter/\">hundreds more words</a>, but I have to <a href=\"https://www.amazon.com/dp/0060891548?tag=photomatt08-20\">edit</a>, <a href=\"https://www.youtube.com/watch?v=aStHTTPxlis\">delete delete delete</a>, trim things down.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Oct 2025 00:01:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: #189 – Weston Ruter on Unlocking WordPress Performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=200138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/podcast/189-weston-ruter-on-unlocking-wordpress-performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:60131:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case how WordPress Core continues to strive to unlock greater performance.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Weston Ruter. Weston is a longtime WordPress user and contributor. He has been a core committer for 10 years, and he co-led the WordPress 4.9 release. He worked in the WordPress agency space, and has also been sponsored to work on the Core Performance Team. He lives in Portland, which as you will hear, was quite handy for this interview.</p>\n\n\n\n<p>We start the conversation by getting into the big picture, why website speed matters more now than ever, and how WordPress performs out of the box. Weston shares details about measuring true performance. Revealing, for example, that achieving a perfect Lighthouse score isn&#8217;t the end game, and that real user experience metrics like Core Web Vitals and Largest Contentful Paint should shape how developers and site owners think about optimization.</p>\n\n\n\n<p>Throughout the episode, you&#8217;ll learn about the advances made by the WordPress Performance Team, from lazy loading and new image formats, to speculative loading that shaves precious milliseconds off page transitions. Weston explains how many performance improvements are designed to work automatically, democratizing speed, so that even casual WordPress users benefit without needing to be technical experts.</p>\n\n\n\n<p>The conversation also touches on the balance between adding features and avoiding plugin bloat. The hidden impact of browser and device differences, and how large companies, like Google, are working hand in hand with WordPress to raise the bar on speed and usability.</p>\n\n\n\n<p>Weston offers practical tips, deep technical wisdom, and a glimpse of where WordPress performance is heading next, and it&#8217;s sure to inspire you to think differently about how your sites load, how your users engage, and how you can squeeze out every last drop of speed from the platform you love.</p>\n\n\n\n<p>Whether you&#8217;re a developer, designer, site owner, or just someone curious about what keeps the web running smoothly. This episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Weston Ruter.</p>\n\n\n\n<p>I am joined on the podcast by Weston Ruter. Hello.</p>\n\n\n\n<p>[00:03:28] <strong>Weston Ruter:</strong> Thank you for having me.</p>\n\n\n\n<p>[00:03:29] <strong>Nathan Wrigley:</strong> You are very welcome. I&#8217;m quite jealous of Weston because we&#8217;re in Portland, Oregon at WordCamp US. I had to get on a plane, which was no hardship really in the grand scheme of things. Nevertheless, it was a lengthy plane journey. You, on the other hand, had to get on some public transport to get here because you live in Portland. That must be nice</p>\n\n\n\n<p>[00:03:45] <strong>Weston Ruter:</strong> I live about five miles to the east of here, and so I jumped on the bus and I got off and walked to coffee shop and over to the conference center.</p>\n\n\n\n<p>[00:03:53] <strong>Nathan Wrigley:</strong> And twice, two years in a row as well. You&#8217;re very, very lucky.</p>\n\n\n\n<p>[00:03:56] <strong>Weston Ruter:</strong> I was very happy when I found out.</p>\n\n\n\n<p>[00:03:57] <strong>Nathan Wrigley:</strong> Yeah. So Weston&#8217;s here today because of a presentation that he&#8217;s giving at WordCamp US. I will read into the record the title of the presentation that you&#8217;re giving, The Site Speed Frontier with Performance Lab and Beyond. So it&#8217;s all about performance, this episode essentially.</p>\n\n\n\n<p>This is one of those subjects where I feel you have to tell us your credentials so that we understand that what you are saying is true. Because I think there&#8217;s a lot of snake oil, certainly from my point of view, quite a lot of ignorance. I don&#8217;t really understand this topic inside and out. So would you mind, a minute or something like that? Just tell us about you and your history with, well, WordPress, but also performance and so on.</p>\n\n\n\n<p>[00:04:32] <strong>Weston Ruter:</strong> Yeah, sure. I have been a WordPress Core committer for 10 years. And I was in the agency space working at XWP, working on enterprise WordPress sites. And then I joined Google and I was a software engineer working on developer programs engineer, then develop a relations engineer working on the AMP project, which is all about making webpages faster using the AMP framework. And from there I transitioned into working on the Core Performance Team for the past couple years. And we are focused on making WordPress fast for everybody.</p>\n\n\n\n<p>[00:05:15] <strong>Nathan Wrigley:</strong> Okay, great. Thank you so much. So the topic at hand then is going to be about performance. Why are you interested in this? I know obviously there&#8217;s a career in it and what have you. Is this something that you lie awake at night thinking about? Do you obsess about this kind of stuff?</p>\n\n\n\n<p>[00:05:28] <strong>Weston Ruter:</strong> Yeah, it&#8217;s a passion of mine because who likes a slow webpage, right? So it&#8217;s fun to eke every bit of performance out of the loading of something. There&#8217;s a lot of little technical details and things to know and best practices to observe. And so it&#8217;s a fun challenge to be as fast as possible and there&#8217;s always room for improvement.</p>\n\n\n\n<p>[00:05:52] <strong>Nathan Wrigley:</strong> And it kind of feels as if the mantra over many, many years has basically been that, you know, if you can make your website faster, it will be successful. People will visit it, people are getting weary of page load time or what have you. And so maybe we&#8217;ll get into the weeds of all of that.</p>\n\n\n\n<p>How does WordPress, if I was just to go, okay, ignore the hosting that it&#8217;s on. Let&#8217;s just imagine we&#8217;ve got a good host, we&#8217;ll just use that term. If I was to download a vanilla version of WordPress and use the default theme, currently 2025, and do nothing else with it, I&#8217;ve written a few blog posts, maybe that&#8217;s it. How does it do out of the box like that?</p>\n\n\n\n<p>[00:06:25] <strong>Weston Ruter:</strong> Yeah, it turns out my talk is exactly about this, and it uses the 2025 theme as a test case to show how the performance of WordPress fares out of the box. And if you were to load up a site running 2025, the theme and nothing else, and you run it through Lighthouse, the performance testing tool from Google, you&#8217;ll most likely get a 100 score, performance score. And you would think, I&#8217;m done, there&#8217;s nothing else to do. But if you dig into it, just because you get a good score, that doesn&#8217;t mean there&#8217;s still not room for improvement. And there&#8217;s still head room even after 100.</p>\n\n\n\n<p>But yeah, WordPress Core does great out of the box, but there are still many opportunities to make it even faster. And as you had Felix on previously to talk about speculative loading, that&#8217;s one example where the performance is improved yet further. And in the performance lab plugin, which the performance team maintains, we have different performance feature plugins that implement additional optimisations that address different scenarios and use cases that WordPress doesn&#8217;t do well out of the box.</p>\n\n\n\n<p>[00:07:40] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting, and I&#8217;ve never heard it framed that way. I&#8217;ve never heard that there was a ceiling above 100. It kind of feels as if that is the ceiling. If you score 100, all bets are off, game over, you&#8217;ve succeeded, hooray, have a party, kind of thing. But no, there&#8217;s still room to be squeezing a little bit out here and there.</p>\n\n\n\n<p>[00:07:57] <strong>Weston Ruter:</strong> Yeah, if you look at a Lighthouse audit, Lighthouse is an example of a lab metric. It simulates a page load for a user, but it&#8217;s not an actual page load for an actual user. It&#8217;s just a simulation. And if you really want to know how your site is actually performing, you need to measure those visits from actual users.</p>\n\n\n\n<p>And if you load up a popular site in Google&#8217;s page speed insights tool, you&#8217;ll see there&#8217;s two different sections on the page. At the top, you&#8217;ll see what users are experiencing, and then at the bottom you&#8217;ll see lab data. And the top is coming from actual site visitors through what&#8217;s called the Chrome User Experience Report. And that tells you how the site is performing in terms of the Core Web Vitals that Google has spearheaded.</p>\n\n\n\n<p>And one of those is called the Largest Contentful Paint or LCP, and that measures the time it takes for the largest element that is most likely going to be the main content of the page to be rendered, from the time you start navigating to the page and that element finishes rendering.</p>\n\n\n\n<p>And a good LCP value is considered from 0 to 2.5 seconds. And so you can have, within 2.5 seconds there&#8217;s a big range in the user experience. So if it&#8217;s just under 2.5 seconds, it&#8217;s considered good, but that doesn&#8217;t mean a 1.5 second page load is actually way better, and a 0.5 second page load is even better yet, and a 0.05 second page load is great, is perfect. That would be the perfection. And that is what we&#8217;re working on.</p>\n\n\n\n<p>[00:09:36] <strong>Nathan Wrigley:</strong> There&#8217;s gradations of it, okay. So within that 100 there may be room to do, aspects of the 100 can be improved. And in this case, by taking the LCP time down.</p>\n\n\n\n<p>We&#8217;re at a conference event. There&#8217;s over a thousand people. There must be designers, developers, SEO people here. There&#8217;s everybody. There&#8217;s the whole gamut of people that use WordPress, probably some people that are new to the whole platform as well. Do you think that performance is something that everybody needs to worry about or are you happy to be one of the few that obsess about it? Is it basically better to leave an expert like yourself to worry about it, or is this something that we can all have a little dabble at and be successful about?</p>\n\n\n\n<p>[00:10:14] <strong>Weston Ruter:</strong> Well, that&#8217;s what we&#8217;re concerned about with the Core Performance Team is making it so that the regular WordPress user doesn&#8217;t have to worry about this, because nobody&#8217;s got time to spend learning like, what is LCP? What is time to first bite? What are these different metrics? And nobody has time to worry about optimising for all these. So WordPress Core should do all this out of the box, and the WordPress ecosystem should implement best practices so that users don&#8217;t have to worry about it.</p>\n\n\n\n<p>[00:10:44] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting. I remember, I&#8217;m thinking it was about six years ago, but I don&#8217;t really remember the date. But Google kind of informed everybody that in a period of time, a year&#8217;s time or what have you, these metrics, LCP and, Core Web Vitals basically were going to come in.</p>\n\n\n\n<p>And it felt like everybody in our industry was running around like a headless chicken, trying to understand something that they knew, there was this sword of Damocles moment, this date in the calendar where the SERPs were going to change. It didn&#8217;t feel like a comfortable time. In some senses, it felt like Google was kind of poisoning the water a bit because they were alienating developers who suddenly had to learn this new thing, because they realised their client websites were going to probably tumble in the SERPs.</p>\n\n\n\n<p>And so they had to upskill in this thing that probably they didn&#8217;t want to be involved with. So it was a curious time, but the dust seems to have settled. I don&#8217;t know too much about, you know, whether they were penalties that really were paid by people because they didn&#8217;t have these fabulous Core Web Vital scores. But it definitely put the cat amongst the pigeons for a while anyway.</p>\n\n\n\n<p>[00:11:38] <strong>Weston Ruter:</strong> The factors that go into ranking pages and Google search are, I never knew what they are, so the knowledge I have is that the performance of a page contributes to the ranking in some way. And basically, as I understand it, all things being equal, you have two sites with the same content and same relevance to the user, and one has better performance, then in theory that would rank higher.</p>\n\n\n\n<p>How much value you get in terms of your ranking is debatable or unknown. I don&#8217;t know. But what is important is the user experience and the benefits that you get for your users. And if they have a good experience on your site, then they&#8217;re more likely to come back. More likely to result in a conversion or a purchase, or whatever you&#8217;re looking to get out of your site. So that&#8217;s where I would focus the concerns.</p>\n\n\n\n<p>[00:12:34] <strong>Nathan Wrigley:</strong> If this were the Squarespace or Wix podcast, which of course it isn&#8217;t, it would be much more straightforward to have a conversation about why your site was quick because, you know, it&#8217;s this proprietary platform. There&#8217;s constraints about what you can do on that platform, and they run the whole thing, you know, they&#8217;ve got their arms around everything.</p>\n\n\n\n<p>WordPress, you download it from .org in most cases, and start to pile things on top of it. And very quickly we get the problems developing I guess, you know, the more things that you throw into it, the more plugins and what have you. Would your advice simply be circumspect about what you throw in, or can you, for want of a better phrase, can you concentrate on additional tech to mask over any problems that you have?</p>\n\n\n\n<p>You know, with the best one in the world, if you&#8217;ve got an LMS, it&#8217;s probably going to slow your website down because it&#8217;s doing a lot. If you&#8217;ve got WooCommerce, it&#8217;s probably going to slow yourself, the website, down from the vanilla install with using the 2025 theme that you just mentioned.</p>\n\n\n\n<p>But there&#8217;s this whole marketplace of hosting companies and performance companies who are selling you things that kind of undo the, and I&#8217;m doing air quotes, the damage that you did by putting the plugins in.</p>\n\n\n\n<p>So I don&#8217;t know if you&#8217;ve got anything to say to that. You know, the whole thing about bloating the website, slowing it down, unpicking it with different tech.</p>\n\n\n\n<p>[00:13:49] <strong>Weston Ruter:</strong> Yeah, well, the WordPress ecosystem has a problem with the kitchen sink issue and a plugin that has more features is somehow valued more highly than a plugin that does one thing and does it really well.</p>\n\n\n\n<p>And so in the Performance Lab plugin in our suite of plugins that we feature, we have the goal that a plugin should do one thing and do it really well. And if you don&#8217;t like what the plugin is doing, you deactivate it and switch to another one that is doing that one issue and doing it well.</p>\n\n\n\n<p>But if you have plugins that do so many things, then you&#8217;re really kind of, your hands are tied and it&#8217;s difficult to switch. And maybe that&#8217;s a strategy by some plugins to lock you in to their ecosystem, but it&#8217;s a difficult problem, yeah.</p>\n\n\n\n<p>[00:14:39] <strong>Nathan Wrigley:</strong> And we also have a, you know, we have plugins which are performance plugins. I mean, there&#8217;s dozens of them. I&#8217;m sure we could rattle off, whose job is to fix the problems that you may have created elsewhere in the website. If you&#8217;re in the weeds of it, like you are, you&#8217;ve probably got some vague understanding about it. You understand whether something is snake oil or not, but for the rest of us, that is a Pandora&#8217;s box, and there&#8217;s only chaos in there.</p>\n\n\n\n<p>I don&#8217;t know what will slow my website down. If I download, I&#8217;m going to use LMS again, if I download an LMS platform, I&#8217;m going to hope that the work has been done successfully. But I&#8217;m probably also going to be thinking about, okay, now do I need to talk to my host, get a different hosting environment, get it set up so it&#8217;s perfect for that? Do I need a performance plugin? Caching layers, putting things on the edge.</p>\n\n\n\n<p>And on and on it goes. It makes WordPress a difficult thing for many, many people to use. And so this idea of democratising publishing sort of goes out the window a little bit because it&#8217;s really extraordinarily hard to use.</p>\n\n\n\n<p>[00:15:34] <strong>Weston Ruter:</strong> Yeah. And I think that in addition to democratising publishing, WordPress should also be as part of that democratising performance. And again, making it so that users don&#8217;t have to worry about that.</p>\n\n\n\n<p>And what we&#8217;re doing in Core, we&#8217;re doing exactly that where as one of WordPress&#8217;s core philosophies is decisions, not options, and things should work out of the box.</p>\n\n\n\n<p>But when it comes to the ecosystem, it&#8217;s a open source environment and there&#8217;s no top down control over what a plugin does. So I think there&#8217;s opportunities with projects like the Plugin Check plugin to do more analysis on the performance, in addition to the security and the best practices for being accepted into the directory.</p>\n\n\n\n<p>But if there&#8217;s also a surfacing of performance issues or additional audits that are done on the impact of installing a plugin, that could be really valuable for site owners to get a sense of, this may cause problems if you install it.</p>\n\n\n\n<p>[00:16:37] <strong>Nathan Wrigley:</strong> How long has the Performance Team been a thing? I feel like three years or something like that, but I could be really wrong.</p>\n\n\n\n<p>[00:16:43] <strong>Weston Ruter:</strong> About four years I think.</p>\n\n\n\n<p>[00:16:45] <strong>Nathan Wrigley:</strong> Okay, yeah. And could you just run over the history of that? I was going to say organisation, but let&#8217;s go with team. Could you run us through the history of that team and what you&#8217;ve been able to do?</p>\n\n\n\n<p>Each of the little steps, some of them are quite profound. Some of them feel less profound, but very important. But over those four years, a lot of really incredible work has been done actually. Certainly from my perspective, it does seem that without that team we&#8217;d be in a very, very different place.</p>\n\n\n\n<p>[00:17:15] <strong>Weston Ruter:</strong> I hope that&#8217;s true. I think it is. Yeah, well, it started out focusing on, I think lazy loading of images was one of the first things to land through this team. And with that we also then uncovered that actually lazy loading everything, which while great for reducing the weight of a page, because you&#8217;re not downloading images that aren&#8217;t actually shown. If you lazy load images that are in the initial viewport, that actually hurts the Largest Contentful Paint metric because the browser wastes to start downloading those images until it knows that they&#8217;re in the viewport.</p>\n\n\n\n<p>So out of that came work to not lazy load images that are in the initial view port, and then also moving on to this attribute called fetch priority, which you can have the value of high, for example. So if you add fetch priority high to an image, then the browser&#8217;s going to prioritise loading that first. And so a lot of work was done to add sensible defaults in WordPress Core so that, for example, the featured image of a post gets fetch priority high, so that it gets loaded sooner over images that are not going to be the Largest Contentful Paint, most likely.</p>\n\n\n\n<p>So there&#8217;s that. And then there was also an issue with like emoji in posts where, on every page load there&#8217;s some JavaScript that runs in the head of the page, and it computes whether the browser supports the emoji, like all the emoji. And if the browser doesn&#8217;t support all the emoji, then it loads the Twitter emoji library to render them. And that JavaScript was causing a long task in lower performing browsers, or devices, that was hurting the largest contentful paint as well. So that was fixed as well.</p>\n\n\n\n<p>And then work has been done to add support for new image formats, like AVIF and WebP so that site owners can upload those image formats instead of JPEGs, which take longer to download.</p>\n\n\n\n<p>We talked about speculative loading, and you talked about that with Felix. So that landed in 6.8, which by default will start prefetching the HTML for a page when you mouse down or tap or click, pointer down on a link to give the browser a bit of a headstart. But then the API allows you to be more aggressive about starting that process, just when you hover over the link, for example, and then not just to prefetch the HTML, but to actually render the whole page.</p>\n\n\n\n<p>And so in my talk, which I gave earlier today, I showed the difference between no speculative loading, speculative loading as in WordPress Core right now, the default, and then moderate prefetch. And then lastly, moderate pre-render.</p>\n\n\n\n<p>[00:19:57] <strong>Nathan Wrigley:</strong> Is that done with the plugin? Well, I guess you could do that with code, but there&#8217;s an option to, if you download the plugin, you&#8217;ve got a UI for that as well.</p>\n\n\n\n<p>[00:20:04] <strong>Weston Ruter:</strong> Exactly. There&#8217;s a UI in the plugin that allows you to opt into moderate eagerness, or to use pre-render instead of prefetch. And in the example I showed, let&#8217;s say your time to first bite is a second. Then in the initial example, like on a slow, or on a fast 4G connection, you&#8217;re going to get like 2.27 seconds to load the page. But then with conservative prefetch, that shaves off like 50 milliseconds because the amount of time it takes to mouse down and mouse up is just a little bit of time that it can shave off that&#8217;s just a little bit to the loading of the page.</p>\n\n\n\n<p>But then when you go to moderate prefetch, then the browser can load the page fully in the background. And so then the time to first bite in that case becomes zero because the whole page is already in the browser&#8217;s cache. And that can reduce it to like one second because you totally eliminated the time to first bite.</p>\n\n\n\n<p>And then with the moderate pre rendering, then when you&#8217;re hovered over that link, the browser not only downloads the HTML, but also all the images, builds out the layout, runs the JavaScript. And so then when you click on that link, the page can load instantaneously.</p>\n\n\n\n<p>[00:21:12] <strong>Nathan Wrigley:</strong> So literally instantaneous.</p>\n\n\n\n<p>[00:21:14] <strong>Weston Ruter:</strong> 0.05 seconds.</p>\n\n\n\n<p>[00:21:16] <strong>Nathan Wrigley:</strong> Yeah. It&#8217;s instantaneous. I mean that&#8217;s pretty incredible. All of that is available inside of WordPress, but just to rewind, probably about 50 seconds, the default is not aggressive. The default in WordPress in order to satisfy the kind of 80 20 rule and what have you, the default is to make it so that there has to be some interaction. The mouse has to be invoked. There&#8217;s a click involved.</p>\n\n\n\n<p>That&#8217;s fascinating. So if you really want to get into the weeds of that, you can basically make the next page load almost instantaneously, should you wish to do that.</p>\n\n\n\n<p>One thing that I did get into with, I believe it was Adam Silverstein not that long ago when I had a podcast episode with him. And I don&#8217;t mean to go deeply into this, but there&#8217;s a curious balancing act here, I think with the environment and all of this speculative loading. Because it wouldn&#8217;t be desirable to load, I don&#8217;t know, there&#8217;s 12 navigation links and the mouse happens to go across all of them. And suddenly 12 unnecessary pages were entirely pre-rendered and what have you. So yeah. I don&#8217;t know if you&#8217;ve got any thoughts on that, whether there&#8217;s a balancing act between performance and environmental concerns.</p>\n\n\n\n<p>[00:22:23] <strong>Weston Ruter:</strong> Yeah. By default, speculative loading only operates on pages when you&#8217;re not logged in. And so when you&#8217;re not logged into WordPress, that is most of the time when you&#8217;re going to have a page cache that can serve it from the cache. And so as long as you have page caching in place, then the server isn&#8217;t going to be overly taxed by those requests.</p>\n\n\n\n<p>In the newest version of the Speculative Loading plugin, it has an opt in to speculative loading for logged in users as well. But there&#8217;s a warning that shows up if you don&#8217;t have a persistent object cache active, for example. So, yeah, it&#8217;s important to have good caching in place, good best practices for scaling.</p>\n\n\n\n<p>However, in addition to pre rendering, which the speculative loading plugin enables, there&#8217;s a much older technology for instant page loads that browsers all support, and that is the back forward cache.</p>\n\n\n\n<p>And WordPress sites, by default when you&#8217;re logged out, will benefit from this most of the time. But as soon as you login or if you&#8217;re navigating to like a shopping cart page, or an account page, or checkout page in an e-commerce site. Oftentimes the plugin will invoke this no cash headers function that tells the browser, primarily tells the page cache, hey, don&#8217;t hold onto this response because you don&#8217;t want to cache the shopping cart for one user and then serve it to another user, because then you would be seeing something embarrassing potentially.</p>\n\n\n\n<p>And so that is one of the benefits of sending that header. But it also has the effect of preventing the browser from holding onto that page as well. So if you navigate back and forward from the shopping cart, then you&#8217;ll notice that it doesn&#8217;t load very fast. It loads slow, because the browser has to re-fetch it all from the server, and has to rebuild everything from scratch.</p>\n\n\n\n<p>And so there&#8217;s a effort underway for 6.9 to stop doing that. To allow the browser to hold onto that in memory. And then to address, one of the issues that turned this off to begin with, allowing the browser to store the pages in the cache. Is if you aren&#8217;t logged in, for example, into WordPress. You&#8217;re on some sensitive page maybe putting some API key in or something, and you go to log out, with this back, forward cache, you could hit the back button to go back into the WordPress admin as another person, maybe on a shared computer and look at that page, even though the user had logged out.</p>\n\n\n\n<p>[00:24:50] <strong>Nathan Wrigley:</strong> Yeah, really not good.</p>\n\n\n\n<p>[00:24:51] <strong>Weston Ruter:</strong> Not good. So there&#8217;s a ticket for 6.9 which would solve that problem by invalidating those pages from bfcache so that that privacy concern isn&#8217;t there. And this issue is not just about, well, these back, forward navigations are very common. So the Chrome team found that one in 10 navigations on desktop are these back, forward navigations?</p>\n\n\n\n<p>[00:25:15] <strong>Nathan Wrigley:</strong> A tenth?</p>\n\n\n\n<p>[00:25:16] <strong>Weston Ruter:</strong> Yeah. And on mobile, I think it&#8217;s one in five. So 20% of the time on mobile, you&#8217;re going back and forward using a gesture instead of hitting a link.</p>\n\n\n\n<p>[00:25:25] <strong>Nathan Wrigley:</strong> That maps to my life, but I hadn&#8217;t thought about it.</p>\n\n\n\n<p>[00:25:28] <strong>Weston Ruter:</strong> But the benefit here is not just in that you get a faster page load, but also bfcache, this back, forward cache will preserve the entire state of the page. So in my talk, I showed an example where you, if you have BuddyPress installed, you start typing in an update, a status update, and then you click away to a separate tab, and then if you hit the back button to go back to that initial tab, then you&#8217;ll find without this back, forward cache that your update&#8217;s gone because that input field was constructed with JavaScript. And when you don&#8217;t have back, forward cache, then the entire document object model has to be rebuilt. All the JavaScript has to re-execute. This is also an issue for the block editor. If you navigated away from a page and you didn&#8217;t save a draft, then everything gets lost without this back, forward cache.</p>\n\n\n\n<p>So back, forward cache not only improves performance, giving you the possibility of these instant page loads, but it also preserves that important state on a page that could be lost otherwise.</p>\n\n\n\n<p>[00:26:25] <strong>Nathan Wrigley:</strong> You have a plugin if memory serves, recently in the repo.</p>\n\n\n\n<p>[00:26:30] <strong>Weston Ruter:</strong> Yes. And I got some feedback that it&#8217;s a terrible name, which I agree.</p>\n\n\n\n<p>[00:26:32] <strong>Nathan Wrigley:</strong> What&#8217;s the name? I&#8217;ve forgotten.</p>\n\n\n\n<p>[00:26:33] <strong>Weston Ruter:</strong> It&#8217;s called no cache, bfcache.</p>\n\n\n\n<p>[00:26:36] <strong>Nathan Wrigley:</strong> That was it, yeah.</p>\n\n\n\n<p>[00:26:37] <strong>Weston Ruter:</strong> But if I were to rename it, which I probably will now, it would probably be called Instant Back Forward Navigations or something. It&#8217;s not so short, but.</p>\n\n\n\n<p>[00:26:43] <strong>Nathan Wrigley:</strong> So is the intention to take, are you spearheading that basically? is the intention to roll the learnings from that plugin into Core?</p>\n\n\n\n<p>[00:26:50] <strong>Weston Ruter:</strong> Yeah.</p>\n\n\n\n<p>[00:26:50] <strong>Nathan Wrigley:</strong> And I&#8217;m just going to read this into the record so that everybody understands. You are talking about backwards and forwards by using the buttons, which I guess typically live at the top left of a browser. Those buttons, the arrows that point backwards and forwards.</p>\n\n\n\n<p>[00:27:03] <strong>Weston Ruter:</strong> That&#8217;s right, or the navigation in like the gesture on Android to go back.</p>\n\n\n\n<p>[00:27:07] <strong>Nathan Wrigley:</strong> Yeah, so swipe typically and swipe right. okay. Yeah, that&#8217;s really interesting because I do that all the time. It really hadn&#8217;t occurred to me that was something that could be cached. And if, as you say it&#8217;s 20% on mobile, or 10% on, that&#8217;s a lot of time that you&#8217;re saving.</p>\n\n\n\n<p>Because you do, it&#8217;s a journey, isn&#8217;t it? And sometimes you get to a dead end, and so you just back three times, because you know that you wanted to go back to that product that you saw a minute ago, but you kind of got lost along the way. So that&#8217;s kind of almost like a roadmap item. That&#8217;s 6.9, hopefully. Are there any other things coming in 6.9 that are interesting?</p>\n\n\n\n<p>[00:27:39] <strong>Weston Ruter:</strong> Well, one of the new features in WordPress Core is this Interactivity API.</p>\n\n\n\n<p>[00:27:44] <strong>Nathan Wrigley:</strong> Oh, so nice.</p>\n\n\n\n<p>[00:27:46] <strong>Weston Ruter:</strong> And one of the great things about the Interactivity API is one of its key design principles is server side rendering. So let&#8217;s say you have a navigation block, or you have an image block with a lightbox. All of the HTML and the CSS needed to render those blocks are output on the server. There&#8217;s no need for JavaScript to construct the user interface.</p>\n\n\n\n<p>Nevertheless, there&#8217;s JavaScript needed because there&#8217;s interactivity involved in these interactive blocks. And so with each of these interactive blocks, there&#8217;s a script module that gets added to the page, and it&#8217;s added in the head of the page. And browsers download those script modules with a high priority. And the impact of that is, well, the browser doesn&#8217;t know that these aren&#8217;t important. It could be important, it could not be important.</p>\n\n\n\n<p>But by loading them with a high priority, they compete with loading of more important critical resources like the Largest Contentful Paint image, for example. So by having these modules in the head, then they cause the LCP metric to degrade. And so there&#8217;s a ticket to add fetch priority low to these script tags, which causes the browser to bump them down in priority so that the Largest Contentful Paint image has a chance to load sooner.</p>\n\n\n\n<p>[00:29:04] <strong>Nathan Wrigley:</strong> Yeah. It seems like a game of tennis, this whole thing. For example, the Interactivity API, what a fabulous thing that is, but smuggled into that with something, it sounds unexpected that nobody foresaw that one and okay, need to address that. And here we are, 6.9, that gets addressed.</p>\n\n\n\n<p>[00:29:21] <strong>Weston Ruter:</strong> Yeah, and one of the great things about the Interactivity API as well is that it has really pushed forward the new Script Modules API in WordPress, where what are also called ESM modules or scripts. And these are a new way of writing JavaScript and they are, by default they don&#8217;t block the rendering of the page.</p>\n\n\n\n<p>Whereas if you have a classic script like jQuery in the head of your page, as you start loading the page, the browser has to stop parsing the HTML, it has to fetch the JavaScript, it has to execute the JavaScript, and then because that JavaScript may be doing something like document.write, where it like adds HTML to the page as it&#8217;s executing. Then only after that&#8217;s all finished then the parser can continue and continue laying out the page. So it&#8217;s very bad for performance to have any external, or even inline sometimes, JavaScript in the head.</p>\n\n\n\n<p>And so one way to solve that issue is to slap a defer attribute on that script tag, or an async attribute, and that causes the script to then not block rendering, and it will be executed once the page has finished loading.</p>\n\n\n\n<p>And a nice feature of script modules is that they&#8217;re deferred by default. You can&#8217;t have a blocking script. And so the thinking was, oh, they don&#8217;t block rendering, so we can just put them in the head. But it turns out that they do impact the network, because there&#8217;s other things on the network than just the scripts. And we need to make sure that the critical resources are prioritised, like the LCP image and not just load everything with high priority.</p>\n\n\n\n<p>[00:30:55] <strong>Nathan Wrigley:</strong> It&#8217;s kind of curious because the past of WordPress has been about, you know, you click on links and you generate, I don&#8217;t know a post, a page or something, but you&#8217;ve got this static piece of content, largely. You know, there may be some JavaScript or something, which is doing something fun.</p>\n\n\n\n<p>But the interactivity, API suddenly presents a page which, I don&#8217;t know, you might be stuck on that page for quite a while doing other things. I don&#8217;t know how that leans into the whole performance thing. I don&#8217;t know we could search and filter a bunch of houses or real estate or what have you, and update things. And we are on this one URL but everything&#8217;s getting changed in front of our eyes. So I don&#8217;t know how that whole LCP thing gets bundled into that. It suddenly becomes a much more difficult problem to identify and solve, I guess.</p>\n\n\n\n<p>[00:31:35] <strong>Weston Ruter:</strong> Yeah. So with LCP, it is for that initial page load. So as soon as you interact with the page, then whatever is the largest element then going to be.</p>\n\n\n\n<p>[00:31:47] <strong>Nathan Wrigley:</strong> Oh, that ceases there does it?</p>\n\n\n\n<p>[00:31:48] <strong>Weston Ruter:</strong> Yeah, it stops at that point. However, there are other problems with performance that can arise after that Largest Contentful Paint. So one of the newer Core Web Vital metrics is the Interaction to Next Paint, and that is this INP value. And that is all about how much JavaScript is executing on the page. And JavaScript functions can do a lot of work, so much work that they cause the user interface to appear to halt.</p>\n\n\n\n<p>[00:32:19] <strong>Nathan Wrigley:</strong> Hang.</p>\n\n\n\n<p>[00:32:20] <strong>Weston Ruter:</strong> Yeah, hang. And so that&#8217;s called jank. And it can cause animations to stutter, it can cause a user interface to be sluggish, and you click a button and then nothing happens and then all of a sudden it opens up. And so that&#8217;s an example of a metric that is still very relevant with the Interactivity API. And there&#8217;s been work to establish best practices to make sure that the event handlers for these interactive blocks are using the best practices. Like, it&#8217;s called scheduler.yield, and it allows you to break up a long running task to give the browser a chance to catch its breath so that it doesn&#8217;t cause those long tasks.</p>\n\n\n\n<p>And then another important metric, which continues to matter even after the page is loaded is called the Cumulative Layout Shift or CLS. And that is a very common issue with, where you have ads or something that will just expand as you&#8217;re scrolling down and you lose your place in the page and that hurts your cumulative layout, that CLS score.</p>\n\n\n\n<p>[00:33:19] <strong>Nathan Wrigley:</strong> Yeah. You end up with your finger in entirely the wrong place just as you&#8217;re about to click on things.</p>\n\n\n\n<p>[00:33:23] <strong>Weston Ruter:</strong> That&#8217;s exactly right.</p>\n\n\n\n<p>[00:33:24] <strong>Nathan Wrigley:</strong> Old TechCrunch website. I don&#8217;t know if you&#8217;ve ever came across that one. That was a WordPress one, I believe. And I don&#8217;t know how many times I click entirely the wrong article because it just shifted just at the moment that my finger was descending.</p>\n\n\n\n<p>[00:33:33] <strong>Weston Ruter:</strong> Very aggravating yeah.</p>\n\n\n\n<p>[00:33:34] <strong>Nathan Wrigley:</strong> Yeah, really annoying. We&#8217;re really in the weeds here and what&#8217;s kind of fascinating, obviously you understand it all, I&#8217;m just holding on for dear life here. But it feels as if there&#8217;s a dance between what we&#8217;re expecting the browser to be able to do, and what it actually can do. And I don&#8217;t know if that&#8217;s the case.</p>\n\n\n\n<p>You know, I don&#8217;t know if the fact that I&#8217;ve got a shiny new Mac means that my experience of the web in the future will be better than my 8-year-old Mac over there. That never used to be something that I worried about. It took time to boot that machine, but once it was up and running, that machine was probably just as good at displaying the web as the shiny new one. But now it feels as if that&#8217;s maybe not the case.</p>\n\n\n\n<p>[00:34:13] <strong>Weston Ruter:</strong> It&#8217;s funny you say that because this emoji issue that I described earlier where it was causing this long task as the page was loading, I only discovered that as a problem because I was using a Chromebook as development device.</p>\n\n\n\n<p>[00:34:25] <strong>Nathan Wrigley:</strong> Yeah, notoriously low on specs.</p>\n\n\n\n<p>[00:34:27] <strong>Weston Ruter:</strong> Relatively, that one was even a fast one. But yes, much slower than one of the newer Macs. And so it&#8217;s important to always be testing in an average device, and not always just use the latest and greatest. Because you&#8217;re going to miss performance issues that are probably impacting a lot of users.</p>\n\n\n\n<p>And one of the issues with emojis is, going back to what I described earlier with this long script in the head, now there&#8217;s just an inline script, and even with an inline script, there is still a performance impact where it will stop, because the browser has to stop parsing the page, execute the JavaScript, and then keep going.</p>\n\n\n\n<p>And so I used my new Mac to analyse the performance of that and I didn&#8217;t see a problem. But then I tried the CPU throttling in Chrome Dev Tools where you can emulate low end, low tier device. And in that case, then all of a sudden I saw this 100 millisecond long task pop up, I can&#8217;t remember how long exactly, but it negatively impacted the LCP because it had to spend that time with this underpowered device.</p>\n\n\n\n<p>So, yeah, there&#8217;s many opportunities for optimising things that, if you&#8217;re using devices that people are actually using.</p>\n\n\n\n<p>[00:35:41] <strong>Nathan Wrigley:</strong> I don&#8217;t really know what the expectation is from WordPress over the next decade, but it doesn&#8217;t feel like it&#8217;s going to be limiting itself to websites. It feels like that&#8217;s a portion of it, but Matt Mullenweg often has talked about it being almost like the operating system for the web. Whether or not that will transpire, I don&#8217;t know.</p>\n\n\n\n<p>But certainly for me, a lot of the things that I used to associate with a downloaded app that would run on MacOS or Windows or what have you, I&#8217;m now fully expecting that to be in a browser. And so I expect that the same would be true of our websites. We&#8217;re going to be doing more with them. They&#8217;re going to be requiring more grunt in the background, you know, more interactivity, more filtering, more searching, more database queries. And yeah, I guess WordPress has got to try and keep up with all that.</p>\n\n\n\n<p>[00:36:29] <strong>Weston Ruter:</strong> In improving web performance, it&#8217;s a top down and a bottom up problem. Browsers are working to get faster. They&#8217;re competing with each other, trying to be as fast as possible for all the bragging rights, right? But oftentimes it&#8217;s impossible for the browser to know, even if it&#8217;s as smart as possible, what to prioritise when loading a page.</p>\n\n\n\n<p>So that&#8217;s why when I was working at Google, we were prioritising improving the web at scale through WordPress to implement best practices in how WordPress builds pages so that Chrome doesn&#8217;t have to figure out everything because it&#8217;s impossible for Chrome to figure that out from the top down.</p>\n\n\n\n<p>So if you look at the, over time these Core Vital Metrics, they all consistently are going up and improving, even if a CMS isn&#8217;t necessarily focused on a performance. They all are inching upward. And that&#8217;s because the browser is getting better at performance as well. But when a CMS like WordPress also invests in improving performance, then you can start to see it edging out other CMSs in terms of the relative improvement in performance.</p>\n\n\n\n<p>[00:37:35] <strong>Nathan Wrigley:</strong> Yeah, okay. Let me just parse that. So whether WordPress is at the top or the browser is at the top, you&#8217;ve got this top bottom thing, and it&#8217;s kind of inching in from the top, coming down. Maybe that&#8217;s the browser, and then WordPress at the bottom inching up, if they happily meet in the middle.</p>\n\n\n\n<p>So what you&#8217;re saying is that even if no performance work was done by a Performance Team in WordPress, there would have been in recent years a performance improvement, But the fact that there&#8217;s those two things in symphony with each other means that there&#8217;s a greater performance improvement.</p>\n\n\n\n<p>Given that WordPress, I don&#8217;t know what the number is right now, but the statistic of 43% was always banded around. So it&#8217;s a huge proportion of the internet. Does WordPress have a voice toward Mozilla and Chrome? Does it get to say what the future of browsers might look like? It feels like with that market share, It ought to have a big voice, but I don&#8217;t know if it does.</p>\n\n\n\n<p>[00:38:26] <strong>Weston Ruter:</strong> Well, I remember back when responsive images became a thing, and as I recall that it was WordPress implementing these responsive images that caused browsers to say, okay, we&#8217;re going to implement these now as well. So I think Chrome, I can&#8217;t remember which browser did at first, but it was kind of a catalyst that caused everything to get going.</p>\n\n\n\n<p>And similarly, recently with the speculative loading, it being adopted by WordPress has, I think, caused other browsers to say, okay, we&#8217;re going to implement this as well.</p>\n\n\n\n<p>And yeah, I know that when I was working at Google, and still I&#8217;m in contact with people at Google who work on web standards work, there are initiatives that they&#8217;re working on that they want feedback from WordPress developers to know like, is this going to work for WordPress? And if WordPress can leverage this, and going back and forth between what works for WordPress and what works for browsers and there&#8217;s ongoing conversations, yeah.</p>\n\n\n\n<p>[00:39:25] <strong>Nathan Wrigley:</strong> Yeah, it is kind of interesting. I was talking to somebody from Google, from the Site Kit team, they obviously put up quite a lot of money to be marquee sponsors, if you like. I don&#8217;t know what the word is, you know like a top tier sponsor often at these events. I don&#8217;t know if they&#8217;re sponsoring this one, but there does seem to be some interest from Google.</p>\n\n\n\n<p>I know that Mozilla doesn&#8217;t have the deep pocket, so we&#8217;re not really expecting that. But it&#8217;s nice to hear that, even if it&#8217;s kind of back channels, and it may not be that WordPress gets asked all the time, that there is some sort of symbiosis there. That&#8217;s nice to know.</p>\n\n\n\n<p>[00:39:55] <strong>Weston Ruter:</strong> Well, I remember also seeing recently that Site Kit was voted one of the most trusted WordPress plugins.</p>\n\n\n\n<p>[00:40:01] <strong>Nathan Wrigley:</strong> Yeah, 5 Million plus installs in under five years. And I was kind of surprised by that actually. when I did that interview, I didn&#8217;t realise the numbers were so big. And then after the interview I went out and asked a bunch of random people whether they&#8217;d used it, and a hundred percent of the random selection of 10 people that I asked used it on everything.</p>\n\n\n\n<p>[00:40:20] <strong>Weston Ruter:</strong> Yeah. I use it for sure.</p>\n\n\n\n<p>[00:40:22] <strong>Nathan Wrigley:</strong> Yeah, yeah. It&#8217;s kind of amazing. So just sort of rounding it off a little bit, I&#8217;m guessing that if you were to have your performance hat on, I could be wrong about this. You would be advising people to step away from the classic way of doing things in WordPress with, you know, the classic editor, the classic themes and things. I genuinely don&#8217;t know if there&#8217;s a performance improvement in full site editing, block-based themes, and what have you. Over to you really, it&#8217;s an open ended question.</p>\n\n\n\n<p>[00:40:46] <strong>Weston Ruter:</strong> Yeah, there definitely is a performance benefit to using block themes, and that is because the way that classic themes load, they load progressively where they will print out the head, head tag in the page and then before they render any of the template, they basically locked in the scripts and styles that the page is going to need even though that doesn&#8217;t actually know what&#8217;s going to be in the page for sure. It can make some guesses, but it doesn&#8217;t know for sure.</p>\n\n\n\n<p>And so for classic themes, you&#8217;ll have these massive style sheets that are printed in the head, you&#8217;ll have a whole bunch of scripts that you may or may not use. And as we said before, those scripts may be blocking the rendering and causing all kinds of problems in performance.</p>\n\n\n\n<p>But with block themes, the way that a template is rendered is completely different, where it actually will render all of the blocks in the content first before it goes about rendering the head, the links, the style sheets and the scripts that go in the head of the HTML. And so because of that, a block theme is able to selectively load just the styles and just the scripts that are relevant to the blocks on that specific page. And so the amount of CSS and JavaScript that&#8217;s on a page can be greatly reduced, which greatly improves performance.</p>\n\n\n\n<p>And also, one of the initiatives that we&#8217;ve been working on in the Core Performance Team is related to these responsive images that we were talking about. Where a responsive image, it has all of the different intermediate image sizes that are available. When you upload an image, it&#8217;ll reference all those different image sizes in the source set attribute. And then there&#8217;s the sizes attribute that says which of those intermediate image sizes should be loaded for that image in the page. But because WordPress doesn&#8217;t know classically, in the classic themes, how big an element is going to be, it uses by default the image that is the width of the view port.</p>\n\n\n\n<p>And so on a mobile device, that&#8217;s often fine because images are often the full width of the content. But on a desktop you often have a center column with margins on either side, and maybe the image is going to be in a column or floated to the right. And so oftentimes on desktop, you&#8217;re going to download a much larger image than is relevant to that container on the page.</p>\n\n\n\n<p>And so there&#8217;s a, one of the plugins in Performance Lab is called Enhanced Responsive Images. And what it does is it leverages the block structure in block themes to be able to figure out what the width is for the container of a given image. And then it can craft that sizes attribute to be much more accurate compared to the default sizes attribute. And in my talk, I showed that the performance gains from that enhancement alone are one of the largest that you can have, much more than just using AVIF or a modern image format.</p>\n\n\n\n<p>[00:43:51] <strong>Nathan Wrigley:</strong> Really?</p>\n\n\n\n<p>[00:43:51] <strong>Weston Ruter:</strong> Yeah because, for example, in my test page, I had a jpeg and then I tried it again with an AVIF and the AVIF was 20% smaller, so maybe I could compress it even further. But the Largest Contentful Paint improvement for that was only 2%. But with the Enhanced Responsive Images plugin active, it was able to use a much smaller image size, which is much fewer bites, even as a jpeg compared to the AVIF. And that improved the LCP by I think 45%. So a magnitude and a half higher.</p>\n\n\n\n<p>[00:44:28] <strong>Nathan Wrigley:</strong> It feels like this work is never, ever going to come to an end. There&#8217;s always going to be little things to tweak and squeeze out here, there and everywhere. And there was a really good example just there.</p>\n\n\n\n<p>I think somebody listening to this podcast, if they&#8217;ve got to this point, it&#8217;s kind of really fascinating that most of this stuff would go under the radar for most people.</p>\n\n\n\n<p>I&#8217;m sure almost everything that you&#8217;ve mentioned, for the casual WordPress user, they would never know that that happened. Not many people are going to read the change log or delve into the weeds of what the Performance Team are doing. And yet there it all is, laid out in front of us over the last 40 minutes or so. Yeah, absolutely loads and loads of work. and never ending. You&#8217;ll be here this time next with new things to say.</p>\n\n\n\n<p>[00:45:06] <strong>Weston Ruter:</strong> Hopefully. I don&#8217;t want to work myself out of a job.</p>\n\n\n\n<p>[00:45:07] <strong>Nathan Wrigley:</strong> That&#8217;s absolutely true. Where do you go to find information about this? You know, who are the scholars, or the YouTubers, or the blog post authors? Who are the people that are pushing the boundaries here?</p>\n\n\n\n<p>[00:45:20] <strong>Weston Ruter:</strong> Well, I have recently been loving the WordPress newsletters that go out, like the Repository and Remkus de Vries, his WP, I forget the name.</p>\n\n\n\n<p>[00:45:32] <strong>Nathan Wrigley:</strong> It&#8217;s okay.</p>\n\n\n\n<p>[00:45:33] <strong>Weston Ruter:</strong> It&#8217;s something in, WP in the name. I think, Within WP, but don&#8217;t quote me on that.</p>\n\n\n\n<p>[00:45:36] <strong>Nathan Wrigley:</strong> Oh, it is, Yeah Remkus, Within WP, you&#8217;re right.</p>\n\n\n\n<p>[00:45:39] <strong>Weston Ruter:</strong> Yes. So I subscribe to his performance blog. So Jono Alderson, Jono or Jono?</p>\n\n\n\n<p>[00:45:46] <strong>Nathan Wrigley:</strong> I think Jono. Yeah, we&#8217;ll go with that. And apologies if it&#8217;s not.</p>\n\n\n\n<p>[00:45:49] <strong>Weston Ruter:</strong> Yes. And so all of his posts are brilliant, so yeah. And then, yeah, following just the newsletters, because I don&#8217;t have time to keep up on social media anymore, but I really am thankful for those newsletters because it really saves me a lot of time. It gets me what I need to know.</p>\n\n\n\n<p>[00:46:05] <strong>Nathan Wrigley:</strong> Yeah, I will, link to the ones, the three that you&#8217;ve just mentioned.</p>\n\n\n\n<p>Yeah, that&#8217;s amazing. Thank you. Honestly, it seems a bit trite, but I&#8217;ve been following what the Performance Team have done for the last four years now, from the capacity that I have to understand it, which is pretty low in all honesty. You know, most of what you&#8217;re saying, I can get a purchase on the overarching idea, but as soon as you were to draw back, if you were to show me what you were doing, the code and so on, I would immediately lose my purchase.</p>\n\n\n\n<p>I&#8217;d just like to express how profoundly happy I am that people like you are taking the time to do it. I don&#8217;t know how much thanks you get for stuff like this, but for my part, thank you.</p>\n\n\n\n<p>[00:46:42] <strong>Weston Ruter:</strong> Well, thank you, but no thanks are required because I enjoy doing it, so.</p>\n\n\n\n<p>[00:46:45] <strong>Nathan Wrigley:</strong> Yeah, great. Well thank you. anyway.</p>\n\n\n\n<p>[00:46:46] <strong>Weston Ruter:</strong> I&#8217;ll do it anyway.</p>\n\n\n\n<p>[00:46:47] <strong>Nathan Wrigley:</strong> Yeah, well Weston Ruter thank you so much for chatting to me today. It&#8217;s been a pleasure.</p>\n\n\n\n<p>[00:46:51] <strong>Weston Ruter:</strong> Thank you very much.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://weston.ruter.net/\">Weston Ruter</a>.</p>\n\n\n\n<p>Weston Ruter is a long-time WordPress user and contributor. He has been a core committer for 10 years and he co-led the WordPress 4.9 release. He worked in the WordPress agency space and has also been sponsored to work on the Core Performance Team. He lives in Portland, which, as you will hear, was quite handy for this interview.</p>\n\n\n\n<p>We start the conversation by getting into the big picture: why website speed matters more now than ever, and how WordPress performs out of the box. Weston shares details about measuring true performance, revealing, for example, that achieving a perfect Lighthouse score isn’t the end game, and that real user experience metrics like Core Web Vitals and Largest Contentful Paint (LCP) should shape how developers and site owners think about optimisation.</p>\n\n\n\n<p>Throughout the episode, you’ll learn about the advances made by the WordPress Performance Team, from lazy loading and new image formats, to speculative loading that shaves precious milliseconds off page transitions. Weston explains how many performance improvements are designed to work automatically, democratising speed so even casual WordPress users benefit without needing to be technical experts. The conversation also touches on the balance between adding features and avoiding plugin bloat, the hidden impact of browser and device differences, and how large companies like Google are working hand-in-hand with WordPress to raise the bar on speed and usability.</p>\n\n\n\n<p>Weston offers practical tips, deep technical wisdom, and a glimpse of where WordPress performance is heading next, and it’s sure to inspire you to think differently about how your sites load, how your users engage, and how you can squeeze out every last drop of speed from the platform you love.</p>\n\n\n\n<p>Whether you’re a developer, designer, site owner, or just someone curious about what keeps the web running smoothly, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2025/session/the-site-speed-frontier-with-performance-lab-and-beyond/\">The Site Speed Frontier with Performance Lab and Beyond</a> &#8211; Weston&#8217;s presentation at WordCamp US 2025</p>\n\n\n\n<p>A post about the presentation (above) on <a href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/\">Weston&#8217;s own website</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/Accelerated_Mobile_Pages\">Accelerated Mobile Pages (AMP)</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/performance/\">WordPress Core Performance Team</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/lighthouse/\">Lighthouse</a></p>\n\n\n\n<p>Podcast &#8211; <a href=\"https://wptavern.com/forums/topic/171-felix-arntz-on-how-speculative-loading-is-speeding-up-your-wordpress-website\">Felix Arntz on How Speculative Loading Is Speeding Up Your WordPress Website</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab plugin</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/crux\">CrUX</a> &#8211; Chrome User Experience Report</p>\n\n\n\n<p><a href=\"https://web.dev/articles/lcp\">Largest Contentful Paint (LCP)</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check (PCP)</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/fetch-priority\">Optimize resource loading with the Fetch Priority API</a></p>\n\n\n\n<p>Podcast &#8211; <a href=\"https://wptavern.com/podcast/178-adam-silverstein-explores-transformative-browser-features-impacting-wordpress-sites\">Adam Silverstein Explores Transformative Browser Features Impacting WordPress Sites</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/bfcache\">Back/forward cache</a></p>\n\n\n\n<p>Weston&#8217;s <a href=\"https://wordpress.org/plugins/nocache-bfcache/\">Instant Back/Forward plugin</a> (mentioned in the podcast with an older name)</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API Reference</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">Script Modules API</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/inp\">Interaction to Next Paint (INP)</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/blog/introducing-scheduler-yield-origin-trial/\">Introducing the scheduler.yield origin trial</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/cls\">Cumulative Layout Shift (CLS)</a></p>\n\n\n\n<p><a href=\"https://sitekit.withgoogle.com/\">Site Kit plugin</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/auto-sizes/\">Enhanced Responsive Images plugin</a></p>\n\n\n\n<p><a href=\"https://withinwp.com/\">Within WordPress</a></p>\n\n\n\n<p><a href=\"https://www.jonoalderson.com/\">Jono Alderson&#8217;s website</a></p>\n\n\n\n<p><a href=\"https://www.therepository.email/\">The Repository</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Matt: D’Angelo &amp;amp; Diane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2025/10/dangelo-diane/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1141:\"<p>Just last night I was re-watching <a href=\"https://en.wikipedia.org/wiki/Annie_Hall\">Annie Hall</a> to remember and <a href=\"https://www.newyorker.com/culture/postscript/diane-keatons-shadows-and-light\">honor Diane Keaton</a>, and now <a href=\"https://www.nytimes.com/2025/10/14/arts/music/dangelo-dead.html\">the  news that D&#8217;Angelo had passed</a>. I&#8217;m writing this listening to <a href=\"https://open.spotify.com/album/2lO9yuuIDgBpSJzxTh3ai8\">Voodoo</a>, one of the great albums of all time. That CD in my beater car in Houston was on constant rotation, the richness of the tracks— it&#8217;s an album you have to listen to in its entirety, it takes you on a journey, the way the tracks blend in to each other. Not ideal for the atomized world of songs being stand-alone.</p>\n\n\n\n<p>D&#8217;Angelo was obviously a star, but one amazing thing about his bands is he brought so many people with him, so many amazing jazz musicians, including Roy Hargrove, Robert Glasper (<a href=\"https://khspva.houstonisd.org/\">HSPVA</a>!), Chris Dave (HSPVA!), Kenny Garrett, Pino Palladino, Questlove&#8230; May his memory be a blessing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Oct 2025 03:49:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Open Channels FM: Why Focus Matters When Building a Successful WordPress Plugin Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://openchannels.fm/why-focus-matters-when-building-a-successful-wordpress-plugin-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"Learn the importance of focus in scaling a WordPress plugin, advocating for prioritizing core products over numerous side projects to achieve long-term success.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 11:38:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Open Channels FM: How Great Storytelling Builds Brand Loyalty and Differentiates Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111053\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://openchannels.fm/how-great-storytelling-builds-brand-loyalty-and-differentiates-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"In this episode, Rae and Adam dig into why storytelling is key for brands to shine in WordPress, sharing tips on connection, differentiation, and authentic messaging.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Nanochat &amp;amp; MCP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150223\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/nanochat-mcp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1156:\"<p>Probably the most interesting thing on the internet today is <a href=\"https://x.com/karpathy/status/1977755427569111362\">Andrej Karpathy&#8217;s nanochat</a>, &#8220;a minimal, from scratch, full-stack training/inference pipeline of a simple ChatGPT clone in a single, dependency-minimal codebase.&#8221; 8,000 lines of beautiful code, <a href=\"https://simonwillison.net/2025/Oct/13/nanochat/\">as Simon Willison notes</a>. If you want to understand how LLMs work, <a href=\"https://github.com/karpathy/nanochat\">study this</a>. Andrej is a code poet.</p>\n\n\n\n<p>In hacking news, Wired has <a href=\"https://www.wired.com/story/satellites-are-leaking-the-worlds-secrets-calls-texts-military-and-corporate-data/\">an amazing article on intercepting geostationary satellite signals</a>.</p>\n\n\n\n<p>On Friday, we turned on something cool: <a href=\"https://wordpress.com/blog/2025/10/07/mcp/\">every WordPress.com site now supports MCP</a>. Right now this is read-only access to your site, because the S in MCP stands for Security, but <a href=\"https://developer.wordpress.com/docs/mcp/prompt-examples/\">you can already start to do some cool stuff with it</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 06:07:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: Last Ball\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150219\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/10/last-ball/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"<p>If you appreciate golf at all, <a href=\"https://www.espn.com/golf/story/_/id/26902640/down-last-ball-how-tiger-avoided-disaster-won-2000-us-open-15\">the story of how Tiger Woods won the U.S. Open at Pebble Beach without knowing he was down to his last golf ball because of arcane rules is pretty interesting</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Oct 2025 06:36:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Gutenberg Times: Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=42245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67394:\"<p>In episode 122 of the GT Changelog podcast, host Birgit Pauli-Haack is joined by Beth Soderberg, CEO of bethink Studio, to discuss the latest updates in Gutenberg 21.8 and WordPress 6.9. The conversation kicks off with reminiscing about past WordCamp experiences and transitions into a deep dive on block themes, evolving design tools, and the challenges of adopting new workflows. Beth shares practical insights from her agency work, highlighting the benefits of section and block styles, synced patterns, and strategies for cleaning up legacy code as Gutenberg advances.</p>\n\n\n\n<p>The episode covers new features like section styles, the highly anticipated accordion block, and improvements to template management, aimed at making theme and site building more flexible for users and developers. They also talk about experimental features such as PHP-only blocks, block bindings, and upcoming blocks like breadcrumbs and table of contents, which promise to streamline site navigation and content organization.</p>\n\n\n\n<p>Birgit and Beth underscore the importance of continuous testing and learning, encouraging listeners—especially those hesitant to adopt block themes—to experiment, seek support, and embrace gradual change. The episode wraps with practical advice, recent security updates, and a look at promising innovations coming to the WordPress ecosystem.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor: <a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Special Guest: Beth Soderberg</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://bethink.studio/\">Bethink Studio</a></li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/bethsoderberg/\">WordPress.org Profile + Slack </a></li>\n\n\n\n<li><strong>Talks by Beth Soderberg</strong>\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.tv/2025/07/25/my-process-for-building-a-custom-wordpress-theme-in-2025/\">My Process for Building a Custom WordPress Theme in 2025</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/2020/04/16/bill-ericksonellen-bauer-beth-soderberg-case-studies-how-to-prepare-your-theme-for-gutenberg/\">Bill Erickson,Ellen Bauer, Beth Soderberg: Case Studies &#8211; How to Prepare your Theme for Gutenberg</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/?s=beth%20soderberg&amp;sort=newest\">And more</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Calls for Testing WordPress 6.9 </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\">Template management</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\">Accordion Block</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Community Contributions</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#blocks-galore-with-telex\">Block Galore</a> by designers and developers using Automattic’s Telex </li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/block-commenting-fun-with-telex-from-classic-to-block-theme-weekend-edition-341/#building-blocks-with-telex\">Moar Blocks</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s Released</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\">WordPress 6.8.3</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/\">What’s new in Gutenberg 21.8? (8 October)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">New Blocks still in the works</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/71588\">Time to Read</a> (m) </li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://href.li/?https://github.com/WordPress/gutenberg/pull/64119\">Accordion Block</a> (m) </li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/71793\">Breadcrumbs Block</a> (m)</li>\n\n\n\n<li><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/70720\">Terms Query block</a> (m) </li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71618\">Dialog Block </a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71227\">Icon Block</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71904\">Stretchy Text</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/69789\">Tabs Block</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/42229\">Table of Contents block</a></li>\n</ul>\n\n\n\n<p><img alt=\"🟣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> = already merged into trunk, as experiments. </p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello and welcome to our 122nd episode of the Gutenberg Changelog. In today&#8217;s episode, we will talk about Gutenberg 21.8 and WordPress 6.9, what we already know about it. And I&#8217;m your host, Birgit Pauli-Haack, curator at Gutenberg Times, co contributor on the Word Open Source project, and I work as a developer advocate for Automattic. I&#8217;m thrilled that I finally have Beth Soderberg join me on the show. Beth is the CEO of Bethink Studio, a special web design and development agency in Alexandria, Virginia, in the U.S. Beth, welcome to the show. How are you doing?</p>\n\n\n\n<p><em>Beth Soderberg:</em> Thank you. Welcome. Welcome to my morning. I&#8217;m doing great. Good to see you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So I tried to recollect how we actually met or we met over the last few years, and I think it was the first time we met at the WordCamp New York in 2019.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think that&#8217;s right. Ish. I definitely have eaten tacos late at night at WordCamp New York. Okay, so that tracks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And I definitely met you sometime before the pandemic, so I&#8217;m not sure exactly, but that sounds about right. And then I know we had lunch at WordCamp us when it was in San Diego.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Oh, okay. Nice. Oh, right. We had this.</p>\n\n\n\n<p><em>Beth Soderberg: </em>There was.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>There was a group of women kind of coming together.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah, I saw a table of women. And if I see a table of women at a conference like that, I&#8217;m going to sit down at it. And you did exactly the same thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Nice. So.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But that&#8217;s the first time I saw you after the pandemic, for sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. And in between, I think we did together the WP Blog Talk virtual conference that was organized by Automattic, but there were a lot of community members in there talking about the Gutenberg and the stage of it and all that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That was when I realized that I don&#8217;t like presenting at virtual conferences in front of audiences that you can&#8217;t see.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, it&#8217;s interesting.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I&#8217;m good with Zoom, because you can get some feedback. But the speaking into the void was. I don&#8217;t know. It could have also been that I wasn&#8217;t speaking to anyone in real life at the time, so it felt extra weird.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, no. I get it. The pre-recording and then just be there for the live part of it. But we had a great live discussion there.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I. It was fun. And we actually did the presentation live. I think that could be why later things were recorded, because it was a really weird experience. It was very strange because you knew you were live. You had no idea if even your audio was working, but you just kind of had to keep talking. And, yeah, it&#8217;s the least feedback I&#8217;ve ever had from anything I&#8217;ve ever spoken at. And I think that not even being sure that the technology was working part. Like, even that level of feedback wasn&#8217;t there. It was fun. And hopefully next time I do something like that, it will be recorded in advance.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. But it was a. It was a good place talk because it was kind of together with Ellen Bauer, and you had 15 minutes, Ellen had 15 minutes. And I think Bill Erickson was there as well.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>There were three of us.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And every one of you kind of took a different take on the block themes. Yeah. And that was really interesting to kind of. Well, we started out in 2020 with that. Yeah. Now it&#8217;s five years later, and we finally connected again at WordCamp. Us, because I made it there again.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I know. I was excited to see you. And I think. Yeah, I mean, doing that talk was interesting. I think there&#8217;s still some divergence around how people are building and how people are utilizing the tools. That set of like 15-minute talks was a really good microcosm of that because each one of us had been actively building with all of the new tools and had a slightly bigger, different approach. I still think there&#8217;s some divergence there, but we&#8217;re starting to see some patterns of, like, actual best practices with the new tools, which I think is really exciting. And also it&#8217;s fun to sort of invent on the fly. Like, okay, how should this work as the people who really are using it with clients right away, what is the standard we want to set? What does and doesn&#8217;t work? And I think that was still in a time period where we were learning so much about what you could do, what the restrictions were. I know in a lot of what we&#8217;re going through today, there&#8217;s like little tiny changes that end up being so impactful. Right. Like, my favorite thing I hated from that time period was it could have been a little earlier, I don&#8217;t remember. But originally you couldn&#8217;t set text colors on lists.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Oh, yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Stuff like that. Where it&#8217;s so small, but when it&#8217;s missing, it&#8217;s a big problem.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So, yeah, I think that a lot of work has been put into having consistent design tools for each block that you can control through the theme JSON file and then make it really a unique experience or unique design for your clients. Yeah, that&#8217;s definitely something there where you don&#8217;t, oh, I can&#8217;t do the fonts. Yeah, well, I guess I need to do a variation of it. So there was a lot of coding done to kind of get around those restrictions. How do you feel about kind of ripping out all this additional around coding now that certain things are in core and that are available? Does that kind of trip you up a bit?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I feel great about it and there&#8217;s not that much I need to rip out. Some of that is because of how I&#8217;ve built things over time. Some of that is because things like the tab block, which I am so excited about, I know it&#8217;s not ready and all that, but I have a few sites where I have random solutions for that, but I&#8217;ve got them compartmentalized. So pulling them out and putting in something new that makes more sense is going to be easy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because I know, you know, like, especially something like the tabs, they don&#8217;t appear that often. And the other thing with stuff like that, you can just search the database for the machine name of block to find where you&#8217;re using it. I do that a lot and sometimes I don&#8217;t know. I ripped Jetpack out of a site recently because it was only being used for slideshows in like six blog posts. There was no need for it. And it might have been more than six, but still this is a major publishing website that has thousands of posts. They didn&#8217;t need Jetpack sitting there doing this like a very minor task. And so that&#8217;s one of my tactics for sure. When I&#8217;m going to rip something out. People forget that you can search easily. Not even in the database. You can use the WordPress search. Search.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Right. For the posts. Yes. Yeah, that&#8217;s what I do. Yeah. Kind of. You can kind of put the blog name in there and then see which post uses what block, especially the third party blocks. When you find out, okay, I have now three query blocks and core blocks and why am I doing this to me?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And I&#8217;ve always been pretty conservative about what I&#8217;ll add.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>So I think that&#8217;s part of why it&#8217;s not super daunting to me. Because if I can make it work with the tools that exist, I will.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I&#8217;m not going to over engineer it just because I could. And that makes it easier to clean up long term.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I think the last big feature that was introduced to theme development was the section styles. Style variation in one and then the section styles, the smaller things and block styles, now that you can edit them in the global styles. How much do you use about that? Is that something that comes up quite a bit in your work?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I use them a lot. Especially when you&#8217;re dealing with semantics, I want to give people the ability to have something look the way they want it to look, but also be semantically correct. So especially with things like headings. Right. Having tooling that&#8217;s easy for an end user to understand to say this should be an H2, but I would like it to look like an H4 without making it an H4 is a game changer. It improves SEO, it improves accessibility, it keeps everything cleaner. And so that kind of tooling, I think when used strategically can really help. When used randomly, you&#8217;re just going to confuse people. But you know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, aren&#8217;t we in the business of confusing people?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, sometimes. Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>All right. Yeah, no, it&#8217;s interesting too. So are you using also side styles variations or just the section styles or block styles?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Heavily using block styles. Okay, not so much the whole site variations yet. Yeah, there hasn&#8217;t. It&#8217;s again, it&#8217;s like you want to use the right tool for the right use case and yeah, normally you don&#8217;t.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Want to change how the site looks.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. There&#8217;s only. You kind of need like a site within a site to make that required. And the only thing like that I&#8217;ve been building lately is a voter guide that&#8217;s like within a site but the voter guide has all the same styling as the rest of the site. Because it&#8217;s supposed to match.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, right. Right. Yeah. Yeah. I&#8217;ve always felt that the style variations are more for theme product developers that want to give more options to modify the theme. For agencies, I didn&#8217;t see that there are a whole lot of use cases for. For them. I might be wrong, but. Yeah, but you&#8217;re kind of confirming a little bit my bias here.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I. I don&#8217;t know. I look at anything that&#8217;s coming in that&#8217;s new. I look at it in terms of strategic utility and there&#8217;s a bunch of stuff that is super cool but it&#8217;s just not necessary for my clients. Right. Like it&#8217;s not the use case for that but for somebody else that could really help. And I&#8217;ve had a few where you end up building this random micro site within the site because some weird reason why they need it. And like that&#8217;s really what you would use that for. It doesn&#8217;t happen all that often.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So yeah. Do you apply section styles to your patterns? Yeah, so that. And you give them design choices and they don&#8217;t have to spend time with kind of reorganize their design just because they want to have a pair of a pink background or a yellow background or something like that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. I also, I restrict color palettes, of course, because we don&#8217;t want anything looking like, you know, we&#8217;re in the. We&#8217;re in some sort of sci fi. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: Geocities. </em>I&#8217;m dating myself now.</p>\n\n\n\n<p><em>Beth Soderberg: </em>It&#8217;s okay. I told the checker at the grocery store the other day about how I worked at Blockbuster in high school and how that dated me, but it was a good job because you could I had to walk around to put the movies back. So I also use a lot of synced and partially synced blocks to achieve design consistency. So paired together. Because that I have found is really good for editorial teams where you can give them a style guide. And usually I make a page on the inside of the site that&#8217;s just privately published so that they can see like, okay, we have these patterns to work from. And, you know, this is the human part. You have a discussion about how, yes, you can do all these things, but you should use these things that we&#8217;ve all agreed upon that follow the style guide.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Well, it also makes for production much, much faster when you don&#8217;t have to make those design decisions. They&#8217;re already there and then.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Exactly. And you don&#8217;t have to train people. I mean, the number one thing I see real clients, real site administrators doing weirdly with formatting is inconsistent vertical spacing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>The tooling is there to make it consistent, but people don&#8217;t. Even if you train them, they&#8217;re like, wait a minute, do I pick it at the fourth hash? Or like, which setting is it again? And does that look. And like as much as I can look at spacing on anything and know if it&#8217;s wrong, many people cannot.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, no, no. Yeah. That&#8217;s a skill.</p>\n\n\n\n<p><em>Beth Soderberg: </em>It&#8217;s a skill.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>And many people really. And I found that like syncing those patterns that way and getting. Locking down some of that basic stuff that like, you don&#8217;t want your end user to be thinking about how much space they need below something.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Like that&#8217;s not what they should be ever actively thinking about. So that&#8217;s how I have approached that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah. So far. Yeah. Makes sense. Have you taken a survey of how often your clients actually use the spacer block? Because I found that WordPress.com that&#8217;s one of the top five blocks used, I.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Have not, but now I&#8217;m curious and I. Some of them, I mean you definitely have some, some where it&#8217;s used more than it should be. But I think that we&#8217;ve avoided some of that and some of it is what we&#8217;ve been able to do recently. Right. A few years ago you had to use it if you were going to get any consistency at all across things. But I think sometimes the patterns and the pattern syncing, that type of thing has dramatically reduced the need to use the spacer block, which is great because the speaker, the spacer block is so annoying on mobile.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, that&#8217;s one thing. It&#8217;s also, you cannot rip it out when, when you redesign the site or something like that, it&#8217;s going to be the. In your content.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah. So I mean, I haven&#8217;t seen similar dislike as it sounds of the spacer block, but when you shrink a screen down suddenly you get wildly different vertical spacing on mobile. And for the average person there is not a straightforward way to make it not do that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>You have to know how to write a workaround for yourself to make it work and that&#8217;s not great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So. Yeah, well, yeah, it&#8217;s good to know. So before we head into our usual sections, is there anything else that you would like to tell people who have not yet done the jump into block themes, why they should do it?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think, I think that it is, it&#8217;s a scary jump, and I have always been an early adopter of the new tooling, and so I look at something like that and it freaks me out a little bit. And then I&#8217;m like, well, why not? And I just push myself through and I know that I have the liberty of doing that because I&#8217;ve been working independently for almost 10 years. So I am in a lot of ways in control of what is and is not allowed in my environment. I&#8217;ve talked to a few folks who have. They understand how it&#8217;s working and they, they personally buy in, but their employer does not.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>And so for those folks, I think building up your skill set with your personal site or a personal project so that you can advocate for different things internally. It&#8217;s very hard to advocate for something that you haven&#8217;t done and that you don&#8217;t have hands-on experience with. But you know, the ability to spin up a little like MVP demo of, hey, this is how this would solve a problem that we have systemically is really how you sort of gain permission in those sorts of environments. There&#8217;s some really good resources out there on learning how to do this. I think that they are much harder to find than they used to be. When I was first learning how to code, it was much easier to find like beginner entry level stuff, to like level yourself up. And now I think fewer people are creating it and I think it&#8217;s harder to find just because of how it&#8217;s labeled. Everything starts to look the same because it&#8217;s all named the same. But I think giving yourself the challenge to &#8211; even if you don&#8217;t understand everything, listening to a podcast like this, listening to a talk that you&#8217;re finding online, having it playing in the background like it does, seep in to how you think about it. And what will happen is that later you&#8217;ll encounter the same subject again and you&#8217;ll be like, oh, wait, that&#8217;s what they were talking about. And that&#8217;s how you start to connect the dots when you&#8217;re learning anything new. And I think the idea that you&#8217;re going to get somebody who has been building themes the classic way, building themes that are heavily reliant on advanced custom fields, something like that, to just magically one day pick up a whole new set of tools with a whole different way of thinking and be completely comfortable from the get is like ludicrous. That&#8217;s not going to happen.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But, you know, giving yourself the ability to slowly absorb it, because it is a different way of thinking, it&#8217;s a completely different way of thinking about how to structure the theme. And for me, that has been the hardest part to learn. Once I figured it out, it was great. But of course, it&#8217;s always the hardest thing to figure out a new way of thinking. When you say it like that, it&#8217;s so obvious. But I think people really get down on themselves about it. And I think really just paying attention, reaching out to folks, you know, when you have questions, not being shy about it. What I&#8217;ve figured out over the course of the last, I guess we&#8217;re almost at eight years of Gutenberg. Yeah, Gutenberg is a month older than my eldest child. So it&#8217;s very easy for me to keep track of how old it is. But we are in a time period where what I have noticed as an early adopter, when I talk to the other early adopters, everybody is making it up. Everybody is inventing their process, everybody is inventing the “ right way.” We&#8217;re starting to congeal on some common things. But it has been a time of innovation. And so being a little bit afraid to stick your toe in. That is so reasonable. And at the same time, when you think about it that way, it becomes less scary to fail in air quotes. Right. Because ultimately, how many light bulbs did Edison make before one worked? Like, it&#8217;s just, you know, you have to experiment in order to figure out how something works. And I think it is challenging to be mid-career and have to go back to that beginning.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>You know, Yeah, I feel a certain.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Confidence that all of a sudden is going away.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah. So. So I. I just think people need to be a little less hard on themselves, push themselves a little, be okay with failing and talk to people, talk to people. Just keep going, Just keep swimming, as the fish say in Finding Nemo.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. All right, so you&#8217;ve listened here to a very experienced theme developer and yeah, it&#8217;s never going to be easy. You need to start now. What is it, the Chinese proverb to the best time to plant a tree was 20 years ago. The second best time is now. So it&#8217;s kind of exactly for that. Yeah. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p>So, okay, so we have a few announcements. Now we&#8217;re going a little bit into the Gutenberg change log message here. We have a few announcements and they&#8217;re all calls for testing because we get new stuff and. And the testing team is really on top of things. Last week a call for testing was made for the new template management features that are coming to Core, which. have you checked it out, Beth, on what&#8217;s going to come with that? We talked about it here two weeks ago with Anne Katzeff and it&#8217;s the tool where you can now have multiple templates with the same slug and of the theme hierarchy and then activate and deactivate the ones that you want to use or not use. So it kind of puts a new layer in there and gets the user a little bit more in control on how the template management actually works and figure that out in there. Because template management is something WordPress users have never done before because it was always a developer designer kind of scope and there was no user interface for it. And now it&#8217;s here and the confusion is there, but it&#8217;s also something that can be learned and can be helped with.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I think it&#8217;s also going to be great for launching changes to live sites where. And you know how to launch code for Gutenberg is a whole other conversation. But the best practice is to keep your live site database as your database of record. Right. And some of what I see with the new template management changes are enabling you to more easily respect that without having weird, momentary blips of your content looking bizarre while you&#8217;re changing something over on a live site. So I think it&#8217;s going to be, again, another adjustment in how we think about how we work. But ultimately we&#8217;ll offer more granular tooling that will allow for the elimination of some of these use cases that haven&#8217;t always ended up being really strange, where you&#8217;re like, yeah, should we put up a maintenance message while we&#8217;re doing this? Because everything is going to look bizarre for the next 20 minutes. That kind of stuff. I think it&#8217;s going to be good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>It&#8217;s really good. Yeah. Yeah. And the first version is going to be not perfect and probably have some bugs, but that&#8217;s why the call for testing is there. So I leave the link in the show notes for you so you can start testing and share your experience with it and also share what still confuses you or what didn&#8217;t work or where you thought it would work, but it didn&#8217;t. It&#8217;s definitely something &#8211; conversation needs to happen. And if you are not sure what to do, come into the W in the WordPress Slack into the Outreach channel and there are a lot of people there that will help you figure that out. So if you don&#8217;t know if it&#8217;s a bug or you don&#8217;t, you&#8217;re not doing it right. I know that&#8217;s often kind of that with new things. Did I get this right or is it not working? Most people, and I&#8217;m one of them, I default to okay, I&#8217;m not doing this right. What&#8217;s happening? And there are two more console testing. </p>\n\n\n\n<p>One is on the ability to hide blocks, which is kind of the first iteration of a blocks visibility kind of plugin idea that you can hide and show blocks conditionally. Right now it&#8217;s only on and off or hide and show. So you could have a block in the editor, but you hide it on the front end. But because you&#8217;re still working on it or you don&#8217;t want to, you want to put it in there so your editor knows about it, but it&#8217;s not going to be pushed to the show version until a certain date or until a certain sale happens or something like that. The instructions for the call for testing are really good and they also show you with little videos how it&#8217;s supposed to work to kind of offset my am I doing this right or not? Idea. And the other one that I wanted to point out in this podcast is the accordion block calls for testing. That seems to be really settled. Came in 20.5, I think, and had some iterations, especially for those of you who started styling it. You need to double check your references because the name changes in between for the panel and for the items and all that. So call for testing for accordion block and what you can do with it. Have you experimented with the accordion block?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Mm, I&#8217;m really excited about it. This is one of the ones that I&#8217;ve been dreaming of for years. It&#8217;s one of the ones where I had an external plugin where like, the only reason I was using the external plugin was because I needed accordions. The detail block is sort of an approximation, but it&#8217;s not the same semantically speaking. So I&#8217;m excited about this one. This one and Tabs are my two that have been a thorn in my side for years.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I&#8217;m also. Well, we can talk about the other blocks that are supposedly come or at least been worked on for Core, even if they don&#8217;t make it into 6.9 at a later date. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions</h3>\n\n\n\n<p>There&#8217;s this new AI feature out there, it&#8217;s called Telex, which is automatic block building AI. And there are a few designers and developers that have actually done some great experimentations with that. One is Tammy Lister. She has started a challenge, kind of the blocktober, meaning every day in October she will build a new block with Telex. And I&#8217;ll of course share the site in the show notes. She started out with a kind of reaching back into history of computers and started out with an esky Tetris game. And that&#8217;s when my afternoon, uploaded my afternoon was shot because I got addicted to Tetris again. Yeah. Did you do any experimentations with that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Nope. That one, I mean, I know about it, I know about Tammy&#8217;s blocktober. I&#8217;m paying attention, but I don&#8217;t have time to just play with it right now.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, I. I feel the same way. It&#8217;s kind of letting other people do that. I. I look at what other people do. Yeah. And there&#8217;s Marco Ivanovich. He&#8217;s a designer at Automattic. He has some animated icon blocks. They were kind of sparkling and all that. And then he also created a post-it note block where you can put post-its on your site with an image and with a background gradient background. So pretty cool to look at. </p>\n\n\n\n<p>And then there was Jeff Paul from Ten Up. He actually also created a game of Pong Hung block that&#8217;s kind of the tennis kind of back and forth where you need to up. It was just handy as an easy, medium and hard. Yeah, that was another afternoon. I tried to figure it out. Yeah. Juan Margarito, he created a mermaid diagram which is actually a markdown diagram. And then you put the. The diagram code in markdown and then it kind of creates a. A diagram with errors back and forth. Yeah, it&#8217;s kind of a flow diagram if you want to. So that was really interesting to see. Yeah. Anyway, so I just. Yeah, check it out. If you want to play around with it. It&#8217;s telex.automattic.com automatic with double T. The second T. Yeah.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; WordPress 6.8.3</h3>\n\n\n\n<p>Okay. So now we come to the heart of the show, which is what&#8217;s released. And before we head into Gutenberg 20.8, I wanted to let everybody know WordPress 6. 8.3 is out. It&#8217;s a security issue. No, it&#8217;s a security release fixing two security issues. And if you haven&#8217;t updated yet, please do we wait. Go and update. The two issues were mentioned in the release post. One was data exposure issues and the other one issue and the other one was a cross scripting vulnerability for the nav menus which has been fixed and you are in a secure environment again. But don&#8217;t forget to update. Yeah. Any thoughts?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Always update. I&#8217;m. I&#8217;m of the. I&#8217;m of the camp. I always update on the security releases right away and then major releases. I always wait and see what happens.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>How long do you wait? How long do you wait?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I usually wait until a point release has come out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Okay.</p>\n\n\n\n<p><em>Beth Soderberg:</em> That&#8217;s usually the trigger but sometimes it&#8217;s really stable and we&#8217;re like, well there. I guess there&#8217;s no point release and it&#8217;s been three weeks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I do the same thing with updating like my iPhone. Yeah, I don&#8217;t. I&#8217;m. As much as I am interested in technology, I am also somebody who just recently started using mobile deposit for checks. I&#8217;m skeptical.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, I think that makes that an early above to decide where to early adopt and where to be cautious.</p>\n\n\n\n<p><em>Beth Soderberg:</em> That&#8217;s true. Yeah. My risk tolerance is very high for certain things and very low for other things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And if it changes my work environment that I need to retrain my muscle memory. I&#8217;m opposed to any change, but I recently had to change my Mac updated and they fixed a bug. That&#8217;s the problem with bug fixes. Yeah. If you, if you have for years known about a workaround and the muscle memory is in. You hate that bug fix that fixes that once and for all. So kind of. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Anyway, that&#8217;s a whole other conversation. Moving on.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Thank you. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 21.8</h3>\n\n\n\n<p>So Gutenberg 21.8 is the second last before 6.9 beta. There&#8217;s one more coming, that&#8217;s a 21.9, of course, and that&#8217;s coming on October 17th. So we are recording this on October 8th and next week we have the last Gutenberg release before 6.9 beta comes. Which means bug fixes, yes. New features, no. From that point on forward to get into Core. Gutenberg 21.8 had 118 PRs by 47 contributors and five people were first time contributors. Congratulations, you got your merge done. That&#8217;s fantastic. Because I can see that the first one is always a little tricky getting it past the reviewers. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>For Gutenberg, we start with the enhancements to the block content. Comments. Block comments is a feature that creates a commenting method for each block in your editor so you and others can add comments to your blocks and have an editorial kind of process going. It&#8217;s a a lot of PRs made it into that. But the first one that I wanted to point out is a discussion field with trackbacks and comment status aggregated for the post page Quick Edit. So you know, in the Quick edit, are there commenting places? Quick Edit is not the quick edit in the WP admin. It&#8217;s a quick edit in the design. But that&#8217;s actually not the commenting. The block commenting thing.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Yeah, this is hard to contextualize even looking at the PR, right? Yeah, the PR. I think ultimately it&#8217;s unifying. It&#8217;s again, it&#8217;s one of those things that&#8217;s unifying design across components to make things more consistent no matter where you find them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So when you have the new design view, what was missing that you were able to manage trackbacks and comments. So it&#8217;s not the feature that I just said. It&#8217;s just getting on par with the previous WP admin kind of thing. Especially for pages. The posts haven&#8217;t been included yet in these new designs, but for pages, definitely. And if there&#8217;s a post experiment in Gutenberg where you can have the post view also in the new design view, as the site editor. And that&#8217;s where this actually comes to pass. So that is kind of labeled wrong in that changelog, but that&#8217;s okay. We can handle that. Do you want to do the next one?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Sure. So displaying a message when there is no related block, which is the most logical thing you could do with commentary that has no source attached to it anymore.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Anymore.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Anymore, anymore. Right. So again, it&#8217;s giving context to something so that your actual conversations make sense. And basically what it&#8217;s doing is just adding a little message that says, hey, your original block was deleted so that somebody reading through it understands and also gives you the ability to&#8230;part of why I like this one is because you&#8217;re going to end up with people who in collaborating with each other are going to remove things. And you want to have a record of the conversation for editorial purposes, but understanding what has happened is a key part of creating that record.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So yeah, definitely you want to have a record of the decision making process for certain things. Yeah. The other one that I wanted to point out is that it now shows the dates of the comments in a more human readable part, like 30 minutes ago or two hours ago or three days ago. So you get a little bit more relation to the timestamps of that. I think there was an option to do this, but I&#8217;m not quite sure that you can switch it on and off. But if not. No, it&#8217;s not. It&#8217;s the first. It&#8217;s the first iteration and there are no options.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I think that&#8217;s coming later.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, but it&#8217;s. It&#8217;s known that there will be something like that needed.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yep. And then the highlighting of the related block. Again, a lot of these changes are improving context indicators and so, you know, this just gives you a clearer sense of what you&#8217;re connecting to and which thing you&#8217;re actually talking about with the comments.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I&#8217;m just going to look through. If we missed something new, we can now go right into the block library section and there&#8217;s a ton of PRs that actually work on the accordion blocks. That&#8217;s also in the bug fix sections. But I think the most prominent stuff is more like the term description block with the context support. So that if it&#8217;s in a template or in an archive template that the term description block is more. You can use it in patterns like you can do post title and query title for that. Yeah, the term description block is something that&#8217;s a little bit of a… I have seen people that are quite adamant that they need the block editor in the category description section for editing the description because I wanted to make it more there. Design it a little bit or make it a little bit more versatile. That&#8217;s quite interesting because you also can now create a page with all the features that you want on that for a particular category and then just have a query loop on that category displayed on it. So you get around that need to have the term description be a block editor or something like that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. I had never thought about that before because theoretically you always could do the latter. Right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But you had to have a certain level of technical skill and knowledge to do that. The idea of adding block support to that description opens up possibilities for folks who are not as technical to make modifications in that presentation of the. The term pages. I don&#8217;t know. I could go either way there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I could also create massive. I can see this going very wrong.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. I think that&#8217;s why nobody touched it for now.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That&#8217;s a new concept to me. But I don&#8217;t know. My gut says no.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So. And then we get a new block. It&#8217;s the time to read block. And now it has been in the Guternberg plugin for ages. Similar to the table of content block. But they were to get it into core. There were always kind of missing things or quirkinesses that weren&#8217;t dealt with. And the time to read had massive accessibility objections because it only had one time that it takes to read a block. Not everybody has that reading skill or is on that level like a lot of people are. English as a second language. They don&#8217;t. They don&#8217;t read so fast or dyslexia is pretty. Yeah. It&#8217;s out there. And they don&#8217;t read that fast. And so it kind of makes them feel bad about not reading in that 15 minutes kind of thing. What they&#8217;re doing now is kind of offering a range option. It says it takes one to five minutes or something like that. And which I feel is kind of even for someone who is fast reading but tired is a good indicator. Yeah. That&#8217;s how long it&#8217;s going to actually take. And then they added also a word count to it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I like that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. When there are word count plugins out there. Word count blocks, plugins out there say that 15 times fast. But I think having a core block that actually offers it option is really cool.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I&#8217;m sorry I didn&#8217;t bold that, but I wanted to talk about it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>No, I agree. I think it&#8217;s. It&#8217;s a kinder way to deal with the problem because you&#8217;re giving people enough information to very quickly self assess without shaming them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the next one is part of the Data Views section actually. It&#8217;s the data forms package. And there&#8217;s now support for certain form elements validation in the data forms package. So if you use that as a plugin or your settings pages. You now get help from the packages that drive that. I think that&#8217;s a. Yeah, it&#8217;s an enhancement for extensibility, for sure.</p>\n\n\n\n<p><em>Beth Soderberg:</em> In the block editor section, block multi selection, disabling transforms and inspector controls.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. That&#8217;s an interesting one. So when you select multiple blocks, you still get the. Sometimes the options that you can transform them. And for paragraphs, a series of paragraphs. I like it. Because then you have. You can transform them to list views. But if you have a mixture of selected blocks, you don&#8217;t need transforms or inspectors back the controls. You just probably want to move it or move the selection. Yeah. So I think it&#8217;s a good way to not confuse people.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Right. And that&#8217;s a good example of a tiny change from an end user perspective that probably won&#8217;t be noticed, but will reduce friction for people. All right. In global styling, adding a reset button to our background controls panel. Hooray.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Hooray. You don&#8217;t have to unselect stuff. Yeah. Just click on things and you make it all go away. It&#8217;s pretty cool. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And then making the additional CSS UI less prominent, which is great because the less random CSS everywhere, the better.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes. And. Well, it&#8217;s. I totally agree with that. And that&#8217;s also the. The justification why they want to put it some. So they&#8217;re going to hide it. Again, it was hidden on the left hand side of the global styles or styles panel. You always could edit it on the right hand side when the styles panel where sooner or later we probably need to decide if we want to use the left hand side or the right hand side for the styles features. But it now is going to be in the ellipse menu in the header of the styles section. So it says add additional CSS as a menu item on top. So. So you are not going to be. Well, it was there and then it wasn&#8217;t there. So where is it kind of thing situation. It ended up in the ellipse menu on top of the screen.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Block bindings. I love block bindings.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. There&#8217;s an experimental feature there.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>To support block attributes from the server side. I haven&#8217;t completely read through it. I&#8217;m not quite sure I understand that. So I would need to go back to the developers and say what&#8217;s the use case and why you&#8217;re doing it kind of thing.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>I think. Did you get something?</p>\n\n\n\n<p><em>Beth Soderberg:</em> I would have to clarify, but my understanding of it is the big thing with block bindings is like which things are supported and which things aren&#8217;t supported and how that is communicated is improved from doing this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Doing it service sort of the nugget.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Of truth there. But I think anything like that. I know it&#8217;s experimental but making block bindings easier and more accessible for people to use anything that helps. That is a good thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I think there are two areas where they come from. One is to make block bindings available for more than 14 blocks which has been the case until now. That&#8217;s one thing. But also to increase extensibility and use have not only blocks use the block bindings but also whole features use the block bindings for external things like the remote block plugin by WordPress VIP USO. Yeah. They also use block bindings to identify the data that comes in and put it into the block editor. But I think it&#8217;s hard to bring the server side and the client side together with the same information. And this one will have the server side be the moment of truth. No, the source of truth for block bindings. Yeah, it&#8217;s definitely a late edition. I&#8217;m not sure it&#8217;s going to make it to 6.9. I&#8217;m skeptical though. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. Right. Right. Mode Try adding content roles to navigation blocks is the name of the PR which I think is delightfully named and I. Even the way that this is written is pretty great. I wanted to see how far we can go with just adding content roles to nav link in some menu blocks given the improvements to content only logic we&#8217;ve had. And then it references another pr. The next sentence is I think it&#8217;s working better now. Whoever this contributor is, I love your writing. Tell the machines.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, that&#8217;s.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Fun times. But I think it&#8217;ll.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Isabelle Bryson. Yeah, she&#8217;s been on the podcast before and she&#8217;s actually worked also on the grid layouts and yeah, she works for Automattic on the team. And the other I think the tri part is okay. We experiment with things. So that&#8217;s when it says try and then there&#8217;s also add is kind of definitely need to fix this or add this feature or fix means fix this bug. Yeah. So they have these prefixes on their PRs and the try thing is. Yeah, let&#8217;s try it out and see what happens. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. But this one, it looks cool. People should check it out. Components. The text area component. Adding a default resize vertical rule just to make things more make sense visually so that you can move stuff around the way you need to.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And you can control the vertical size of things. That&#8217;s always a good thing. And then the other component PR is actually adding storybook examples for the fields package. So there&#8217;s more documentation there for the plugin developers who want to use it. Also of course, for the core developers who are going to use the Fields.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Package for their work patterns, we have a change to the block inspector adding a content tab for section blocks that displays content only descendant blocks. So similar to the existing styles tab, but for content.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And it&#8217;s up until now it lists the blocks that can be edited in a section pattern or in a content only block. But that&#8217;s all part of the write mode, and we will see how which part of it actually will come into 6.9. But I think it&#8217;s very helpful for content creators who use a pattern to just see the pieces that you can edit and not be confused with any styling of that, even if it&#8217;s only the section styles. And from the PR before and after, you can see that the little drop water drop that&#8217;s in the block toolbar actually gives you a way to browse through the styles for this particular section. So it&#8217;s not taking anything away, it&#8217;s just kind of making it clear where the things the information is going to be for you. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think for anyone who might be confused about what we&#8217;re talking about, look at the pr. The screenshots will help you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. It&#8217;s a little bit. Sometimes it&#8217;s a little bit hard on the podcast to make things come to life on a. In a visual component.</p>\n\n\n\n<p><em>Beth Soderberg: </em>The screenshots make it make sense if you&#8217;re confused by what we just said.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And the PR we&#8217;re talking about is 71714. The next one is an easy one, but it&#8217;s definitely something to talk about for Black Friday and all the WooCommerce stuff. There is now a WordPress gift icon available for content creators and developers. So you can use that. It comes from a WooCommerce team, but they contributed to Core so anybody can use it. </p>\n\n\n\n<h3 class=\"wp-block-heading\">New API</h3>\n\n\n\n<p>The next thing I want to point out was the block API has now the block visibility, control support and the ui. That&#8217;s the part where the underlying architecture for the hide and show of blocks I think it is. And that also is the foundation for when you. Later on we will have the conditional Hide and seek. No hide and show. Yeah. When you want to say okay, I want it for logged in users or not. I want it for people who come from Twitter or not. These kinds of conditionals, they&#8217;re not yet in there. For that you still need the block visibility plugin by Nick Diego. So I think we have one more. No. Yeah, there&#8217;s an accordion block also in write mode. We hide the add button in write mode so you can add an additional accordion block in write mode. But I&#8217;m not quite sure that&#8217;s particularly helpful for a content creator. But time will tell.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, that could go either way.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s a 5050 kind of thing. You do it right for 50 people and the others are going to hate you for that. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fix</h3>\n\n\n\n<p>And then one bug fix I wanted to point out there is a bug in the pattern override. Some users might have found it is that editing was allowed on non-enabled override blocks which kind of defeated the purpose, but it&#8217;s now fixed. So there&#8217;s another experiment. I don&#8217;t know how that comes about, but the PR definitely has some interesting conversations. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Experiments</h3>\n\n\n\n<p>There is allow registering PHP only blocks. What do you say for that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I say I think this is gonna be, this is gonna be so much bigger than it sounds.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because basically what you&#8217;re doing is you&#8217;re enabling developers to create blocks using only PHP. So you&#8217;re opening up the can of worms about who knows PHP and who knows JavaScript and are we gatekeeping by moving everything to JavaScript and blah blah.</p>\n\n\n\n<p>But then you&#8217;re also changing the structure in a way that might make things less portable between projects. So I don&#8217;t know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, it&#8217;s definitely an experiment.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That&#8217;s true. I think, you know, and I. One of the things I have noticed, there is a developer on my team that I have been mentoring for years and really started learning WordPress specifically post Gutenberg. And what&#8217;s fascinating about watching her is that she struggles with some of the traditional ways of doing things, but can do them the new way. Right. So for somebody like that this might be terrible, you know, and I. It just becomes a context thing about what you know and how you&#8217;ve been progressing with different skills along the way if you&#8217;ve completely forgotten PHP or you know, various things. So I, I don&#8217;t know, I think this, this one is going to be a much bigger deal than I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I think so too. And there will be restrictions to that and I think the documentation will show that because it actually uses something the server side render component that actually was not considered best practice to use until now and the registration of PHP only blocks will actually use the server render component. So I think there is also something a little bit of a movement in the core contributing ranks about that. And it definitely needs some more. Yeah. Experimenting with it and exploration and. But it&#8217;s in there. One listened and maybe there&#8217;s something that can be pushed to the finish line outside the experiments. All the developers out there who were waiting for something like this go have at it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Oh. Interesting to see what people do.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, me too. And I added a. The label needs developer documentation and a project manager on the team also removed it because it&#8217;s experimental. So the developers that created it have some leeway in backwards compatibility. And it&#8217;s experimental. It means it&#8217;s not documented. You cannot build on it. You need to be part of the experiment spirit about it to use it and not rely on it. That it&#8217;s going to be working like that for the foreseeable future. So yeah. It&#8217;s also that caveat on it. Just wanted to point it out.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I just saw that that&#8217;s important because you&#8217;re going to have somebody who goes off and builds a whole new thing on it and then in two weeks it&#8217;ll break.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Which. Yeah. Any plugin developer that built plugins for Gutenberg has been doing kind of living through that for multiple years now. Yeah. So. But that&#8217;s 21.8 release with quite a few new features and the final release will be today on October 10th. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p>And now we are coming to the section where we talk a little bit about what&#8217;s in development and discuss. And there are new blocks in the works and we know this because Matthias has. Matthias Ventura has published that discussion about new blocks that were previously thought about plug into territory. And now quite a few theme developers think that they are held back with their designs if there are not more additional blocks in core because then now they can style it in their themes and make it available on templates and all that. So Justin Tadlock also did an opinion piece on the Gutenberg Times for it about four weeks ago. I can link it again in the show notes. But we are getting new blocks and the ones that have been merged they&#8217;re not entirely out of experiments yet. Time to read. And we talked about it because it just was merged. We also talked about the accordion block that was merged a while ago and still in experiments. But there are two. Oh, we also talked about the terms query block that has been merged but we haven&#8217;t talked about the breadcrumbs block. And I&#8217;m really excited about that because it felt such a need in the template area that people are getting so confused where am I? And I have a better map and I have breadcrumbs and all that. Yeah, it&#8217;s such a useful tool and I&#8217;m looking forward to get that tested. And yeah, watch out on the test team. They&#8217;re putting some more calls for testing together to get this all in the hands of people who want to help with making it better.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I&#8217;m excited about the breadcrumbs block too. That&#8217;s another one where I&#8217;ve had to do sort of weird things to make things work over time and it&#8217;s going to be nice to not have to do the weird things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I was using Justin Tadock&#8217;s breadcrumbs block that he developed and he had some thoughts in this VR on how broad or restricted this new. This first version is going to be. And I think we all going to like it because depending on the context you can get additional. The breadcrumbs will change. And I really like that.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Yeah, I&#8217;ve. I&#8217;ve used his plugin too. I forget which one it was. There&#8217;s a few independent plugins for breadcrumbs and my team has run into some weird edge cases of what they will do depending on your content structure. So I think that&#8217;s part of why the scope of the breadcrumbs block being limited at first makes so much sense, because the complexity of what you&#8217;re actually trying to do from a templating level, depending on where you are in a site and how your site is structured can get incredibly complex. I don&#8217;t remember which plugin it was, but we had a site. It may have been the Voter Guide. The Voter Guide within the site that completely killed everything. Like something about the logic of where we were just. And we had to use a different plugin just for that one site to make it work.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I might have even re. Ended up doing something sort of manual instead. I don&#8217;t remember. But those plugins have been incredibly useful, but are also prone to edge case weirdness. Basically generating navigation on the fly. And if you don&#8217;t know where you are within the structure of the site from a structural standpoint, or if someone has made some odd decisions about where they&#8217;re putting things or how their hierarchy works, you&#8217;re going to end up with a really confusing breadcrumb.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. And sometimes you don&#8217;t have the controls to actually make changes. It&#8217;s just all this black box kind of mystery mute kind of thing again. Yeah, yeah. And I. While we&#8217;re running a little bit out of time or short on time, I just wanted to mention there&#8217;s also a dialogue block in the works. There&#8217;s an icon block in the works. My favorite one is the stretchy text. It sounds so weird, but it actually makes sense. It&#8217;s text that stretches over a certain container and it&#8217;s flexible depending on how the container works. So you could do this for hero sections, all that. And then here&#8217;s your bestest favorite. The tabs block is in the works. And then also my favorite is a table of contents block. Because I have these long posts all the time and I want to do the table of contents block. But it had some weird issues. That&#8217;s why it&#8217;s not in Core yet. And they&#8217;re trying to figure that out how that all can be done. It&#8217;s now attempted to be a dynamic one and allow usage outside of the post or page that is actually referring to. But for instance, in a template, you could put it in a single post template in the sidebar and you will always have a table of content for your posts. So I think that&#8217;s a really good use case for pages, when you have landing pages or tutorial pages or documentation pages that you don&#8217;t have to fiddle with it while you&#8217;re creating the content. And it&#8217;s just there in the template.</p>\n\n\n\n<p><em>Beth Soderberg: </em>This is one where my weird workaround for it. There&#8217;s one of the SEO plugins has a table of contents block built into it. I forget which one offhand, but I&#8217;ve used that before to get this type of functionality.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because it. Sometimes you really just need it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, absolutely. Yeah. Yeah. </p>\n\n\n\n<p>So that&#8217;s it. That is the Gutenberg changelog 122. Thank you so much for being with me on this, Beth. And it was great to chat with you and talk about block themes and all these good things. Block style stuff. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Thanks for having me. It was fun.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Dear listeners, as always, the show notes will be published on the <a href=\"http://gutenbergtimes.com/podcast\">gutenbergtimes.com/podcast</a>. This is 122. I already said that. But if you have questions or suggestions or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> that&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> and I forgot a question for you, Beth. And that is if people want to get in touch with you, what is a good place to do that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>You can find me in the WordPress slack under my name, Beth Soderberg. And then you can find me at work at our website, which is Bethink.studio or bethinkstudio.com. but you know, it&#8217;s really fun when you can get the non.coms to work with your name.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So. Yes, all right. So I&#8217;ll list of course, all those contact information, more in the show notes.</p>\n\n\n\n<p>And thank you all for listening. Thank you for being here and see you when I&#8217;ll see you back. Well, in two weeks. Goodbye, and have a good time. </p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 12 Oct 2025 10:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: In Canada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150205\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/10/in-canada/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:731:\"<p>I&#8217;ve been trying to find time in my calendar to attend more WordCamps as I love meeting <a href=\"https://ma.tt/2025/09/wordpresser/\">WordPressers</a> all over the world. The stars aligned, and I&#8217;ll be swinging by <a href=\"https://canada.wordcamp.org/2025/\">WordCamp Canada</a> next week. They&#8217;ve put together an amazing program, including open web pioneer and inventor Dave Winer, so I&#8217;m looking forward to checking out the sessions. I wish I could go to every WordCamp, like I used to! I&#8217;ve been recording videos and messages for those I can&#8217;t physically attend. Ottawa is also great as the only other commercial board I&#8217;m on is <a href=\"https://fieldeffect.com/\">Field Effect</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Oct 2025 15:35:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Twitter Hacked\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150193\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/twitter-hacked/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:662:\"<p>Sorry everybody, my @photomatt on Twitter has been hacked, I&#8217;m trying to regain account access, but it is not currently in my control. <strong>Update: </strong>Thank you to the fine teams at X/Twitter and <a href=\"https://x.com/nikitabier\">Nikita Bier</a>, my account has been recovered. Just for future reference, I will never promote cryptocurrencies or similar investments. If you see anything from me or WordPress claiming that, be highly skeptical. Invest in open source, public stocks, and great companies like Automattic. <img alt=\"🙂\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f642.png\" style=\"height: 1em;\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Oct 2025 00:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"Gutenberg Times: Mega Menus in core, WordPress 6.9 calls for testing, going from Elementor to Site Editor — Weekend Edition 344\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42168\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:23201:\"<p>Howdy,</p>\n\n\n\n<p>After meeting so many people at WordCamp Gdynia, on the plane and then on the train, I caught a nasty cold and struggled all week. I call this stage mushbrain, and everything becomes much harder, especially reading comprehension suffers. I am over it now, though. It also wasn&#8217;t the first time that I sounded horsey on a podcast episode. </p>\n\n\n\n<p>It&#8217;s the time of year now here in Munich when the days get shorter and the weather is cold, drissly and overcast. A time when snow would brighten the sights, with its whiteness covering partly the darkgray, dark brown background. </p>\n\n\n\n<p>Enjoy again  this weekend edition  and stay healthy. </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#help-testing-new-features-for-wordpress-6-9\">Help testing new features for WordPress 6.9</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#what-s-new-in-and-around-playground\">What&#8217;s new in and around Playground</a></li></ol></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Gutenberg 21.8 is now available and release lead <strong>Carlos Bravo</strong> hightlighed in his release post <a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/\"><strong>What’s new in Gutenberg 21.8? (8 October)</strong></a></p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#block-visibility-support-ui\">Block Visibility Control Support and UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#block-comments-improvements\">Block Comments Improvements</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#accordion-time-to-read\">Accordion and Time To Read Blocks</a></li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>This week <strong>Gutenberg Changelog 122</strong> recording, <strong>Beth Soderberg</strong>, lead developer at <a href=\"https://bethink.studio/\">Bethink.studio</a> and I chatted about the release and other WordPress topics around Block themes and on going change. The episode arrive at your favorite podcast app over the weekend. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\">Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9</a> with Beth Soderberg of <a href=\"https://bethink.studio/\">Bethink Studio</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 122 with Beth Soderberg\" class=\"wp-image-42236\" height=\"193\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-11-at-12.32.48.png?resize=652%2C193&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>It was <strong>JuanMa Garrido</strong>&#8216;s turn to write the monthly roundup post <a href=\"https://developer.wordpress.org/news/2025/10/whats-new-for-developers-october-2025/\"><strong>What’s new for developers? (October 2025)</strong></a> on the WordPress Developer Blog. The 21.6, 21.7, and 21.8 Gutenberg releases add features for developers. The Command Palette now works throughout the admin, the new Terms Query block makes taxonomy layouts easier, and Block Visibility controls allow for conditional display. Notes (that&#8217;s how we call Block Comments now) improve team collaboration, while content-only editing maintains design integrity during client handoffs.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"help-testing-new-features-for-wordpress-6-9\">Help testing new features for WordPress 6.9</h3>\n\n\n\n<p>Release test co-leads <strong>Krupa Nanda</strong> and <strong>Jonathan Bossenger</strong>, published several calls for testing in preparation in WordPress of the 6.9 release. Each of the post has a detailed description of the feature, and instructions on how to test is with specific scenarios. It&#8217;s much easier to follow along with any of the calls for testing, to also learn what&#8217;s new in the next release. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>Help test changes to template management</strong></a> is probably the most elaborate call for testing, as template management received a completely new feature, and it needs to be working for many different use cases, and has consquences on existing sites.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\"><strong>Call for Testing: Ability to Hide Blocks</strong></a> for this feature it&#8217;s the bare minimum of a new feature, that will be in future releases see some refinement and extensiblity. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\"><strong>Call for Testing: Accordion Block</strong></a> lets you dive into a whole new block, many users asked for an several plugins are already available for. Now it will come to core. </p>\n\n\n\n<p>Your time spent on testing the new features for WordPress 6.9, has a lot of impact, as the bugs found now, make the release the best it can be for millions of other users. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Lesley Sim</strong> informed us that <a href=\"https://wordpress.org/plugins/eventkoi-lite/\"><strong>EventKoi Lite</strong></a> is now available from the WordPress Plugin Repository. I mentioned the premium version before, Event Koi is modern, WordPress events calendar. Create single or multi-day events and display month, week, or list views via blocks (or shortcodes).</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mike McAlister </strong>announced a new product: <strong>OlliePro Extensions</strong> on Bluesky. He mentions: Animations, advanced grid + column controls, keyboard shortcuts, and more. Watch the vidoe <a href=\"https://www.youtube.com/watch?v=qq2DLc43pTk\"><strong>Introducing Ollie Pro Extensions &#8211; Supercharge Your WordPress Block Editor</strong></a></p>\n\n\n\n<p>All controls are seamlessly integrated with the Core editor sitebar sections. <strong>Mark Howells-Mead</strong> <a href=\"https://wordpress.slack.com/archives/C015GUFFC00/p1760046957248569\">commented</a> in the WordPress Slack #outreach channel: &#8221; I’m very impressed with how he’s been able to integrate the little add-ons many of us are integrating to our own projects, but in such a seamless way by extending core controls.&#8221;  McAlister shared an <a href=\"https://gist.github.com/mikemcalister/937664ea19e87d61add7fc9902f10ac9\">example Gist on GitHub</a>.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>David McCan</strong> took a deep dive into the world of Block plugins. In this blog post   <a href=\"https://dynamicwp.co/performance-of-third-party-blocks-and-core-compared/\"><strong>Performance of Third Party Blocks and Core Compared</strong></a> he tries to answer the questions many site builders and owners have: &#8220;Can you add the features Gutenberg is missing yet still be performant like core?&#8221;. McCan tested ten third-party Gutenberg block plugins with WordPress core, specifically focusing on performance.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Matt Medeiros</strong>, WPMinute, took the <em>Mega Menu Designer</em>, also made  by Mike McAlister, out for the spin. He shared his thoughts in the Video <a href=\"https://www.youtube.com/watch?v=7NYskePLDM0#feedback\"><strong>How to Build Mega Menus with WordPress Blocks</strong></a>. He provides a detailed walkthrough calls it &#8220;Perfect for anyone looking to enhance their website&#8217;s navigation experience.&#8221; As reported earlier <a href=\"https://wordpress.org/plugins/ollie-menu-designer/\">the plugin is available for free</a> in the WordPress plugin repository. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p><strong>Rae Morey</strong>, publisher or The Repository, reported <strong><a href=\"https://www.therepository.email/ollies-menu-designer-flagged-for-core-with-automattic-developers-set-to-help-shepherd-it?utm_source=mailpoet&amp;utm_medium=email&amp;utm_source_platform=mailpoet&amp;utm_campaign=issue-276\">Ollie&#8217;s Menu Designer Flagged for Core, With Automattic Developers Set to Help Shepherd It</a></strong>. Automattic&#8217;s Anne McCarthy says developers are preparing to review Ollie&#8217;s Menu Designer for inclusion in the Gutenberg plugin, marking the start of a collaborative push to bring the plugin&#8217;s features into WordPress. This follows WordPress co-founder Matt Mullenweg&#8217;s suggestion that the menu functionality should be part of core. Details and links in Moery&#8217;s article. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>This episode of <em>Greyd Conversations</em> show, <strong><a href=\"https://www.youtube.com/watch?v=cRM4FjR_UbE\">Switching to FSE from a pagebuilder</a>, </strong>covers the story of <em>Buro Staal</em>, a smal dutch agency, which switched from Elementor to Full site editing cold turkey. Greyd&#8217;s host <strong>Sandra Kurze</strong> and agency owner <strong>Rosanne van Staalduinen</strong> shared why and how her agency switched and the lessons learned along the way. </p>\n\n\n\n<p>The biggest hurdles were limited functionality of navigation block, not able to create Mega Menus, and the need for controls for mobile sites and responsiveness. So they augmented their tech stack with Kadence Blocks and Ollie Pro theme. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>Ryan Welcher</strong> published another recipe from his Blockdevelopment Cook Book on YouTube.  <strong><a href=\"https://www.youtube.com/watch?v=dJ4gUrxTgjM\">How To Make A Simple Fade In Effect Fast</a></strong>. &#8220;In this recipe, we’re adding a little flair by loading custom JavaScript and CSS for the Cover and Image blocks to create a smooth fade-in effect as they scroll into view. To keep things efficient, we’ll only enqueue these files when the blocks are actually on the page.&#8221; </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<h3 class=\"wp-block-heading\" id=\"what-s-new-in-and-around-playground\">What&#8217;s new in and around Playground</h3>\n\n\n\n<p><strong>Nick Diego</strong> announces that <a href=\"https://wordpress.com/blog/2025/10/08/introducing-blueprints-in-wordpress-studio-1-6-0/\"><strong>WordPress Studio version 1.6.0</strong></a> now supports Blueprints, which are lightweight JSON files that predefine site configurations for quick and consistent setup. Instead of starting with empty sites or using large snapshots, teams can create portable recipes specifying WordPress versions, plugins, and settings. Studio offers three featured blueprints for quick starts, development, and commerce, while users can also upload custom blueprints. The feature integrates into the standard site creation flow and helps streamline workflows for solo developers and teams alike.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.github.io/wordpress-playground/\"><strong>Playground documentation</strong></a> now has Ask AI button, to get help finding and understanding feature sets and APIs.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.github.io/wordpress-playground/\"><img alt=\"\" class=\"wp-image-42203\" height=\"339\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-09-at-18.50.23.png?resize=652%2C339&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ajit Bohra</strong> of Lubus <a href=\"https://x.com/ajitbohra/status/1975920964266258538\">shared on X</a> &#8220;The Visual BluePrint Builder for Playground is shaping up nicely. All the latest updates are in, and it’s feeling solid. Stable version coming soon, but you can already check it out and start building visually.&#8221; A blueprint builder with blocks, how nice.  You can test it via <a href=\"https://playground.wordpress.net/?blueprint-url=https%3A%2F%2Fraw.githubusercontent.com%2FlubusIN%2Fvisual-blueprint-builder%2Fplayground%2F_playground%2Fblueprint-github.json\">this Playground link</a>. The code is available on <a href=\"https://github.com/lubusIN/visual-blueprint-builder\">GitHub</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jamie Marsland</strong> also tries to make it easier to create blueprints for Playground sites and open up the WordPress in a browser tool for a broader audience. Details in his post <a href=\"https://www.pootlepress.com/2025/10/introducing-pootle-playground-my-experimental-wordpress-blueprint-builder/\" rel=\"noreferrer noopener\" target=\"_blank\"><strong>Introducing Pootle Playground — My Experimental WordPress Blueprint Builder</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Adam Zielinski</strong> created an <a href=\"https://playground.wordpress.net/php-playground.html\"><strong>online PHP code editor</strong></a> using Playground. It allows developers to test PHP snippets quickly in their browser. The tool supports WordPress functions, enables switching between PHP and WordPress versions, and allows sharing code configurations through links. Built with WordPress Playground, it runs entirely client-side with network access and popular PHP extensions included. He&#8217;s currently experimenting with adding CLI and file browser capabilities to support composer packages and frameworks like Laravel or Symfony.</p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Free colorful building blocks image by <a href=\"https://www.rawpixel.com/image/5906195/photo-image-public-domain-free-game\">Rawpixel </a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 23:35:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: Jeremy Kranz and Sentinel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150173\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/jeremy-kranz/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2487:\"<p>I&#8217;d like to introduce you to <a href=\"https://www.linkedin.com/in/jeremykranz/\">Jeremy Kranz</a>. With his career as an investor at <a href=\"https://www.intelcapital.com/\">Intel Capital</a>, then <a href=\"https://en.wikipedia.org/wiki/GIC_(sovereign_wealth_fund)\">GIC</a>, which is the sovereign wealth fund of Singapore rumored to manage over $700B, to now running his own fund <a href=\"https://www.sentinelglobal.xyz/\">Sentinel Global</a>, he has had a front-row seat to investments in industry changing companies such as ByteDance (which became TikTok), Alibaba, Uber, DoorDash, Zoom, DJI (which changed the drone industry and argubly modern warfare), and many more I&#8217;m probably not even aware of.</p>\n\n\n\n<p>When I first met Jeremy in 2014, I was amazed that a late-stage financial investor could understand Open Source so well, and he immediately grokked what <a href=\"https://automattic.com/\">Automattic</a> was doing in a way that I think has little parallel in the world. (Today, it reminds me of Joseph Jacks at <a href=\"https://oss.capital/\">OSS Capital</a>.) <a href=\"https://www.insightpartners.com/team/deven-parekh/\">Deven Perekh of Insight Partners</a> led Automattic&#8217;s 1.16B valuation Series C round, making us one of only forty &#8220;unicorns&#8221; (private companies valued over a billion dollars) at the time, and one of the reasons they beat out others as the lead of the round was that GIC/Jeremy was a LP of Insight so they could directly co-invest. GIC is so intensely private <a href=\"https://ma.tt/2014/05/new-funding-for-automattic/\">I couldn&#8217;t even mention them in the announcement at the time</a> even though they were the catalyst for the round.  Since then, Jeremy has become a close friend and advisor, and he even took me to <a href=\"https://www.nugs.net/live-download-of-dead-and-company-dos-equis-pavilion-dallas-tx-10-14-2021-mp3-flac-or-online-music-streaming/26749.html\">my first Grateful Dead concert</a>.</p>\n\n\n\n<p>Eleven years later, this is his first podcast! Jeremy shares incredible <a href=\"https://www.investopedia.com/terms/a/alpha.asp\">alpha</a> around China, AI and its adoption in the enterprise, how asset allocation is evolving, and at the end, a beautiful tie together of the Grateful Dead and Open Source.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 19:30:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Kathy Sierra\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150166\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/kathy-sierra/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:774:\"<p>I was reminded today of the profound marketing influence of <a href=\"https://en.wikipedia.org/wiki/Kathy_Sierra\">Kathy Sierra</a>, who was a pretty prolific blogger and speaker back in the day. I would summarize her thesis as such: <strong>Your best marketing and communication should talk about how you make your users awesome, not how you&#8217;re awesome</strong>. If you&#8217;d like to check out some of her talks, <a href=\"https://href.li/?https://wordpress.tv/2008/10/31/wordcamp-sf-2008-kathy-sierra-kicking-ass-and-creating-passionate-users/\">she spoke at WordCamp in 2008</a>, <a href=\"https://vimeo.com/81625882?fl=pl&amp;fe=ti\">at Business of Software in 2013</a>, and at <a href=\"https://www.youtube.com/watch?v=iBtcGwHPMKM\">Mind the Product in 2015</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 01:22:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Open Channels FM: Bootstrapping a Successful WordPress Business Through Customer Feedback and Iteration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110936\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://openchannels.fm/bootstrapping-a-successful-wordpress-business-through-customer-feedback-and-iteration/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:218:\"In this episode, Mark chats with Aurelio Volle from WPUmbrella about his journey in creating a WordPress management tool, maintaining customer focus, and the importance of community and transparency in business growth.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Oct 2025 10:47:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Battery Scan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/battery-scan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1067:\"<p>One of the cooler companies I&#8217;ve seen in a while is <a href=\"https://www.lumafield.com/\">LumaField</a>, which does industrial CT scanning, as they describe it.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Industrial X-ray CT (Computed Tomography) works on the same basic principle as medical CT, taking hundreds of X-ray images from different angles to capture the internal and external structure of objects in three dimensions.</p>\n</blockquote>\n\n\n\n<p>In addition to providing amazing graphics of these scans, they also gather some valuable data. <a href=\"https://www.lumafield.com/battery-report\">Their Lumafield Battery Quality Report does a deep dive into lithium ion battery manufacturing</a>, showing the wild differences between different brands. </p>\n\n\n\n<p>I love this stuff, whether you call it QA, evals, testing, or whatever, it reminds me of <a href=\"https://www.principles.com/principles/8b086563-5bb4-4741-8713-c62bd1a0d749/\">Ray Dalio&#8217;s Principle to embrace reality and deal with it</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Oct 2025 06:24:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: #188 – Bud Kraus on Teaching and Using WordPress With Low Vision\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=199897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/podcast/188-bud-kraus-on-teaching-and-using-wordpress-with-low-vision\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39989:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case teaching and using WordPress with low vision.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Bud Kraus. Bud was diagnosed with mascular degeneration, a condition often associated with old age, when he was 37. Affecting both eyes, this gradually eroded his central vision, making it difficult for him to see straight ahead, recognize faces, drive or read.</p>\n\n\n\n<p>Despite these challenges, Bud&#8217;s peripheral vision remained intact, sparing him the need for a cane or guide dog, and allowing him to continue to navigate daily life. Through perseverance and adaptation, Bud continues to live fully, facing the hurdles of vision loss with resilience and optimism.</p>\n\n\n\n<p>Bud opens up the podcast by talking about his experience living with legal blindness, how his central vision loss has shaped everything from everyday activities to his professional routines. He explains the practical ways he adapts his devices and workflow, including tweaks to operating system settings, using screen zoom functions, and relying on pattern recognition to teach coding, write tutorials, and even host his Seriously, Bud? podcast. His unique perspective sheds light on the often overlooked nuances of accessibility, reminding us that every user interacts with technology differently.</p>\n\n\n\n<p>Bud also chats about the broader impact of accessibility in the WordPress space, from frustrations with hard to navigate interfaces, to the importance of not excluding users who may become your audience or customers. His reflections reveal how living with low vision pushed him beyond mere acceptance, helping him discover new opportunities, hone his teaching skills, and even find humour in daily challenges.</p>\n\n\n\n<p>Bud&#8217;s story serves as a powerful reminder of the importance of designing with empathy, embracing adaptation, and viewing accessibility, not just as a technical requirement, but as a source of creativity and connection. It&#8217;s full of real world tips, personal anecdotes, and a dose of inspiration.</p>\n\n\n\n<p>Whether you&#8217;re a designer, developer, educator, or simply passionate about building a more inclusive web, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Bud Kraus.</p>\n\n\n\n<p>I am joined on the podcast by Bud Kraus. Hello, Bud.</p>\n\n\n\n<p>[00:03:35] <strong>Bud Kraus:</strong> Hello, Nathan. Thanks for having me.</p>\n\n\n\n<p>[00:03:37] <strong>Nathan Wrigley:</strong> Yeah, you&#8217;re very welcome. This is not the first time we&#8217;ve spoken, but it is the first time we&#8217;ve spoken at an event because we&#8217;re both at WordCamp US in Portland, it&#8217;s 2025. We&#8217;re in a corridor, so I&#8217;ve got to say at the very outset, if it ends up being quite noisy, there&#8217;s not a lot we can do about that. But we&#8217;ve done our best. We&#8217;ve found a nice quiet little alcove, and we&#8217;re going to be chatting today to Bud about his experience online. Before we do that, Bud, do you mind just telling us a little bit about yourself? Give us your potted bio, if you like.</p>\n\n\n\n<p>[00:04:01] <strong>Bud Kraus:</strong> Yeah, sure. So I create WordPress content for WordPress businesses, articles, blog posts, tutorials, videos, and I am the host of the podcast called Seriously, Bud?</p>\n\n\n\n<p>[00:04:14] <strong>Nathan Wrigley:</strong> And the talk that you&#8217;re doing at WordCamp US, which I guess you haven&#8217;t yet done, because we&#8217;re on the first day of presentations and it&#8217;s fairly early on. You haven&#8217;t done it, right?</p>\n\n\n\n<p>[00:04:23] <strong>Bud Kraus:</strong> No, I actually, no, I haven&#8217;t done it yet, but I&#8217;ve done this a couple times, so this is not my first time doing this talk.</p>\n\n\n\n<p>[00:04:29] <strong>Nathan Wrigley:</strong> So you know how it&#8217;s going to go. It&#8217;s called using low vision as my tool to help me teach WordPress. Now, that kind of leads us into the subject at hand really. We&#8217;re going to be talking about how it is that your experience of the web may differ from other people.</p>\n\n\n\n<p>Are you willing to just tell us a little bit about your experience in the offline world as well as the online world? What is it that you are dealing with on a day-to-day basis?</p>\n\n\n\n<p>[00:04:50] <strong>Bud Kraus:</strong> Sure. So I have macular degeneration, which is a condition of old age, which I got when I was 37. And it&#8217;s the leading cause of legal blindness in the United States. It&#8217;s a destruction of your central vision.</p>\n\n\n\n<p>I have the condition in both eyes, which means I really have it. And it makes it very hard for me to see straight ahead, recognise faces, reading. I can&#8217;t drive a car, which is okay. So anything that&#8217;s straight ahead.</p>\n\n\n\n<p>Now, my peripheral vision&#8217;s perfectly intact, so that means I don&#8217;t need to have a seeing eye dog or a cane, or I don&#8217;t bump into things because the peripheral vision&#8217;s fine. But the very fine vision that we all use to see straight ahead, like to thread a needle, that&#8217;s what I&#8217;m missing.</p>\n\n\n\n<p>[00:05:30] <strong>Nathan Wrigley:</strong> So are you able to describe what you are seeing in that area. And is it like the central portion of your site?</p>\n\n\n\n<p>[00:05:38] <strong>Bud Kraus:</strong> It is the exact central portion of my sight. So I tend to see elliptically, which means I move my eyes around to get a better picture. Like, when I&#8217;m looking at you right now, I&#8217;m moving my eyes around so I can see better because of the destruction of the centre part of my vision.</p>\n\n\n\n<p>[00:05:52] <strong>Nathan Wrigley:</strong> And does that rule out certain tasks? So for example, you mentioned reading there. Obviously I do not have what you have, and so it&#8217;s a given to me that when I&#8217;m staring as I am doing at the moment at my laptop, my eyes, the bullseye, if you like, of my eyes go straight to the letter looking at. And for me, it&#8217;s hard to imagine deploying my peripheral vision to do that, but can you, for example, do things like reading or is that out of the?</p>\n\n\n\n<p>[00:06:16] <strong>Bud Kraus:</strong> You can&#8217;t, peripheral vision is not a, it&#8217;s not even close to being a perfect substitute for central vision. So the answer is no. You cannot read with peripheral vision. You cannot understand. You can see, but you can&#8217;t understand. And it just makes things difficult.</p>\n\n\n\n<p>[00:06:33] <strong>Nathan Wrigley:</strong> Yeah. So how does that affect your real life? So obviously you mentioned things like being unable to drive a car or things like that. Is there anything else that might give us a frame of reference for just how profound it is?</p>\n\n\n\n<p>[00:06:44] <strong>Bud Kraus:</strong> Well, I like to look at it differently. So I have a different approach to this. So when I first was diagnosed with this when I was 37, I thought, oh, this is the worst thing that could ever happen. And that makes sense, but it is not the worst thing that could ever happen.</p>\n\n\n\n<p>And having lived with this for quite a long time now, I look at this not as a curse, but as a blessing. Because what it&#8217;s done is allow me to have so many different opportunities, experiences, ideas, thoughts, whatever that I would&#8217;ve not otherwise had.</p>\n\n\n\n<p>So that process of going, it&#8217;s the grief process when you start from, you know, this is the most horrible thing in the world, to acceptance. I&#8217;m actually beyond acceptance. It&#8217;s like, I like this. This is okay with me. And do I wish it on other people? No, I don&#8217;t. But like I said, it&#8217;s not the end of the world. There are conditions and diseases that are far worse than this.</p>\n\n\n\n<p>So I do think of, and in fact in my talk that I&#8217;m giving, at the end I talk about why this is a blessing and not a curse. I mean, like for example, you can get as inebriated as you want at parties because you&#8217;re not going to be driving the car home. So there&#8217;s lots of that, okay. Or you don&#8217;t see your friends get older because you can&#8217;t see the detail on their face. When I go in a grocery store, I don&#8217;t see all the junk food, so that&#8217;s good. Is it inconvenient? Yes. Do I have a hard time finding people at a large event like this? Yes. But I manage.</p>\n\n\n\n<p>[00:08:09] <strong>Nathan Wrigley:</strong> So in the wider world, you can obviously deploy your peripheral vision. So we&#8217;re sitting in a, I don&#8217;t know, it&#8217;s maybe this room&#8217;s about 10 meters by 10 meters. There&#8217;s a lot of space. Whereas the thing that we&#8217;re talking about, WordPress, building websites and so on, it&#8217;s usually this constrained little, well, let&#8217;s say rectangle. It could be something that we&#8217;re holding our hands, a mobile phone or a computer, laptop, something like that. How does your situation, how does it get impacted by this then? Are you doing this peripheral vision, glancing left and right and trying to figure out what&#8217;s going on? Or do you have other tools, mechanisms, things that you deploy?</p>\n\n\n\n<p>[00:08:39] <strong>Bud Kraus:</strong> I do, and that&#8217;s what my talk is about. So, for example, I&#8217;ve taught WordPress and I taught coding for a long time. And people say, well, how do you do that if you can&#8217;t see?</p>\n\n\n\n<p>Well, one thing is I&#8217;m always very prepared. So when I go into a class, I can&#8217;t wing it. I just have to know exactly what I&#8217;m going to be doing. And in code there&#8217;s a lot of patterns and I recognise patterns.</p>\n\n\n\n<p>And, yes, I do use Zoom. I use audio. I use touch. Now, touch is not really relevant here, but I&#8217;m able to, with the technology as good as it has become for me, I&#8217;m able to Zoom in and out of the screen and I&#8217;m able to read things out loud. And then I have to do a fair amount of memory. But that&#8217;s okay.</p>\n\n\n\n<p>[00:09:22] <strong>Nathan Wrigley:</strong> So do you have adaptations that you make, let&#8217;s say for example, you go out today and you purchase a new computer, do you have adaptations that you make on an operating system level?</p>\n\n\n\n<p>[00:09:30] <strong>Bud Kraus:</strong> Yeah, I do.</p>\n\n\n\n<p>[00:09:31] <strong>Nathan Wrigley:</strong> Okay. I&#8217;m curious to hear about these because I make no modifications when I purchase, so tell me more.</p>\n\n\n\n<p>[00:09:35] <strong>Bud Kraus:</strong> Yeah, good question. So one of the things I do, and I&#8217;ll be demonstrating, is my resolution is a low resolution, meaning 1024 by 768 would be low today. In the olden days, that would be high. But it makes the screen, it makes it easier for me to see the screen. And then I make all kinds of adjustments to make icons bigger, letters bigger, so that it&#8217;s just works for me. And yeah, I don&#8217;t have a problem with it.</p>\n\n\n\n<p>Now, it does cause me to do things maybe a little slower because it&#8217;s just harder for me to maybe find something. But I think I mentioned that patterns is a very important thing to me. So if I&#8217;m going to a website and they change the UI totally around, that&#8217;s going to be a pain in the neck for me, because then I have to relearn where everything is.</p>\n\n\n\n<p>It&#8217;s sort of like changing the furniture if you were blind, I mean, really blind, which most people aren&#8217;t. So I&#8217;m legally blind but, you know, I&#8217;m not like lights out blind. If you change where things are, then it&#8217;s going to make things very difficult for me, whether it&#8217;s in the real world or in the virtual world. I have to relearn everything.</p>\n\n\n\n<p>[00:10:35] <strong>Nathan Wrigley:</strong> A sort of curious question that&#8217;s just occurred to me. When you buy a new computer, is there a process whereby you have to combat the regular default icon size and default tech size, just for a moment in order to wrangle it into the version of the OS that you need?</p>\n\n\n\n<p>[00:10:50] <strong>Bud Kraus:</strong> You&#8217;re absolutely right. So if you&#8217;re booting up for the first time, it&#8217;s a hole in the whole process, which is at least the last time I did, which is there&#8217;s no audio, there&#8217;s no nothing, and you&#8217;re seeing like little tiny print to, you know, configure the language and the location and the time and all that stuff that you do when you work with a computer for the first time. That is a real problem, yeah.</p>\n\n\n\n<p>[00:11:11] <strong>Nathan Wrigley:</strong> You would imagine that there&#8217;d be some mechanism to invoke that as the first thing that happens?</p>\n\n\n\n<p>[00:11:17] <strong>Bud Kraus:</strong> I think so.</p>\n\n\n\n<p>[00:11:17] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s interesting.</p>\n\n\n\n<p>Okay, so we&#8217;ve talked about the wider world. We&#8217;ve talked about a computer that you may modify. Let&#8217;s get onto the bit which we are all here for, which is WordPress. Are there any adjustments or tools, or this could extend to the browser, so it may be browser tools, what have you, but for the internet, let&#8217;s say, what are the modifications that you are making to make your life possible there?</p>\n\n\n\n<p>[00:11:37] <strong>Bud Kraus:</strong> You know, I don&#8217;t think there&#8217;s anything really any different than anybody else makes. I mean, the biggest thing is I will either zoom in or out of a webpage. And it&#8217;s really funny because, if you&#8217;re using a certain screen size with a certain resolution, things can get very hard to work with. I don&#8217;t think enough companies, like I&#8217;m thinking of even LinkedIn, for example, that I was using today. Sorry to call them out, but it&#8217;s just like their chat areas were just really, I just had to do all kinds of crazy things to actually see the text. And then the text was really small.</p>\n\n\n\n<p>I think because I&#8217;m a stress case, that they don&#8217;t always test down to my level. And I think it&#8217;s, I just accept it. But that&#8217;s the way it is, I guess. But I think that you don&#8217;t want to exclude people from anything really, because they may be your customer. And if I can&#8217;t buy something because it&#8217;s really hard to do, and that is something, I don&#8217;t know if I&#8217;ve ever talked to you about it, but other people, that if I am discouraged from buying something because it&#8217;s just, the UI is just too hard to work with, I&#8217;ll just find an alternative. I will. Or I&#8217;ll ask my wife.</p>\n\n\n\n<p>[00:12:39] <strong>Nathan Wrigley:</strong> I guess you&#8217;re in a curious space as well in that we hear a lot in the accessibility space about things like screen readers and those kind of assistive technologies. I guess you are not deploying those because you have enough sight to not have that as a, something to lean upon.</p>\n\n\n\n<p>[00:12:54] <strong>Bud Kraus:</strong> Yeah, that&#8217;s exactly right. I have not, and don&#8217;t use JAWS or any of those big fancy screen reader technologies. I just use what&#8217;s built into the macOS and I just highlight the text and I press a button and it reads. I think it&#8217;s called voiceover, or it&#8217;s text to speech, or whatever it is. And it&#8217;s in the accessibility part of the settings.</p>\n\n\n\n<p>I don&#8217;t use technology beyond what I need it for. It&#8217;s just overkill. What do I, those are complicated systems to master, so I stay away from that because they don&#8217;t need it.</p>\n\n\n\n<p>[00:13:22] <strong>Nathan Wrigley:</strong> So when you are building websites, is there anything unique about the way that you do that? Is there any sort of, again, a tool that you deploy? Or maybe you are relying on other human beings to sort of cast their eye over it a second time after you&#8217;ve done the work. I don&#8217;t know, just talk us through that whole thing.</p>\n\n\n\n<p>[00:13:37] <strong>Bud Kraus:</strong> Well, I don&#8217;t make websites. No, I have, okay. I&#8217;ve done everything, but I don&#8217;t make websites because I don&#8217;t like to make websites. It&#8217;s not because of my vision. But yes, if I am working, in the past like I have, I would ask people to help me with, particularly with colour because I have a very, I think I have a poor colour palette. And I think that&#8217;s either, it&#8217;s because of me. So I have to ask, does this go good with this?</p>\n\n\n\n<p>It&#8217;s just something that I, either I&#8217;m not good at, or I&#8217;m not interested, or my vision, or whatever it is. So I do have a problem with colour in that regard. But because of the technology and the tools that are built in, it&#8217;s not as difficult as one might think.</p>\n\n\n\n<p>[00:14:15] <strong>Nathan Wrigley:</strong> Interesting. Yeah, okay. We&#8217;ll get into that. But you do make a podcast, and there&#8217;s lots and lots of different spinning wheels that have to done there. You know, you&#8217;ve got to book people onto the show, you&#8217;ve got to have calendars, you&#8217;ve got to have posts and pages and things like that on the website. Is there anything uniquely interesting about, I understand the process of making a website from my perspective, there anything that would be different to my process than would be for yours?</p>\n\n\n\n<p>[00:14:36] <strong>Bud Kraus:</strong> Yes, I think one thing I could think of is like a lot of times I won&#8217;t, let&#8217;s say in WordPress, you can write into the editor, you could write a page or a post right into the Gutenberg, the block editor. I choose not to do that. What I do is use a notepad, or not notepad, what is it for a Mac? I forgot.</p>\n\n\n\n<p>[00:14:53] <strong>Nathan Wrigley:</strong> TextEdit.</p>\n\n\n\n<p>[00:14:54] <strong>Bud Kraus:</strong> Yes, TextEdit. Thanks. I&#8217;ll use that and I&#8217;ll have the font blown up bigger than normal, and I&#8217;ll just edit in there, and then I&#8217;ll just take that and then I&#8217;ll copy that and paste that into WordPress. It&#8217;s just easier for me to do it that way. So I just like it that way. You know, everybody has their own little thing. That&#8217;s my little thing. And I think it&#8217;s because of my vision.</p>\n\n\n\n<p>[00:15:14] <strong>Nathan Wrigley:</strong> And in terms of kind of getting the recording software to work and things like that, how do those UIs function for you?</p>\n\n\n\n<p>[00:15:19] <strong>Bud Kraus:</strong> Yeah, pretty good. The problem I have with learning something new and complicated is that, I think it&#8217;s like everybody, quite frankly, I get confused and try to figure out where&#8217;s what. And like I was using, I use Descript, and it just took me quite a while to figure out, how do I do this? How do I do that? But like anything else, once I learn it, it&#8217;s pretty solid and it gets easier.</p>\n\n\n\n<p>Now I do tend to blow things up to make it bigger. And my wife is always telling me, I can&#8217;t use your computer because stuff is too big. Now, I don&#8217;t think it&#8217;s too big, but she does. And when I look at other people&#8217;s computers, then I realise, no, it&#8217;s bigger than theirs.</p>\n\n\n\n<p>[00:15:53] <strong>Nathan Wrigley:</strong> Okay, so we&#8217;re in the era of Gutenberg. It sounds like you&#8217;ve been using WordPress for a fairly long time, presumably before Gutenberg. What&#8217;s your opinion on whether or not that was a move in the right direction? In other words, is it favorable? Is it more straightforward for you to create a post? I know that you said in the scenario for a podcast, you&#8217;re writing it elsewhere and copying and pasting it in. But with other things like, I don&#8217;t know, laying out content and writing paragraphs and things, do you think it&#8217;s a good experience? Did we go in the right direction there?</p>\n\n\n\n<p>[00:16:18] <strong>Bud Kraus:</strong> That&#8217;s a very hard question for me to answer. I&#8217;ll answer it in a couple of different ways. One, as far as accessibility goes, I&#8217;m no expert in this. I am not an accessibility expert. Am I a stakeholder? We all are. But I can&#8217;t answer it in that regard.</p>\n\n\n\n<p>But from a more technical standpoint, because I write technical articles for Kinsta, Hostinger, others, that I find it to be difficult. I know I was told it&#8217;s not supposed to be easy, so it certainly doesn&#8217;t match the easy. Yeah, and that has nothing to do with my vision. It&#8217;s just, I feel it&#8217;s just complicated, even though I&#8217;ve learned quite a bit of the technical side of this stuff. I&#8217;m not trying to be cute here, but I&#8217;m trying to be cute, and I just can&#8217;t answer that question that&#8217;s going to provide any value so.</p>\n\n\n\n<p>[00:17:06] <strong>Nathan Wrigley:</strong> I was kind of wondering if there was a thing which, if you could click your fingers and make it appear in the Block Editor or the Gutenberg interface, which you would, and I don&#8217;t know that you&#8217;ve got got an answer to that.</p>\n\n\n\n<p>[00:17:15] <strong>Bud Kraus:</strong> I, let me think. No, I don&#8217;t think so. No. And I use Elementor too. So I think from a logic standpoint, Elementor seems to be easier for me. What I just don&#8217;t like is a lot of confusion. Too much information built into a UI is a real problem for me.</p>\n\n\n\n<p>Nathan, the funny thing is I feel like I have a special filter on the world that other people don&#8217;t have. This is another one of these blessings, that gives me the ability to understand what works and what doesn&#8217;t work without having to ask somebody because it&#8217;s just built in.</p>\n\n\n\n<p>Now, the thing about disability or this field in general, which is huge, it&#8217;s very idiosyncratic. So my setup is good for me, but it may not work for somebody else. And it&#8217;s very hard to, as those who keep accessibility in mind, and hopefully it&#8217;s everybody. It&#8217;s a very difficult subject because how do we design our systems, our content so that the greatest number of people can access this information, or whatever, on the largest number of devices. I mean, that&#8217;s what accessibility to me is about.</p>\n\n\n\n<p>[00:18:24] <strong>Nathan Wrigley:</strong> It&#8217;s curious that you said, I think you said at the beginning that your condition is one which will deteriorate over time.</p>\n\n\n\n<p>[00:18:31] <strong>Bud Kraus:</strong> Well, macular degeneration, generally, can get worse over time. But fortunately, for reasons that we don&#8217;t need to get into, since 1992 it&#8217;s been very stable, which I&#8217;m really fortunate because trust me, I don&#8217;t want it to get any worse than this. I don&#8217;t need another, that much of a blessing.</p>\n\n\n\n<p>[00:18:50] <strong>Nathan Wrigley:</strong> Yeah, I was wondering from that, whether or not the accessibility side of WordPress is something that you lean into. Do you attend those kind of, I don&#8217;t know, WP Accessibility Day, those kind of events?</p>\n\n\n\n<p>[00:18:59] <strong>Bud Kraus:</strong> No, it just doesn&#8217;t really interest me. You know, back in like 1999, 2000, I was teaching a course at Pratt Institute in New York called Accessible Web Design. And it was way ahead of its time. And the concepts I was teaching were basically concepts because the browsers and technology just wasn&#8217;t there yet. So you&#8217;d have to say, well, one day, and one day did happen in large measure.</p>\n\n\n\n<p>And then I started realising, I just didn&#8217;t want to like make a career out of teaching this or testing or, you know, I started to meet people in the field and I just said, I don&#8217;t really like this. I mean, just because I&#8217;m, I have a disability doesn&#8217;t mean I have to like the field of accessible design, you know, accessibility.</p>\n\n\n\n<p>[00:19:40] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s interesting. You are wearing a WordCamp Montclair t-shirt, which kind of tells me that not only are you attending this event, WordCamp US, but you&#8217;re also attending other ones as well. Is that a big part of your life? If it is, how accessible are things like this event? Do you come here fully expecting of yourself that you&#8217;ll have a full experience the same way that everybody else does?</p>\n\n\n\n<p>[00:19:59] <strong>Bud Kraus:</strong> Well, I have a good experience, but it is not the same way everybody else does. For example, I can&#8217;t see the screens at all. And when they&#8217;re doing stuff, the slides, I&#8217;m just listening, okay. It&#8217;s sort of like, I watch TV a lot that way too. I hear things. Unless I got really close, I&#8217;m not going to be able to see what&#8217;s on the screen. If I took a picture of something that&#8217;s really important, yeah, that&#8217;ll help.</p>\n\n\n\n<p>But generally speaking, that doesn&#8217;t work for me. And then it could be kind of a, yes, I&#8217;ve gone to many WordCamps, but they&#8217;re all sort of the same in terms of the issues. And I don&#8217;t even think of them as issues anymore. I just think of it as like, we&#8217;re all different. This is the way I&#8217;m different. And talking about this stuff, quite frankly is like talking about being right-handed. Would you do an interview of me being right-handed?</p>\n\n\n\n<p>[00:20:42] <strong>Nathan Wrigley:</strong> Yeah, fascinating. I guess, from my perspective, because I just don&#8217;t, I can&#8217;t prize that open my own life, it&#8217;s really intriguing to sort of try to have some sort of understanding of how it differs from my experience to your experience. And I guess for you it&#8217;s, this is how I live.</p>\n\n\n\n<p>[00:20:58] <strong>Bud Kraus:</strong> Yeah. But Nathan, you know, vision is a spectrum. It&#8217;s a continuum. It isn&#8217;t just everybody looks at things the same way. No. So I don&#8217;t think, alright, I&#8217;m like sort of on one end of the spectrum, I get it, but everybody looks at things differently. And I don&#8217;t mean that figuratively, I mean that literally. So I don&#8217;t think of it anymore much as a handicap, you know, other than the fact that, yeah, that&#8217;s a pain in the neck sometimes. And sometimes you find yourself doing some foolish things.</p>\n\n\n\n<p>And I think the hardest thing for me at these events is that I won&#8217;t know who I&#8217;m talking to until about five minutes after I&#8217;m talking to them, and I figured out by looking at their shape, stuff like that, that I can, oh, I&#8217;m talking to Nathan Wrigley, or your accent, or something like that.</p>\n\n\n\n<p>[00:21:42] <strong>Nathan Wrigley:</strong> Yeah. You&#8217;re obviously quite keen on the sort of education side of things though because you&#8217;re writing tutorials. I&#8217;ll link in the show notes to one that you wrote for Smashing Magazine, which is no mean feat. Getting in there is really rather impressive. So well done for that.</p>\n\n\n\n<p>But you&#8217;re also obviously turning up two events like this. And it sounds from what you said as if this is content that you&#8217;ve done before. So very keen on that, even though it may be talking about, you were describing there, it&#8217;s like talking about whether you&#8217;re right-handed. You&#8217;ve put together this presentation in which you&#8217;re going to share these different bits and pieces about how you make amendments and adjustments to WordPress and the operating system and so on. So do you enjoy the education side of it?</p>\n\n\n\n<p>[00:22:16] <strong>Bud Kraus:</strong> Oh, absolutely. I&#8217;m a teacher at heart. I mean, you know, that&#8217;s what I&#8217;ve been doing for 25 years. And even in the writings that I do, they&#8217;re basically, it&#8217;s a different way of teaching. Now the talk that I&#8217;m giving though here, the funny thing is, as I&#8217;ve said, I&#8217;m sort of like cool to the idea to be honest about it. There are other talks I&#8217;d rather give than this one, but this is the talk that everybody seems to be interested in. And I get that.</p>\n\n\n\n<p>And when you come up with a topic called using low vision is a tool to help me teach WordPress, that&#8217;s a winner because you got two things in there that everybody loves. One, we love disability, and two, we love teaching WordPress. So two weird things got put into one title.</p>\n\n\n\n<p>[00:22:57] <strong>Nathan Wrigley:</strong> It&#8217;s a hit.</p>\n\n\n\n<p>[00:22:58] <strong>Bud Kraus:</strong> It got to be a hit, right.</p>\n\n\n\n<p>[00:22:59] <strong>Nathan Wrigley:</strong> What would be the presentation that you would do?</p>\n\n\n\n<p>[00:23:01] <strong>Bud Kraus:</strong> Ah. The one that I&#8217;m threatening to do instead of this one, because I keep saying, I don&#8217;t wanna do this one, let me do another one. There&#8217;s two.</p>\n\n\n\n<p>One is, burnt out on web design, what your future career could be, which is my story.</p>\n\n\n\n<p>And the other one is, show me the money, how to get sponsors to financially help with your podcast, event, whatever. I like that topic, show me the money.</p>\n\n\n\n<p>[00:23:24] <strong>Nathan Wrigley:</strong> Paraphrasing, just a minute, what are the nuggets? Because I&#8217;m curious about that one.</p>\n\n\n\n<p>[00:23:27] <strong>Bud Kraus:</strong> Oh, come on. You could teach me, okay?</p>\n\n\n\n<p>[00:23:30] <strong>Nathan Wrigley:</strong> What are the nuggets in there though?</p>\n\n\n\n<p>[00:23:32] <strong>Bud Kraus:</strong> Well, in my case with my podcast, I&#8217;ve been sort of lucky in that they came to me and said, we&#8217;d like to sponsor you. Which is a shock because when I started the podcast a year and a half ago, or actually the idea was, it&#8217;s now two years old, I said, I didn&#8217;t care if anybody ever listened, I didn&#8217;t care if anybody ever sponsored. And then of course, over time, I did care.</p>\n\n\n\n<p>But I never thought of my show ever being sponsored. I said, I&#8217;ll just do it. And then I started realising, hey, this takes a lot of time, should get paid for this. And, you know, I feel just, if I have a second or two say how fortunate I am to be a part of all of this because at my advanced age, to be in this community with such smart, brilliant, whatever, people that are friendly. When I talk to people my age who are generally retired or retiring and, their world gets smaller and mine gets bigger.</p>\n\n\n\n<p>[00:24:24] <strong>Nathan Wrigley:</strong> Oh, that&#8217;s interesting.</p>\n\n\n\n<p>[00:24:25] <strong>Bud Kraus:</strong> So I&#8217;m really, really lucky about that.</p>\n\n\n\n<p>[00:24:28] <strong>Nathan Wrigley:</strong> Yeah. I don&#8217;t know what your age is, but I am of a certain age, and I&#8217;m kind of feeling at the moment that there&#8217;s this whole thing which everybody wants to talk about, which is AI. And I&#8217;m kind of feeling as if that train has already, you know, that ship has sailed for me. Can&#8217;t invest all of the time and what have you to learn all of the different bits and pieces. It&#8217;s like there&#8217;s another bus coming. I don&#8217;t know what you think about that.</p>\n\n\n\n<p>[00:24:47] <strong>Bud Kraus:</strong> Well, I&#8217;ll tell you what it is, for me, it&#8217;s been a career extender, because I am now writing at a level for Kinsta, technical articles that I could not otherwise write. And because of my use of, and if you will, mastery of AI, I&#8217;ve been able to code things that I could not do before. So I&#8217;ve always had sort of, for the longest time, because I taught great foundation of HTML, CSS, some JavaScript, whatever. So I know this stuff, okay.</p>\n\n\n\n<p>But to elevate that knowledge, to create stuff now that is much more complicated, sort of like junior development oriented stuff or maybe a little bit beyond that. That is amazing. And it&#8217;s because of AI.</p>\n\n\n\n<p>[00:25:28] <strong>Nathan Wrigley:</strong> That&#8217;s fascinating.</p>\n\n\n\n<p>[00:25:30] <strong>Bud Kraus:</strong> It&#8217;s extending what I can do.</p>\n\n\n\n<p>[00:25:32] <strong>Nathan Wrigley:</strong> Yeah, you feel like you&#8217;ve got a new lease of life there.</p>\n\n\n\n<p>[00:25:34] <strong>Bud Kraus:</strong> Yeah, a bit. So I don&#8217;t have to keep writing the same things over and over about how to create a post. You know, I&#8217;ve done that. I want to be challenged to learn new things, and AI is helping me do that. And we&#8217;re teaching AI, and AI is teaching us. So it&#8217;s really cool.</p>\n\n\n\n<p>[00:25:49] <strong>Nathan Wrigley:</strong> Your presentation, is it today or tomorrow?</p>\n\n\n\n<p>[00:25:51] <strong>Bud Kraus:</strong> Well, it&#8217;s tomorrow.</p>\n\n\n\n<p>[00:25:53] <strong>Nathan Wrigley:</strong> I was going to say, you&#8217;re looking very calm for somebody that has a presentation later today.</p>\n\n\n\n<p>[00:25:56] <strong>Bud Kraus:</strong> Well, you know, I&#8217;ve been around the block. I&#8217;m not going to be nervous. Now what I do have to do is I&#8217;ve got to do some more memorisation. And that&#8217;s what I talked about always being prepared. I just can&#8217;t go in there and read the slides. It&#8217;s not going to happen. So I have to really know what the slides are, what the order is, and what the words are on the screen. I don&#8217;t have to read those words, but I have to know the ideas behind all this.</p>\n\n\n\n<p>[00:26:16] <strong>Nathan Wrigley:</strong> So in some sense, you&#8217;ve memorised it more or less. Oh, that&#8217;s interesting. So you&#8217;ve really applied thought to every, more or less, every sentence that comes out of your mouth.</p>\n\n\n\n<p>[00:26:24] <strong>Bud Kraus:</strong> Basically.</p>\n\n\n\n<p>[00:26:25] <strong>Nathan Wrigley:</strong> But you don&#8217;t get nervous.</p>\n\n\n\n<p>[00:26:26] <strong>Bud Kraus:</strong> We&#8217;re with friends.</p>\n\n\n\n<p>[00:26:28] <strong>Nathan Wrigley:</strong> I would get so nervous.</p>\n\n\n\n<p>[00:26:29] <strong>Bud Kraus:</strong> At least I like to think so.</p>\n\n\n\n<p>[00:26:30] <strong>Nathan Wrigley:</strong> Yeah. No, I agree. Every time I&#8217;ve been to a presentation, even when the person delivering it has been quite nervous, there&#8217;s always been a very positive sentiment in the room.</p>\n\n\n\n<p>[00:26:39] <strong>Bud Kraus:</strong> I&#8217;ll tell you why I don&#8217;t get nervous, I don&#8217;t see their faces.</p>\n\n\n\n<p>[00:26:41] <strong>Nathan Wrigley:</strong> Oh.</p>\n\n\n\n<p>[00:26:42] <strong>Bud Kraus:</strong> So if you don&#8217;t see their faces. There&#8217;s so many advantages of vision impairment. I know it sounds crazy, but if you don&#8217;t see their faces, then you don&#8217;t see their reactions. Now, of course, that&#8217;s a negative too. But then you don&#8217;t get nervous.</p>\n\n\n\n<p>[00:26:55] <strong>Nathan Wrigley:</strong> Absolutely fascinating. Well, I wish you the best of luck with it. It will be out on wordpress.tv at some point. Typically now they come out really soon. These flagship events, they turn them around really quickly.</p>\n\n\n\n<p>[00:27:06] <strong>Bud Kraus:</strong> Well, I don&#8217;t know when this is coming out, but this is going to be live streamed around the world.</p>\n\n\n\n<p>[00:27:09] <strong>Nathan Wrigley:</strong> Is it?</p>\n\n\n\n<p>[00:27:10] <strong>Bud Kraus:</strong> Yeah. So one person can watch.</p>\n\n\n\n<p>[00:27:11] <strong>Nathan Wrigley:</strong> The point being, dear listener, that if you&#8217;ve enjoyed this episode and you want to follow on the talk, the presentation that Bud has given at WordCamp US, by the way, maybe the quickest way to do that is to just Google, either WordCamp US 2025. Or Google, using low vision as my tool to help me teach WordPress. That&#8217;s the other short circuit if you like. You&#8217;ll be able to see exactly what it is that Bud delivered.</p>\n\n\n\n<p>I have no further questions, so unless you&#8217;ve got something to add, I will say thank you very much for chatting to me.</p>\n\n\n\n<p>[00:27:40] <strong>Bud Kraus:</strong> Well, thank you Nathan. And you know I&#8217;m a big fan of what you do and thanks for having me on.</p>\n\n\n\n<p>[00:27:43] <strong>Nathan Wrigley:</strong> Thank you so much.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://seriouslybud.com/\">Bud Kraus</a>.</p>\n\n\n\n<p>Bud was diagnosed with macular degeneration, a condition often associated with old age, when he was 37. Affecting both eyes, this gradually eroded his central vision, making it difficult for him to see straight ahead, recognize faces, drive or read. Despite these challenges, Bud’s peripheral vision remained intact, sparing him the need for a cane or guide dog, and allowing him to continue to navigate daily life. Through perseverance and adaptation, Bud continues to live fully, facing the hurdles of vision loss with resilience and optimism.</p>\n\n\n\n<p>Bud opens up the podcast by talking about his experience living with legal blindness, how his central vision loss has shaped everything from everyday activities to his professional routines. He explains the practical ways he adapts his devices and workflow, including tweaks to operating system settings, using screen zoom functions, and relying on pattern recognition to teach coding, write tutorials, and even host his Seriously, Bud podcast. His unique perspective sheds light on the often-overlooked nuances of accessibility, reminding us that every user interacts with technology differently.</p>\n\n\n\n<p>Bud also chats about the broader impact of accessibility in the WordPress space, from frustrations with hard-to-navigate interfaces to the importance of not excluding users who may become your audience or customers. His reflections reveal how living with low vision pushed him beyond mere acceptance, helping him discover new opportunities, hone his teaching skills, and even find humour in daily challenges.</p>\n\n\n\n<p>Bud’s story serves as a powerful reminder of the importance of designing with empathy, embracing adaptation, and viewing accessibility not just as a technical requirement, but as a source of creativity and connection. It’s full of real-world tips, personal anecdotes, and a dose of inspiration.</p>\n\n\n\n<p>Whether you’re a designer, developer, educator, or simply passionate about building a more inclusive web, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2025/session/using-low-vision-as-my-tool-to-help-me-teach-wordpress/\">Using Low Vision As My Tool To Help Me Teach WordPress</a>, Bud&#8217;s presentation at WordCamp US 2025</p>\n\n\n\n<p><a href=\"https://www.freedomscientific.com/products/software/jaws/\">JAWS, Job Access With Speech software</a></p>\n\n\n\n<p><a href=\"https://www.pratt.edu/\">Pratt Institute</a></p>\n\n\n\n<p><a href=\"https://www.descript.com/\">Descript</a></p>\n\n\n\n<p><a href=\"https://www.smashingmagazine.com/2018/05/using-low-vision-teach-wordpress/\">Using Low Vision As My Tool To Help Me Teach WordPress</a>, Bud&#8217;s post on Smashing Magazine</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Open Channels FM: From Home Kitchen to International Orders\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110428\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://openchannels.fm/from-home-kitchen-to-international-orders/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"Using WooCommerce and open source to take kitchen baking into an online cake business, embracing cake in a jar and building a vibrant brand with community support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Oct 2025 12:41:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Tim &amp;amp; Pablos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/10/tim-pablos/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:652:\"<p>Two of my favorite humans, <a href=\"https://tim.blog/\">Tim Ferriss</a> and <a href=\"https://pablosspeaks.com/\">Pablos Holman</a>, had a great interview together.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>Pablos has a <a href=\"https://www.amazon.com/dp/B0F23CLXZP\">great new book out</a>, and <a href=\"https://audrey.co/\">Audrey Capital</a> is a happy LP in his <a href=\"https://deepfuture.tech/\">Deep Future fund</a>. Of my many hacker friends, Pablos is probably the most public.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Oct 2025 13:36:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Open Channels FM: How Decentralized Social Platforms Grew from Identica to Modern-Day Mastodon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://openchannels.fm/how-decentralized-social-platforms-grew-from-identica-to-modern-day-mastodon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"Matthias Pfefferle discusses the Fediverse\'s origins and evolution with Evan Prodromou, highlighting decentralized social networks, protocols, privacy, and the future of federated systems.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Oct 2025 11:12:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Beeper Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150133\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/beeper-updates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:277:\"<p><a href=\"https://blog.beeper.com/2025/10/06/beeper-september/\">Beeper has a fun set of September updates</a>, adding support for Google Voice, LinkedIn now runs on-device, typing indicators for Google Messages and Instagram, full Telegram custom emoji support, and more.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Oct 2025 18:22:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Open Channels FM: Why Linking and Permalinks Are the Backbone of the Open Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://openchannels.fm/why-linking-and-permalinks-are-the-backbone-of-the-open-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"Dave Winer talks about the open web\'s basics, emphasizing that linking is crucial for real connection. Platforms limiting links miss out on that vibrant web experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Oct 2025 12:49:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Tammie Lister: September in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://binatethoughts.com/?p=2455\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://binatethoughts.com/september-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5187:\"<p>Another month has turned just like the leaves as autumn settles in. I was lucky enough to get time to focus thanks to sponsors, here is what I did within WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">August reflections</h2>\n\n\n\n<p>It’s worth noting I am aware that August didn’t have a month post, this was due to travelling back from being at WordCamp US. This post is a merged month in many sense as the theme has maintained the same as September saw solidifying of what I was doing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A new team</h2>\n\n\n\n<p>The Core Program team was <a href=\"https://make.wordpress.org/project/2025/09/15/announcing-the-core-program-team/\">announced</a> and I will be the first team rep. This was a huge part of this month as required setting up and focus. I am beyond excited what this means. </p>\n\n\n\n<p>I am thrilled to say <a href=\"https://www.bigscoots.com/\">BigScoots</a> is sponsoring me to cover some time focusing on the Core Program team and thankful for the opportunity to go to sponsors and highlight where I am needed most.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Focusing on AI and editor</h2>\n\n\n\n<p>Relating to the last section a little, <a href=\"https://greyd.io/\">Greyd</a> are now going to be sponsoring me to focus both on Core AI and also on Core Editor. This combination allows me to focus even more my contributions where they can be effective. </p>\n\n\n\n<p>This split focus will add to <a href=\"https://servmask.com/\">ServMask’s</a> sponsorship of me within Core AI already to give me extra time within that area.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Areas of contribution</h2>\n\n\n\n<p>My split this month was given a new focus thanks to being a team rep for a new <a href=\"https://make.wordpress.org/program/2025/09/12/welcome-to-the-core-program-team/\">team announced</a>, Core Program. Beyond that, top areas were:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>&#8216;Needs design&#8217;</strong>: adding design to Core AI experiments.</li>\n\n\n\n<li><strong>Triage:</strong> focused on 6.9 design issues, unblocking and also giving feedback.</li>\n\n\n\n<li><strong>Program team work</strong>: establishing team and getting goals brewing. Weekly posts <a href=\"https://make.wordpress.org/program/tag/this-week/\">here</a>.</li>\n\n\n\n<li><strong>Core AI:</strong> focusing on roadmaps.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Sharing the journey</h2>\n\n\n\n<p>I got to share a few things this month, I also got to attend LoopConf and speak about AI at the local WP London meetup the night before:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://binatethoughts.com/the-sparkle-paradox-how-ai-signalling-undermines-adoption/\">The sparkle paradox</a>: specifically fuelled the designs I worked on for Experiments.</li>\n\n\n\n<li>Spoke at WPLDN about &#8216;<a href=\"https://www.wpldn.uk/talk/when-the-interface-doesnt-matter-anymore/\">When the Interface doesn’t matter anymore</a>&#8216;.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><br />Upcoming plans for contribution</h2>\n\n\n\n<p>October is already shaping up to be busy with Core Program and the 6.9 release.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Triage: </strong>focus on 6.9, but I don’t want to ignore the <a href=\"https://core.trac.wordpress.org/tickets/ancient\">ancient and inactive</a> trac log. This month triage won’t be my main focus but more about unblocking</li>\n\n\n\n<li><strong>Core AI:</strong> feedback and iterations for experiments and program work on abilities. I would also love to work on the <a href=\"https://github.com/WordPress/ai/discussions/23\">documentation</a> and handbook if time.\n<ul class=\"wp-block-list\">\n<li>I had some awesome fun working on the issues for experiments. <a href=\"https://github.com/WordPress/ai/issues/13#issuecomment-3352028955\">#</a> <a href=\"https://github.com/WordPress/ai/issues/12#issuecomment-3353681251\">#</a> <a href=\"https://github.com/WordPress/ai/issues/11#issuecomment-3352146880\">#</a> <a href=\"https://github.com/WordPress/ai/issues/10#issuecomment-3352689787\">#</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Core Program: </strong>shape goals collaboratively, goals will be posted weekly on #core-program in Slack.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Sponsors this month</h2>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>I now have these sponsors and from this month I am highlighting the areas they are helping me focus on if sponsoring a particular focus. </p>\n\n\n\n<p><a href=\"https://www.bigscoots.com\">BigScoots</a> (Core Program), <a href=\"https://greyd.io\">Greyd</a> (Core AI / Core Editor), <a href=\"https://kinsta.com\">Kinsta</a> (Triage), <a href=\"https://servmask.com\">ServMask</a> (Core AI), <a href=\"https://github.com/aaronjorbin\">Aaron Jorbin</a>, <a href=\"https://github.com/timnashcouk\">Tim Nash</a>, <a href=\"https://github.com/jeffpaul\">Jeffrey Paul</a> and <a href=\"https://github.com/scotrumery\">Scot Rumery</a> (<a href=\"https://rumspeed.com/about/\">Rumspeed</a>). To everyone who sponsored me and helped me secure sponsorship, thank you.</p>\n\n\n\n<p>Want to sponsor me? You can through <a href=\"https://github.com/sponsors/karmatosed\">GitHub</a>.</p>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Oct 2025 09:06:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"binatethoughts.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Telegram and Weird Al\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150113\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://ma.tt/2025/10/telegram-and-weird-al/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2529:\"<p>I have two interesting interviews to share with you today, the first is <a href=\"https://www.youtube.com/watch?v=qjPH9njnaVU\">Lex Fridman interviewing Pavel Durov</a>, the founder of <a href=\"https://telegram.org/\">Telegram</a>. I started using and advocating for Telegram back in 2015, and <a href=\"https://audrey.co/\">Audrey Capital</a> was part of their aborted fundraise in 2018. As a software craftsperson, I&#8217;ve always had tremendous respect for the team and the rate at which they shipped truly novel design and UI. I&#8217;m amazed by the speed at which they ship major features across multiple platforms. The network also has incredibly resiliency, which they get into on the podcast. As I&#8217;m often in poor connectivity situations in planes or remote locations, Telegram has been one of the networks that works most reliably.</p>\n\n\n\n<p>I&#8217;ve met Pavel only briefly about a decade ago, but have followed his story as he&#8217;s a unique character with an ascetic lifestyle, target of many intelligence agencies, sperm donor father of 100+ children, and many other unique characteristics. I use Telegram like I use X/Twitter, I put things I consider semi-public on it and I think of it like a social network and development platform, and <a href=\"https://ma.tt/2022/08/telegram-channel/\">since 2022 I&#8217;ve cross-posted my blog to a Telegram channel using a Jetpack bot</a>. It&#8217;s probably my favorite community platform. The four hour interview between Lex and Pavel covers a lot of ground, but product builders will probably appreciate most the middle part around the 2-hour mark where they go into their engineering and design philosophies. (BTW I usually watch/listen to these at 2x speed.)</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>If you&#8217;re looking for something a little lighter on a Sunday I recommend this <a href=\"https://www.youtube.com/watch?v=sSu2eMkIyZs\">heart-warming conversation between John Mayer and Weird Al Yankovic</a>.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>I know this seems like an unusual pairing, but both Pavel and Weird Al are hackers in the sense that they examined the rules of the system and decided to create a new game.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 05 Oct 2025 21:08:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Tammie Lister: Why Gentle Leadership Builds Better Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://binatethoughts.com/?p=2447\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://binatethoughts.com/why-gentle-leadership-builds-better-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11249:\"<p>We&#8217;ve all seen it. A product launches, a feature ships, a choice gets made. And within hours, the not-so-hot, more grumpy takes arrive. Threads dissecting every misstep. Social media posts stating how they&#8217;d have done x or y better. Statements across the web cataloguing failures. Commentary that positions the critic as the one who would have done it better. This happens even more on Open Source projects, we&#8217;ve all seen it across WordPress.</p>\n\n\n\n<p>This is an increasingly prevalent issue in product circles. Yet, we seldom highlight the human impact of this culture and the more effective alternatives that can truly foster better products and stronger teams. Even more so in open source. It&#8217;s also worth noting that those who can drive change, those called and looked to as product leaders, are often the ones who contribute most to the problem. By inspiring others and adopting more positive practices, we can foster a more collaborative and thriving environment for everyone involved.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Changing Position of the Role of Product</h2>\n\n\n\n<p>My experience in product is a journey many of us share as we grew alongside the practice. We often had to fight for our place at the table, sometimes moving gently and other times more forcefully to ensure our voices were heard.</p>\n\n\n\n<p>Times have changed, and now the product is at the centre of much of our work. It no longer needs to prove its worth or challenge existing components; instead, it should avoid adopting harmful practices seen in longer traditions, such as design, which have led to dangerous and destructive patterns of critique. It&#8217;s possible to disagree without resorting to tearing others down or stripping away their contributions. In fact, taking a more constructive approach is a sign of greater skill, as many of us have come to learn.</p>\n\n\n\n<p>Throughout my career, I have learned a great deal through trial and error, thanks to the incredible mentors who guided me and the space they provided for me to understand. Their compassion and calmness shaped my understanding of leadership; it&#8217;s not just about being in the spotlight, which was a breath of fresh air for someone like me who thrives behind the scenes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Psychology of What We&#8217;re Really Doing</h2>\n\n\n\n<p>When we share our thoughts on products and the teams behind them, we&#8217;re doing more than just providing feedback; we&#8217;re meant to encourage accountability and nurture growth. The impact of our words can ripple far beyond the initial conversation, creating a meaningful dialogue.</p>\n\n\n\n<p>Studies in self-determination theory reveal that environments filled with criticism, rather than constructive support, can lead to loss of motivation. This is especially true over time. In open-source and collaborative spaces, the consequences are even more significant. Unhelpful criticism can generate conflicts and discourage participation, particularly for those from underrepresented backgrounds. Our language truly matters, and it becomes even more powerful when coming from influential voices.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Leadership is about making others better as a result of your presence and making sure that impact lasts in your absence.&#8221;</p>\n\n\n\n<p><a href=\"https://www.goodreads.com/quotes/785876-leadership-is-about-making-others-better-as-a-result-of\" rel=\"noreferrer noopener\" target=\"_blank\">Sheryl Sandber</a>g</p>\n</blockquote>\n\n\n\n<p>The evidence suggests that public criticism, especially when not accompanied by constructive input, doesn&#8217;t enhance products. Instead, it risks stifling the very voices we should be championing to drive improvement and innovation. Let&#8217;s strive to uplift one another and create positive pathways for making. I know I want to create in a space like that, and I&#8217;m reasonably sure those who often critique the loudest do.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What Leadership Actually Looks Like</h2>\n\n\n\n<p>This isn&#8217;t about being soft or avoiding critical conversations, far from it. But if harsh criticism is all you&#8217;re known for, people eventually stop listening. By taking this approach, you are showing an understanding that great products emerge from empowered teams, not demoralised ones.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;To me, leadership is about encouraging people. It&#8217;s about stimulating them. It&#8217;s about enabling them to achieve what they can achieve — and to do that with a purpose.&#8221;</p>\n\n\n\n<p><a href=\"https://www.washingtonpost.com/business/on-leadership/lagarde-on-leadership-its-about-encouraging-people/2014/07/11/4696f284-06b5-11e4-a0dd-f2b22a257353_story.html\" rel=\"noreferrer noopener\" target=\"_blank\">Christine Lagarde</a></p>\n</blockquote>\n\n\n\n<p>The difference between critique and leadership is simple. Leaders focus on building capability, not broadcasting judgment. They build up whilst also setting on a path for that building. It&#8217;s certainly a harder thing to do, but in the long term, far more rewarding for both the leader and those involved. Being the critic, even if you have been elevated to a lead, eventually casts you as the villain of the piece, and that&#8217;s not good for anyone&#8217;s heart. Most leads got there through being incredible makers in the first place; somewhere along the way, they shifted from making to criticising, from building to broadcasting judgment.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Alternative: Being Part of the Solution</h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;I raise my own voice—not so that I can shout, but so that those without a voice can be heard.&#8221;</p>\n\n\n\n<p><a href=\"https://www.goodreads.com/quotes/6628892-i-raise-up-my-voice-not-so-that-i-can\" rel=\"noreferrer noopener\" target=\"_blank\">Malala Yousafzai</a></p>\n</blockquote>\n\n\n\n<p>If you see a product or team struggling, you have choices beyond posting about it.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Mentor someone on the team.</strong> Reach out privately. Offer your experience. It is often more impactful to say it privately. Share what you&#8217;ve learned from similar challenges. </li>\n\n\n\n<li><strong>Contribute directly.</strong> If it&#8217;s open source, submit a thoughtful pull request. If it&#8217;s not, offer specific, actionable feedback through proper channels. Build the bridge instead of pointing out it&#8217;s incomplete.</li>\n\n\n\n<li><strong>Support publicly, guide privately.</strong> Public spaces should be for celebrating attempts, acknowledging effort, and showing solidarity. Save detailed feedback for contexts where it can actually be heard and acted upon.</li>\n\n\n\n<li><strong>Balance your critiques with equal praise. </strong>When was the last time you praised a feature? Do that as much as you also critique and balance.</li>\n\n\n\n<li><strong>Build knowledge, not status.</strong> Research shows that when team members feel their psychological needs met, such as autonomy, competence, and relatedness, they&#8217;re far more likely to develop intrinsic motivation and engage meaningfully with their work. Your role as a leader isn&#8217;t to prove you could have done better. It&#8217;s to help others actually do better. </li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">The Myth of &#8220;Necessary Toughness&#8221;</h2>\n\n\n\n<p>There&#8217;s a belief in some communities that toxicity is &#8220;a naturally occurring if not necessary facet of culture.&#8221; This is demonstrably false. Toxic behaviour causes contributors to leave projects and creates barriers to participation, particularly for newcomers and those from underrepresented communities. It causes burnout not just in those receiving but also in those giving. It eats at you.</p>\n\n\n\n<p>Gentle leadership isn&#8217;t weak leadership. It&#8217;s strategic leadership. It&#8217;s essential to understand that the long-term health of products and communities depends on creating environments where people want to contribute their best work, not environments where they&#8217;re afraid to take risks and fail.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Evaluating Your Leadership</h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;You can evaluate the quality of your authority by looking deeply to see if compassion is the foundation of your leadership.&#8221;</p>\n\n\n\n<p><a href=\"https://laidlawscholars.network/posts/see-if-compassion-is-the-foundation-of-your-leadership\" rel=\"noreferrer noopener\" target=\"_blank\">Zen Buddhist monk Thích Nhất Hạnh</a> </p>\n</blockquote>\n\n\n\n<p>This isn&#8217;t just an abstract philosophy. You can apply a practical lens for examining how we show up as leaders. The next time you&#8217;re tempted to post about what&#8217;s wrong with someone else&#8217;s or your own product, ask yourself:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Will this help the team, the product improve, or position me as knowledgeable?</li>\n\n\n\n<li>Who does this harm and who does this serve?</li>\n\n\n\n<li>Could I offer this insight in a way that builds rather than breaks?</li>\n\n\n\n<li>Am I solving a problem or performing expertise?</li>\n</ul>\n\n\n\n<p>The products that endure, the teams that innovate, they don&#8217;t come from cultures of constant public criticism. They come from environments where people feel safe to experiment, supported when they stumble, and mentored toward excellence.</p>\n\n\n\n<p>Your influence as a product leader isn&#8217;t measured by how effectively you can identify flaws; it&#8217;s also about how effectively you can address them. It&#8217;s measured by how many people do better work because you were there.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Building Better, Together</h2>\n\n\n\n<p>Every product you see represents countless hours of human effort, difficult trade-offs, and people doing their best with the information and resources available to them. Before you critique, consider how you might contribute. Before pointing out failures, consider how you can prevent them in the future by teaching, mentoring, and supporting.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;At the end of the day, at the end of the week, at the end of my life, I want to say I contributed more than I criticised.&#8221;</p>\n\n\n\n<p><a href=\"https://www.goodreads.com/work/quotes/62183586-dare-to-lead-brave-work-tough-conversations-whole-hearts\" rel=\"noreferrer noopener\" target=\"_blank\">Brené Brown</a></p>\n</blockquote>\n\n\n\n<p>The industry doesn&#8217;t need more critics. It needs more builders. It requires leaders who understand that gentle doesn&#8217;t mean permissive, and that the strongest teams are built on foundations of trust, growth, and mutual support.</p>\n\n\n\n<p>If I can leave one thought at the end of this, it would be to consider: &#8220;What impact will your leadership have?&#8221; Great products are built by great teams. Great teams are built by leaders who lift others. Choose to be that leader.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 05 Oct 2025 11:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"binatethoughts.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Greenwashing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150105\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/greenwashing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3909:\"<p>Tonight there was a lovely event at <a href=\"https://tinkertendo.com/\">TinkerTendo</a> by Raman Frey and Karin Johnson of <a href=\"https://www.gpdinners.com/\">Good People Dinners</a>, this one honoring <a href=\"https://davidgelles.com/\">David Gelles&#8217;</a> new book, <a href=\"https://www.amazon.com/Dirtbag-Billionaire-Chouinard-Patagonia-Fortune/dp/1668032260?tag=photomatt08-20\">Dirtbag Billionaire: How Yvon Chouinard Built Patagonia, Made a Fortune, and Gave It All Away</a>. I&#8217;m a huge fan of Yvon Chouinard and really enjoyed his book <a href=\"https://www.amazon.com/Let-People-Surfing-Education-Businessman/dp/1594200726/?tag=photomatt08-20\">Let My People Go Surfing</a> which I read back in 2018. It was the first time hosting such a large 60-person dinner in the TinkerTendo warehouse, and thanks to <a href=\"https://copperhome.com/\">this Copper battery-operated induction stovetop</a> and an amazing local chef, <a href=\"https://www.komaaj.com/\">Hanif Sadr</a>, the food turned out amazing.</p>\n\n\n\n<p>I&#8217;ve only started the new book, but I&#8217;m interested to see what&#8217;s happened in the 20 years between Yvon&#8217;s book and David&#8217;s, especially the story of <a href=\"https://www.nytimes.com/2022/09/14/climate/patagonia-climate-philanthropy-chouinard.html\">how Yvon gave away all his equity and control in the company</a> to ensure a focus on his lifelong goal of environmentalism and conservation. Patagonia is one of the better corporate entities fighting for good, but it reminded me of how companies can put on a jacket of doing good while actually being evil underneath.</p>\n\n\n\n<p>Like I talked about the <a href=\"https://ma.tt/2025/09/externalities/\">economic concept of Externalties a few weeks ago</a>, I think it&#8217;s imperative that the WordPress community understands the history of <a href=\"https://en.wikipedia.org/wiki/Greenwashing\">Greenwashing</a>, which the <a href=\"https://www.un.org/en/climatechange/science/climate-issues/greenwashing\">United Nations defines as follows</a>:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Claiming that the company will achieve future environment milestones while not putting sufficient plans in place to do so.</li>\n\n\n\n<li>Being intentionally vague about operations or using vague claims that cannot be specifically proven (like saying they are &#8220;environmentally friendly&#8221; or &#8220;green&#8221;).</li>\n\n\n\n<li>Saying that a product does not contain harmful materials or use harmful practices that they would not use anyway.</li>\n\n\n\n<li>Highlighting one thing the company does well regarding the environment while not doing anything else.</li>\n\n\n\n<li>Promoting products that meet regulatory minimums as if peer products do not.</li>\n</ol>\n\n\n\n<p>In <a href=\"https://wordpress.org/\">WordPress</a> and open source our environmental crisis comes from companies that frack the open source software and brands, which shows up as lack of investment in the code which falls fallow <a href=\"https://tech.eu/2025/07/25/chronic-underfunding-of-open-source-software-poses-strategic-risk-to-europes-digital-sovereignty/\">especially in the security sense</a>, or by attaching themselves to a brand or trademark and tricking people into thinking they&#8217;re associated with the Good Open thing, when they&#8217;re really a parasitic cancer on it.</p>\n\n\n\n<p>This is happening right now in WordPress, so when you see a company hire a good person or sponsor an event that seems on its own a good thing, and probably represents hundreds of thousands of dollars of investment, weigh that against the tens of millions they&#8217;re spending with their other hand to destroy the source of everything they&#8217;ve benefited from, and if they were to win, endanger every open source project. It&#8217;s an open source form of greenwashing, perhaps call it <a href=\"https://en.wikipedia.org/wiki/Openwashing\">openwashing</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 05 Oct 2025 06:44:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Gutenberg Times: Blocks galore, test template management, Woo product collections, and more—Weekend Edition 343\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42093\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20342:\"<p>Howdy, </p>\n\n\n\n<p>And just like that, the last quarter of 2025 has begun. It&#8217;s been an interesting year again, and now we are on the home stretch, heading into a Holiday season. It&#8217;s become my favorite time of the year when Autumn make nature paint trees and bushes in so many colors. After a life near evergreen Everglades of Florida, the middle European changing colors of the fall seems magical.</p>\n\n\n\n<p>Soon it&#8217;s time to plan for 2026. Speaking of which, in case you missed it, WordCamp Asia <a href=\"https://asia.wordcamp.org/2026/call-for-speakers-is-now-open/\">Call for Speakers</a> has been out for a couple of week, and the deadline is quite early: October 31, 2025. If you were thinking about going to WordCamp Asia, what would be a talk you would be interested in seeing in April of 2026? </p>\n\n\n\n<p>Anyway, the present is pretty amazing right now, too. So without further ado, the news. </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n<p>PS: This weekend, on October 3rd, Germany celebrates the <a href=\"https://en.wikipedia.org/wiki/German_Unity_Day\">35th anniversary of the Reunion</a> after the Iron Curtain was lifted. </p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#blocks-galore-with-telex\">Blocks Galore with Telex </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</a></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>.<strong>Jonathan Bossenger</strong>, WordPress 6.9 release co-lead for testing, is asking for your <a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>help to test changes to the template management</strong></a>. The new feature is a great enhancement to the way templates are handled in the Site Editor. More eyes are needed to make sure it&#8217;s the best it can be in the short amount of time until the first Beta version is released. The instructions are detailed, and Bossenger added a video to show how the various sections of this test should work.</p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined is-color-set\" style=\"color: #4c38c1; border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n</section>\n\n\n<div class=\"wp-block-spacer\" style=\"height: 39px;\"></div>\n\n\n\n<p>The security and maintenance release, <a href=\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\"><strong>WordPress 6.8.3 </strong></a>is now available. John Blackbourn led the release and shares the details in his release post. Update as soon as you can, as it plugs a few security holes.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Carlos Bravo</strong> issues the <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v21.8.0-rc.1\"><strong>release candidate for Gutenberg 21.8</strong></a> and it&#8217;s available for testing. The final release is scheduled for October 8. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\">Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9</a> with Beth Soderberg of <a href=\"https://bethink.studio/\">Bethink Studio</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 122 with Beth Soderberg\" class=\"wp-image-42236\" height=\"193\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-11-at-12.32.48.png?resize=652%2C193&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>In the WordPress VIP blog post and video, <a href=\"https://wpvip.com/case-studies/pew-research-center/\"><strong>Pew Research Center Builds Interactive Content at Scale</strong></a>, the Seth Rubenstein and his team share how they rebuilt their website using WordPress VIP to tackle challenges in a world where people seldom visit original sources. Their old method took weeks of custom coding for interactive content, which delayed publishing. By adopting a block-first strategy in 2022, they cut production time from weeks to minutes, enabling editors and designers to create quizzes and maps on their own. This shift allowed developers to focus on innovation while increasing publishing frequency and lowering costs with evergreen interactive content that engages audiences directly.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his video <a href=\"https://www.youtube.com/watch?v=l7GRSnSd7SM\"><strong>Level up your Product Collections</strong></a>, <strong>Brian Coords</strong> demonstrates the new features in WooCommerce 10.2. He covered carousel layouts, taxonomy filters (Category/Brand/Tag), and an improved Cross-Sells collection for displaying products.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Joanne Courtright</strong> of Groundworx released a new <a href=\"https://wordpress.org/plugins/groundworx-testimonial/\"><strong>Testimonials plugin</strong></a> in the WordPress repository. Get the skinny from her blog post:   <a href=\"https://groundworx.dev/blog/introducing-groundworx-testimonial-modern-testimonials-for-wordpress-block-themes/\">Introducing Groundworx Testimonial: Modern Testimonials for WordPress Block Themes</a>. &#8220;Most testimonial plugins are still stuck in the classic era. This one is designed for developers and site builders who want testimonials that “just work” with Gutenberg, she wrote. It aims to be Gutenberg-native, theme.json aware, and accessibility-first. It includes a dedicated Testimonial post type + flexible blocks.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Justin Tadlock</strong> released the first version of an <strong><a href=\"https://wordpress.org/plugins/x3p0-authors/\">Authors List Block</a></strong> for multi-author sites. &#8220;This is especially useful if you’re coming over from using a classic WordPress theme and need a block that’s similar to the old <code>wp_list_authors()</code> template tag,&#8221; he wrote. The plugin comes with a full array of block design tools. It also sports options to display number of posts, various order filters, and feed links. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-42113\" height=\"354\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-02-at-16.34.38-2.png?resize=652%2C354&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p><strong>Mike McAlister</strong> released his <a href=\"https://wordpress.org/plugins/ollie-menu-designer/\"><strong>Ollie Menu Designer</strong></a> for free in the WordPress repository. It is a powerful way to build  mobile and dropdown menus in the WordPress block editor—no coding required. For more details, watch <a href=\"https://www.youtube.com/watch?v=w96lghXWhiI\">his announcement video on YouTube. </a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"blocks-galore-with-telex\">Blocks Galore with Telex </h2>\n\n\n\n<p>In his post, <a href=\"https://www.pootlepress.com/2025/10/if-automattics-telex-builds-this-you-might-not-need-that-page-builder/\"><strong>If Automattic’s Telex Builds This, You Might Not Need That Page Builder</strong></a>, <strong>Jamie Marsland</strong> explores how Automattic&#8217;s Telex AI tool could transform WordPress by enabling users to extend existing core blocks rather than just creating new ones. Currently, Telex generates custom blocks like video effects and timelines, but extending core blocks like paragraphs, tables, or buttons requires complex developer skills. If Telex could extend core blocks and offer a public directory for sharing these extensions, it could replace traditional page builders by unlocking the full potential of WordPress&#8217;s native blocks without adding technical debt or duplication.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tammie Lister </strong>started her personal <a href=\"https://blocktober.fun/\"><strong>Blocktober</strong></a>, posting a block a day on the newly created site. Every day at noon, she uses Automattic&#8217;s Telex and builds a new block. Spanning the arc of history back to the 1980s, Lister started with an <a href=\"https://blocktober.fun/ascii-tetris/\">ASCII Tetris</a> block. Here goes my Thursday morning&#8230;. </p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-42099\" height=\"377\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-02-at-11.22.33.png?resize=652%2C377&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>In his latest blog post, <strong>Marko Ivanovic</strong> made a set of <strong><a href=\"https://ivanovicmarko.com/2025/09/25/telex-for-designers/\">blocks for designers</a></strong> with the help of Automattic&#8217;s Telex. Earlier he also created <a href=\"https://ivanovicmarko.com/2025/09/20/interactive-icons/\">animated icon blocks</a>. Ivanovic is a designer working for Automattic, and since 2022. His post on <a href=\"https://ivanovicmarko.com/2025/10/01/wordpress-and-design/\"><strong>how he rediscovered WordPress</strong></a> and why any designer should embrace WordPress is worth a read, too. And I love those sticky notes.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://ivanovicmarko.com/2025/09/25/telex-for-designers/\"><img alt=\"\" class=\"wp-image-42101\" height=\"331\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-02-at-11.30.51.png?resize=652%2C331&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>In preparation for the WordPress 6.9 release on December 2,  <strong>Justin Tadlock </strong>published a new tutorial on the WordPress Developer Blog: You  on how to implement <a href=\"https://developer.wordpress.org/news/2025/09/border-radius-size-presets-in-wordpress-6-9/\"><strong>Border radius size presets in WordPress 6.9</strong></a>. &#8220;You define an array of sizes that users can apply to blocks that support border radius. You can also reuse them within your own theme stylesheets and <code>theme.json</code> file.&#8221;, he wrote.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"border radius presets coming to WordPress 6.9 \" class=\"wp-image-42118\" height=\"337\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/border-radius-on-gradient.webp?resize=652%2C337&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>At WordCamp Gdynia I shared how to <strong><a href=\"https://wordpress.tv/2025/09/30/streamlined-block-theme-development-using-wordpress-playground-and-github-for-no-code-version-contr/\">use WordPress Playground and GitHub for No-Code Version Control of Site Editor Changes</a></strong> The recording of my talk is now on WordPress TV. You will learn how theme developers can leverage WordPress Playground alongside the Create Block Theme plugin to create a seamless, browser-based development environment that integrates directly with GitHub for version control—all without writing a single line of code. <a href=\"https://docs.google.com/presentation/d/1ffMAVMjFxm1Ai7p2JWWwZAK5vQN5ryCbh-VXOqDjRiQ/edit?usp=drive_web&amp;ouid=101776844630674138344\">The slides are available on Google Drive. </a></p>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://wordpress.tv/2025/09/30/streamlined-block-theme-development-using-wordpress-playground-and-github-for-no-code-version-contr/\"><img alt=\"\" class=\"wp-image-42115\" height=\"408\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/WCGdynia_-Block-Theme-Development-Playground-CBT-GitHub.jpg?resize=652%2C408&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 19px;\"></div>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor.</h2>\n\n\n\n<p>Long-time block developer <strong>Kevin Batdorf</strong> at <em>Extendify</em> just updated his <a href=\"https://github.com/KevinBatdorf/block-starter\"><strong>Block Starter plugin</strong> </a>repo—an &#8220;opinionated starter template for crafting WordPress block plugins,&#8221; as he calls it. It uses Tailwind v4 with output for the editor and frontend, TypeScript and Biome.js for code quality and type safety, and runs Playwright tests on PR using the Playground CLI. It also includes a Plugin Check on commits to main and before a release.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: &#8220;Building blocks&#8221; by jgbarah is licensed under CC BY-SA 2.0 and found on WordPress.org/openverse.</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 04 Oct 2025 07:41:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Matt: Linkrot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150093\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/10/linkrot/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2861:\"<p>One of the things I hate most on the internet, and part of the reason I started <a href=\"https://wordpress.org/\">WordPress</a>, was to fight linkrot. Ever since 1998, when <a href=\"https://www.w3.org/People/Berners-Lee/\">Tim Berners-Lee</a> wrote &#8220;<a href=\"https://www.w3.org/Provider/Style/URI\">Cool URIs Don&#8217;t Change</a>,&#8221; I&#8217;ve been obsessed with content management and ensuring that links don&#8217;t break. (BTW, TBL, a pioneer of creating the World Wide Web, <a href=\"https://www.newyorker.com/magazine/2025/10/06/tim-berners-lee-invented-the-world-wide-web-now-he-wants-to-save-it\">has a great new profile out in the New Yorker</a>.)</p>\n\n\n\n<p>I learned today from the <a href=\"https://newspack.com/\">Newspack</a> newsletter that the <a href=\"https://www.houstonpress.com/\">Houston Press</a> is now on WordPress. Newspack is a distribution or bundle of WordPress designed for journalism, and it is led by <a href=\"https://kinsey.nyc/\">Kinsey Wilson</a>, who began his career as a night-shift journalist covering cops for a newspaper in Chicago, went on to have top editorial and business positions at The New York Times, NPR, and USA TODAY, and ran WordPress.com for a few years, which gives him a very unique position to help craft WordPress for journalists and publishers.</p>\n\n\n\n<p>The Houston Press is an alt-weekly that wrote the very first profile of me in the world, <a href=\"https://ma.tt/2004/10/press-and-cnet/\">which I blogged about here</a>. There&#8217;s a funny quote in there:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>He recently considered taking a job with a San Francisco search-engine start-up, but ended up turning them down. “They have a ton of money…But it would be 50- or 60- or 70-hour weeks, a lot of work, and I wouldn’t have time” to do WordPress. </p>\n</blockquote>\n\n\n\n<p>That &#8220;search-engine start-up&#8221; was <a href=\"https://www.google.com/\">Google</a>! How the internet might have turned out differently if I had taken that job, as my Mom wanted me to (because they offered free food). I still think Google is one of the most interesting companies in the world, one of the few places I&#8217;d consider working if I weren&#8217;t running <a href=\"https://automattic.com/\">Automattic</a>.</p>\n\n\n\n<p>Back to linkrot, the original link to the profile in that article was <code>http://www.houstonpress.com/issues/2004-10-28/feature2.html</code>, which this morning didn&#8217;t work, but thanks to the Houston Press being on Newspack/WordPress I was able to ping Kinsey and his colleague Jason Lee was able to fix it so it redirects to the new canonical URL for that content in minutes. A little corner of the internet tidied up! I love the <a href=\"https://web.archive.org/\">Wayback Machine</a>, but not needing it is even better.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 04 Oct 2025 00:24:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: Blocktober\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150063\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/10/blocktober/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:406:\"<p>It&#8217;s so exciting to see what the creative minds like <a href=\"https://iconick.io/\">Nick Hamze</a> or <a href=\"https://tammielister.com/\">Tammie Lister</a> are doing with Automattic&#8217;s AI vibe coding tool, <a href=\"https://telex.automattic.ai/\">Telex</a>. Tammie is doing a Blocktober, <a href=\"https://blocktober.fun/\">a block every day this month of October, you should follow along</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Oct 2025 22:15:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Fight For Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/fight-for-open/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2067:\"<p>Sometimes the battle for open source and freedom can take on very prosaic and practical terms, but the wins can benefit everybody. To give an example: In <a href=\"https://www.beeper.com/\">Beeper</a> we need more memory for showing notifications, because we support end-to-end encryption for networks like Signal, but Apple&#8217;s default was to only give 15 megabytes — barely enough to do anything. The previous CEO of Beeper, Eric Migicovsky, started a lobbying effort with the <a href=\"https://digital-markets-act.ec.europa.eu/index_en\">EU’s Digital Markets Act</a> on behalf of the team to give third-party apps the same memory limits that Apple provides for their own apps, which is 50MB instead of 15MB. (And up to 250MB on their higher end devices.)</p>\n\n\n\n<p>Today we’ve gotten a notification that as part of iOS 26 update Apple has shipped to 2.3B devices around the world, our memory limits issue has been addressed globally, for every application developer, and some interoperability requests we had for <a href=\"https://developer.apple.com/documentation/telephonymessagingkit\">SMS/RCS</a> have been addressed for EU users. Kudos and huge thank you to Apple for giving us all new capabilities to build amazing experiences for users on par with what they seek to deliver themselves. If you want to geek out on this, <a href=\"https://blog.beeper.com/2025/10/01/how-beeper-ios-implements-notifications/\">check out the technical deep dive that Beeper just posted</a>.</p>\n\n\n\n<p>BTW, if you haven&#8217;t heard of it yet, <a href=\"https://www.beeper.com/\">Beeper</a> is an Automattic product which aims to democratize messaging, just like WordPress democratized publishing for the world, by allowing you to get all your messages from friends across 11 different networks, like WhatsApp, Instagram, Telegram, Twitter/X, Signal, Discord, in one single inbox. The new version we launched in July does this in a completely secure way that&#8217;s local to your device, so the same encryption, privacy, and security each network provides is maintained.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Oct 2025 20:29:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"WPTavern: #187 – June Liu and David Denedo on Making the Web Accessible: The Mission Behind WP Accessibility Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=199767\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://wptavern.com/podcast/187-june-liu-and-david-denedo-on-making-the-web-accessible-the-mission-behind-wp-accessibility-day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48317:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case, making the web accessible, and the mission behind WP Accessibility Day.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have June Liu and David Denedo.</p>\n\n\n\n<p>Both June and David are key members of the WP Accessibility Day organizing team, a global, volunteer driven, event focused on improving accessibility in the WordPress ecosystem.</p>\n\n\n\n<p>June serves as the marketing team co-lead, and works with sponsors, bringing her background in project management to keep the events efforts on track.</p>\n\n\n\n<p>David, a web designer and content creator based in London, contributes to the marketing and post-event teams, with his interest in web accessibility stemming from his personal experience as a visually impaired user.</p>\n\n\n\n<p>WP Accessibility Day has grown significantly in the past few years, uniting a large international group of volunteers, and organizers, to drive awareness and practical change in web accessibility.</p>\n\n\n\n<p>The event is powered by a host of teams, marketing, sponsors, tech and vendor, post-event, translation, speakers, and more, ensuring that everything from live captioning to sign language interpretation is in place.</p>\n\n\n\n<p>We begin by learning about June and David&#8217;s unique paths to accessibility advocacy. One through direct lived experience, and the other through supporting a loved one with cognitive challenges. Their stories highlight why accessibility can&#8217;t be an afterthought, and how events like WP Accessibility Day are raising awareness in this important area.</p>\n\n\n\n<p>We discuss what attendees can expect at this year&#8217;s event happening from the 15th of October, 2025. It&#8217;s free, fully virtual, and runs for 24 hours, making space for a diverse range of speakers and topics.</p>\n\n\n\n<p>Whether you&#8217;re interested in the moral, legal or technical cases for accessibility, there&#8217;s something for you here, including sessions on accessible design, risk management for agencies, legal compliance, and demonstrations of assistive technologies.</p>\n\n\n\n<p>June and David share how the event format, a combination of prerecorded talks and live chat, mixes polished content with real time engagement. Plus how translation and community involvement are key to its growing impact.</p>\n\n\n\n<p>If you want to learn more about how you can make your WordPress sites, and the web in general, more inclusive, or if you&#8217;re motivated by global collaboration or personal stories, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you June Liu and David Denedo.</p>\n\n\n\n<p>I am joined on the podcast by two fabulous guests. I&#8217;ve got June Liu and David Denedo. Hello both. How are you both doing?</p>\n\n\n\n<p>[00:03:58] <strong>June Jiu:</strong> Hi there.</p>\n\n\n\n<p>[00:03:59] <strong>David Denedo:</strong> Hello. I&#8217;m doing all right.</p>\n\n\n\n<p>[00:04:00] <strong>Nathan Wrigley:</strong> Well, it&#8217;s very nice to have you both with us. The intention of today&#8217;s podcast is to draw attention to something which well, I&#8217;m sure many of you will know about. If you don&#8217;t know about it, I certainly hope that by the end of this, not only do you know about it, but you are highly engaged, and hopefully going to attend and all of those kind of things, maybe even contribute some of your time, you never know.</p>\n\n\n\n<p>It&#8217;s called WP Accessibility Day, and we&#8217;re going to get into that in a moment. Before we do that, I just want to get the little bio, the introduction from both of you, one at a time, just telling us who you are, what your interest is in WordPress and accessibility, I guess.</p>\n\n\n\n<p>So we&#8217;ll keep it nice and short and sweet. So I&#8217;ll go to June first. Just let us know who you are, June.</p>\n\n\n\n<p>[00:04:39] <strong>June Jiu:</strong> Thank you, Nathan. I&#8217;m June, I serve on the organising team for WP Accessibility Day as the marketing team co-lead, and I also work on the sponsors team.</p>\n\n\n\n<p>My background is mostly project management, so my forte right now is helping the team coordinate tasks, and keeping the initiatives on track. Yeah, I coordinate between the sponsors and the marketing team to get the sponsor page prepared. So that&#8217;s basically my work with WPAD.</p>\n\n\n\n<p>[00:05:08] <strong>Nathan Wrigley:</strong> Thank you so much. That&#8217;s great. And David, let&#8217;s go to you next. Same question really.</p>\n\n\n\n<p>[00:05:11] <strong>David Denedo:</strong> Hi, I&#8217;m David. I&#8217;m visually impaired, so that&#8217;s why I love accessibility. I work in London as a web designer and a content creator, and I&#8217;m part of the WP Accessibility Day organising team, as part of the post-event people. But I&#8217;m also in the marketing team, just jumping around, and at least trying to put as much as I can into web accessibility.</p>\n\n\n\n<p>Yeah, I got into web accessibility mainly because of some talks I had two years ago from the WP Accessibility Day, and that just encouraged me. And then here we are two years later.</p>\n\n\n\n<p>[00:05:53] <strong>Nathan Wrigley:</strong> Thank you so much. So, WP Accessibility Day, one thing that just jumped out at me straight away from what you were both talking about there, you both talked about, I&#8217;m on the, and then you mentioned a team. That implies that there&#8217;s quite a lot of you in the background.</p>\n\n\n\n<p>So just to give credit where credit&#8217;s due, I think it&#8217;s always important to make sure that we credit not just the two of you, because there&#8217;s probably a lot of people behind this as well. I don&#8217;t want to go down the route of missing anybody out. So I wonder if it&#8217;s possible for us to just mention the kind of teams and things like that. And if there are any people in particular that you&#8217;ve been working with that you do wish to name, caveat emptor, dear listener, I apologise on behalf of everybody on this panel. If we miss anybody&#8217;s name out, sorry about that. But let&#8217;s go for the, how many teams there are and how big an enterprise is this these days?</p>\n\n\n\n<p>[00:06:39] <strong>June Jiu:</strong> I don&#8217;t think I&#8217;ve ever counted how many teams there are, but I&#8217;ll list some of them. And David, add yours if I miss any, please.</p>\n\n\n\n<p>There is a volunteer team that&#8217;s, right now, pivotal. That&#8217;s their work right now in preparing the event. The event is on October 15th, so we&#8217;re just about a month away. So the volunteer team is very active right now in onboarding the volunteers.</p>\n\n\n\n<p>Then we have the tech and vendors. And those are also very active. They work closely with the volunteer team to prepare the day of. So they&#8217;re the ones that prepare the Zoom platform for us. So making sure that it all runs well.</p>\n\n\n\n<p>Then we have website, APAC, post event, translation, sponsors, marketing. What else? I feel like there&#8217;s a few others that I&#8217;m missing. But there is a huge team behind Amber, Bet and Joe, working and making sure that we can make the event as smooth as possible, and take some of the load off of them.</p>\n\n\n\n<p>[00:07:36] <strong>Nathan Wrigley:</strong> The Amber, the Bet and the Joe that you just mentioned, we have got Amber Hinds, Bet Hannon and Joe Dolson. So there&#8217;s three names. Do you have any recollection whether they were the people that kind of kickstarted the event, whenever that was? Because if that was the case, it sounds like it&#8217;s gone gangbusters since then with lots of people joining on, and you two being some examples.</p>\n\n\n\n<p>[00:07:56] <strong>June Jiu:</strong> We do have a pretty big team this year. And yes, you&#8217;re right, the history is that Joe Dolson did start WP Accessibility Day. I don&#8217;t recall all of the specifics, but I think the second year, Bet, I think it might&#8217;ve started with Bet and Joe, and then Amber also came on soon after that.</p>\n\n\n\n<p>But we&#8217;re in our fifth year. It&#8217;s very exciting. I joined last year as an organiser and it was a point in my time where I was returning to work. So finding WPAD was kind of a sweet spot for me to test out my skill sets again, get used to being out in the public, so I have a soft spot for them.</p>\n\n\n\n<p>[00:08:35] <strong>Nathan Wrigley:</strong> Thank you. Okay, so there&#8217;s a few that we&#8217;ve rattled off. David, I don&#8217;t know if you can fill in any gaps that might have been left there. If so, go now.</p>\n\n\n\n<p>[00:08:42] <strong>David Denedo:</strong> Yeah, I think those are the main ones that were involved. And I would say Amber Hinds, when she came on board, she brought in a lot of organisation because, you know, with Joe, Joe understands the technical bits of things, but he&#8217;s not really so organised. So when she came in, that&#8217;s why the team grew exponentially from 2022, I believe when she joined. And then the year after, things just kept spiraling. And then now we have a massive team with lots of volunteers, everybody&#8217;s happy to help.</p>\n\n\n\n<p>The other thing that is quite nice is that there was a nice spread of people who are volunteering. So it&#8217;s not just maybe from one region or one country. We are a very nice spread of people, so that&#8217;s really nice. So from different parts, from Asia, from Africa, from the Americas and all of that, they&#8217;re all wide base.</p>\n\n\n\n<p>[00:09:33] <strong>Nathan Wrigley:</strong> That&#8217;s amazing. Everybody from all over the place. That&#8217;s really lovely.</p>\n\n\n\n<p>David, in your introduction, in your bio, you described that you are kind of eating your own dog food a little bit here in that, I can&#8217;t remember the exact phrasing that you had around your eyes. How did you describe the condition that you have, if that&#8217;s the right word?</p>\n\n\n\n<p>[00:09:50] <strong>David Denedo:</strong> Okay, yeah. So I am visually impaired, so I have very high myopia and high astigmatism. I also struggle to see myself, so that&#8217;s one reason why I got really interested when I saw how people are able to make the web more accessible. Because I grew up in a background where we had to adapt to so many stressful things, like there wasn&#8217;t really much help for people with accessibility needs.</p>\n\n\n\n<p>So I didn&#8217;t really know there were ways to help people out. Until I came into the whole system and I realised that, oh wow, so you can actually do this to help somebody else. Because I was always struggling, most times I couldn&#8217;t see the screen. So I&#8217;m always like relying on other people to tell me what&#8217;s in front of me, what&#8217;s on the screen, and all of that.</p>\n\n\n\n<p>But then when you start to see that, oh yeah, we can use a screen reader, you can use screen magnifier, you can do this, you can do that, you can just improve a little bit on your website, or even on the reality, makes things more accessible. I was like, wow, I&#8217;ve been living under the rock basically.</p>\n\n\n\n<p>[00:10:53] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s absolutely fascinating. I&#8217;m just wondering, June, if you have a similar story to tell in that, is there anything that you would like to share in that regard?</p>\n\n\n\n<p>[00:11:01] <strong>June Jiu:</strong> I do. My mother had a stroke, and from that she had vascular dementia. And being her caregiver for that many years, and seeing the decline in her loss of independence, because she wasn&#8217;t able to navigate the medical system by herself anymore. It was kind of, I learned everything in hindsight. I wish I had the knowledge that I have today to have helped her like 8, 10 years ago. But that drew me in.</p>\n\n\n\n<p>I was telling you how I came back into the workforce, and one of the things that somebody said to me was, hey, there&#8217;s this free event. It&#8217;s online, you don&#8217;t have to leave your house, just try it out. And it was WPAD. And when I was listening to the talks, I was like, yeah, wait a second, you mean that websites can be laid out differently so that it would be easier for somebody to navigate it, even with a mental decline?</p>\n\n\n\n<p>And it&#8217;s those simple, to us, it initially could be simple, but in the back end it might not be so simple. But just having her read through an online PDF, you know, it was difficult for her to hit the right area, because the PDF lines were so tiny. And her eye, hand coordination was reduced, so she&#8217;s not able to hit those lines to fill in the PDF.</p>\n\n\n\n<p>So for me it was the acknowledgement of, oh my gosh, it doesn&#8217;t have to be this way going forward. So it&#8217;s me trying to learn as much as I can to direct my future clients into a direction that gives better accessibility to all, and not just their one demographic.</p>\n\n\n\n<p>[00:12:41] <strong>Nathan Wrigley:</strong> It&#8217;s so curious that you&#8217;ve both got two stories where the end of it, the target, if you like, is the same, but how you&#8217;ve arrived at the things are entirely different.</p>\n\n\n\n<p>David, a very personal story about your own life. And June, well, another personal story, but viewed through the prism of somebody else. Almost like standing over somebody&#8217;s shoulder and being able to ascertain, well, this person&#8217;s not getting what they could out of the internet.</p>\n\n\n\n<p>And it strikes me that if you rewound the clock, I don&#8217;t know, let&#8217;s say 30 years ago before the internet was in any way, shape, or form common, but you could describe what would be available in 30 years time. And you could say, well, so many people, they&#8217;d have this little device in their hand, and there&#8217;d be these machines where there&#8217;d be screens on desktops and things like that.</p>\n\n\n\n<p>At that moment, you would be thinking to yourself, this is literally the perfect technology to help people who, let&#8217;s say for example, are struggling to see. Are unable to get out of the house. There may be an aspect of their body which doesn&#8217;t function in the way that your body or my body might function.</p>\n\n\n\n<p>You would describe that and you&#8217;d think, oh, this is like manna from heaven. This is the perfect thing. But it never turned out that way. The internet went in a way entirely leaving those people behind, I think, which was such a lost opportunity.</p>\n\n\n\n<p>So we&#8217;re kind of 25 years or whatever it is into the internet, and we&#8217;re now going back and filling in all of the gaps that probably, with the benefit of hindsight, should never have been left.</p>\n\n\n\n<p>I mean, I don&#8217;t know that there&#8217;s any question in there, but it&#8217;s curious that that one technology which could have made the lives of so many people so much more straightforward, really hasn&#8217;t serviced those people particularly well until events like this come along and educate the rest of us in how to do it.</p>\n\n\n\n<p>[00:14:23] <strong>June Jiu:</strong> I think, Nathan, you hit two big points. Everyone&#8217;s journey with accessibility is very personal, and unless you experienced it firsthand, or even secondhand in my case, you don&#8217;t really see that impact.</p>\n\n\n\n<p>And the second part is that the second nail that you hit is that a lot of times it becomes an afterthought. Accessibility becomes the afterthought. I think that with an event like WPAD, we want it to become the foundational, so we&#8217;re hoping to make that change.</p>\n\n\n\n<p>[00:14:53] <strong>Nathan Wrigley:</strong> For example, I&#8217;m imagining, again harking back to how the internet could have been, we&#8217;ve now got a technology where a small rectangle held in your hand, with a few clicks of a few buttons can enable you to more or less have anything delivered to your front door, in a very short space of time. Which is like, how incredible is that, that that is even possible?</p>\n\n\n\n<p>And so this is the perfect answer to people, let&#8217;s say for example, who struggle to get out of the front door, and navigate the shops and what have you.</p>\n\n\n\n<p>And yet we&#8217;re faced with a situation where that sublimely cool technology is impenetrable, and unavailable, to many people because it never got baked in as a requirement, and we can come to that later. David, I&#8217;m sorry, I think I interrupted.</p>\n\n\n\n<p>[00:15:36] <strong>David Denedo:</strong> Oh no. Yeah, what you said is quite right. There is an imbalance in the way things are getting better, but it&#8217;s getting better for a certain set of people, but leaving some other people behind. So that is the problem.</p>\n\n\n\n<p>With the web, it was improving at a very fast rate in terms of how to build the web, but somewhere along the line, people forgot that the whole essence of worldwide web, the man who created the W3C consortium, who basically created the web, the father of the web, his whole idea was that the web should be accessible to all. That was his vision, his goal from the very start.</p>\n\n\n\n<p>But as people are trying to push the boundaries, sometimes they forget, well, it is quite normal that sometimes unless you are experiencing a certain problem, you will not find a solution to it. So now that we are bringing the awareness to people, then they&#8217;re now finding out, okay, we forgot this certain set of people, let&#8217;s now incorporate them into our thinking, into our design, into everything.</p>\n\n\n\n<p>So that is one nice thing about having a conference like WPAD, to help spread awareness to people. Because if you&#8217;ve never experienced a certain problem, for example, you&#8217;ve never been blind or you&#8217;ve never had something with your mobility. You may not really appreciate the struggles of those people. But when they&#8217;re able to express it out and explain to you in these conferences, then you can now get that third party understanding, and at least you can incorporate accessibility into your own lifestyle.</p>\n\n\n\n<p>[00:17:21] <strong>Nathan Wrigley:</strong> Yeah, I have a question around that, because I am in the position where my eyes, despite the fact I wear glasses, once the glasses are on my nose, my eyes, functionally, I think you would describe them as normal, and I have good ish hearing, and my body functions. And so, David, you&#8217;ve basically just described me.</p>\n\n\n\n<p>It can be, it has been hard to imagine, what is the lived experience of people who are not in the same boat as I am?</p>\n\n\n\n<p>And I did wonder if a part of WPAD, I did wonder if a part of that was that educational piece? Whether it was explaining to people, web developers, people who may not be accustomed to what the conference is about, and what the summit will, you know, the educational pieces. I wondered if there was a piece where you explained, okay, this is the setup that somebody using a screen reader, this is what it feels like to them when they&#8217;re on the internet. This is what it would feel like, for example, I don&#8217;t know, if you are using a puff and sip system or something like that.</p>\n\n\n\n<p>So I don&#8217;t know if you are providing content like that, but I&#8217;d be curious to know whether you explain what the lived experience would be for people who may benefit as a result of the tech talks in the conference.</p>\n\n\n\n<p>[00:18:34] <strong>David Denedo:</strong> Yeah, so from what we have planned, there are a few of the conference talks that will reflect about accessibility. I think one of them is by Dennis, he&#8217;s going to show how a screen reader user will access a website. And then there are also talks about post-production of videos. So some people will incorporate the talks in, or at least talk about the experiences, but it may not be like a full on description.</p>\n\n\n\n<p>But yeah, I&#8217;ve seen a few of the talks that will be happening and they will be incorporating some of the disabilities that we know, like colorblindness, and then like audio and other things. So that will help people to get an awareness of what disabilities are out there, and how to incorporate that into building a more accessible system.</p>\n\n\n\n<p>[00:19:26] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s really interesting. I suppose the old adage is, you know, a picture says the same as a thousand words or something like that. And being able to perceive what&#8217;s going on. I&#8217;ve always found that incredibly motivating, because immediately I can see how the internet is a more difficult place than a thousand words could describe and what have you.</p>\n\n\n\n<p>So, okay, so that&#8217;s interesting. And then moving on to the conference itself, I&#8217;m presuming that this is aimed squarely at people already using WordPress as their content management system, their website builder. But it is curious because, I don&#8217;t know exactly where you land on this, maybe what I&#8217;m about to say doesn&#8217;t fit at all, but I&#8217;m presuming the conference is designed to enable everybody to get some way along the road of producing an accessible website.</p>\n\n\n\n<p>But presumably also the audience is a little bit of, trying to do what I&#8217;ve just described, make the case, the moral case, the legal case for needing to do it as well. So it&#8217;s the tech side of how to do it, as well as the sort of the moral and the legal obligations that might sort of follow that in train.</p>\n\n\n\n<p>[00:20:32] <strong>June Jiu:</strong> Yeah, there is one session that I think you might find interesting along that line, is that it&#8217;s talking about accessibility as a risk management for agencies and for business owners. So I think that in particular, I have found it most interesting. With a background in project management, I&#8217;ve often had conversations where somebody will say to me, but why do I need to have it assessable? And then you&#8217;d have to take that pause and go, okay. But I think that to have the angle of risk management is certainly something that business owners will be able to relate to a little bit better.</p>\n\n\n\n<p>We also have another one that is talking about what features you should be on a lookout for so that you can kind of mitigate the legal portion of it. I&#8217;m not saying that you can avoid it completely, but at least you&#8217;re more aware of it.</p>\n\n\n\n<p>So there&#8217;s that one and, of course, our keynote speaker is Vitaly Friedman, from Smashing Magazine. He&#8217;s going to come at it from the UI, UX portion of it. So it&#8217;s not just all on the development, but it&#8217;s also on different aspects of website building and different viewpoints on business and ownership of a website.</p>\n\n\n\n<p>[00:21:48] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s kind of interesting because there are many threads there aren&#8217;t there. If you were just to take the technical side, you could probably do a conference that lasted many, many weeks about the technicalities of how to do it.</p>\n\n\n\n<p>But it&#8217;s curious that you&#8217;ve also leaned into the things like, well, the compulsion, the kind of maybe the advent of the ambulance chasing lawyer, dare I say it, who has realised, latched onto the fact that the European Accessibility Act over this side of the Atlantic is now a thing. There is no longer just a moral component to doing the accessibility work on your website. There is now increasingly a big legal hammer, which could be deployed.</p>\n\n\n\n<p>And so that alone, I presume will draw a certain audience who, you know, if the only thing that they want to hear about is how to mitigate that problem, well, maybe that&#8217;s not the ideal motivation for it, but nevertheless, it is a bit of a carrot and stick, and it will bring some people into the arena, which is good.</p>\n\n\n\n<p>[00:22:41] <strong>June Jiu:</strong> And here&#8217;s why I&#8217;d like to give a shout out to a team that I forgot, the speaker team. They&#8217;re the ones that put together the application, and they vetted through all the applications to see what would be more interesting for everybody.</p>\n\n\n\n<p>The rating system is, when they go through the rating system, they kind of make it anonymous of who the presenter would be. So it makes it, you are really looking at what the topic is being talked about, rather than who might be presenting. And that gives us an edge in finding topics that might not be as well known and from areas that are less featured.</p>\n\n\n\n<p>So we do have a couple of speakers that are coming from the continent of Africa, and those are always very interesting to hear. In the past, because of the location and the technical availability, there had been technical issues. But this year we&#8217;re having it so that the sessions are all prerecorded. So that will kind of help with the presentation of it, the clarity. But each of the speakers will be in the chat and they&#8217;ll be available to answer questions in the chat.</p>\n\n\n\n<p>So I think that&#8217;s an interesting fold into this year&#8217;s event, to have that feature in there so that the speaker is not just presenting, but they&#8217;re in the chat room answering questions. I think that adds another layer to the event.</p>\n\n\n\n<p>[00:24:04] <strong>Nathan Wrigley:</strong> Yeah, I think what&#8217;s really nice about that as well is that if everything&#8217;s prerecorded, the speaker will get the chance to create and then re-edit, and then adapt and modify. And what you end up with hopefully is the best version of that talk.</p>\n\n\n\n<p>With the best will in the world, some people are not as great as others at doing live things. You know, they go down rabbit holes, and they lose their train of thought or what have you. This completely gets rid of that problem. They can do it as many times as they like and give you the best version.</p>\n\n\n\n<p>But also that lovely aspect of, they suddenly become available to have a conversation in the chat, whereas before, they was presenting, you know, and presumably needed to go and have a bit of a lie down afterwards. Whereas in this situation, much more relaxed, you can ask them the questions.</p>\n\n\n\n<p>I really appreciate that format. I think that&#8217;s actually, that&#8217;s my preferred way of a summit, kind of like this, the Accessibility Day in this case, being put together. I think that&#8217;s very forward thinking. And I hope that you continue doing it that way because I think the presenters probably appreciate it. Your audience will appreciate it, because it will be polished, and also you get to chat with the person involved. Anything on that, David?</p>\n\n\n\n<p>[00:25:11] <strong>David Denedo:</strong> Yeah. Another thing we forgot to talk about is the translation team. So as the talks are being presented, there are also some nice volunteers who are translating it into other languages to have as much diversity as possible. Because some people, English is not their first language, so we have a team trying to convert to like French. We have the one for Spanish. There are also some other ones, even like Hebrew and so many other ones. So it&#8217;s a very nice feeling to have so many translations and everybody is doing their bit.</p>\n\n\n\n<p>That is one thing I love about WP Accessibility, the entire organising team is the fact that everybody&#8217;s skill level, it doesn&#8217;t matter your skill level, you can always put in something. So that is something great. Whether you are a web designer, you are just a business owner, you can sponsor the event. If you are good with multilingual, you can be part of the translation. You can apply to speak.</p>\n\n\n\n<p>The whole talks is not all technical, like you already mentioned. The talks are varied, so we talk about risk management, we talk about designers can give their own bits. People who are in business can give the business case for accessibility. So it&#8217;s all, it&#8217;s a lovely spread and I really love it.</p>\n\n\n\n<p>[00:26:30] <strong>Nathan Wrigley:</strong> There really is a lovely spread. I mean, firstly, one thing that I should have done right top of the show, which I didn&#8217;t, and I will mention it because I record a preamble before we actually start talking, one thing I will do is I&#8217;ll read into the record the URL. But I&#8217;ll do that now as well.</p>\n\n\n\n<p>So the URL is fabulous, by the way. It&#8217;s just ideal. If you are returning customer, if you like, it&#8217;s wpaccessibility.day. Just one more time, wpaccessibility, the regular spelling, no underscores, no hyphens or anything like that, dot day.</p>\n\n\n\n<p>And then as a subdomain you are going to put in the year. So in this case it&#8217;s going to be 2 0 2 5, 2025.wpaccessibility.day. And you&#8217;re going to find all the different bits and pieces over there.</p>\n\n\n\n<p>And one of the things that I noticed about the getting involved side of things is, yeah, there&#8217;s the whole sponsorship thing. So you can become a sponsor if you&#8217;d like to do that. But also you can volunteer, you can become a media partner. If you feel philanthropic and you just want to donate some of your money into the project, that is also an option. And then there&#8217;s a whole tab for the attendees as well. It&#8217;s under community. There&#8217;s an attendee section as well.</p>\n\n\n\n<p>So it sounds like it&#8217;s not just this little event which flicks on for a couple of days and then turns off again. I mean, certainly from your side, it sounds like there&#8217;s a whole fun community of things happening in the background.</p>\n\n\n\n<p>And really that&#8217;s the glue that binds a successful project together. If it was all very uninteresting and dry and a bit boring and you were all feeling under pressure, it wouldn&#8217;t have so many legs, it wouldn&#8217;t be able to run for this many years. But I&#8217;m guessing that you&#8217;ve had nice experiences, right, in the background?</p>\n\n\n\n<p>[00:28:04] <strong>June Jiu:</strong> Oh, yes. Yes. We have a lot of fun. But thank you for mentioning those links.</p>\n\n\n\n<p>[00:28:08] <strong>Nathan Wrigley:</strong> No, I think that&#8217;s wonderful. So again, go and check that out.</p>\n\n\n\n<p>The other thing to say though is, let&#8217;s talk about how it&#8217;s actually happening. Obviously you&#8217;ve described that it&#8217;s going to be prerecorded videos. How are you making that content available? What&#8217;s going to be the platform of choice, or how are you going to get it?</p>\n\n\n\n<p>Is there a way that you can, I don&#8217;t know, for example, download all of the bits and pieces so you can watch them in your own time? Is it an event which is spanning a single day, you know, a 24 hour time?</p>\n\n\n\n<p>[00:28:35] <strong>June Jiu:</strong> Yeah, we do say that it is 24 hours, but all the content and the videos, they&#8217;re going to be available for replay after we go through the post-event production. Either from each subdomain, as you mentioned, the 2025 will be available on the 2025.wpaccessibility.day.</p>\n\n\n\n<p>Last year&#8217;s event is available on the 2024.wpaccessibility.day. So you can rewatch them. It&#8217;s also available through YouTube. So if you need some background noise, I often do it. I just turn on that and let it roll.</p>\n\n\n\n<p>I have to say, it is a lot of information to absorb, but I do find it to be very resourceful. I know that one of David&#8217;s work this year is to put in chapters for these past event videos. So that has been very helpful to me when I find the relevant video from the past. And I said, I remember somebody saying something about that. Now with the chapters there, it&#8217;s much easier to navigate and find it. So good work, David. Thank you.</p>\n\n\n\n<p>[00:29:37] <strong>Nathan Wrigley:</strong> Yeah, indeed. Good work. But what&#8217;s this, in the show notes that were shared before we actually joined the call, it describes, it says here, and I don&#8217;t know which one of you wrote it, but it says, the event will be hosted through Zoom events. And Zoom is capitalised, so I presume it&#8217;s the platform Zoom that we&#8217;re all familiar with. I don&#8217;t know what a Zoom event is. Does that differ from a regular Zoom call? Is there some key difference?</p>\n\n\n\n<p>[00:29:59] <strong>June Jiu:</strong> Yes. It&#8217;s different from like a Zoom webinar or a Zoom call. It&#8217;s a platform that has a lobby. You&#8217;re registering on our site, but then on event day you&#8217;ll be able to go into the Zoom event.</p>\n\n\n\n<p>There&#8217;ll be a lobby and there&#8217;ll be a chat room, that&#8217;s where you can find all the information for the event. So, it&#8217;s not like a traditional webinar where there&#8217;s just one link in order to go and join it, to join that session, or that sector of sections. So now you can go in and when that hour pops up, that session would pop up.</p>\n\n\n\n<p>[00:30:32] <strong>Nathan Wrigley:</strong> Oh, I see. Right. So you go to this one central place, and everything&#8217;s kind of bound in this one, so as soon as you&#8217;re in, you&#8217;re in, basically, and you don&#8217;t have to keep clicking links in emails to find the latest session, which is going live.</p>\n\n\n\n<p>[00:30:44] <strong>June Jiu:</strong> Exactly.</p>\n\n\n\n<p>[00:30:45] <strong>Nathan Wrigley:</strong> Okay. That&#8217;s really nice. Dave, anything to add to that?</p>\n\n\n\n<p>[00:30:47] <strong>David Denedo:</strong> Yeah. And you also have access to like swag. Everything will be in the event, so you can get some of the sponsor swag, you can chat with the speakers, you can chat with other event members, all within the same platform. So not having to jump from one platform to another platform to chat and then come back. You can lose people that way, but now everything all packaged together.</p>\n\n\n\n<p>[00:31:12] <strong>June Jiu:</strong> I wanted to give a shout out to the platform itself. It allows us to do live captioning. A lot of times with webinars, it is just automated caption. We actually do have live captioners typing into Zoom. That is another layer to WP Accessibility Day that is not a feature in other events.</p>\n\n\n\n<p>[00:31:32] <strong>Nathan Wrigley:</strong> No kidding, yeah.</p>\n\n\n\n<p>[00:31:33] <strong>June Jiu:</strong> Yes. And the other big one, expense for us is the American Sign Language interpreters. So they will be also on hand on event day, and there&#8217;s a team of them that will be available to us, and they do the ASL.</p>\n\n\n\n<p>This year one of our speakers is from Australia and he will be bringing in Australian Sign Language, which is different from American Sign Language. So there&#8217;s another layer to the accessibility. We understand either British Sign Language or American Sign Language but, yeah, there&#8217;s Australian Sign Language too.</p>\n\n\n\n<p>[00:32:08] <strong>Nathan Wrigley:</strong> You drop this as if it&#8217;s really straightforward, but when my head starts spinning on the technicalities there, the idea of injecting real time, typed transcriptions, somehow overlaying that into the video, there&#8217;s a whole technical piece there.</p>\n\n\n\n<p>And then you&#8217;ve got a sign language person. That&#8217;s a whole nother layer as well. That all needs, presumably, I don&#8217;t know if that&#8217;s going to be done live or filmed. Maybe there&#8217;s an opportunity.</p>\n\n\n\n<p>[00:32:33] <strong>June Jiu:</strong> It&#8217;s live.</p>\n\n\n\n<p>[00:32:33] <strong>Nathan Wrigley:</strong> Yeah, okay. So all of that, there are lots and lots of moving parts here.</p>\n\n\n\n<p>[00:32:37] <strong>June Jiu:</strong> That&#8217;s why we have the technical and vendor team, and the volunteer team. They&#8217;re pivotal on event day to have those two teams in place.</p>\n\n\n\n<p>[00:32:47] <strong>Nathan Wrigley:</strong> Can I just ask, because I know there&#8217;ll be some people that are curious about the, how to describe it, the business status, let&#8217;s put it that way. And maybe this is not something that either of you can answer, I don&#8217;t know.</p>\n\n\n\n<p>What&#8217;s the structure of WP Accessibility Day? So, for example, if I was to donate, in the UK we call these things charities. I think in the US the correct term is non-profit. So if I was to donate, do I have some sort of assurance that the money isn&#8217;t going to end up in some, I don&#8217;t even want to say the words because I know that nobody&#8217;s ethics are this poorly thought through, but I&#8217;m going to say it anyway. Just want to make sure that the money doesn&#8217;t end in somebody&#8217;s back pocket.</p>\n\n\n\n<p>Where did the donations end up? How is the structure of this organisation ensuring that everything is out in the open and clear and easy to understand?</p>\n\n\n\n<p>[00:33:28] <strong>June Jiu:</strong> Well, this year WordPress Accessibility Day was recognised by IRS as the 501 C3 public charity. So based upon that, a hundred percent of our income that comes in goes right back into the event.</p>\n\n\n\n<p>Organisers and volunteers are not paid. Every one of us who are working on this is out of the goodness of our heart, and what time availability that we have.</p>\n\n\n\n<p>The one caveat I will say, some of our translators are paid because translation is an income based business. And this is a recent development. In the past we&#8217;ve had to ask them to please donate their time to do the translation. But now we have a little bit more security to be able to pay them.</p>\n\n\n\n<p>People who have the ability to speak multiple languages, look into the translation because if you aren&#8217;t able to participate as an organiser or a volunteer, donating your time to translate or being paid for be translators for us is a huge difference for us to bring all these sessions available to a greater audience.</p>\n\n\n\n<p>[00:34:36] <strong>Nathan Wrigley:</strong> I think everybody would understand that there&#8217;s, that is how that industry works, isn&#8217;t it? When you go to a WordCamp, for example, and you see the people doing the live captioning, or you see the people standing on the stage and they&#8217;re doing the sign language, I think it&#8217;s understood that that is what they do for a living.</p>\n\n\n\n<p>[00:34:51] <strong>June Jiu:</strong> And I would be remiss not to give credit to our sponsors too. We have many sponsors who are repeat sponsors year after year, and they support us with their sponsorship. We are very appreciative of that.</p>\n\n\n\n<p>This year we have some new ones and a lot of repeating ones from every range. Our higher level are of course now closed, but we still have the bronze level, which is at a $500, or a micro sponsor which is at $150. And the difference between that is the Bronze has a webpage, a dedicated webpage for their company, and the micro sponsor has a logo on our sponsor page.</p>\n\n\n\n<p>[00:35:28] <strong>Nathan Wrigley:</strong> So as of recording, and maybe that will keep going right up to the deadline, I don&#8217;t know, so if what you&#8217;ve heard has made you feel that you&#8217;d like to be involved on a sponsorship level, bronze is available, that one is $500, and there&#8217;s a micro one. And obviously you can go onto the 2025 Accessibility Day website and discover for yourself what&#8217;s available in there.</p>\n\n\n\n<p>So we found out what&#8217;s happening. We found out why it&#8217;s being done. We found out some of the people that are being involved. I suppose what we ought to do at this point is drive people toward the schedule.</p>\n\n\n\n<p>Well, you&#8217;ve announced it already, but let&#8217;s just make sure we&#8217;re doing it again. The date for this event is when?</p>\n\n\n\n<p>[00:36:03] <strong>David Denedo:</strong> So it&#8217;ll be happening on October 15th to the 16th, and it&#8217;ll be 24 hour long event. So it&#8217;s going to go right up for 24 hours. We have the speakers all in the schedule, so you can go ahead and check it out. The link will be in the shownotes.</p>\n\n\n\n<p>[00:36:19] <strong>Nathan Wrigley:</strong> It will. Yeah, that&#8217;s absolutely right. So the 15th of October, it&#8217;s a 24 hour event. So I don&#8217;t know if you start in the sort of Pacific neck of the woods, that seems to be the traditional way that things are done. So Australia, they&#8217;re the sort of first people to receive the content, and then it just goes around the globe. And maybe the people in, on the west coast of the US and Hawaii and what have you, they get the content more towards the end of the day. I assume that&#8217;s how it&#8217;s working.</p>\n\n\n\n<p>But if you go to the URL that we mentioned earlier and just add forward slash schedule to it, you will be able to see through opening remarks from Joe Dolson right at the beginning of the day, right through the keynotes and everything, to the closing remarks, or at least the last presentation, which is happening some 23 or so hours later.</p>\n\n\n\n<p>I think that&#8217;s all the questions that I had. Is there anything that you feel it would&#8217;ve been important to say that we didn&#8217;t say? If that&#8217;s the case, please feel free to use this platform now.</p>\n\n\n\n<p>[00:37:09] <strong>June Jiu:</strong> The event is free, but we do ask that you register, so that we do have a good count of how many people are coming. So please sign up at 2025.wpaccessibility.day and you&#8217;ll find the registration link there.</p>\n\n\n\n<p>[00:37:26] <strong>Nathan Wrigley:</strong> Is that a mere request or is that a requirement? In order to gain access, do you need to have, yeah, okay. So I&#8217;m getting a nod of the head there from June. So go and register in order to access the content as well. David, anything we missed?</p>\n\n\n\n<p>[00:37:38] <strong>David Denedo:</strong> Yeah, the only thing is that I&#8217;m excited for Vitaly Friedman, because he has a very wide following, so he will bring more people into our event, hopefully. And he is going to be talking about accessible designs, which is something quite powerful. Because in this day and age, people always associate accessibility with very boring designs. But he&#8217;s coming to show you that you can have very beautiful designs in 2025 and still be accessible. So that&#8217;s a very important topic.</p>\n\n\n\n<p>[00:38:09] <strong>Nathan Wrigley:</strong> Well, the WP Accessibility Day website is an example of that. It&#8217;s actually a really tasteful, beautiful design. I&#8217;m going to guess that it&#8217;s, you know, the accessibility credentials of it are fairly strong. Let&#8217;s just, make that assumption, but it&#8217;s beautifully designed.</p>\n\n\n\n<p>Yeah, we didn&#8217;t really touch on the names of the speakers or what have you. But yeah, I&#8217;ll just go through a few just as I scroll through, just to give you some ideas.</p>\n\n\n\n<p>So accessible design patterns is Vitaly. Being a colorblind designer, typography, readability, digital accessibility, building accessibility that works in the global south, hyper accessible web design for the blind, audio accessibility, accessibility lawsuits, gosh, we&#8217;re only like six or seven in, and we&#8217;ve run the full gamut already. So here we go. Why accessibility matters, video and media your post-production, guide making WordPress events accessible, gosh, that&#8217;s fascinating. Auditing WordPress plugin accessibility, demystifying screen readers, technical checklists. That means testing WordPress themes and plugins for accessibility. The future is automated, will it be accessible? Making Gutenberg blocks accessible. I&#8217;m going to stop there, but you get the idea. There&#8217;s absolutely loads of breadth and depth.</p>\n\n\n\n<p>It&#8217;s very much the case that if you were to show up, I would guarantee more or less that there&#8217;s going to be something which will pique your interest and keep you engaged. The schedule, like I said, is at forward slash schedule.</p>\n\n\n\n<p>Okay, if that&#8217;s the case, I will just say thank you so much for being one of many cogs in this very important wheel. Thank you for doing what is incredibly important work, making the web accessible to far more people. Thank you. That&#8217;s quite amazing.</p>\n\n\n\n<p>So June and David, thanks for joining us today. Really appreciate it.</p>\n\n\n\n<p>[00:39:46] <strong>June Jiu:</strong> Thanks for having us.</p>\n\n\n\n<p>[00:39:48] <strong>David Denedo:</strong> Thanks for having us.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://2025.wpaccessibility.day/people/june-liu/\">June Liu</a> and <a href=\"https://2025.wpaccessibility.day/people/david-denedo/\">David Denedo</a>.</p>\n\n\n\n<p>Both June and David are key members of the <a href=\"https://2025.wpaccessibility.day/\">WP Accessibility Day</a> organising team, a global, volunteer-driven event focused on improving accessibility in the WordPress ecosystem. June serves as the marketing team co-lead and works with sponsors, bringing her background in project management to keep the event’s efforts on track. David, a web designer and content creator based in London, contributes to the marketing and post-event teams, with his interest in web accessibility stemming from his personal experience as a visually impaired user.</p>\n\n\n\n<p>WP Accessibility Day has grown significantly in the past few years, uniting a large, international group of volunteers and organisers to drive awareness and practical change in web accessibility. The event is powered by a host of teams, marketing, sponsors, tech and vendor, post-event, translation, speakers, and more, ensuring that everything from live captioning to sign language interpretation is in place.</p>\n\n\n\n<p>We begin by learning about June and David’s unique paths to accessibility advocacy, one through direct lived experience, and the other through supporting a loved one with cognitive challenges. Their stories highlight why accessibility can&#8217;t be an afterthought and how events like WP Accessibility Day are raising awareness in this important area.</p>\n\n\n\n<p>We discuss what attendees can expect at this year’s event, happening from October 15th, 2025. It’s free, fully virtual, and runs for 24 hours, making space for a diverse range of speakers and topics. Whether you’re interested in the moral, legal, or technical cases for accessibility, there’s something for you here, including sessions on accessible design, risk management for agencies, legal compliance, and demonstrations of assistive technologies.</p>\n\n\n\n<p>June and David share how the event format, a combination of pre-recorded talks and live chat, mixes polished content with real-time engagement, plus how translation and community involvement are key to its growing impact.</p>\n\n\n\n<p>If you want to learn more about how you can make your WordPress sites, and the web in general, more inclusive, or if you’re motivated by global collaboration and personal stories, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://2025.wpaccessibility.day/\">WP Accessibility Website</a></p>\n\n\n\n<p><a href=\"https://2025.wpaccessibility.day/about/organizers/\">The WP Accessibility Day Team</a></p>\n\n\n\n<p><a href=\"https://2025.wpaccessibility.day/schedule/\">The WP Accessibility Day Schedule</a></p>\n\n\n\n<p><a href=\"https://www.youtube.com/channel/UCes9XCUZd51CAigbBEGlfNg\">WP Accessibility Day YouTube Channel</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WordPress.org blog: WordPress 6.8.3 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4937:\"<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.3.zip\">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-9/\">version 6.9</a>, which is planned for December 2nd, 2025.<br />For more information on WordPress 6.8.3, please visit the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-8-3/\">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href=\"https://hackerone.com/wordpress?type=team\">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href=\"https://hackerone.com/mnelson4\">Mike Nelson</a>, <a href=\"https://hackerone.com/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, and <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href=\"https://x.com/Savphill\">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/andraganescu%20\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phillsav\">Phill</a>, <a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://app.slack.com/client/T024MFP4J/C02RQBWTW\">#core</a> Slack channel. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a> for reviewing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 19:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: What’s Your Time?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150037\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/09/tick-tock/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:908:\"<p>I think some of the best writing about technology PR is this ten-year-old article by <a href=\"https://www.onbackground.com/\">Aaron Zamost</a>: <a href=\"https://medium.com/backchannel/how-the-tech-press-forces-a-narrative-on-companies-it-covers-5f89fdb7793e\">What’s Your Hour in ‘Silicon Valley Time’?</a> It describes the cycles that companies go through in public perception, and the beauty of revisiting it ten years later is that you can see which of the examples are still relevant, or the domains that 404. As someone who has been around this clock probably a dozen times now, I highly suggest this for anyone &#8220;going through it.&#8221; Some of the most powerful words in the English language: <em>This too shall pass</em>. </p>\n\n\n\n<p>See also: The Zen fable or old Chinese poem of <a href=\"https://en.wikipedia.org/wiki/The_old_man_lost_his_horse\">the old man who loses his horse</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 17:30:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"Open Channels FM: Surviving the WordPress Plugin Grind Growth, Marketing and Overcoming Burnout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110777\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://openchannels.fm/surviving-the-wordpress-plugin-grind-growth-marketing-and-overcoming-burnout/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:237:\"In this WP Behind the Builds episode, guest Devin Walker discusses his transition from corporate IT to successful WordPress plugin development, focusing on GiveWP, WP Rollback, and lessons learned about business and community engagement.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 11:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matt: Om 59\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://ma.tt/2025/09/om-59/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3905:\"<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-150030\" height=\"340\" src=\"https://i0.wp.com/ma.tt/files/2025/09/IMG_0803-1-edited-scaled.jpeg?resize=604%2C340&#038;quality=89&#038;ssl=1\" width=\"604\" /></figure>\n\n\n\n<p>I want to dedicate my blog post today to my dear friend and brother, <a href=\"https://om.co/\">Om Malik</a>, whose birthday it is. Om is a multi-hyphenate, but at his core, he&#8217;s a writer, someone who looks at the world and parses it down for others, a seeker who appreciates the spark of creation before most others.</p>\n\n\n\n<p>Om was one of the earliest users of WordPress and he was one of <a href=\"https://ma.tt/2005/01/meetup-aftermath/\">8 people who came to the very first WordPress meetups at Chaat Cafe on 3<sup>rd</sup> street in San Francisco in 2005</a>. (You can tell what an early adopter he is because he has the username &#8220;Om&#8221; <a href=\"https://x.com/om\">on Twitter/X</a> and <a href=\"https://www.instagram.com/om/\">Instagram</a> and WordPress and probably more.) We had connected on the WordPress support forums when I helped him get set up around the 1.0 days. After I moved to San Francisco to take the job at CNET he connected me to people like Phil Black, Tony Conrad, and Toni Schneider who would become, respectively, an investor, board member, and CEO of Automattic. These are folks I still work with and consider close friends today. As a journalist, he had a keen nose for BS and made sure as a naïve 20-something in SF I was connecting with quality people.</p>\n\n\n\n<p>Since we met we&#8217;ve both had a shared love for photography, and I&#8217;ve seen Om blossom into an amazing photographer with a really unique style and approach, <a href=\"https://www.photosbyom.com/\">in fact you can even buy some of his photography prints</a>.</p>\n\n\n\n<p>Over the years, we&#8217;ve dipped in and out of shared obsessions with cameras, watches, shoes, fashion, and design. We have a fair number of matching things in each. In photography we&#821